/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.fc;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.lib.jnm.Fc4Decoder;
import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.VarBindList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class EditNameServerTable
extends EditTable {
    private static final int PORT_NAME = 2;
    private static final int FC4TYPE = 4;
    private static final int FC4FEATURE = 5;
    private static final int FABRIC_NAME = 6;
    private static final int IFINDEX = 7;
    private static final int FWWN = 8;
    private ArrayList _devAliasIndeces;
    HashMap<Wwn, String> npvHash = new HashMap();

    public EditNameServerTable(String[] vars) {
        super(vars);
    }

    @Override
    protected void build() {
        super.build();
        this._table.removeColumn(this._table.getColumnModel().getColumn(7));
    }

    @Override
    protected void get() {
        super.get();
        this.npvHash = new HashMap();
        if (Discover.getSysVersion().compareTo("3.0(2)") > 0) {
            this._devAliasIndeces = new ArrayList();
        } else {
            this._table.removeColumn(this._table.getColumnModel().getColumn(6));
        }
    }

    @Override
    protected Object[] buildRow(SnmpPDU pdu, int[] responseOid, int rowNo) {
        VarBindList vbl = pdu.getVariables();
        byte[] pWwn = vbl.byteValue(1);
        if (this._devAliasIndeces != null) {
            int[] devAliasIndex = new int[9];
            devAliasIndex[0] = 1;
            for (int i = 1; i < devAliasIndex.length; ++i) {
                devAliasIndex[i] = pWwn[i - 1] & 0xFF;
            }
            this._devAliasIndeces.add(devAliasIndex);
        }
        byte[] fWwn = vbl.byteValue(5);
        int[] type = SnmpIntList.valueOf(pdu.getVariables().byteValue(3));
        String fc4 = (String)Fc4Decoder.fcNameServerFC4Features((SnmpString)pdu.getVar(3), (SnmpString)pdu.getVar(4));
        byte[] ipa = vbl.byteValue(6);
        Object[] r = super.buildRow(pdu, responseOid, rowNo);
        Object[] row = new Object[r.length + 1];
        System.arraycopy(r, 0, row, 0, r.length);
        row[7] = new Wwn(fWwn);
        row[4] = fc4;
        boolean isSanTuner = Fc4Decoder.isFc4TypeSet(type, 227);
        if (!isSanTuner && WwnDictionary.isCiscoWwn(fWwn) && this.isFcInterface(fc4)) {
            String portName = this.ipaToIfName(ipa);
            if (portName == null) {
                Discover.getInstance();
                boolean isLocal = this.isEndPortLocalConnected(fWwn, Discover.getSwitchWWN());
                if (isLocal) {
                    if (WwnDictionary.isMDSWwn(fWwn)) {
                        int ifIndex = Discover.getRoot().ifWwn2IfIndex(fWwn, IfIndexIf.FwwnInfo.EP);
                        String string = portName = IfIndexUtil.isFmIfIndex(ifIndex) ? null : Discover.getRoot().ifIndexToName(ifIndex);
                        if (IfIndexUtil.isFmIfIndex(ifIndex)) {
                            DefaultLogger._DefLogger.debug((Object)("fmInternal (VSAN, Fcid) " + row[0] + "  (FabricPortName)" + SnmpString.toHexString(fWwn, 0, fWwn.length, true) + "  (possible slot/port " + (IfIndexUtil.ifWwn2Card(fWwn) + 1) + "/" + IfIndexUtil.ifWwn2Port(fWwn) + ")"));
                        }
                    } else {
                        portName = null;
                    }
                    row[6] = row[6] + (portName == null ? "" : " (" + portName + ")");
                }
            } else {
                row[6] = row[6] + " (" + portName + ")";
            }
        }
        if (row[4] instanceof String && row[4].equals("FICON:CUP")) {
            int offset = ((String)row[6]).indexOf(40);
            if (offset != -1) {
                row[6] = ((String)row[6]).substring(0, offset - 1);
            }
            row[6] = row[6] + " (sup)";
        }
        if (Fc4Decoder.isFc4TypeSet(type, 229)) {
            this.npvHash.put(new Wwn(fWwn), (String)row[6]);
        }
        return row;
    }

    private boolean isEndPortLocalConnected(byte[] fWwn, byte[] swWwn) {
        byte[] swWwnBase = WwnDictionary.convertWwnBytes2MacBytes(swWwn);
        byte[] fWwnBase = WwnDictionary.convertWwnBytes2MacBytes(fWwn);
        if (swWwnBase != null && fWwnBase != null) {
            return Arrays.equals(fWwnBase, swWwnBase);
        }
        return false;
    }

    private String ipaToIfName(byte[] ipa) {
        if ((~ipa[0] | ~ipa[1] | ~ipa[2] | ~ipa[3] | ~ipa[4] | ~ipa[5] | ~ipa[6] | ~ipa[7]) == 0) {
            return null;
        }
        int ifIndex = ((ipa[4] & 0xFF) << 24) + ((ipa[5] & 0xFF) << 16) + ((ipa[6] & 0xFF) << 8) + (ipa[7] & 0xFF);
        return Discover.getRoot().ifIndexToName(ifIndex);
    }

    private boolean isFcInterface(String fc4) {
        if (fc4.indexOf("iscsi") != -1 || fc4.indexOf("virtual") != -1) {
            return false;
        }
        return fc4.indexOf("scsi-fcp") != -1 || fc4.indexOf("FICON") != -1;
    }

    @Override
    protected void postProcessing() throws SnmpException {
        if (this._devAliasIndeces != null) {
            int[] cfdaDevIdToAliasMapDeviceAlias = MibNode.get("cfdaDevIdToAliasMapDeviceAlias").getOid();
            VarBindList vbl = new VarBindList(this._devAliasIndeces.size());
            for (int i = 0; i < this._devAliasIndeces.size(); ++i) {
                vbl.add(cfdaDevIdToAliasMapDeviceAlias, (int[])this._devAliasIndeces.get(i));
            }
            SnmpPDU resp = SnmpFetch.get(this.getPeer(), vbl);
            vbl = resp.getVariables();
            for (int i = 0; i < vbl.size(); ++i) {
                String alias = vbl.stringValue(i);
                this._tableModel.setValueAt(alias.equals("n/a") ? "" : alias, i, 5);
            }
        }
        for (int i = 0; i < this._data.size(); ++i) {
            String matchedNpvFabricName;
            Object[] row = (Object[])this._data.elementAt(i);
            if (row[7] == null || (matchedNpvFabricName = this.npvHash.get(row[7])) == null) continue;
            row[6] = matchedNpvFabricName;
        }
    }
}

