/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.fc;

import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.FieldPanel;

public class EditTimersForm
extends EditForm {
    int EDTOV = 3;
    int DSTOV = 2;
    SnmpVar _newEdTovVar;
    SnmpVar _oldEdTovVar;
    SnmpVar _newDsTovVar;
    SnmpVar _oldDsTovVar;
    static final int[] _edTovOid = MibNode.get("fcTimerEdtov").getOid();
    static final int[] _dsTovOid = MibNode.get("fcTimerDstov").getOid();

    public EditTimersForm(String[] vars) {
        super(vars);
    }

    @Override
    protected SnmpVar getVarFromString(String text, int index) throws Exception {
        if (index == this.EDTOV) {
            int n = Integer.parseInt(text);
            int dstov = Integer.parseInt(((FieldPanel)this._values[this.DSTOV]).getText());
            if (n < this._mibNodes[index].getLo() || n > dstov) {
                throw new NumberFormatException(this.trim(this._vars[index]) + ' ' + "not in range");
            }
        }
        return super.getVarFromString(text, index);
    }

    @Override
    protected void setComponentValue(int i, SnmpVar v) {
        super.setComponentValue(i, v);
        if (i == this.DSTOV) {
            this._oldDsTovVar = v;
        } else if (i == this.EDTOV) {
            this._oldEdTovVar = v;
        }
    }

    @Override
    protected SnmpPDU getSetPDU() throws Exception {
        SnmpPDU pdu = null;
        int _edTovPos = -1;
        int _dsTovPos = -1;
        int pos = 0;
        for (int i = 0; i < this._mibNodes.length; ++i) {
            if (this._mibNodes[i] == null || !this.isEditable(this._mibNodes[i]) || !this.isChanged(i)) continue;
            if (pdu == null) {
                pdu = new SnmpPDU(-93, new VarBindList());
            }
            try {
                int[] oid = this._mibNodes[i].getOid();
                if (SnmpOID.startsWith(oid, _edTovOid)) {
                    _edTovPos = pos;
                    this._newEdTovVar = this.getComponentValue(i);
                } else if (SnmpOID.startsWith(oid, _dsTovOid)) {
                    _dsTovPos = pos;
                    this._newDsTovVar = this.getComponentValue(i);
                }
                pdu.addVar(new SnmpOID(oid, this.getIndex(i)), this.getComponentValue(i));
                ++pos;
                continue;
            }
            catch (SnmpException ex) {
                this._values[i].requestFocus();
                throw ex;
            }
        }
        if (this.isSwap(_edTovPos, _dsTovPos)) {
            SnmpVarBind edTovVb = pdu.getVariables().get(_edTovPos);
            SnmpVarBind dsTovVb = pdu.getVariables().get(_dsTovPos);
            pdu.removeVarAt(_dsTovPos);
            pdu.removeVarAt(_edTovPos);
            pdu.addVar(edTovVb);
            pdu.addVar(dsTovVb);
        }
        return pdu;
    }

    boolean isSwap(int edTovPos, int dsTovPos) {
        if (edTovPos == -1 || dsTovPos == -1) {
            return false;
        }
        return ((SnmpUnsignedInt)this._newDsTovVar).getValue() < ((SnmpUnsignedInt)this._oldEdTovVar).getValue();
    }
}

