/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.fcip;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dmdb.DmId;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;

public class EditFcipEntityTable
extends EditTable {
    static final int SENDBUFFER = 7;
    static final int MAXBW = 8;
    static final int MINBW = 9;
    static final int TIMESET = 10;
    static final int PMTU_ENABLE = 11;
    static final int PMTU = 12;
    static final int[] cfmFcipEntityExtTcpMaxBWOid = MibNode.get("cfmFcipEntityExtTcpMaxBW").getOid();
    static final int[] cfmFcipEntityExtTcpMinAvailBWOid = MibNode.get("cfmFcipEntityExtTcpMinAvailBW").getOid();
    static final int[] cfmFcipEntityExtTcpRndTrpTimeEstOid = MibNode.get("cfmFcipEntityExtTcpRndTrpTimeEst").getOid();
    boolean _isTunnelBase;

    public EditFcipEntityTable(String[] vars, boolean isTunnelBase) {
        super(vars);
        this._isTunnelBase = isTunnelBase;
    }

    @Override
    protected int[] getIndexFor(MibNode mibNode, int[] index) {
        if (this._isTunnelBase) {
            return new int[]{0};
        }
        return super.getIndexFor(mibNode, index);
    }

    @Override
    protected void build() {
        super.build();
        if (DmId.isAlishan(Discover.getSysObjectID())) {
            this._table.removeColumn(this._table.getColumnModel().getColumn(7));
        }
    }

    @Override
    protected boolean isAtEnd(int[] firstOid, SnmpVarBind vb, boolean isMultiple, SnmpPDU pdu) {
        if (this._isTunnelBase) {
            if (vb.getError() == 21) {
                return true;
            }
            return !SnmpOID.startsWith(firstOid, vb.getOid().getValue());
        }
        return super.isAtEnd(firstOid, vb, isMultiple, pdu);
    }

    void addVb(SnmpPDU pdu, int curr, int row, int col, int[] oid) {
        int[] index = this._tableModel.getIndex(row);
        SnmpVarBind vb = new SnmpVarBind(new SnmpOID(oid, index), (SnmpGauge)this._tableModel.getValueAt(row, col));
        pdu.getVariables().add(curr, vb);
    }

    @Override
    protected void sendPdu(SnmpPDU pdu) throws SnmpException {
        Array changedCells = this._tableModel.getChanged();
        int cellCt = changedCells.size();
        for (int i = cellCt - 1; i >= 0; --i) {
            Cell cell = (Cell)changedCells.elementAt(i);
            if (cell._col == 10) {
                if (i < 1 || ((Cell)changedCells.elementAt((int)(i - 1)))._row != cell._row || ((Cell)changedCells.elementAt((int)(i - 1)))._col != 9) {
                    this.addVb(pdu, i, cell._row, cell._col - 1, cfmFcipEntityExtTcpMinAvailBWOid);
                } else {
                    --i;
                }
                if (i < 1 || ((Cell)changedCells.elementAt((int)(i - 1)))._row != cell._row || ((Cell)changedCells.elementAt((int)(i - 1)))._col != 8) {
                    this.addVb(pdu, i, cell._row, cell._col - 2, cfmFcipEntityExtTcpMaxBWOid);
                } else {
                    --i;
                }
            }
            if (cell._col == 9) {
                this.addVb(pdu, i + 1, cell._row, cell._col + 1, cfmFcipEntityExtTcpRndTrpTimeEstOid);
                if (i < 1 || ((Cell)changedCells.elementAt((int)(i - 1)))._row != cell._row || ((Cell)changedCells.elementAt((int)(i - 1)))._col != 8) {
                    this.addVb(pdu, i, cell._row, cell._col - 1, cfmFcipEntityExtTcpMaxBWOid);
                } else {
                    --i;
                }
            }
            if (cell._col != 8) continue;
            this.addVb(pdu, i + 1, cell._row, cell._col + 2, cfmFcipEntityExtTcpRndTrpTimeEstOid);
            this.addVb(pdu, i + 1, cell._row, cell._col + 1, cfmFcipEntityExtTcpMinAvailBWOid);
        }
        super.sendPdu(pdu);
    }

    @Override
    protected DmTableModel buildTableModel() {
        return new SnmpFcipTableModel();
    }

    class SnmpFcipTableModel
    extends DmTableModel {
        SnmpFcipTableModel() {
        }

        @Override
        public boolean isCellActive(int row, int col) {
            if (col == 12 && row < EditFcipEntityTable.this._data.size()) {
                Object o = this.getValueAt(row, 11);
                return o != null && (Boolean)o != false;
            }
            return super.isCellActive(row, col);
        }
    }
}

