/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.fcip;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.dmdb.DmId;
import com.cisco.dcbu.lib.mds.FCIPDefaults;
import com.cisco.dcbu.lib.mds.SharedUtil;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.MenuButton;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class InsertFCIPEntities
extends InsertForm
implements ItemListener {
    static final int IPADDRESS = 1;
    static final int SENDBUFFERSIZE = 8;
    static final int MAXBW = 9;
    static final int MINBW = 10;
    static final int ESTRDTRIPTIME = 11;
    static final int PMTU_ENABLE = 12;
    static final int CWM_ENABLE = 14;
    static HashMap<String, FCIPDefaults> fcipDefaultHash = new HashMap();
    static FieldPanel _ipAddressField;
    static int[] CfmFcipEntityExtTcpSendBufSizeOID;

    public InsertFCIPEntities(InsertDialog parent, EditTable table) {
        super(parent, table);
    }

    @Override
    protected void build() {
        super.build();
        ((JCheckBox)this._values[12]).addItemListener(this);
        if (Discover.isSysVersionGreaterThanEqual("2.1(0)")) {
            ((JCheckBox)this._values[14]).addItemListener(this);
        }
        if (DmId.isAlishan(Discover.getSysObjectID())) {
            ((FieldPanel)this._values[8]).setVisible(false);
            this._labels[8].setVisible(false);
        }
    }

    @Override
    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == 11) {
            return new JLabel("<html><div align=right>Estimated Round<br>Trip Time:</html>", 4);
        }
        return super.createFormLabel(mibVar, index);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this._values[12]) {
            this.setEnabled(13, e.getStateChange() == 1);
        }
        if (Discover.isSysVersionGreaterThanEqual("2.1(0)") && e.getSource() == this._values[14]) {
            this.setEnabled(15, e.getStateChange() == 1);
        }
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 1) {
            _ipAddressField = new FieldPanel(15, (JComponent)new IpAddressMenuButton(null, this.getPeer()));
            _ipAddressField.getField().addFocusListener(new FcipBWListener());
            _ipAddressField.getField().addActionListener(this);
            return _ipAddressField;
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 1 && ((FieldPanel)this._values[index]).getText().equals("")) {
            throw new Exception("Please provide IPAddress");
        }
        return super.getComponentValue(index);
    }

    @Override
    protected SnmpPDU buildInsertPDU(int[] index, SnmpVar[] values) {
        SnmpPDU pdu = super.buildInsertPDU(index, values);
        SnmpVarBind tcpPortVb = pdu.getVariables().get(2);
        pdu.getVariables().remove(2);
        pdu.getVariables().add(1, tcpPortVb);
        if (DmId.isAlishan(Discover.getSysObjectID())) {
            for (int i = 0; i < pdu.getVariables().size(); ++i) {
                int[] oid = pdu.getVariables().get(i).getOid().getValue();
                if (!SnmpOID.startsWith(oid, CfmFcipEntityExtTcpSendBufSizeOID)) continue;
                pdu.getVariables().remove(i);
                break;
            }
        }
        return pdu;
    }

    @Override
    protected void insert() throws Exception {
        super.insert();
        int max = MibNode.get("cfmFcipEntityId").getHi();
        int linkId = Integer.parseInt(this.getComponentText(0));
        if (linkId < max && max != 0) {
            int index = Integer.parseInt(this.getComponentText(0));
            this.setComponentText(0, Integer.toString(index + 1));
        } else {
            this.setComponentText(0, "");
        }
    }

    private void setFCIPBW(String ipString) {
        if (fcipDefaultHash != null) {
            FCIPDefaults fcipDef = fcipDefaultHash.get(ipString);
            this.setComponentText(9, fcipDef != null && fcipDef.getDefaultTCPmax() != 0 ? Integer.toString(fcipDef.getDefaultTCPmax()) : "");
            this.setComponentText(10, fcipDef != null && fcipDef.getDefaultTCPmin() != 0 ? Integer.toString(fcipDef.getDefaultTCPmin()) : "");
        } else {
            this.setComponentText(9, "");
            this.setComponentText(10, "");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == _ipAddressField.getField()) {
            this.setFCIPBW(this.getComponentText(1));
            this.getButton('C').doClick();
            return;
        }
        super.actionPerformed(e);
    }

    static {
        CfmFcipEntityExtTcpSendBufSizeOID = MibNode.get("cfmFcipEntityExtTcpSendBufSize").getOid();
    }

    class IpAddressMenuButton
    extends MenuButton {
        SnmpPeer _peer;

        public IpAddressMenuButton(JMenu menu, SnmpPeer peer) {
            super(menu);
            this._peer = peer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JMenuItem) {
                if (this.getParent() instanceof FieldPanel) {
                    InsertFCIPEntities.this.setFCIPBW(((JMenuItem)e.getSource()).getText());
                }
            } else if (this._menu == null) {
                this._menu = new JMenu();
                try {
                    ArrayList<String> nameList = new ArrayList<String>();
                    Discover.getInstance();
                    fcipDefaultHash = SharedUtil.getEthIpAddressFCIPDefaults(this._peer, Discover.getRoot());
                    if (fcipDefaultHash == null) {
                        return;
                    }
                    Iterator<String> it = fcipDefaultHash.keySet().iterator();
                    while (it.hasNext()) {
                        nameList.add(it.next());
                    }
                    if (nameList.size() == 0) {
                        this.setEnabled(false);
                        return;
                    }
                    this.buildMenu(nameList.toArray());
                }
                catch (SnmpException snmpException) {
                    // empty catch block
                }
            }
            super.actionPerformed(e);
        }
    }

    class FcipBWListener
    extends FocusAdapter {
        FcipBWListener() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (e.getSource() == _ipAddressField.getField()) {
                InsertFCIPEntities.this.setFCIPBW(InsertFCIPEntities.this.getComponentText(1));
            }
        }
    }
}

