/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.fcip;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.dmdb.andiamo.dialogs.ficon.FiconLogicalMenuButton;
import com.cisco.dcbu.lib.jnm.SnmpFiconPort;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.mds.ficon.FiconPortByIfIndexCache;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class InsertFCIPTunnel
extends InsertForm
implements ItemListener {
    boolean is_6_2_5 = Discover.isSysVersionGreaterThanEqual("6.2(5)");
    int LINK_ID = 1;
    int IP_COMP = this.is_6_2_5 ? 11 : 10;
    int TAPE_ACCELERATOR_ENABLE = this.is_6_2_5 ? 13 : 12;
    int BUFFER_SIZE;
    int FICON_PORT;
    boolean _isFiconEnabled;
    int _ficonPort;
    MibEnum[] _enumsIpComp;
    static final MibNode cfmFcipLinkIndex = MibNode.get("cfmFcipLinkIndex");

    public InsertFCIPTunnel(InsertDialog parent, EditTable table) {
        super(parent, table);
        int n = this.BUFFER_SIZE = this.is_6_2_5 ? 14 : 13;
        this.FICON_PORT = Discover.isSysVersionlessThan("2.0(0)") ? 12 : (this.is_6_2_5 ? 15 : 14);
        this._isFiconEnabled = FiconPortByIfIndexCache.getInstance(this.getPeer()).getIsFiconEnabled();
    }

    @Override
    protected void build() {
        super.build();
        int[] index = this.getLastIndex();
        int nextValue = index == null ? 1 : index[1] + 2;
        this.setComponentText(this.LINK_ID, Integer.toString(nextValue));
        ((JCheckBox)this._values[this.TAPE_ACCELERATOR_ENABLE]).addItemListener(this);
        this.setEnabled(this.TAPE_ACCELERATOR_ENABLE + 1, false);
        ((FieldPanel)this._values[this.BUFFER_SIZE]).setText("0");
        this._labels[this.FICON_PORT].setVisible(this._isFiconEnabled);
        this._values[this.FICON_PORT].setVisible(this._isFiconEnabled);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == this.FICON_PORT) {
            return new FieldPanel(mibNode.getMaxWidth(), (JComponent)new FiconLogicalMenuButton(null, this.getPeer()));
        }
        if (mibVar.equals("cfmFcipLinkExtFlowCtrlBufSize")) {
            String tc = mibNode.getTCLabel();
            int width = this.getWidth(mibVar, mibNode, tc);
            StringBuffer sb = new StringBuffer();
            if (SnmpTableModel._Units.get(mibVar) != null) {
                sb.append((String)SnmpTableModel._Units.get(mibVar));
            }
            sb.append(" (0=Auto)");
            return new FieldPanel(width, mibNode.getLo(), mibNode.getHi(), sb.toString());
        }
        if (mibVar.equals("cfmFcipLinkExtIPComp")) {
            MibEnum[] enums = mibNode.getEnums();
            this._enumsIpComp = new MibEnum[4];
            System.arraycopy(enums, 0, this._enumsIpComp, 0, this._enumsIpComp.length);
            int grid = this.getEnumGrid(index);
            if (this._enumsIpComp.length < grid * 2) {
                grid = this._enumsIpComp.length;
            }
            return new RadioButtonPanel(this._enumsIpComp, grid);
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected int[] getInsertIndex(SnmpVar[] values) throws Exception {
        int[] index = super.getInsertIndex(values);
        int n = this.LINK_ID;
        index[n] = index[n] - 1;
        return index;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean isSelected;
        boolean bl = isSelected = e.getStateChange() == 1;
        if (e.getSource() == this._values[this.TAPE_ACCELERATOR_ENABLE]) {
            this.setEnabled(this.TAPE_ACCELERATOR_ENABLE + 1, isSelected);
        }
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == this.FICON_PORT) {
            this._ficonPort = ((FieldPanel)this._values[this.FICON_PORT]).getText().equals("") || !this._isFiconEnabled ? -1 : SnmpFiconPort.parse(((FieldPanel)this._values[this.FICON_PORT]).getText(), true);
            return null;
        }
        if (index == this.BUFFER_SIZE && ((FieldPanel)this._values[index]).getRawText().equals("0")) {
            return new SnmpGauge(0L);
        }
        if (index == this.IP_COMP) {
            int selected = ((RadioButtonPanel)this._values[index]).getSelected();
            if (selected == -1) {
                throw new Exception(this._labels[index].getText() + " please make a selection");
            }
            return new SnmpInt(this._enumsIpComp[selected].getValue());
        }
        return super.getComponentValue(index);
    }

    @Override
    protected SnmpPDU buildInsertPDU(int[] index, SnmpVar[] values) {
        SnmpPDU pdu = super.buildInsertPDU(index, values);
        if (this._ficonPort != -1) {
            int[] fcipId = new int[]{0xA000000 + index[1]};
            pdu.getVariables().add(pdu.getVariables().size(), new SnmpVarBind(new SnmpOID(FiconPortByIfIndexCache._cficonPortIfIndexOid, this._ficonPort), new SnmpInt(fcipId[0])));
        }
        return pdu;
    }

    @Override
    protected void tableInsert(SnmpVar[] values, int[] index) throws Exception {
        super.tableInsert(values, index);
        if (this._ficonPort != -1) {
            FiconPortByIfIndexCache.getInstance(this.getPeer()).setFiconPort(0xA000000 + index[1], this._ficonPort);
        }
    }

    @Override
    protected void insert() throws Exception {
        this._ficonPort = -1;
        super.insert();
        int max = cfmFcipLinkIndex.getHi();
        int linkId = Integer.parseInt(this.getComponentText(this.LINK_ID));
        if (linkId < max && max != 0) {
            int index = Integer.parseInt(this.getComponentText(this.LINK_ID)) + 1;
            this.setComponentText(this.LINK_ID, Integer.toString(index));
        } else {
            this.setComponentText(this.LINK_ID, "");
        }
    }
}

