/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.fcs;

import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dmdb.andiamo.dialogs.fcs.EditFcsIeTable;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;

public class EditFcsPlatformTable
extends EditFcsIeTable {
    static final int TYPE = 2;
    static final int SOURCE = 3;
    int NODENAMEINDEX = 7;
    int MGMTADRINDEX = 8;

    public EditFcsPlatformTable(String[] vars) {
        super(vars);
    }

    @Override
    protected Object[] buildRow(SnmpPDU pdu, int[] responseOid, int rowNo) {
        Object[] row = super.buildRow(pdu, responseOid, rowNo);
        Object[] newRow = new Object[row.length + 2];
        System.arraycopy(row, 0, newRow, 0, row.length);
        newRow[row.length] = newRow[row.length - 3];
        newRow[row.length + 1] = newRow[row.length - 2];
        return newRow;
    }

    @Override
    protected void postProcessing() throws SnmpException {
        boolean fetchNode = false;
        boolean fetchMgmt = false;
        int max = this._data.size();
        for (int i = 0; i < max; ++i) {
            Object[] row = (Object[])this._data.elementAt(i);
            if (!(row[4] instanceof SnmpInt)) continue;
            SnmpInt node = (SnmpInt)row[4];
            if (node.getValue() != 0) {
                fetchNode = true;
            } else {
                row[4] = null;
            }
            SnmpInt mgmt = (SnmpInt)row[5];
            if (mgmt.getValue() != 0) {
                fetchMgmt = true;
                continue;
            }
            row[5] = null;
        }
        if (fetchNode) {
            VarBindList vbl = new VarBindList();
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("fcsNodeNameRowStatus").getOid())));
            SnmpPDU resp = SnmpFetch.getBulk(this.getPeer(), vbl);
            this.updateColumn(4, 14, resp.getVariables(), true);
        }
        if (fetchMgmt) {
            VarBindList vbl = new VarBindList();
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("fcsMgmtAddr").getOid())));
            SnmpPDU resp = SnmpFetch.getBulk(this.getPeer(), vbl);
            this.updateColumn(5, 14, resp.getVariables(), false);
        }
    }

    @Override
    protected SnmpPDU getDeletePDU(int[] selected) {
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(selected.length));
        for (int i = 0; i < selected.length; ++i) {
            Object mgmtAdrList;
            pdu.addVar(new SnmpOID(this._rowStatus, this._tableModel.getIndex(selected[i])), new SnmpInt(this._deleteValue));
            Object nodeNameList = this._tableModel.getValueAt(selected[i], this.NODENAMEINDEX);
            if (nodeNameList != null) {
                int[] rowStatusOid = MibNode.get("fcsNodeNameRowStatus").getOid();
                this.deleteList(this.getPeer(), pdu, ((SnmpInt)nodeNameList).getValue(), 9, rowStatusOid, rowStatusOid);
            }
            if ((mgmtAdrList = this._tableModel.getValueAt(selected[i], this.MGMTADRINDEX)) == null) continue;
            int[] mibVarOid = MibNode.get("fcsMgmtAddr").getOid();
            int[] rowStatusOid = MibNode.get("fcsMgmtAddrRowStatus").getOid();
            this.deleteList(this.getPeer(), pdu, ((SnmpInt)mgmtAdrList).getValue(), 2, mibVarOid, rowStatusOid);
        }
        return pdu;
    }

    void deleteList(SnmpPeer peer, SnmpPDU deletePDU, int addrListIdx, int offset, int[] mibVar, int[] rowStatus) {
        int[] index = new int[]{addrListIdx};
        VarBindList vbl = new VarBindList(1);
        vbl.add(new SnmpVarBind(new SnmpOID(mibVar, index)));
        try {
            SnmpPDU resp = SnmpFetch.getBulk(this.getPeer(), vbl);
            vbl = resp.getVariables();
            if (vbl.size() == 0) {
                return;
            }
            index = new int[offset];
            for (int i = 0; i < vbl.size(); ++i) {
                int[] oid = vbl.get(i).getOid().getValue();
                System.arraycopy(oid, oid.length - offset, index, 0, offset);
                deletePDU.addVar(new SnmpOID(rowStatus, index), new SnmpInt(6));
            }
        }
        catch (SnmpException ex) {
            // empty catch block
        }
    }

    @Override
    protected DmTableModel buildTableModel() {
        return new SnmpPlatformTableModel();
    }

    static class SnmpPlatformTableModel
    extends DmTableModel {
        SnmpPlatformTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (col == 2) {
                Object o = this.getValueAt(row, 3);
                return o != null && o.toString().equals("createdByMgmt");
            }
            return super.isCellEditable(row, col);
        }
    }
}

