/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.fcs;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi.InsertIscsi2FcNode;
import com.cisco.dcbu.lib.mds.VsanIdMenuButton;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Dimension;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class InsertFcsPlatform
extends InsertForm {
    static final int VSANID = 0;
    static final int PLATFORMID = 1;
    static final int NODELIST = 4;
    static final int MGMTADRLIST = 5;
    JTextArea _nodeListArea;
    String[] _nodeList;
    int _nodeNameListIdx;
    JTextArea _mgmtAdrListArea;
    String[] _mgmtAdrList;
    int _mgmtAdrListIdx;

    public InsertFcsPlatform(InsertDialog parent, EditTable table) {
        super(parent, table);
    }

    @Override
    protected void build() {
        super.build();
        ((JTextField)this._values[1]).setVisible(false);
        this._labels[1].setVisible(false);
    }

    @Override
    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == 4) {
            return new JLabel("<html><div align=right>Node WWN(s):<br>(comma separated)</html>", 4);
        }
        if (index == 5) {
            return new JLabel("<html><div align=right>Management<br>Address(es):<br>(comma separated)</html>", 4);
        }
        return super.createFormLabel(mibVar, index);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 0) {
            FieldPanel f = new FieldPanel(5, (JComponent)new VsanIdMenuButton(null, this.getPeer(), Discover.getRoot()));
            f.setRange(1, 4093);
            return f;
        }
        if (index == 4) {
            this._nodeListArea = new JTextArea();
            this._nodeListArea.setWrapStyleWord(true);
            this._nodeListArea.setLineWrap(true);
            this._nodeListArea.setFont(ChangedCellRenderer.getNormalFont());
            JScrollPane sp = new JScrollPane(this._nodeListArea);
            sp.setPreferredSize(new Dimension(180, 50));
            return sp;
        }
        if (index == 5) {
            this._mgmtAdrListArea = new JTextArea();
            this._mgmtAdrListArea.setWrapStyleWord(true);
            this._mgmtAdrListArea.setLineWrap(true);
            this._mgmtAdrListArea.setFont(ChangedCellRenderer.getNormalFont());
            JScrollPane sp = new JScrollPane(this._mgmtAdrListArea);
            sp.setPreferredSize(new Dimension(180, 50));
            return sp;
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 1) {
            int vsan = Integer.parseInt(((FieldPanel)this._values[0]).getText());
            int platformId = 0;
            for (int i = 0; i < this.getTableModel().getRowCount(); ++i) {
                int[] rowIndex = this.getTableModel().getIndex(i);
                if (rowIndex[0] != vsan || rowIndex[1] <= platformId) continue;
                platformId = rowIndex[1];
            }
            return new SnmpInt(++platformId);
        }
        if (index == 4) {
            Array<String> nodeList = new Array<String>();
            String nodeListString = this._nodeListArea.getText();
            StringTokenizer st = new StringTokenizer(nodeListString, ",");
            while (st.hasMoreTokens()) {
                SnmpString wwnB;
                String wwn = st.nextToken().trim();
                try {
                    wwnB = new SnmpString(wwn);
                }
                catch (NumberFormatException ex) {
                    throw new NumberFormatException("Node  " + ex.getMessage());
                }
                MibNode fcsNodeName = MibNode.get("fcsNodeName");
                if (fcsNodeName.getMaxWidth() < wwnB.getValue().length) {
                    throw new NumberFormatException("Node  maximum length is " + fcsNodeName.getMaxWidth());
                }
                if (fcsNodeName.getMinWidth() > wwnB.getValue().length) {
                    throw new NumberFormatException("Node  minimum length is " + fcsNodeName.getMinWidth());
                }
                nodeList.addElement(wwn);
            }
            this._nodeList = new String[nodeList.size()];
            for (int i = 0; i < nodeList.size(); ++i) {
                this._nodeList[i] = (String)nodeList.elementAt(i);
            }
            return new SnmpInt(0);
        }
        if (index == 5) {
            Array<String> mgmtAdrList = new Array<String>();
            String mgmtAdrListString = this._mgmtAdrListArea.getText();
            StringTokenizer st = new StringTokenizer(mgmtAdrListString);
            while (st.hasMoreTokens()) {
                mgmtAdrList.addElement(st.nextToken().trim());
            }
            this._mgmtAdrList = new String[mgmtAdrList.size()];
            for (int i = 0; i < mgmtAdrList.size(); ++i) {
                this._mgmtAdrList[i] = (String)mgmtAdrList.elementAt(i);
            }
            return new SnmpInt(0);
        }
        return super.getComponentValue(index);
    }

    @Override
    protected void tableInsert(SnmpVar[] values, int[] index) throws Exception {
        this._mgmtAdrListIdx = -1;
        this._nodeNameListIdx = -1;
        if (this._nodeList != null && this._nodeList.length > 0) {
            this._nodeNameListIdx = InsertFcsPlatform.insertNodeNameList(this.getPeer(), null, this._nodeList);
        }
        if (this._mgmtAdrList != null && this._mgmtAdrList.length > 0) {
            this._mgmtAdrListIdx = InsertFcsPlatform.insertMgmtAdrList(this.getPeer(), null, this._mgmtAdrList);
        }
        super.tableInsert(values, index);
    }

    @Override
    protected SnmpPDU buildInsertPDU(int[] index, SnmpVar[] values) {
        SnmpPDU pdu = super.buildInsertPDU(index, values);
        if (this._mgmtAdrListIdx != -1) {
            SnmpVarBind mgmtAdrListIdx = pdu.getVariables().get(pdu.getVariables().size() - 1);
            mgmtAdrListIdx.setVar(new SnmpInt(this._mgmtAdrListIdx));
        }
        if (this._nodeNameListIdx != -1) {
            SnmpVarBind nodeNameListIdx = pdu.getVariables().get(pdu.getVariables().size() - 2);
            nodeNameListIdx.setVar(new SnmpInt(this._nodeNameListIdx));
        }
        return pdu;
    }

    public static int insertNodeNameList(SnmpPeer peer, SnmpPDU pdu, String[] nodeNameList) throws Exception {
        int[] rowStatusOid = MibNode.get("fcsNodeNameRowStatus").getOid();
        int[] index = new int[9];
        index[0] = InsertIscsi2FcNode.getLastIndex(peer, 9, "fcsNodeNameRowStatus");
        if (pdu == null) {
            pdu = new SnmpPDU(-93, new VarBindList());
        }
        for (int i = 0; i < nodeNameList.length; ++i) {
            SnmpString v = new SnmpString(nodeNameList[i]);
            byte[] b = v.getValue();
            int indexSize = 1;
            for (int j = 0; j < b.length; ++j) {
                index[indexSize++] = b[j] & 0xFF;
            }
            pdu.addVar(new SnmpOID(rowStatusOid, index), new SnmpInt(4));
        }
        peer.set(pdu);
        return index[0];
    }

    public static int insertMgmtAdrList(SnmpPeer peer, SnmpPDU pdu, String[] mgmtAdrList) throws Exception {
        int[] fcsMgmtAddrOid = MibNode.get("fcsMgmtAddr").getOid();
        int[] rowStatusOid = MibNode.get("fcsMgmtAddrRowStatus").getOid();
        int[] index = new int[]{InsertIscsi2FcNode.getLastIndex(peer, 2, "fcsMgmtAddr"), 1};
        if (pdu == null) {
            pdu = new SnmpPDU(-93, new VarBindList());
        }
        for (int i = 0; i < mgmtAdrList.length; ++i) {
            pdu.addVar(new SnmpOID(rowStatusOid, index), new SnmpInt(4));
            pdu.addVar(new SnmpOID(fcsMgmtAddrOid, index), new SnmpString(mgmtAdrList[i]));
            index[1] = index[1] + 1;
        }
        peer.set(pdu);
        return index[0];
    }
}

