/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.ficon;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditFormTable;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.SnmpFcAddressId;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.mds.VsanUtil;
import com.cisco.dcbu.lib.mds.ficon.FiconPortByIfIndexCache;
import com.cisco.dcbu.lib.mds.renderers.FiconPortIfIndexRenderer;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class EditFiconPortAttrTable
extends EditFormTable {
    static final int PORT_ADDR = 0;
    static final int UNIT_TYPE = 6;
    static final int PORT_ID = 7;
    static final int FCID = 8;
    static final int STATUS = 9;
    static final int CLEAR = 10;
    static final int IF_OPERSTATUS = 12;
    static final int SHOW_INSTALL = 0;
    static final int ESCON_STYLE = 1;
    static boolean _ShowInstalled;
    protected static boolean _ShowESCONStyle;
    protected String _ProhibitChar = "X";
    protected String _AllowChar = "";
    private int _keyCounter = -1;
    private int[] _zero = new int[]{0};
    boolean _isPortAttTable;
    SnmpString _members;
    static final int[] _vsanMembershipSummaryInterfaceOid;
    static final int[] _cficonVsanKeyCounterOid;

    public EditFiconPortAttrTable(String[] vars, String[] formVars) {
        super(vars, formVars);
        boolean bl = this._isPortAttTable = vars.length > 7 && vars[6].equals("cficonRunCfgPortId");
        if (DmSystem._AutoSave != null) {
            DmSystem._AutoSave.enable(false);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (DmSystem._AutoSave != null) {
            DmSystem._AutoSave.enable(true);
        }
    }

    @Override
    protected JComponent buildFormComponent(int index) {
        if (index == 0) {
            JCheckBox cb = new JCheckBox("Installed Ports Only");
            cb.setActionCommand("4");
            cb.addActionListener(this);
            return cb;
        }
        if (index == 1) {
            JCheckBox cb = new JCheckBox("ESCON Style", _ShowESCONStyle);
            this.setESCONStyle(_ShowESCONStyle);
            cb.setActionCommand("5");
            cb.addActionListener(this);
            return cb;
        }
        return super.buildFormComponent(index);
    }

    @Override
    protected void updateFormComponent(int index, SnmpVar v) {
        if (index == 0) {
            JCheckBox cb = (JCheckBox)this._formVars[index];
            if (v.getType() == 2) {
                this.setInstalled(((SnmpInt)v).getValue() == 2);
                cb.setSelected(_ShowInstalled);
            }
        }
    }

    protected void setInstalled(boolean isInstalled) {
        _ShowInstalled = isInstalled;
    }

    protected void setESCONStyle(boolean isESCION) {
        _ShowESCONStyle = isESCION;
        this._ProhibitChar = _ShowESCONStyle ? "P" : "X";
        this._AllowChar = _ShowESCONStyle ? "A" : "";
    }

    @Override
    protected void preGet() {
        this.getMembers();
        this.getKeyCounter();
    }

    void getKeyCounter() {
        this._keyCounter = -1;
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        pdu.addVar(new SnmpOID(_cficonVsanKeyCounterOid, this.getIndex()[0]));
        try {
            SnmpPDU resp = this.getPeer().send(pdu);
            this._keyCounter = resp.getVariables().intValue(0);
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    boolean isKeyCounterValid() throws Exception {
        boolean valid;
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        pdu.addVar(new SnmpOID(_cficonVsanKeyCounterOid, this.getIndex()[0]));
        SnmpPDU resp = this.getPeer().send(pdu);
        boolean bl = valid = resp.getVariables().intValue(0) == this._keyCounter;
        return valid || this.isIgnoreWarning("FICON Configuration has changed since last Refresh.\nDo you want to continue applying changes?");
    }

    @Override
    protected void buildTable() {
        super.buildTable();
        this.getMembers();
        this._table.getColumnModel().getColumn(0).setCellRenderer(new FiconPortIfIndexRenderer(this.getPeer(), this._members));
        boolean[] isEditable = this._tableModel.getEditable();
        if (this._isPortAttTable) {
            isEditable[9] = false;
        }
        this._tableModel.setEditable(isEditable);
    }

    @Override
    protected Object[] buildRow(SnmpPDU pdu, int[] responseOid, int rowNo) {
        Object[] row = super.buildRow(pdu, responseOid, rowNo);
        if (!this._isPortAttTable) {
            return row;
        }
        Object[] newRow = new Object[row.length + 1];
        System.arraycopy(row, 0, newRow, 0, row.length);
        return newRow;
    }

    @Override
    protected int[] getFormIndex() {
        return this._zero;
    }

    @Override
    protected void postProcessing() throws SnmpException {
        int[] oid;
        if (!this._isPortAttTable) {
            return;
        }
        VarBindList vbl = new VarBindList();
        VarBindList fcidVbl = new VarBindList();
        for (int i = 0; i < this._data.size(); ++i) {
            Object[] row = (Object[])this._data.elementAt(i);
            if (((String)row[6]).startsWith("-")) {
                row[6] = "";
            }
            row[12] = new SnmpInt(0);
            row[8] = new SnmpFcAddressId(new byte[0]);
            oid = ((SnmpOID)row[0]).getValue();
            Array list = FiconPortByIfIndexCache.getInstance(this.getPeer()).getFiconIfIndexByPortAddr(oid[oid.length - 1]);
            int ifIndex = (Integer)list.elementAt(0);
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("ifOperStatus").getOid(), ifIndex), null));
            int[] fcidIndex = new int[]{ifIndex, this.getIndex()[0]};
            fcidVbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("fcIfNxPortAddress").getOid(), fcidIndex), null));
        }
        if (vbl.size() > 0) {
            SnmpPDU resp = SnmpFetch.get(this.getPeer(), vbl);
            if (resp != null && resp.getVariables().size() > 0) {
                vbl = resp.getVariables();
                for (int i = 0; i < vbl.size(); ++i) {
                    Object[] row = (Object[])this._data.elementAt(i);
                    row[12] = new SnmpInt(vbl.intValue(i));
                }
            }
            if ((resp = SnmpFetch.next(this.getPeer(), fcidVbl)) != null && resp.getVariables().size() > 0) {
                vbl = resp.getVariables();
                for (int i = 0; i < vbl.size(); ++i) {
                    oid = vbl.get(i).getOid().getValue();
                    if (!SnmpOID.startsWith(this._mibNodes[8].getOid(), oid)) continue;
                    Object[] row = (Object[])this._data.elementAt(i);
                    int[] portNumOid = ((SnmpOID)row[0]).getValue();
                    Array list = FiconPortByIfIndexCache.getInstance(this.getPeer()).getFiconIfIndexByPortAddr(portNumOid[portNumOid.length - 1]);
                    int ifIndex = (Integer)list.elementAt(0);
                    int[] returnIndex = new int[3];
                    System.arraycopy(oid, this._mibNodes[8].getOid().length, returnIndex, 0, 3);
                    if (returnIndex[0] != ifIndex || returnIndex[1] != this.getIndex()[0]) continue;
                    row[8] = new SnmpFcAddressId(vbl.byteValue(i));
                }
            }
        }
    }

    @Override
    protected void doIt(char ch, ActionEvent e) throws Exception {
        if (ch == '4') {
            boolean isInstalled = ((JCheckBox)this._formVars[0]).isSelected();
            SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
            pdu.addVar(new SnmpOID(MibNode.get("cficonShowPorts").getOid(), 0), new SnmpInt(isInstalled ? 2 : 1));
            pdu.setIgnoreSetCount(true);
            this.sendPdu(pdu);
            this.setInstalled(isInstalled);
            this.get();
        } else if (ch == '5') {
            this.setESCONStyle(((JCheckBox)this._formVars[1]).isSelected());
            this._table.repaint();
        } else {
            super.doIt(ch, e);
        }
    }

    @Override
    protected DmTableModel buildTableModel() {
        return new SnmpFiconPortAttrTableModel();
    }

    void getMembers() {
        try {
            this._members = new SnmpIntList(new byte[144], (IfIndexIf)Discover.getRoot());
            VarBindList vbl = new VarBindList();
            vbl.add(new SnmpVarBind(new SnmpOID(_vsanMembershipSummaryInterfaceOid, this.getIndex()[0])));
            SnmpPDU resp = SnmpFetch.getBulk(Discover.getPeer(), vbl, 0);
            vbl = resp.getVariables();
            for (int i = 0; i < vbl.size(); ++i) {
                SnmpVarBind vb = vbl.get(i);
                int[] oid = vb.getOid().getValue();
                int ifIndex = oid[oid.length - 1];
                int card = Discover.getRoot().ifIndex2Card(ifIndex);
                int port = Discover.getRoot().ifIndex2Port(ifIndex);
                VsanUtil.setBit(this._members.getValue(), card, port);
            }
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    static {
        _vsanMembershipSummaryInterfaceOid = MibNode.get("vsanMembershipSummaryInterface").getOid();
        _cficonVsanKeyCounterOid = MibNode.get("cficonVsanKeyCounter").getOid();
    }

    static class SnmpFiconPortAttrTableModel
    extends DmTableModel {
        SnmpFiconPortAttrTableModel() {
        }

        @Override
        public boolean isCellActive(int row, int col) {
            if (col >= 0 && col <= 8) {
                Object operStatus = this.getValueAt(row, 12);
                return operStatus != null && ((SnmpInt)operStatus).getValue() == 1;
            }
            if (col == 10) {
                Object status = this.getValueAt(row, 9);
                return status != null && ((MibEnum)status).getValue() == 3;
            }
            return super.isCellActive(row, col);
        }

        @Override
        public Object toCellEditTable(MibNode mibNode, SnmpPDU pdu, SnmpVarBind vb, String var, SnmpOID index, int row, int col) {
            if (col == 9) {
                return Boolean.FALSE;
            }
            return super.toCellEditTable(mibNode, pdu, vb, var, index, row, col);
        }

        @Override
        protected SnmpVar getChangedCell(int row, int col) throws Exception {
            if (col == 10) {
                return new SnmpInt(2);
            }
            return super.getChangedCell(row, col);
        }
    }
}

