/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.ficon;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.dmdb.andiamo.elements.Port;
import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpFiconPort;
import com.cisco.dcbu.lib.mds.FiconCacheIf;
import com.cisco.dcbu.lib.mds.InterfacePortsCellEditor;
import com.cisco.dcbu.lib.mds.PortEditorCardAttribute;
import com.cisco.dcbu.lib.mds.PortEditorFilter;
import com.cisco.dcbu.lib.mds.VsanUtil;
import com.cisco.dcbu.lib.mds.ficon.FiconPortByIfIndexCache;
import com.cisco.dcbu.lib.mds.ficon.FiconPortList;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import javax.swing.event.ListSelectionEvent;

public class EditVsanFiconTable
extends EditTable {
    static final int MEMBER = 1;
    int _lastSelectedRow = -1;
    Array _portMemberShip;
    Array _errorMember;
    Array _warningMember;
    static final int[] _cficonSetHostTimeControlOid = MibNode.get("cficonSetHostTimeControl").getOid();
    static final int[] _vsanIfVsanOid = MibNode.get("vsanIfVsan").getOid();
    public static final int _defaultVSAN = 1;

    public EditVsanFiconTable(String[] vars) {
        super(vars);
    }

    @Override
    protected void buildTable() {
        super.buildTable();
        InterfacePortsCellEditor edtrRndr = new InterfacePortsCellEditor(Discover.getDeviceName(), 3, false, Discover.getRoot(), DmSystem.getCardAttributes(), new PortEditorFilter(new int[]{1, 153, 152}), this.getPeer(), 6);
        this._table.getColumnModel().getColumn(1).setCellEditor(edtrRndr);
    }

    @Override
    protected void updateTable() {
        if (this.getStatus().startsWith("timeout")) {
            super.updateTable();
        } else {
            this.fetchPortMembership();
        }
    }

    protected void fetchPortMembership() {
        try {
            Object[] row;
            int i;
            VarBindList vbl = new VarBindList();
            vbl.add(new SnmpVarBind(new SnmpOID(_vsanIfVsanOid)));
            SnmpPDU resp = SnmpFetch.getBulk(this.getPeer(), vbl, 0);
            int max = this._data.size();
            for (i = 0; i < max; ++i) {
                row = (Object[])this._data.elementAt(i);
                row[1] = new FiconPortList(new byte[242], (IfIndexIf)Discover.getRoot(), this.getPeer());
            }
            vbl = resp.getVariables();
            for (i = 0; i < vbl.size(); ++i) {
                SnmpVarBind vb = vbl.get(i);
                int[] oid = vb.getOid().getValue();
                int ifIndex = oid[oid.length - 1];
                int vsan = ((SnmpInt)vb.getVar()).getValue();
                SnmpString s = this.getPortMembership(vsan);
                if (IfIndexUtil.getType(ifIndex) == 1) {
                    if (s == null) continue;
                    int card = Discover.getRoot().ifIndex2Card(ifIndex);
                    int port = Discover.getRoot().ifIndex2Port(ifIndex);
                    VsanUtil.setBit(s.getValue(), card, port);
                    continue;
                }
                if (IfIndexUtil.getType(ifIndex) == 4) {
                    if (s == null) continue;
                    int portChannel = IfIndexUtil.ifIndex2PortChannel(ifIndex);
                    VsanUtil.setBit(s.getValue(), portChannel + 1152);
                    continue;
                }
                if (IfIndexUtil.getType(ifIndex) != 10 || s == null) continue;
                int fcip = IfIndexUtil.ifIndex2Fcip(ifIndex);
                VsanUtil.setBit(s.getValue(), fcip + 1408);
            }
            max = this._data.size();
            for (i = 0; i < max; ++i) {
                row = (Object[])this._data.elementAt(i);
                FiconPortList p = (FiconPortList)row[1];
                p._value = VsanUtil.getVSanLabel(p.getValue(), true, Discover.getRoot(), (FiconCacheIf)((Object)Discover.getRoot()));
            }
        }
        catch (SnmpException ex) {
            this.setStatus(ex.toString());
        }
        super.updateTable();
    }

    SnmpString getPortMembership(int vsan) {
        int max = this._data.size();
        for (int i = 0; i < max; ++i) {
            Object[] row = (Object[])this._data.elementAt(i);
            int v = ((SnmpOID)row[0]).getValue()[0];
            if (v != vsan) continue;
            return (FiconPortList)row[1];
        }
        return null;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (!DeviceManager.getInstance().showingPhysicalView()) {
            return;
        }
        int[] rows = this._table.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        SnmpString members = (SnmpString)this._tableModel.getValueAt(rows[0], 1);
        PhysicalView view = DeviceManager.getInstance().getView();
        if (this._lastSelectedRow == rows[0] && view.getFirstSelected() instanceof Port) {
            return;
        }
        view.clearSelection();
        if (members.toString().length() > 0) {
            Array elements = view.getElements();
            for (int i = elements.size() - 1; i >= 0; --i) {
                PhysicalElement el = (PhysicalElement)elements.elementAt(i);
                if (!(el instanceof Port)) continue;
                int card = Discover.getRoot().ifIndex2Card(el.getIndex()[0]);
                int port = Discover.getRoot().ifIndex2Port(el.getIndex()[0]);
                if (!VsanUtil.getBit(members.getValue(), (card << 6) + port)) continue;
                el.setSelected(true);
            }
        }
        view.repaint();
        this._lastSelectedRow = rows[0];
    }

    @Override
    protected void addEnumCellEditorEMTable(MibNode[] _mibNodes) {
        super.addEnumCellEditorEMTable(_mibNodes);
        this._table.getColumnModel().getColumn(1).setCellEditor(this._table.getDefaultCellEditor());
    }

    @Override
    protected void sendPdu(SnmpPDU pdu) throws SnmpException {
        Array changedCells = this._tableModel.getChanged();
        SnmpPDU memberPDU = new SnmpPDU(-93, new VarBindList());
        this._portMemberShip = null;
        this._errorMember = null;
        this._warningMember = null;
        for (int i = pdu.getVariables().size() - 1; i >= 0; --i) {
            SnmpVarBind vb = pdu.getVariables().get(i);
            SnmpOID oid = vb.getOid();
            if (!oid.startsWith(_cficonSetHostTimeControlOid)) continue;
            pdu.getVariables().remove(i);
            int vsan = oid.getValue()[_cficonSetHostTimeControlOid.length];
            Cell cell = (Cell)changedCells.elementAt(i);
            Object[] values = (Object[])this._data.elementAt(cell._row);
            Object[] changed = (Object[])values[this._tableModel.getHeaders().length];
            this.getPortMembershipPDU(memberPDU, vsan, (FiconPortList)vb.getVar(), (FiconPortList)changed[1]);
        }
        if (this._warningMember != null && this._warningMember.size() > 0) {
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            for (int i = 0; i < this._warningMember.size(); ++i) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                int ficonPort = (Integer)this._warningMember.elementAt(i);
                sb.append(SnmpFiconPort.toString(ficonPort));
            }
            throw new SnmpException("Please assign interface to the following ficon port(s) " + sb + " first");
        }
        if (this._errorMember != null && this._errorMember.size() > 0) {
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            for (int i = 0; i < this._errorMember.size(); ++i) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                int ifIndex = (Integer)this._errorMember.elementAt(i);
                sb.append(SnmpFiconPort.toString(FiconPortByIfIndexCache.getInstance(this.getPeer()).getFiconPort(ifIndex)));
            }
            throw new SnmpException("Please re-assign ficon port " + sb + " to a new VSAN");
        }
        if (pdu.getVariables().size() > 0) {
            super.sendPdu(pdu);
        }
        if (memberPDU.getVariables().size() > 0) {
            super.sendPdu(memberPDU);
            this.fetchPortMembership();
        }
    }

    void getPortMembershipPDU(SnmpPDU memberPDU, int vsan, FiconPortList newMembership, FiconPortList oldMembership) throws SnmpException {
        int i;
        int[] newIfIndex = FiconPortList.parse(newMembership._value, Discover.getRoot(), this.getPeer());
        int[] oldIfIndex = FiconPortList.parse(oldMembership._value, Discover.getRoot(), this.getPeer());
        int[] newFiconPortList = FiconPortList.parse(newMembership._value, (IfIndexIf)Discover.getRoot(), this.getPeer(), false);
        for (int i2 = 0; i2 < newIfIndex.length; ++i2) {
            if (newIfIndex[i2] != -1) continue;
            this.addToWarningList(newFiconPortList[i2]);
        }
        if (this._warningMember != null && this._warningMember.size() > 0) {
            return;
        }
        int startJ = 0;
        int startI = 0;
        block1: for (i = 0; i < newIfIndex.length; ++i) {
            for (int j = startJ; j < oldIfIndex.length; ++j) {
                if (newIfIndex[i] == oldIfIndex[j]) {
                    ++startJ;
                    ++startI;
                    continue block1;
                }
                if (newIfIndex[i] > oldIfIndex[j]) {
                    if (!this.isInList(oldIfIndex[j])) {
                        this.addToErrList(oldIfIndex[j]);
                    }
                    ++startJ;
                    continue;
                }
                memberPDU.addVar(new SnmpOID(_vsanIfVsanOid, newIfIndex[i]), new SnmpInt(vsan));
                this.addToList(newIfIndex[i]);
                ++startI;
                continue block1;
            }
        }
        if (oldIfIndex.length == 0 || newIfIndex.length > 0 && newIfIndex[newIfIndex.length - 1] > oldIfIndex[oldIfIndex.length - 1]) {
            for (i = startI; i < newIfIndex.length; ++i) {
                memberPDU.addVar(new SnmpOID(_vsanIfVsanOid, newIfIndex[i]), new SnmpInt(vsan));
                this.addToList(newIfIndex[i]);
            }
        }
        if (newIfIndex.length == 0 || oldIfIndex.length > 0 && oldIfIndex[oldIfIndex.length - 1] > newIfIndex[newIfIndex.length - 1]) {
            for (i = startJ; i < oldIfIndex.length; ++i) {
                if (this.isInList(oldIfIndex[i])) continue;
                this.addToErrList(oldIfIndex[i]);
            }
        }
    }

    void addToErrList(int ifIndex) {
        if (this._errorMember == null) {
            this._errorMember = new Array();
        }
        this._errorMember.addElement(new Integer(ifIndex));
    }

    void addToWarningList(int ficonPort) {
        if (this._warningMember == null) {
            this._warningMember = new Array();
        }
        this._warningMember.addElement(new Integer(ficonPort));
    }

    void removeFromErrList(int ifIndex) {
        if (this._errorMember == null) {
            return;
        }
        for (int i = this._errorMember.size() - 1; i >= 0; --i) {
            if (ifIndex != (Integer)this._errorMember.elementAt(i)) continue;
            this._errorMember.removeElementAt(i);
        }
    }

    void addToList(int ifIndex) {
        if (this._portMemberShip == null) {
            this._portMemberShip = new Array();
        }
        this._portMemberShip.addElement(new Integer(ifIndex));
        this.removeFromErrList(ifIndex);
    }

    boolean isInList(int ifIndex) {
        if (this._portMemberShip == null) {
            return false;
        }
        for (int i = 0; i < this._portMemberShip.size(); ++i) {
            if (ifIndex != (Integer)this._portMemberShip.elementAt(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected DmTableModel buildTableModel() {
        return new SnmpVsanFiconTableModel();
    }

    static class MyInterfacePortsCellEditor
    extends InterfacePortsCellEditor {
        MyInterfacePortsCellEditor(String windowTitle, boolean exclusive, IfIndexIf ifIndexIf, PortEditorCardAttribute[] slotmembers, PortEditorFilter filters, SnmpPeer peer, int type) {
            super(windowTitle, 3, exclusive, ifIndexIf, slotmembers, filters, peer, type);
        }

        @Override
        protected void setIsFiconPortDialog(boolean isFicon) {
            super.setIsFiconPortDialog(true);
        }
    }

    class SnmpVsanFiconTableModel
    extends DmTableModel {
        SnmpVsanFiconTableModel() {
        }

        @Override
        protected SnmpPeer getRowPeer(int row) {
            return EditVsanFiconTable.this.getPeer();
        }
    }
}

