/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.ficon;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dmdb.andiamo.dialogs.ficon.FiconLogicalMenuButton;
import com.cisco.dcbu.lib.jnm.SnmpFiconPort;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.mds.ficon.FiconPortByIfIndexCache;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public class FiconLogicalCellEditor
extends DefaultCellEditor
implements ActionListener {
    JPopupMenu _menu;
    int _row;
    int _column;
    JTable _table;
    private Object _value;
    SnmpPeer _peer;
    static final String UNSET = "<Unset>";

    public FiconLogicalCellEditor(SnmpPeer peer) {
        super(new JComboBox());
        this.setClickCountToStart(1);
        this._peer = peer;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this._row = row;
        this._column = column;
        this._table = table;
        this._value = value;
        this._menu = new JPopupMenu();
        JCheckBoxMenuItem mi = new JCheckBoxMenuItem(UNSET);
        this._menu.add(mi);
        mi.addActionListener(this);
        String[] ports = FiconLogicalMenuButton.getLogicalFiconPorts(Discover.getPeer(), true);
        for (int j = 0; j < ports.length; ++j) {
            int ficonPort = SnmpFiconPort.parse(ports[j], true);
            Array list = FiconPortByIfIndexCache.getInstance(this._peer).getFiconIfIndexByPortAddr(ficonPort);
            if (list != null) continue;
            mi = new JCheckBoxMenuItem(ports[j]);
            this._menu.add(mi);
            mi.addActionListener(this);
        }
        Component[] changeListeners = ((SnmpKTable)this._table).getChangeListener();
        if (changeListeners != null) {
            for (int i = 0; i < changeListeners.length; ++i) {
                changeListeners[i].setEnabled(true);
            }
        }
        Rectangle rect = table.getCellRect(row, column, false);
        this._menu.show(this._table, rect.x, rect.y);
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JCheckBoxMenuItem mi = (JCheckBoxMenuItem)e.getSource();
        int modelCol = this._table.convertColumnIndexToModel(this._column);
        String ficonPortString = mi.getText().equals(UNSET) ? "" : mi.getText();
        this._table.getModel().setValueAt(ficonPortString, this._row, modelCol);
    }
}

