/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.ip;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.dmdb.DmId;
import com.cisco.dcbu.lib.jnm.SnmpInetAddress;
import com.cisco.dcbu.lib.mds.VsanIdMenuButton;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.ui.CheckBoxPanel;
import com.cisco.dcbu.lib.ui.FieldPanel;
import javax.swing.JComponent;

public class InsertIPRouteV6
extends InsertForm {
    static final int INSTANCE = 0;
    static final int DEST_TYPE = 1;
    static final int DEST = 2;
    static final int MASK = 3;
    static final int GATEWAY_TYPE = 4;
    static final int GATEWAY = 5;
    static final int METRIC = 6;
    static final int INTERFACE = 7;

    public InsertIPRouteV6(InsertDialog parent, EditTable table) {
        super(parent, table);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 7) {
            int type;
            type = DmId.isN5K(Discover.getSysObjectID()) ? (type = 3) : 2;
            FieldPanel f = new FieldPanel(mibNode.getMaxWidth(), (JComponent)new VsanIdMenuButton(null, this.getPeer(), type, Discover.getRoot()));
            return f;
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected void buildForm() {
        super.buildForm();
        this.getComponentAt(0).setVisible(false);
        this._labels[0].setVisible(false);
        this.getComponentAt(1).setVisible(false);
        this._labels[1].setVisible(false);
        this.getComponentAt(4).setVisible(false);
        this._labels[4].setVisible(false);
        this.setComponentText(0, "0");
        this.setComponentText(3, "24");
        this.setComponentText(6, "1");
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 7) {
            String ifName = ((FieldPanel)this._values[index]).getText();
            return new SnmpInt(Discover.getRoot().nameToIfIndex(ifName));
        }
        if (index == 6) {
            if (((FieldPanel)this._values[index]).getText().equals("1")) {
                return new SnmpInt(-1);
            }
        } else if (index == 0) {
            int pos;
            String ifName = ((FieldPanel)this._values[7]).getText();
            int moduleId = 0;
            if (ifName.startsWith("cpp") && (moduleId = Integer.parseInt(ifName.substring(3, pos = ifName.indexOf(47)))) < 0) {
                throw new Exception("bad interface: " + ifName);
            }
            return new SnmpInt(moduleId);
        }
        return super.getComponentValue(index);
    }

    @Override
    protected boolean isAddStringLength(MibNode mibNode, JComponent value) {
        if (mibNode.getTCLabel() == null) {
            return mibNode.getType() == 4 && !(value instanceof CheckBoxPanel);
        }
        return mibNode.getType() == 4 && !mibNode.getTCLabel().equals("FcAddressId") && !mibNode.getTCLabel().equals("FcNameId") && !mibNode.getTCLabel().equals("InetAddress");
    }

    @Override
    protected int[] getInsertIndex(SnmpVar[] values) throws Exception {
        int[] index = super.getInsertIndex(values);
        if (values[2] instanceof SnmpInetAddress) {
            int n = index[1] = ((SnmpInetAddress)values[2]).getValue().length == 16 ? 2 : 1;
        }
        if (values[5] instanceof SnmpInetAddress) {
            int len = ((SnmpInetAddress)values[5]).getValue().length;
            index[index.length - len - 1] = len == 16 ? 2 : (len == 0 ? 0 : 1);
        }
        return index;
    }
}

