/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.ip;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.lib.mds.MdsPortChooser;
import com.cisco.dcbu.lib.mds.PortEditorFilter;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.MenuButton;
import com.cisco.dcbu.lib.util.Array;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class InsertIPSecInterface
extends InsertForm {
    private static final int INTERFACE = 0;
    private static final int SETNAME = 1;
    static final int[] _cipsStaticCryptomapSetSizeOid = MibNode.get("cipsStaticCryptomapSetSize").getOid();
    static final int _oidLength = _cipsStaticCryptomapSetSizeOid.length;
    MdsPortChooser _ports;

    public InsertIPSecInterface(InsertDialog parent, EditTable table) {
        super(parent, table);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 0) {
            this._ports = new MdsPortChooser(Discover.getDeviceName(), 3, true, Discover.getRoot(), DmSystem.getCardAttributes(), new PortEditorFilter(new int[]{22, 27, 39, 41, 68}, new int[]{2}), this.getPeer(), 11);
            this._ports.addUnits("(e.g. gigE1/15, gigE2/16.1)");
            return this._ports;
        }
        if (index == 1) {
            return new FieldPanel(20, (JComponent)new SetNameMenuButton(null, this.getPeer()));
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == 0) {
            return new JLabel("Interface");
        }
        return super.createFormLabel(mibVar, index);
    }

    @Override
    public void dispose() {
        if (this._ports != null) {
            this._ports.dismiss();
        }
        super.dispose();
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 1 && ((FieldPanel)this._values[index]).getText().equals("")) {
            throw new Exception("cannot be blank");
        }
        return super.getComponentValue(index);
    }

    @Override
    protected int[] getInsertIndex(SnmpVar[] values) throws Exception {
        int[] index = super.getInsertIndex(values);
        int[] newIndex = new int[index.length];
        System.arraycopy(index, 1, newIndex, 0, index.length - 1);
        newIndex[newIndex.length - 1] = index[0];
        return newIndex;
    }

    public static String[] getProfiles(SnmpPeer peer) throws SnmpException {
        VarBindList vbl = new VarBindList();
        vbl.add(new SnmpVarBind(new SnmpOID(_cipsStaticCryptomapSetSizeOid)));
        vbl = SnmpFetch.getBulk(peer, vbl, 0).getVariables();
        if (vbl.size() == 0) {
            return null;
        }
        Array<String> profileList = new Array<String>();
        for (int i = 0; i < vbl.size(); ++i) {
            int[] oid = vbl.get(i).getOid().getValue();
            profileList.addElement(SnmpString.toString(oid, _oidLength + 1, oid.length));
        }
        if (profileList.size() == 0) {
            return null;
        }
        String[] names = new String[profileList.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = (String)profileList.elementAt(i);
        }
        return names;
    }

    static class SetNameMenuButton
    extends MenuButton {
        SnmpPeer _peer;
        EditForm _parent;

        public SetNameMenuButton(JMenu menu, SnmpPeer peer) {
            super(menu);
            this._peer = peer;
            this._parent = null;
        }

        public void setParent(EditForm parent) {
            this._parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this._menu == null) {
                this._menu = new JMenu();
                try {
                    Object[] names = InsertIPSecInterface.getProfiles(this._peer);
                    if (names == null || names.length == 0) {
                        this.setEnabled(false);
                        return;
                    }
                    this.buildMenu(names);
                }
                catch (SnmpException snmpException) {
                    // empty catch block
                }
            }
            super.actionPerformed(e);
            if (e.getSource() instanceof JMenuItem && this._parent != null) {
                this._parent.setChanged((FieldPanel)this.getParent());
            }
        }
    }
}

