/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi;

import com.cisco.dcbu.dm.DMPanel;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi.EditIScsiForm;
import com.cisco.dcbu.lib.mds.VsanIdMenuButton;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class EditIScsiIfForm
extends EditIScsiForm {
    private static final int PORTVSAN = 7;
    private static final int ENABLE = 9;
    private static final int ADDR_ASSIGN = 10;
    private static final int PORT_WWN = 11;
    private static final int NODE_WWN = 12;

    public EditIScsiIfForm(String[] vars) {
        super(vars);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (mibVar.equals("vsanIfVsan")) {
            VsanIdMenuButton vsanId = new VsanIdMenuButton(null, this.getPeer(), Discover.getRoot());
            vsanId.setParent(this);
            FieldPanel vsanIdPanel = new FieldPanel(5, (JComponent)vsanId);
            vsanIdPanel.getField().addKeyListener(new DMPanel.ChangedFieldListener());
            vsanIdPanel.setRange(1, 4094);
            return vsanIdPanel;
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected void build() {
        super.build();
        if (!this.isMultiple()) {
            JCheckBox enableBox = (JCheckBox)this.getComponentAt(9);
            ToggleEnablePanel enablePanelListener = new ToggleEnablePanel();
            enableBox.addActionListener(enablePanelListener);
            RadioButtonPanel buttonPanel = (RadioButtonPanel)this.getComponentAt(10);
            ToggleAddrAssign addrAssignListener = new ToggleAddrAssign();
            for (int i = 0; i < buttonPanel.getComponentCount(); ++i) {
                buttonPanel.getButton(i).addActionListener(addrAssignListener);
            }
        }
    }

    @Override
    protected void updateForm(SnmpPDU pdu) {
        super.updateForm(pdu);
        this.enableLabels();
    }

    @Override
    protected void doIt(char ch, ActionEvent e) throws Exception {
        super.doIt(ch, e);
        if (ch == 'A' && this.isMultiple()) {
            this.setStatus(" ");
            super.doIt('R', e);
        }
    }

    @Override
    protected DmTableModel buildTableModel() {
        return new ISCSIIfTableModel();
    }

    private void enableLabels() {
        boolean intrProxyMode = ((JCheckBox)this._values[9]).isSelected();
        this._labels[10].setEnabled(intrProxyMode);
        RadioButtonPanel buttonPanel = (RadioButtonPanel)this._values[10];
        int selectedButton = -1;
        for (int i = 0; i < buttonPanel.getComponentCount(); ++i) {
            buttonPanel.getButton(i).setEnabled(intrProxyMode);
            if (!buttonPanel.getButton(i).isSelected()) continue;
            selectedButton = i;
        }
        if (selectedButton < 1 || !intrProxyMode) {
            this._labels[11].setEnabled(false);
            ((KTextField)this._values[11]).setEnabled(false);
            this._labels[12].setEnabled(false);
            ((KTextField)this._values[12]).setEnabled(false);
            return;
        }
        if (selectedButton == 1) {
            this._labels[11].setEnabled(true);
            ((KTextField)this._values[11]).setEnabled(true);
            this._labels[12].setEnabled(true);
            ((KTextField)this._values[12]).setEnabled(true);
        }
    }

    static class ISCSIIfTableModel
    extends DmTableModel {
        ISCSIIfTableModel() {
        }

        @Override
        public boolean isCellActive(int row, int col) {
            if (col == 10) {
                return this.getValueAt(row, 9) != null && (Boolean)this.getValueAt(row, 9) != false;
            }
            if (col >= 11 && col <= 12) {
                boolean enable = this.getValueAt(row, 9) != null && (Boolean)this.getValueAt(row, 9) != false;
                boolean manual = this.getValueAt(row, 10) != null && this.getValueAt(row, 10).toString().equals("manual");
                return enable && manual;
            }
            return super.isCellActive(row, col);
        }

        @Override
        protected SnmpVar checkCell(SnmpVar v, MibNode mibNode, String name, int row, int col) throws Exception {
            if (col == 7) {
                int value = ((SnmpInt)v).getValue();
                if (value < 1 || value > 4094) {
                    throw new Exception(name + " should be in range " + 1 + ".." + 4094);
                }
                return v;
            }
            return super.checkCell(v, mibNode, name, row, col);
        }
    }

    class ToggleEnablePanel
    implements ActionListener {
        ToggleEnablePanel() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EditIScsiIfForm.this.enableLabels();
        }
    }

    class ToggleAddrAssign
    implements ActionListener {
        ToggleAddrAssign() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EditIScsiIfForm.this.enableLabels();
        }
    }
}

