/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dmdb.DmId;
import com.cisco.dcbu.dmdb.andiamo.dialogs.EditVLANBaseForm;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;

public class EditVLANForm
extends EditVLANBaseForm {
    static final int VLAN_TYPE = 0;
    static final int VLAN = 1;
    public static final int STATIC = 1;
    public static final int DYNAMIC = 2;
    public static final int MULTIVLAN = 3;
    SnmpString _vlanVar;

    public EditVLANForm(String[] vars, boolean removeHelpBtn, int first, int utilType) {
        super(vars, removeHelpBtn, first, utilType);
    }

    @Override
    protected void build() {
        super.build();
        if (this.isMultiple()) {
            this._table.removeColumn(this._table.getColumnModel().getColumn(2));
            if (!DmId.isN5K(Discover.getSysObjectID())) {
                this._table.removeColumn(this._table.getColumnModel().getColumn(1));
            }
        } else {
            this._labels[0].setVisible(DmId.isN5K(Discover.getSysObjectID()));
            this._values[0].setVisible(DmId.isN5K(Discover.getSysObjectID()));
            this._labels[1].setVisible(false);
            this._values[1].setVisible(false);
        }
    }

    @Override
    protected SnmpPDU getVlans(SnmpPDU pdu) {
        VarBindList vbl = pdu.getVariables();
        int vlanType = vbl.intValue(0);
        SnmpVar vlansVar = vbl.get(this._first).getVar();
        if (vlansVar.getType() != 5 && vlanType != 3) {
            byte[] b = new byte[512];
            ((SnmpString)vlansVar).setValue(b);
            int vlan = vbl.intValue(1);
            SnmpString.setBitBase0(((SnmpString)vlansVar).getValue(), vlan - 1);
            vbl.removeRange(this._2k, this._4k + 1);
            return pdu;
        }
        return super.getVlans(pdu);
    }
}

