/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi;

import com.cisco.dcbu.dm.ChartDialog;
import com.cisco.dcbu.dm.DMDialog;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.GraphTable;
import com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi.IscsiConnectionChartDialog;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Dimension;
import java.util.HashMap;
import javax.swing.table.AbstractTableModel;

public class GraphIscsiConnectionTable
extends GraphTable {
    HashMap _iscsiHash = new HashMap();
    Array _iSCSIConnectionList;
    Array _ipSecList;
    int _iSCSIIndexNo;

    public GraphIscsiConnectionTable(String[] vars) {
        super(vars);
    }

    @Override
    protected int getNumObjects() {
        if (this._iSCSIConnectionList == null) {
            return 0;
        }
        return this._iSCSIConnectionList.size();
    }

    @Override
    protected int[] getIndex() {
        int[] ifIndex = new int[]{super.getIndex()[0]};
        ifIndex[0] = (ifIndex[0] & 0x1FFFFFF) + 0xB000000;
        return ifIndex;
    }

    protected int[] getOriginalMultipleIndex(int row) {
        int[] ifIndex = new int[]{super.getMultipleIndex(row)[0]};
        ifIndex[0] = (ifIndex[0] & 0x1FFFFFF) + 0xB000000;
        return ifIndex;
    }

    @Override
    protected int[] getMultipleIndex(int row) {
        row = this._iSCSIConnectionList.size() > 1 ? row : 0;
        connectionkey key = (connectionkey)this._iSCSIConnectionList.elementAt(row);
        int[] index = new int[5];
        index[1] = 1;
        index[2] = key._index[0];
        index[3] = key._index[1];
        index[4] = key._index[2];
        index[0] = (Integer)this._iscsiHash.get(key);
        return index;
    }

    @Override
    protected void preGet() {
        this._iscsiHash = new HashMap();
        this._iSCSIConnectionList = new Array();
        this._ipSecList = new Array();
        this._iSCSIIndexNo = 0;
        if (this.isMultiple()) {
            for (int i = 0; i < this._parent._multipleIndeces.length; ++i) {
                this.getConnections(this.getOriginalMultipleIndex(i)[0], this._iSCSIConnectionList, this._ipSecList);
            }
        } else {
            this.getConnections(this.getIndex()[0], this._iSCSIConnectionList, this._ipSecList);
        }
        Array<Object[]> data = new Array<Object[]>();
        for (int i = 0; i < this.getNumObjects(); ++i) {
            Object[] row = new Object[this._vars.length + 1];
            row[0] = Discover.getRoot().ifIndexToName(this.getMultipleIndex(i)[0]);
            data.addElement(row);
        }
        this._data = data;
        this._model.setData(this._data);
        this._absolutes = new SnmpVar[this._data.size()][this._vars.length];
        this._cumulatives = new long[this._data.size()][this._vars.length];
        this._minimums = new long[this._data.size()][this._vars.length];
        this._maximums = new long[this._data.size()][this._vars.length];
        this._lastValues = new long[this._data.size()][this._vars.length];
        this._scrollPane.setPreferredSize(this._table.calcPreferredSize());
        if (this._iSCSIConnectionList == null || this._iSCSIConnectionList.size() == 0) {
            Dimension d = this._table.calcPreferredSize();
            this._scrollPane.setPreferredSize(d);
            if (d.width > 1008) {
                this._table.setAutoResizeMode(0);
            }
            this._table.getTableHeader().resizeAndRepaint();
            ((KTableModel)this._table.getModel()).fireTableDataChanged();
            return;
        }
        int indexColWidth = this.getInitiatorTargetInfo(data);
        this._table.getColumnModel().getColumn(0).setPreferredWidth(indexColWidth);
        Dimension d = this._scrollPane.getPreferredSize();
        this._scrollPane.setPreferredSize(new Dimension(d.width + indexColWidth, d.height));
        ((AbstractTableModel)this._table.getModel()).fireTableDataChanged();
    }

    void getConnections(int iscsiIndex, Array iscsiConnectionList, Array ipSecList) {
        try {
            int[] oid;
            VarBindList vbl = new VarBindList();
            int[] ipSecInUseOid = MibNode.get("cIscsiStatsIpSecInUse").getOid();
            vbl.add(new SnmpVarBind(new SnmpOID(ipSecInUseOid, iscsiIndex)));
            SnmpPDU resp = SnmpFetch.getBulk(this.getPeer(), vbl);
            vbl = resp.getVariables();
            if (vbl.size() == 0) {
                return;
            }
            for (int i = 0; i < vbl.size() && (oid = vbl.get(i).getOid().getValue())[ipSecInUseOid.length] == iscsiIndex; ++i) {
                int[] keyIndex = new int[]{oid[ipSecInUseOid.length + 2], oid[ipSecInUseOid.length + 3], oid[ipSecInUseOid.length + 4]};
                connectionkey key = new connectionkey(keyIndex);
                iscsiConnectionList.addElement(key);
                ipSecList.addElement(new Integer(vbl.intValue(i)));
                this._iscsiHash.put(key, new Integer(iscsiIndex));
            }
        }
        catch (SnmpException ex) {
            // empty catch block
        }
    }

    int getInitiatorTargetInfo(Array data) {
        VarBindList vbl = new VarBindList();
        for (int i = 0; i < this._iSCSIConnectionList.size(); ++i) {
            int[] connectionStatsIndex = this.getMultipleIndex(i);
            int[] sessionIndex = new int[connectionStatsIndex.length - 2];
            System.arraycopy(connectionStatsIndex, 1, sessionIndex, 0, sessionIndex.length);
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cIscsiSsnInitiatorName").getOid(), sessionIndex)));
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cIscsiSsnInitiatorAlias").getOid(), sessionIndex)));
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cIscsiSsnTargetName").getOid(), sessionIndex)));
        }
        try {
            SnmpPDU resp = SnmpFetch.get(this.getPeer(), vbl);
            vbl = resp.getVariables();
            if (vbl.size() == 0) {
                return 0;
            }
            int minWidth = 0;
            for (int i = 0; i < vbl.size(); i += 3) {
                Object[] row = (Object[])this._data.elementAt(i / 3);
                int id = i / 3 + 1;
                String initiator = vbl.stringValue(i);
                String alias = vbl.stringValue(i + 1);
                String target = vbl.stringValue(i + 2);
                int ipSecInUse = (Integer)this._ipSecList.elementAt(i / 3);
                StringBuffer sb = new StringBuffer();
                sb.append(", ");
                sb.append(alias.equals("") ? initiator : alias);
                if (target.equals("")) {
                    sb.append(" (Discovery)");
                } else {
                    sb.append(", ");
                    sb.append(target);
                }
                if (ipSecInUse == 1) {
                    sb.append(", ");
                    sb.append(" (IPSEC)");
                }
                row[0] = id + ": " + row[0] + sb.toString();
                if (row[0].toString().length() <= minWidth) continue;
                minWidth = this._table.getFontMetrics(this._table.getFont()).stringWidth(row[0].toString());
            }
            this._table.getColumnModel().getColumn(0).setPreferredWidth(minWidth);
            return minWidth;
        }
        catch (SnmpException ex) {
            return 0;
        }
    }

    @Override
    protected ChartDialog getChartDialog(DMDialog parent, int type, SnmpKTable table, int[] selRows, int[] selCols, String title, boolean isSnapshot) throws Exception {
        return new IscsiConnectionChartDialog(parent, type, table, selRows, selCols, title, isSnapshot);
    }

    static class connectionkey {
        public int[] _index;

        public connectionkey(int[] connectionIndex) {
            this._index = connectionIndex;
        }

        public boolean equals(Object x) {
            if (x == this) {
                return true;
            }
            if (x == null || !(x instanceof connectionkey)) {
                return false;
            }
            if (this._index.length != ((connectionkey)x)._index.length) {
                return false;
            }
            for (int i = 0; i < this._index.length; ++i) {
                if (this._index[i] == ((connectionkey)x)._index[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this._index[0] ^ this._index[1] ^ this._index[2];
        }
    }
}

