/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi;

import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi.EditIscsiPWWNTable;
import com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi.InsertIscsi2FcNode;
import com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi.InsertIscsiNode;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;

public class InsertIscsiInitPWWN
extends InsertIscsiNode {
    public InsertIscsiInitPWWN(InsertDialog parent, EditTable table) {
        super(parent, table);
        this._tableModel = this._table.getTableModel();
    }

    @Override
    protected void insert() throws Exception {
        if (((EditIscsiPWWNTable)this._table)._oldNumAuto != 0L && !this.isIgnoreWarning("<html>Are you sure you want to create Port WWN? Auto-generated Port WWN(s) will be removed before this new Port WWN is created")) {
            return;
        }
        super.insert();
    }

    @Override
    protected void tableInsert(SnmpVar[] values, int[] index) throws Exception {
        if (((EditIscsiPWWNTable)this._table)._oldNumAuto != 0L) {
            SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(1));
            SnmpVarBind numAutoVb = new SnmpVarBind(new SnmpOID(MibNode.get("iscsi2FcPortNumFCAddr").getOid(), ((EditIscsiPWWNTable)this._table)._iscsiIndex), new SnmpGauge(0L));
            pdu.addVar(numAutoVb);
            this.getPeer().set(pdu);
            this.updateCFSStatus();
        }
        super.tableInsert(values, index);
    }

    @Override
    int getNewListIndex() {
        return InsertIscsi2FcNode.getLastIndex(this.getPeer(), 2, "fcAddress");
    }

    @Override
    int[] getListIndexOid() {
        return MibNode.get("iscsi2FcPortFCAddrListIndex").getOid();
    }

    @Override
    int[] getPersistentOid() {
        return MibNode.get("iscsi2FcPortPersistentFCAddr").getOid();
    }

    @Override
    MibNode getObjectMibNode() {
        return MibNode.get("fcAddress");
    }

    @Override
    String getObjectString() {
        return "Port WWN";
    }

    @Override
    int getInitiatorName() {
        return -1;
    }
}

