/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.mds9020.syslog;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.dmdb.andiamo.dialogs.mds9020.QlogicCommandHandlerDM;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SyslogForm
extends EditForm {
    public SyslogForm(String[] vars) {
        super(vars);
    }

    @Override
    protected void buildForm() {
        this._labels = new JLabel[2];
        this._labels[1] = new JLabel("Server IP Address:", 4);
        this._values = new JComponent[2];
        this._values[0] = new JCheckBox("Enabled");
        this._values[1] = new JTextField(15);
        this._isEditable = true;
        this.addChangeListener(0);
        this.addChangeListener(1);
        this.layoutForm();
        ((JPanel)this._container).setBorder(DialogUtil._Margin);
        this._size = this._container.getPreferredSize();
    }

    @Override
    protected void get() {
        this.enableButton('R', false);
        try {
            QlogicCommandHandlerDM cmdHandler = QlogicCommandHandlerDM.getInstance(DeviceManager.getInstance(), Discover.getPeer());
            String[] out = cmdHandler.getSyslogEnable();
            ((JCheckBox)this._values[0]).setSelected(QlogicCommandHandlerDM.parseTrueValueString(out[0]));
            out = cmdHandler.getSyslogServer();
            ((JTextField)this._values[1]).setText(QlogicCommandHandlerDM.parseHexIpString(out[0]));
        }
        catch (Exception ex) {
            Util.errorMessage((Component)DeviceManager.getInstance(), ex.getMessage());
        }
        this.enableButton('R', true);
        this.resetChanges();
        this._needsRefresh = false;
        this._timeStamp = System.currentTimeMillis();
    }

    @Override
    protected void set() throws Exception {
        try {
            QlogicCommandHandlerDM cmdHandler = QlogicCommandHandlerDM.getInstance(DeviceManager.getInstance(), Discover.getPeer());
            if (this.isChanged(0)) {
                cmdHandler.setSyslogEnable(((JCheckBox)this._values[0]).isSelected() ? "True" : "False");
            }
            if (this.isChanged(1)) {
                byte[] b = SnmpIpAddress.parse(((JTextField)this._values[1]).getText());
                String hexString = SnmpString.toHexString(b, 0, b.length, false);
                cmdHandler.setSyslogServer(hexString);
            }
        }
        catch (Exception ex) {
            this.setStatus("  ");
            throw new Exception(ex.getMessage());
        }
        this.resetChanges();
        this.setStatus("ok");
    }

    @Override
    protected void resetChanges() {
        for (int i = 0; i < this._values.length; ++i) {
            this.clearChanged(this._values[i]);
        }
        this.enableButton('A', false);
        this.enableButton('u', false);
        this.enableButton('P', false);
    }
}

