/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.physical;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dmdb.DmId;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.dmdb.andiamo.elements.Card_1;
import com.cisco.dcbu.dmdb.andiamo.elements.Chassis;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.mds.renderers.ErrorColorRenderer;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class EditCardForm
extends EditForm {
    int[] sysOid = Discover.getSysObjectID();
    private int _operStatusPos = 2;
    private int _resetPos = 3;
    private int _resetReasonPos = 4;
    private int _xcvrFrequencyPos = 5;
    private int _localSwitchingPos = 5;
    private int _powerAdminPos = 5;
    private int _unitPos = 7;
    private int _currentPos = 8;
    private int _unitPosInPDU = 7;
    private int _currentPosInPDU = 8;
    private JTextArea _resetReason;
    int _activeSup;
    int _standbySup;
    int _standbyState;
    int _units = 4200;
    String _standbyStateString;
    MibNode _cRFStatusPeerUnitState = MibNode.get("cRFStatusPeerUnitState");
    MibNode _cefcModuleAdminStatus = MibNode.get("cefcModuleAdminStatus");
    MibNode _cefcFRUPowerAdminStatus = MibNode.get("cefcFRUPowerAdminStatus");
    MibNode _fcIfModuleXcvrFrequencyConfig = MibNode.get("fcIfModuleXcvrFrequencyConfig");
    int[] _fcIfModuleBandwidthFairnessConfigOid = MibNode.get("fcIfModuleBandwidthFairnessConfig").getOid();
    String _cefcModuleAdminStatusTC = MibNode.get("cefcModuleAdminStatus").getTCLabel();
    private static final int UNKNOWN = 0;
    Chassis coreChassis = DmSystem.getCoreSwitchChassis();

    public EditCardForm(String[] vars) {
        super(vars);
        this._activeSup = DmSystem.getActiveSup()[0];
        this._standbySup = DmSystem.getStandbySup()[0];
        this._standbyState = DmSystem.getStandbySupStatus();
        this._standbyStateString = MibEnum.getLabel(this._cRFStatusPeerUnitState.getEnums(), this._standbyState);
        this._resetReasonPos = this.getVarIndex("cefcModuleResetReasonDescription");
        this._powerAdminPos = this.getVarIndex("cefcFRUPowerAdminStatus");
        this._localSwitchingPos = this.getVarIndex("cefcModuleLocalSwitchingMode");
        this._xcvrFrequencyPos = this.getVarIndex("fcIfModuleXcvrFrequencyConfig");
        this._currentPos = this.getVarIndex("cefcFRUCurrent");
        this._unitPos = this.getVarIndex("cefcPowerUnits");
        this._currentPosInPDU = this._currentPos - 1;
        this._unitPosInPDU = this._unitPos - 1;
        this._operStatusPos = this.getVarIndex("cefcModuleOperStatus");
        this._resetPos = this.getVarIndex("cefcModuleAdminStatus");
    }

    @Override
    protected int[] getIndex(int varIndex) {
        int[][] PowerSupplyIndex;
        if (this._unitPos != -1 && varIndex == this._unitPos && (PowerSupplyIndex = DmSystem.getPowerSupplyIndeces()) != null) {
            return PowerSupplyIndex[0];
        }
        return super.getIndex(varIndex);
    }

    @Override
    protected void preGet() throws SnmpException {
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        pdu.addNull(new SnmpOID(MibNode.get("cRFStatusPeerUnitState").getOid(), 0));
        try {
            SnmpPDU resp = this.getPeer().set(pdu);
            this._standbyState = resp.getVariables().intValue(0);
            this._standbyStateString = MibEnum.getLabel(this._cRFStatusPeerUnitState.getEnums(), this._standbyState);
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    @Override
    protected void build() {
        super.build();
        if (!this.isMultiple() && Discover.isSysVersionGreaterThanEqual("5.2(0)") && !Discover.getRoot().isN5K()) {
            if (this._localSwitchingPos < 0) {
                return;
            }
            int offset = FRUConstants.getComponentOffset(this.getIndex()[0]);
            int satSwitchId = FRUConstants.getSatelliteSwitchId(this.getIndex()[0]);
            int moduleType = Discover.getRoot().getCardType4Slot(satSwitchId, offset - 21);
            if (moduleType > 0 && moduleType != 53 && moduleType != 54) {
                this._values[this._localSwitchingPos].setVisible(false);
                this._labels[this._localSwitchingPos].setVisible(false);
            }
        }
        if (this.isMultiple() && this._operStatusPos != -1) {
            this._table.getColumnModel().getColumn(this._operStatusPos + 1).setCellRenderer(new ErrorColorRenderer(new String[]{"ok", "disabled", "okButDiagFailed", "boot", "selfTest", "on", "offAdmin", "up", "n/a"}, Color.yellow));
        }
    }

    @Override
    protected JComponent buildNonEditableComponent(String mibVar, MibNode mibNode, int index) {
        if (index == this._resetReasonPos) {
            this._resetReason = new JTextArea();
            this._resetReason.setEditable(false);
            this._resetReason.setWrapStyleWord(true);
            this._resetReason.setLineWrap(true);
            this._resetReason.setFont(ChangedCellRenderer.getNormalFont());
            this._resetReason.setBackground((Color)UIManager.getDefaults().get("Label.background"));
            this._resetReason.setPreferredSize(new Dimension(150, 30));
            JScrollPane sp = new JScrollPane(this._resetReason);
            sp.setPreferredSize(new Dimension(150, 40));
            return sp;
        }
        return super.buildNonEditableComponent(mibVar, mibNode, index);
    }

    @Override
    protected void setComponentValue(int i, SnmpVar v) {
        if (i == this._resetPos || i == this._powerAdminPos) {
            if (i == this._resetPos) {
                boolean isSelected = this._cefcModuleAdminStatusTC.charAt(0) == 'A' ? false : ((SnmpInt)v).getValue() == 3;
                ((JCheckBox)this._values[i]).setSelected(isSelected);
            } else {
                super.setComponentValue(i, v);
            }
            this._values[i].setEnabled(this.isSupportReset(this.getIndex()[0]));
        } else if (i == this._resetReasonPos) {
            this._resetReason.setText(v.toString());
        } else if (i == this._operStatusPos) {
            if (this.getIndex()[0] == this._activeSup) {
                ((JLabel)this._values[i]).setText("active");
            } else if (this.getIndex()[0] == this._standbySup && this._standbyState != 0) {
                ((JLabel)this._values[i]).setText(this._standbyStateString);
            } else {
                super.setComponentValue(i, v);
            }
        } else if (i == this._xcvrFrequencyPos) {
            this._values[i].setEnabled(!this.isXBar(this.getIndex()[0]));
        } else {
            super.setComponentValue(i, v);
        }
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == this._resetPos) {
            return new SnmpInt(3);
        }
        return super.getComponentValue(index);
    }

    @Override
    protected void setComponentLabel(JLabel l, SnmpVar v, String var, MibNode mibNode) {
        String unit;
        int pos;
        if (var.equals("cefcFRUCurrent")) {
            l.setText(this.getCurrent(((SnmpInt)v).getValue(), this._units));
            return;
        }
        if (var.equals("cefcPowerUnits") && (pos = (unit = v.toString()).indexOf(64)) != -1) {
            try {
                this._units = Integer.parseInt(unit.substring(pos + 2, unit.indexOf(86))) * 100;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        super.setComponentLabel(l, v, var, mibNode);
    }

    private String getCurrent(int current, int units) {
        if (current == 0) {
            return "n/a";
        }
        double amp = Math.abs((double)current / 100.0);
        double amps = (double)units * 1.0;
        int watt = (int)(amp * amps);
        return units == 0 ? amp + "A" : (double)watt / 100.0 + "W / " + amp + "A";
    }

    @Override
    protected void buildRow(Object[] row, SnmpPDU pdu, int rowNo) {
        super.buildRow(row, pdu, rowNo);
        String unit = "";
        int totalCurrent = 0;
        if (this._currentPos > 0) {
            unit = pdu.getVariables().stringValue(this._unitPosInPDU);
            totalCurrent = pdu.getVariables().intValue(this._currentPosInPDU);
            int units = 4200;
            int pos = unit.indexOf(64);
            if (pos != -1) {
                try {
                    units = Integer.parseInt(unit.substring(pos + 2, unit.indexOf(86))) * 100;
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            row[this._currentPos] = this.getCurrent(totalCurrent, units);
        }
        if (this._operStatusPos != -1) {
            if (((SnmpOID)row[0]).getValue()[0] == this._activeSup) {
                row[this._operStatusPos + 1] = "active";
            } else if (((SnmpOID)row[0]).getValue()[0] == this._standbySup && this._standbyState != 0) {
                row[this._operStatusPos + 1] = this._standbyStateString;
            }
        }
    }

    @Override
    protected void updateForm(SnmpPDU pdu) {
        super.updateForm(pdu);
        if (this._resetReasonPos != -1) {
            this._parent.setPreferredSize(new Dimension(360, 165));
            this._parent.validate();
            this._parent.invalidate();
            this._parent.pack();
        }
    }

    @Override
    protected void sendPdu(SnmpPDU pdu) throws SnmpException {
        super.sendPdu(pdu);
        for (int i = 0; i < pdu.getVariables().size(); ++i) {
            if (!pdu.getVariables().get(i).getOid().startsWith(this._fcIfModuleBandwidthFairnessConfigOid)) continue;
            JOptionPane.showMessageDialog(this._parent, "Bandwidth fairness configuration changes will be effective upon next module reload", this._parent.getTitle(), 2);
        }
    }

    @Override
    protected boolean checkWarnVar(String mibVar, Object value, String[] warningVars) {
        if (mibVar.equals("cefcModuleAdminStatus")) {
            int standbySup;
            PhysicalElement e;
            PhysicalElement physicalElement = e = this.isMultiple() ? null : DeviceManager.getInstance().getView().find(Card_1.class, this.getIndex()[0]);
            return e == null || (standbySup = DmSystem.getStandbySup()[0]) != e.getIndex()[0] && (((Card_1)e)._activeSup != e.getIndex()[0] || standbySup == 0);
        }
        if (mibVar.equals("cefcModuleLocalSwitchingMode")) {
            return true;
        }
        return super.checkWarnVar(mibVar, value, warningVars);
    }

    @Override
    protected boolean validateFormChanges(String[][] warnVars, String[] message) throws Exception {
        if (this._warningVars == null || this._warningVars.length == 0) {
            return true;
        }
        boolean needWarning = false;
        StringBuffer warnMsg = new StringBuffer();
        for (int i = 0; i < this._vars.length; ++i) {
            if (this._mibNodes[i] == null || !this.isEditable(this._mibNodes[i]) || !this.isChanged(i)) continue;
            for (int j = 0; j < warnVars.length; ++j) {
                if (!this.isWarnVar(this._vars[i], this.getComponentValue(i), warnVars[j], new Integer(i))) continue;
                needWarning = true;
                if (warnMsg.toString().length() > 0) {
                    int trimOffset = warnMsg.indexOf("Continue?");
                    if (trimOffset != -1) {
                        warnMsg = new StringBuffer(warnMsg.substring(0, trimOffset));
                    } else {
                        warnMsg.append('\n');
                    }
                }
                warnMsg.append(message[j]);
            }
        }
        if (needWarning) {
            return JOptionPane.showConfirmDialog(this.getParent(), warnMsg.toString(), this._parent.getTitle(), 0) == 0;
        }
        return true;
    }

    @Override
    protected boolean isEditable(MibNode mibNode) {
        if (mibNode.equals(this._cefcFRUPowerAdminStatus)) {
            return this.isSupportReset(this.getIndex()[0]);
        }
        if (mibNode.equals(this._fcIfModuleXcvrFrequencyConfig)) {
            return !this.isXBar(this.getIndex()[0]);
        }
        return super.isEditable(mibNode);
    }

    private boolean isSupportReset(int moduleId) {
        if (DmId.isN5K(Discover.getSysObjectID()) || DmId.isN7K(Discover.getSysObjectID())) {
            return false;
        }
        return !this.isXBar(moduleId);
    }

    private boolean isXBar(int moduleId) {
        int[] cardTypes;
        int slotId;
        return this.coreChassis != null && ((slotId = moduleId - 21 - 1) >= (cardTypes = this.coreChassis.getCardTypes()).length || FRUConstants.isXBar(cardTypes[slotId]));
    }

    @Override
    protected DmTableModel buildTableModel() {
        return new SnmpCardlTableModel();
    }

    class SnmpCardlTableModel
    extends DmTableModel {
        SnmpCardlTableModel() {
        }

        @Override
        public int[] getIndex(int row, int cell) {
            int[][] PowerSupplyIndex;
            if (EditCardForm.this._unitPos != -1 && cell == EditCardForm.this._unitPos && (PowerSupplyIndex = DmSystem.getPowerSupplyIndeces()) != null) {
                return PowerSupplyIndex[0];
            }
            return super.getIndex(row, cell);
        }

        @Override
        public boolean isCellActive(int row, int col) {
            if (EditCardForm.this._resetPos != -1 && col == EditCardForm.this._resetPos + 1 || EditCardForm.this._powerAdminPos > 0 && col == EditCardForm.this._powerAdminPos) {
                int moduleId = ((SnmpOID)this.getValueAt(row, 0)).getValue()[0];
                return EditCardForm.this.isSupportReset(moduleId);
            }
            if (EditCardForm.this._xcvrFrequencyPos > 0 && col == EditCardForm.this._xcvrFrequencyPos + 1) {
                int moduleId = ((SnmpOID)this.getValueAt(row, 0)).getValue()[0];
                return !EditCardForm.this.isXBar(moduleId);
            }
            if (EditCardForm.this._localSwitchingPos >= 0 && col == EditCardForm.this._localSwitchingPos + 1) {
                if (DmId.isN5K(Discover.getSysObjectID())) {
                    return false;
                }
                int slot = FRUConstants.getComponentOffset(((SnmpOID)this.getValueAt(row, 0)).getValue()[0]);
                int satSwitchId = FRUConstants.getSatelliteSwitchId(((SnmpOID)this.getValueAt(row, 0)).getValue()[0]);
                int moduleType = Discover.getRoot().getCardType4Slot(satSwitchId, slot - 21);
                if (moduleType > 0 && moduleType != 53 && moduleType != 54) {
                    return false;
                }
            }
            return super.isCellActive(row, col);
        }

        @Override
        public Object toCell(MibNode mibNode, SnmpVar v, String var, int row) {
            return super.toCell(mibNode, v, var, row);
        }
    }
}

