/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.physical;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dmdb.andiamo.elements.Card_1;
import com.cisco.dcbu.dmdb.andiamo.elements.FlashDev;
import com.cisco.dcbu.dmdb.andiamo.elements.Pcmcia;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import java.awt.Component;
import java.awt.Cursor;
import java.util.HashMap;

public class EditPcmciaTable
extends EditTable {
    HashMap _flashDeviceHash = new HashMap();
    int _activeSupFlag = -1;
    static final int ON_ACTIVE = 1;
    static final int ON_STANDBY = 2;

    public EditPcmciaTable(String[] vars) {
        super(vars);
    }

    @Override
    protected int[] getIndex() {
        return new int[]{0};
    }

    @Override
    protected int[] getMultipleIndex(int row) {
        return new int[]{0};
    }

    private void getFlashDevices() throws SnmpException {
        VarBindList vbl = new VarBindList(2);
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("ciscoFlashDeviceName").getOid())));
        SnmpPDU resp = SnmpFetch.getBulk(this.getPeer(), vbl, 0);
        vbl = resp.getVariables();
        if (vbl.size() == 0) {
            return;
        }
        for (int i = 0; i < vbl.size(); ++i) {
            int[] oid = vbl.get(i).getOid().getValue();
            String name = vbl.stringValue(i);
            if (!name.startsWith("slot0") && !name.startsWith("usb")) continue;
            this._flashDeviceHash.put(new Integer(oid[oid.length - 1]), name);
        }
    }

    @Override
    protected void preGetMultiple(int row) {
        PhysicalElement[] selected = DeviceManager.getInstance().getView().getSelected();
        if (row < selected.length && (selected[row] instanceof Pcmcia || selected[row] instanceof FlashDev)) {
            this._activeSupFlag = -1;
            if (selected[row].getParent() instanceof Card_1) {
                this._activeSupFlag = ((Card_1)selected[row].getParent())._activeSup == -1 ? 2 : 1;
            }
        }
    }

    @Override
    protected void get() {
        PhysicalElement[] selected = DeviceManager.getInstance().getView().getSelected();
        if (selected.length == 0 || !(selected[0] instanceof Pcmcia) && !(selected[0] instanceof FlashDev)) {
            return;
        }
        int activeSupFlag = -1;
        if (selected[0].getParent() instanceof Card_1) {
            int n = activeSupFlag = ((Card_1)selected[0].getParent())._activeSup == -1 ? 2 : 1;
        }
        if (!this.getButton('R').isEnabled() && this._activeSupFlag != -1) {
            if (activeSupFlag != this._activeSupFlag) {
                Util.errorMessage((Component)this.getParent(), "Please wait until current table is complete.");
            }
            return;
        }
        this._activeSupFlag = activeSupFlag;
        this._flashDeviceHash = new HashMap();
        try {
            this.getFlashDevices();
        }
        catch (SnmpException ex) {
            boolean timedOut = ex.getMessage().indexOf("timeout") != -1;
            String errMsg = timedOut ? "timeout at " : "error at ";
            this.setErrorStatus(errMsg + "0 rows");
            this._parent.setCursor(Cursor.getDefaultCursor());
            this._refreshing = false;
            this.updateTableLater();
            return;
        }
        if (this._flashDeviceHash.size() == 0) {
            return;
        }
        super.get();
    }

    @Override
    protected boolean isSkip(SnmpPDU pdu) {
        int[] oid = pdu.getVariables().get(0).getOid().getValue();
        int index = oid[oid.length - 2];
        String partitionName = pdu.getVariables().stringValue(0);
        boolean match = this._activeSupFlag == -1 ? true : partitionName.startsWith("sup-local") && this._activeSupFlag == 1 || !partitionName.startsWith("sup-local") && this._activeSupFlag == 2;
        return this._flashDeviceHash.get(new Integer(index)) == null || !match;
    }

    @Override
    protected Object[] buildRow(SnmpPDU pdu, int[] responseOid, int rowNo) {
        String partitionName = pdu.getVariables().stringValue(0);
        Object[] row = super.buildRow(pdu, responseOid, rowNo);
        if (row[0] instanceof SnmpOID) {
            row[0] = this._flashDeviceHash.get(((SnmpOID)row[0]).getValue()[0]);
        }
        if (partitionName != null && partitionName.equals("sup-remote")) {
            row[1] = "sup-standby";
        }
        return row;
    }
}

