/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.physical;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;

public class EditSensorTable
extends EditTable {
    int _sensorOffset;
    int _sensorStopOffset;
    static final int NONE = -127;
    static final int MAJOR = 20;
    static final int MAJORCOL = 2;
    static final int MINORCOL = 3;
    static final int CURRENT = 4;
    static final int STATUSCOL = 5;
    static final int NOT_AVAILALBE = 2;
    static final int[] SeverityOid = MibNode.get("entSensorThresholdSeverity").getOid();

    public EditSensorTable(String[] vars) {
        super(vars);
    }

    private int[] getSensorStartingIndex(int index) {
        this._sensorOffset = FRUConstants.getSensorOffset(Discover.isSysVersionGreaterThanEqual("3.0(0)"));
        this._sensorStopOffset = FRUConstants.getSensorStopOffset(Discover.isSysVersionGreaterThanEqual("3.0(0)"));
        if (index != 0) {
            int satOffset = FRUConstants.getSatelliteSwitchComponentOffset(index);
            this._sensorOffset = satOffset + this._sensorOffset;
            this._sensorStopOffset = satOffset + this._sensorStopOffset;
        }
        return new int[]{this._sensorOffset - 1};
    }

    @Override
    protected int[] getIndex() {
        return this.getSensorStartingIndex(super.getIndex()[0]);
    }

    @Override
    protected int[] getMultipleIndex(int row) {
        return this.getSensorStartingIndex(this._parent._multipleIndeces[row][0]);
    }

    @Override
    protected boolean isEnd(int[] req, SnmpVarBind vb) {
        if (vb.getError() == 21) {
            return true;
        }
        int[] firstOid = new int[req.length - 1];
        System.arraycopy(req, 0, firstOid, 0, firstOid.length);
        if (super.isEnd(firstOid, vb)) {
            return true;
        }
        int[] oid = vb.getOid().getValue();
        return oid[oid.length - 1] >= this._sensorStopOffset;
    }

    @Override
    protected boolean isEnd(int[] req, SnmpVarBind vb, int[] index) {
        return this.isEnd(req, vb);
    }

    @Override
    protected boolean isSkip(SnmpPDU pdu) {
        VarBindList vbl = pdu.getVariables();
        int status = vbl.intValue(4);
        return status == 2;
    }

    @Override
    protected void postProcessing() throws SnmpException {
        int i;
        for (int i2 = 0; i2 < this._data.size(); ++i2) {
            Object[] row = (Object[])this._data.elementAt(i2);
            row[2] = "n/a";
            row[3] = "n/a";
            this._tableModel.setNoSuchInstance(i2, 2, false);
            this._tableModel.setNoSuchInstance(i2, 3, false);
        }
        VarBindList queryVbl = new VarBindList();
        queryVbl.add(new SnmpVarBind(new SnmpOID(SeverityOid)));
        queryVbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("entSensorThresholdValue").getOid())));
        queryVbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("entSensorThresholdEvaluation").getOid())));
        VarBindList vbl = new VarBindList();
        if (this.isMultiple()) {
            for (i = 0; i < this._parent._multipleIndeces.length; ++i) {
                SnmpPDU resp = SnmpFetch.getBulkWithStartIndexFix(this.getPeer(), queryVbl, this._data.size() * 3 * 2, this.getMultipleIndex(i), null);
                VarBindList subVbl = resp.getVariables();
                if (subVbl.size() == 0) {
                    if (SnmpSession.isTrace()) {
                        System.out.println("BULK for sensorThreshold vblList size 0!");
                    }
                    return;
                }
                vbl.addAll(0, subVbl);
            }
        } else {
            SnmpPDU resp = SnmpFetch.getBulkWithStartIndexFix(this.getPeer(), queryVbl, this._data.size() * 3 * 2, this.getIndex(), null);
            VarBindList subVbl = resp.getVariables();
            if (subVbl.size() == 0) {
                return;
            }
            vbl.addAll(0, subVbl);
        }
        i = 0;
        for (int rowNo = 0; rowNo < this._data.size() && i < vbl.size(); ++rowNo) {
            int minor;
            SnmpOID oid = vbl.get(i).getOid();
            if (!oid.startsWith(SeverityOid)) {
                return;
            }
            Object[] row = (Object[])this._data.elementAt(rowNo);
            int id = ((SnmpOID)row[0]).getValue()[0];
            if (oid.getValue()[oid.getValue().length - 2] != id) {
                --rowNo;
                i += 6;
                continue;
            }
            int[] severity = new int[2];
            SnmpInt[] value = new SnmpInt[2];
            int[] evaluation = new int[2];
            for (int j = 0; j < 2; ++j) {
                if (i >= vbl.size()) continue;
                int[] a = vbl.get(i).getOid().getValue();
                severity[j] = ((SnmpInt)vbl.get(i++).getVar()).getValue();
                value[j] = (SnmpInt)vbl.get(i++).getVar();
                evaluation[j] = ((SnmpInt)vbl.get(i++).getVar()).getValue();
            }
            int major = severity[0] == 20 ? 0 : 1;
            int n = minor = major == 0 ? 1 : 0;
            if (!((String)row[5]).equals("ok")) {
                row[4] = "n/a";
                continue;
            }
            row[2] = value[major];
            row[3] = value[minor];
            if (evaluation[major] == 1) {
                row[5] = "major";
                continue;
            }
            if (evaluation[minor] != 1) continue;
            row[5] = "minor";
        }
        this.setStatus(this._data.size() + " row(s)");
    }
}

