/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.physical;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.mds.SharedUtil;
import com.cisco.dcbu.lib.mds.renderers.SensorValueRenderer;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;

public class EditSfpDiagTable
extends EditTable {
    int[] _Index = new int[]{FRUConstants.getSensorOffset(Discover.isSysVersionGreaterThanEqual("3.0(0)"))};
    static final int LOW_ALARM_COL = 2;
    static final int LOW_WARNING_COL = 3;
    static final int SENSOR_VAL_COL = 1;
    static final int HIGH_WARNING_COL = 4;
    static final int HIGH_ALARM_COL = 5;
    static final int RELATION_COL = 6;
    static final int TYPE_COL = 7;
    static final int SCALE_COL = 8;
    static final int ENT_INDEX_COL = 10;
    static final int MAJOR = 1;
    static final int MINOR = 2;
    static final int LESS_THAN = 1;
    static final int GREATER_THAN = 3;
    protected boolean is6_1_0_above = Discover.getSysVersionWithMinor().compareTo("6.1(0)") >= 0;
    MibEnum[] _EntSensorScaleEnums = MibNode.get("entSensorScale").getEnums();
    static final int[] Scale = new int[]{0, -24, -21, -18, -15, -12, -9, -6, -3, 0, 3, 6, 9, 12, 15, 18, 21, 24};
    static final MibEnum[] SensorType = new MibEnum[]{new MibEnum("Voltage", 3), new MibEnum("Current", 5), new MibEnum("Temperature", 8), new MibEnum("Rx Power", 14), new MibEnum("Tx Power", 15)};

    public EditSfpDiagTable(String[] vars) {
        super(vars);
    }

    private int getSensorIndex(int ifIndex) {
        return SharedUtil.getSensorIndex(this.is6_1_0_above, ifIndex, Discover.getRoot().getCardType4IfIndex(ifIndex));
    }

    @Override
    protected int[] getIndex() {
        return new int[]{this.getSensorIndex(super.getIndex()[0])};
    }

    @Override
    protected int[] getMultipleIndex(int row) {
        return new int[]{this.getSensorIndex(super.getMultipleIndex(row)[0])};
    }

    @Override
    protected void buildTable() {
        super.buildTable();
        this._table.getColumnModel().getColumn(1).setCellRenderer(new SensorValueRenderer(3, 4, 1));
    }

    @Override
    protected void updateTable() {
        super.updateTable();
    }

    @Override
    protected void build() {
        super.build();
        this._table.removeColumn(this._table.getColumnModel().getColumn(8));
        this._table.removeColumn(this._table.getColumnModel().getColumn(7));
        this._table.removeColumn(this._table.getColumnModel().getColumn(6));
    }

    @Override
    protected Object[] buildRow(SnmpPDU pdu, int[] responseOid, int rowNo) {
        Object[] row = super.buildRow(pdu, responseOid, rowNo);
        String type = (String)row[7];
        int exp = Scale[MibEnum.getValue(this._EntSensorScaleEnums, (String)row[8])];
        int current = ((SnmpInt)row[1]).getValue();
        int slot = SharedUtil.getSensorSlot(this.is6_1_0_above, ((SnmpOID)row[0]).getValue()[0]);
        int port = SharedUtil.getSensorPort(this.is6_1_0_above, ((SnmpOID)row[0]).getValue()[0], slot);
        int interfaceIndex = 0;
        interfaceIndex = this.isMultiple() ? super.getMultipleIndex(this._multipleIndexNo)[0] : super.getIndex()[0];
        int ifPort = IfIndexUtil.getPortEntity2If(port, Discover.getRoot().getCardType4IfIndex(interfaceIndex));
        int lane = SharedUtil.getSensorLane(this.is6_1_0_above, ((SnmpOID)row[0]).getValue()[0], slot, port);
        int sens_type = SharedUtil.getSensorType(this.is6_1_0_above, ((SnmpOID)row[0]).getValue()[0], slot, port, lane);
        String sens_string = MibEnum.getLabel(SensorType, sens_type);
        row[1] = current == 0 && (sens_string.startsWith("Rx") || sens_string.startsWith("Tx")) ? "n/a" : SharedUtil.getSensorString(exp, current, type);
        Object[] newRow = new Object[row.length + 1];
        System.arraycopy(row, 0, newRow, 0, row.length);
        newRow[newRow.length - 1] = row[0];
        StringBuffer sb = new StringBuffer();
        int ifType = IfIndexUtil.getType(interfaceIndex);
        int ifIndex = IfIndexUtil.nameToIfIndex(slot + 1, ifPort + 1, ifType);
        String ifName = Discover.getRoot().ifIndexToName(ifIndex);
        sb.append(ifName);
        if (lane > -1) {
            sb.append(" lane ");
            sb.append(lane + 1);
        }
        sb.append(", ");
        sb.append(sens_string);
        newRow[0] = sb.toString();
        return newRow;
    }

    @Override
    protected boolean isEnd(int[] req, SnmpVarBind vb) {
        return this.isEnd(req, vb, this.getIndex());
    }

    @Override
    protected boolean isEnd(int[] req, SnmpVarBind vb, int[] index) {
        if (vb.getError() == 21) {
            return true;
        }
        int[] oid = vb.getOid().getValue();
        for (int i = 0; i < req.length - 1 && i < oid.length; ++i) {
            if (req[i] == oid[i]) continue;
            return true;
        }
        int sensorStopOffset = SharedUtil.getSensorStopOffset(this.is6_1_0_above, index[0]);
        return req.length != oid.length || oid[oid.length - 1] > sensorStopOffset;
    }

    @Override
    protected void postProcessing() throws SnmpException {
        VarBindList vbl = new VarBindList();
        int[] _thresholdValueOid = MibNode.get("entSensorThresholdValue").getOid();
        int[] _entSensorThresholdRelationOid = MibNode.get("entSensorThresholdRelation").getOid();
        int[] thresholdIndexOrder = new int[]{3, 4, 2, 1};
        for (int i = 0; i < this._data.size(); ++i) {
            Object[] row = (Object[])this._data.elementAt(i);
            row[3] = "";
            row[2] = "";
            row[4] = "";
            row[5] = "";
            for (int k = 0; k < thresholdIndexOrder.length; ++k) {
                int[] index = new int[]{((SnmpOID)row[10]).getValue()[0], thresholdIndexOrder[k]};
                vbl.add(new SnmpVarBind(new SnmpOID(_thresholdValueOid, index)));
                vbl.add(new SnmpVarBind(new SnmpOID(_entSensorThresholdRelationOid, index)));
            }
        }
        SnmpPDU resp = SnmpFetch.get(this.getPeer(), vbl);
        vbl = resp.getVariables();
        if (vbl.size() == 0) {
            return;
        }
        int i = 0;
        for (int rowNo = 0; rowNo < this._data.size() && i < vbl.size(); ++rowNo) {
            if (vbl.getVb(i).getVar().getType() == 5) continue;
            SnmpOID oid = vbl.get(i).getOid();
            if (!oid.startsWith(_thresholdValueOid)) {
                return;
            }
            Object[] row = (Object[])this._data.elementAt(rowNo);
            int id = ((SnmpOID)row[10]).getValue()[0];
            if (oid.getValue()[oid.getValue().length - 2] != id) continue;
            String type = (String)row[7];
            int scale = MibEnum.getValue(this._EntSensorScaleEnums, (String)row[8]);
            for (int j = 2; j <= 5; ++j) {
                SnmpVar value;
                int[] index = vbl.get(i).getOid().getValue();
                int thresholdType = index[index.length - 1] == 1 || index[index.length - 1] == 2 ? 1 : 2;
                if ((value = vbl.get(i++).getVar()).getType() == 5) continue;
                int relation = ((SnmpInt)vbl.get(i++).getVar()).getValue();
                int exp = Scale[scale];
                int sensorValue = ((SnmpInt)value).getValue();
                row[j] = SharedUtil.getSensorString(exp, sensorValue, null);
            }
        }
        this.setStatus(this._data.size() + " row(s)");
    }
}

