/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.security;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dmdb.andiamo.dialogs.fc.EditIfPortForm;
import com.cisco.dcbu.dmdb.andiamo.dialogs.security.CommonRoleFeatureCache;
import com.cisco.dcbu.dmdb.andiamo.dialogs.security.InsertCommonRoleRule;
import com.cisco.dcbu.lib.mds.CommonRoleUtil;
import com.cisco.dcbu.lib.mds.PortInterfaceUtil;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;

public class EditCommonRoleTable
extends EditTable {
    static final int NAME = 0;
    static final int VSANENABLE = 1;
    static final int VSANSCOPE = 2;
    static final int[] _scope1Oid = MibNode.get("commonRoleScope1").getOid();
    static final int[] _scope2Oid = MibNode.get("commonRoleScope2").getOid();
    InsertCommonRoleRule _insertRuleDialog;

    public EditCommonRoleTable(String[] vars) {
        super(vars);
    }

    @Override
    protected Array getButtons() {
        Array btns = super.getButtons();
        btns.insertElementAt("Rules...", 0);
        return btns;
    }

    @Override
    protected void buildButtons() {
        super.buildButtons();
        this._buttons[0].setActionCommand("L");
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        this.enableButton('L', this._table.getSelectedRowCount() > 0);
    }

    @Override
    public void dispose() {
        if (this._insertRuleDialog != null) {
            this._insertRuleDialog.dispose();
        }
        super.dispose();
    }

    @Override
    protected void updateTable() {
        super.updateTable();
        this.enableButton('L', false);
    }

    @Override
    protected void sendGetPdu(SnmpPDU pdu) throws SnmpException {
        int[] oid = pdu.getVariables().get(2).getOid().getValue();
        if (oid.length > _scope2Oid.length) {
            int[] index = new int[oid[_scope2Oid.length] + 1];
            System.arraycopy(oid, _scope2Oid.length, index, 0, index.length);
            pdu.addNull(new SnmpOID(_scope2Oid, index));
        } else {
            pdu.addNull(new SnmpOID(_scope2Oid));
        }
        super.sendGetPdu(pdu);
    }

    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        if (!timedOut) {
            SnmpVarBind vb = pdu.getVariables().get(0);
            if (this._state == -95 && !this.isEnd(this._firstOid, vb) || this._state == -96) {
                pdu = EditIfPortForm.appendVsan4kTo2kVar(pdu, 4, 2, pdu.getVariables().size() - 1, -1, -1, true);
            }
        }
        super.callback(session, reqid, pdu, timedOut);
    }

    @Override
    protected void sendPdu(SnmpPDU pdu) throws SnmpException {
        for (int i = 0; i < pdu.getVariables().size(); ++i) {
            SnmpVarBind vb = pdu.getVariables().get(i);
            int[] oid = vb.getOid().getValue();
            int[] index = new int[oid.length - _scope1Oid.length];
            System.arraycopy(oid, _scope1Oid.length, index, 0, index.length);
            PortInterfaceUtil.getInstance(4).addVsan4k2Pdu(pdu, vb.getOid(), vb.getVar(), index);
        }
        this.getPeer().setFrag(pdu);
        this.setCFSPending(this.getPeer());
    }

    @Override
    protected void sendDeletePdu(SnmpPDU pdu) throws SnmpException {
        super.sendDeletePdu(pdu);
        this.setCFSPending(this.getPeer());
    }

    @Override
    protected void doIt(char ch, ActionEvent e) throws Exception {
        if (ch == 'L') {
            String msg = this.getStatus();
            this.setStatus("Retrieving features, please wait...");
            this._parent.setCursor(Cursor.getPredefinedCursor(3));
            SwingUtilities.invokeLater(new RoleRuleWorker(e, msg, this));
        } else {
            super.doIt(ch, e);
        }
    }

    @Override
    protected DmTableModel buildTableModel() {
        return new SnmpCommonRoleTableModel();
    }

    static class SnmpCommonRoleTableModel
    extends DmTableModel {
        SnmpCommonRoleTableModel() {
        }

        @Override
        public boolean isCellActive(int row, int col) {
            if (col == 3) {
                Object o = this.getValueAt(row, 2);
                return o != null && (Boolean)o != false;
            }
            return super.isCellActive(row, col);
        }
    }

    class RoleRuleWorker
    implements Runnable {
        ActionEvent _event;
        String _message;
        EditTable _thisTable;

        public RoleRuleWorker(ActionEvent event, String message, EditTable thisTable) {
            this._event = event;
            this._message = message;
            this._thisTable = thisTable;
        }

        @Override
        public void run() {
            HashMap features = CommonRoleUtil.getInstance().getFeatureHash(EditCommonRoleTable.this.getPeer(), CommonRoleFeatureCache.getInstance().getCommonRoleFeatures());
            CommonRoleFeatureCache.getInstance().setCommonRoleFeatures(features);
            long maxRulePerRole = CommonRoleUtil.getInstance().getMaxRulePerRole(EditCommonRoleTable.this.getPeer(), CommonRoleFeatureCache.getInstance().getMaxRulePerRole());
            CommonRoleFeatureCache.getInstance().setMaxRulePerRole(maxRulePerRole);
            JFrame parent = (JFrame)EditCommonRoleTable.this._parent.getParent();
            int[] name = ((SnmpOID)EditCommonRoleTable.this._tableModel.getValueAt(EditCommonRoleTable.this._table.getSelectedRow(), 0)).getValue();
            String roleName = SnmpString.toString(name, 1, name.length);
            if (EditCommonRoleTable.this._insertRuleDialog != null && EditCommonRoleTable.this._insertRuleDialog.isVisible()) {
                EditCommonRoleTable.this._insertRuleDialog.refresh(CommonRoleUtil.getInstance().getRuleData(EditCommonRoleTable.this.getPeer(), roleName, features));
                StringBuffer sb = new StringBuffer(Discover.getDeviceName());
                sb.append(" - Edit Role Rules");
                sb.append(" " + roleName);
                EditCommonRoleTable.this._insertRuleDialog.setTitle(sb.toString());
                EditCommonRoleTable.this._insertRuleDialog.toFront();
            } else {
                EditCommonRoleTable.this._insertRuleDialog = new InsertCommonRoleRule(parent, this._thisTable, EditCommonRoleTable.this.getPeer(), roleName, CommonRoleUtil.getInstance().getRuleData(EditCommonRoleTable.this.getPeer(), roleName, features), true);
                EditCommonRoleTable.this._insertRuleDialog.setTitle(Discover.getDeviceName() + " - Edit Role Rules " + roleName);
                EditCommonRoleTable.this._insertRuleDialog.setLocation(DialogUtil.getPointOnScreen(new Point(0, 0), (JComponent)this._event.getSource(), EditCommonRoleTable.this._insertRuleDialog.getSize()));
                EditCommonRoleTable.this._insertRuleDialog.setVisible(true);
            }
            EditCommonRoleTable.this.setStatus(this._message);
            EditCommonRoleTable.this._parent.setCursor(Cursor.getDefaultCursor());
        }
    }
}

