/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.security;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dmdb.andiamo.dialogs.SwitchMapUtil;
import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;

public class EditPsmDBTable
extends EditTable {
    static final int POINT = 0;
    static final int DEV_TYPE = 1;
    static final int DEV = 2;
    static final int IS_LEARNT = 3;
    static final int DIFF_REASON = 3;
    public static final int POINT_TYPE_FWWN = 1;
    public static final int POINT_TYPE_IFINDEX = 2;
    public static final int POINT_TYPE_WILD = 3;
    static final int DEV_TYPE_MAC = 1;
    static final int DEV_TYPE_NWWN = 2;
    static final int DEV_TYPE_PWWN = 3;
    static final int DEV_TYPE_SWWN = 4;
    static final int DEV_TYPE_WILD = 5;
    static final int DEV_TYPE_DEVICEALIAS = 6;
    static final int PSM_SW_PORTTYPE_IFINDEX = 2;
    static final int[] _cpsmPortBindLoginPointOid = MibNode.get("cpsmPortBindLoginPoint").getOid();
    static final int[] _cpsmPortBindLoginPointTypeOid = MibNode.get("cpsmPortBindLoginPointType").getOid();
    int _pointType;
    int _devType;
    ArrayList _switchList = null;
    HashMap _switchHash = null;

    public EditPsmDBTable(String[] vars) {
        super(vars);
    }

    @Override
    protected void build() {
        super.build();
        if (this._table.getColumnModel().getColumnCount() > 4) {
            this._pointType = this._table.getColumnModel().getColumnCount() - 1;
            this._table.removeColumn(this._table.getColumnModel().getColumn(this._pointType));
        }
        this._switchHash = SwitchMapUtil.getSwitchMapHash(this.getPeer(), 0, new ArrayList());
    }

    Object getLoginPoint(byte[] point, int type) {
        switch (type) {
            case 1: {
                return Discover.getRoot().ifIndexToName(Discover.getRoot().ifWwn2IfIndex(point, IfIndexIf.FwwnInfo.Config)) + " (" + WwnDictionary.get(point) + ")";
            }
            case 2: {
                int ifIndex = ((point[0] & 0xFF) << 24) + ((point[1] & 0xFF) << 16) + ((point[2] & 0xFF) << 8) + (point[3] & 0xFF);
                Discover.getInstance();
                byte[] swWwn = Discover.getSwitchWWN();
                if (swWwn == null) {
                    return Discover.getRoot().ifIndexToName(ifIndex);
                }
                byte[] prtWWN = IfIndexUtil.ifIndex2wwn(ifIndex, swWwn, Discover.getRoot().isN5K());
                return Discover.getRoot().ifIndexToName(ifIndex) + " (" + WwnDictionary.get(prtWWN) + ")";
            }
            case 3: {
                return "any";
            }
        }
        return "";
    }

    Object getLoginDevice(byte[] dev, int type) {
        switch (type) {
            case 1: {
                return SnmpString.toHexString(dev);
            }
            case 2: 
            case 3: {
                return WwnDictionary.get(dev);
            }
            case 4: {
                Wwn wwn = new Wwn(dev);
                InetAddress adr = SwitchMapUtil.SwitchIPBySwitchWWN(this._switchHash, wwn);
                return adr == null ? WwnDictionary.get(dev) : WwnDictionary.get(dev) + "(" + adr.getHostAddress() + ")";
            }
            case 5: {
                return "";
            }
            case 6: {
                return new String(dev);
            }
        }
        return "";
    }

    @Override
    protected void sendInsertPdu(SnmpPDU pdu) throws SnmpException {
        super.sendInsertPdu(pdu);
        this.setCFSPending(this.getPeer());
    }

    @Override
    protected void sendDeletePdu(SnmpPDU pdu) throws SnmpException {
        super.sendDeletePdu(pdu);
        this.setCFSPending(this.getPeer());
    }

    @Override
    protected DmTableModel buildTableModel() {
        return new SnmpPsmDBTableModel();
    }

    class SnmpPsmDBTableModel
    extends DmTableModel {
        SnmpPsmDBTableModel() {
        }

        @Override
        public SnmpPDU setChangedCells() throws Exception {
            Array cells = this.getChanged();
            if (cells == null) {
                return null;
            }
            SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(cells.size()));
            for (int i = 0; i < cells.size(); ++i) {
                Cell cell = (Cell)cells.elementAt(i);
                int[] index = this.getIndex(cell._row);
                SnmpOID oid = new SnmpOID(this._mibNodes[cell._col].getOid(), index);
                if (cell._col == 2) {
                    String cellVal = (String)this.getValueAt(cell._row, cell._col);
                    int ifIndex = Discover.getRoot().nameToIfIndex(cellVal);
                    byte[] b = new byte[4];
                    b[3] = (byte)(ifIndex & 0xFF);
                    b[2] = (byte)(ifIndex >> 8 & 0xFF);
                    b[1] = (byte)(ifIndex >> 16 & 0xFF);
                    b[0] = (byte)(ifIndex >> 24 & 0xFF);
                    pdu.addVar(new SnmpOID(_cpsmPortBindLoginPointTypeOid, index), new SnmpInt(2));
                    pdu.addVar(new SnmpOID(_cpsmPortBindLoginPointOid, index), new SnmpString(b));
                    continue;
                }
                pdu.addVar(oid, this.getChangedCell(cell._row, cell._col));
            }
            return pdu;
        }

        @Override
        public Object toCellEditTable(MibNode mibNode, SnmpPDU pdu, SnmpVarBind vb, String var, SnmpOID index, int row, int col) {
            VarBindList vbl = pdu.getVariables();
            if (var.equals("cpsmPortBindLoginPoint") || var.equals("cpsmPortBindEnfLoginPoint") || var.equals("cpsmPortBindDiffLoginPoint")) {
                int type = pdu.getVariables().intValue(EditPsmDBTable.this._pointType - 1);
                byte[] point = vbl.byteValue(0);
                return EditPsmDBTable.this.getLoginPoint(point, type);
            }
            if (var.equals("cpsmPortBindLoginDevType") || var.equals("cpsmPortBindEnfLoginDevType") || var.equals("cpsmPortBindDiffLoginDevType")) {
                EditPsmDBTable.this._devType = vbl.intValue(col - 1);
                return super.toCellEditTable(mibNode, pdu, vb, var, index, row, col);
            }
            if (var.equals("cpsmPortBindLoginDev") || var.equals("cpsmPortBindEnfLoginDev") || var.equals("cpsmPortBindDiffLoginDev")) {
                byte[] dev = vbl.byteValue(2);
                return EditPsmDBTable.this.getLoginDevice(dev, EditPsmDBTable.this._devType);
            }
            return super.toCellEditTable(mibNode, pdu, vb, var, index, row, col);
        }
    }
}

