/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.security;

import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class EditRadiusForm
extends EditForm {
    int KEYTYPE = 1;
    int KEY = 2;
    static final MibEnum[] _typeEnums = new MibEnum[]{new MibEnum("plaintext", 112), new MibEnum("encrypted", 101)};
    int[] _keyOid = MibNode.get("crRadiusAuthKey").getOid();
    int[] _keyTypeOid = MibNode.get("crRadiusServerType").getOid();

    public EditRadiusForm(String[] vars) {
        super(vars);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == this.KEYTYPE) {
            return new RadioButtonPanel(_typeEnums);
        }
        if (index == this.KEY) {
            return new JPasswordField();
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected void showError(int index, boolean isError) {
        if (index != this.KEYTYPE) {
            super.showError(index, isError);
        }
    }

    @Override
    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == this.KEYTYPE) {
            return new JLabel("AuthKeyType:", 4);
        }
        return super.createFormLabel(mibVar, index);
    }

    @Override
    protected void setComponentValue(int i, SnmpVar v) {
        if (i == this.KEYTYPE) {
            return;
        }
        if (i == this.KEY) {
            byte[] b = ((SnmpString)v).getValue();
            if (b.length > 0) {
                byte val = b[0];
                RadioButtonPanel type = (RadioButtonPanel)this._values[this.KEYTYPE];
                for (int j = 0; j < _typeEnums.length; ++j) {
                    if (val != _typeEnums[j].getValue()) continue;
                    if (j >= type.getComponentCount()) break;
                    JToggleButton rb = type.getButton(j);
                    rb.setSelected(true);
                    break;
                }
                byte[] newKey = new byte[b.length - 1];
                System.arraycopy(b, 1, newKey, 0, newKey.length);
                ((JTextField)this._values[i]).setText(new String(newKey));
            } else {
                super.setComponentValue(i, v);
            }
        } else {
            super.setComponentValue(i, v);
        }
    }

    @Override
    protected void sendPdu(SnmpPDU pdu) throws SnmpException {
        for (int i = pdu.getVariables().size() - 1; i >= 0; --i) {
            int selected;
            Object key;
            SnmpVarBind vb = pdu.getVariables().get(i);
            SnmpOID oid = vb.getOid();
            if (oid.startsWith(this._keyOid)) {
                key = ((SnmpString)vb.getVar()).getValue();
                pdu.removeVarAt(i);
                if (i > 0) {
                    SnmpVarBind nextVb = pdu.getVariables().get(i - 1);
                    SnmpOID nextOid = nextVb.getOid();
                    if (nextOid.startsWith(this._keyTypeOid)) {
                        pdu.removeVarAt(i - 1);
                    }
                    --i;
                }
                if ((selected = ((RadioButtonPanel)this._values[this.KEYTYPE]).getSelected()) == -1) {
                    throw new SnmpException("Please make a selection for AuthKeyType");
                }
                vb.setVar(new SnmpString(EditRadiusForm.getAuthKey(_typeEnums[selected].getValue(), (byte[])key)));
                pdu.addVar(vb);
                continue;
            }
            if (!oid.startsWith(this._keyTypeOid)) continue;
            key = new SnmpString(((JTextField)this._values[this.KEY]).getText());
            if (((SnmpString)key).getValue().length == 0) {
                throw new SnmpException("Please enter a value for AuthKey");
            }
            selected = ((RadioButtonPanel)this._values[this.KEYTYPE]).getSelected();
            byte[] newKey = EditRadiusForm.getAuthKey(_typeEnums[selected].getValue(), ((SnmpString)key).getValue());
            pdu.removeVarAt(i);
            pdu.addVar(new SnmpOID(MibNode.get("crRadiusAuthKey").getOid(), 0), new SnmpString(newKey));
        }
        super.sendPdu(pdu);
    }

    public static byte[] getAuthKey(int keyType, byte[] key) {
        byte[] newKey = new byte[key.length + 1];
        System.arraycopy(key, 0, newKey, 1, key.length);
        newKey[0] = (byte)keyType;
        return newKey;
    }
}

