/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.security;

import com.cisco.dcbu.dm.DMPanel;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditFormTable;
import com.cisco.dcbu.lib.mds.renderers.SSHIndexRenderer;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class EditSSHFormTable
extends EditFormTable {
    static final int SSH = 0;
    static final int TELNET = 1;
    static final int[] _cssKeyOverWriteOid = MibNode.get("cssKeyOverWrite").getOid();
    static final int[] _cssKeyGenerationStatusOid = MibNode.get("cssKeyGenerationStatus").getOid();
    boolean _isSSHReady;

    public EditSSHFormTable(String[] vars, String[] formVars) {
        super(vars, formVars);
    }

    @Override
    protected void buildForm() {
        this._formPanel.add(new JLabel("Enable: "));
        super.buildForm();
        this._formVars[1].setEnabled(Discover.isSysVersionGreaterThanEqual("3.0(0)"));
    }

    @Override
    protected Array getButtons() {
        Array btns = super.getButtons();
        btns.insertElementAt("Apply", 2);
        return btns;
    }

    @Override
    protected JComponent buildFormComponent(int index) {
        String label = index == 0 ? "SSH" : "Telnet";
        JCheckBox cb = new JCheckBox(label);
        cb.addItemListener(new DMPanel.ChangedFieldListener());
        return cb;
    }

    @Override
    protected void preGet() {
        this._isSSHReady = true;
        VarBindList vbl = new VarBindList(1);
        vbl.add(new SnmpVarBind(new SnmpOID(_cssKeyGenerationStatusOid, 0)));
        try {
            SnmpPDU resp = this.getPeer().send(new SnmpPDU(-96, vbl));
            this._isSSHReady = resp.getVariables().intValue(0) != 1;
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    @Override
    protected void get(SnmpPDU pdu, int[] index) {
        if (!this._isSSHReady) {
            Util.errorMessage((Component)this.getParent(), "SSH table is not ready: updating Key structure.");
            this._data.clear();
            this.updateTable();
            return;
        }
        super.get(pdu, index);
    }

    @Override
    protected void updateFormComponent(int index, SnmpVar v) {
        if (v instanceof SnmpInt) {
            boolean isEnabled = ((SnmpInt)v).getValue() == 1;
            JCheckBox cb = (JCheckBox)this._formVars[index];
            cb.setSelected(isEnabled);
            cb.setFont(null);
        }
    }

    @Override
    protected void formSet() throws Exception {
        boolean isSelected;
        if (this._formVars[0].getFont() != ChangedCellRenderer.getChangeFont() && this._formVars[1].getFont() != ChangedCellRenderer.getChangeFont()) {
            return;
        }
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        if (this._formVars[0].getFont() == ChangedCellRenderer.getChangeFont()) {
            isSelected = ((JCheckBox)this._formVars[0]).isSelected();
            pdu.addVar(new SnmpOID(MibNode.get("cssServiceActivation").getOid(), 0), new SnmpInt(isSelected ? 1 : 2));
        }
        if (this._formVars[1].getFont() == ChangedCellRenderer.getChangeFont()) {
            isSelected = ((JCheckBox)this._formVars[1]).isSelected();
            pdu.addVar(new SnmpOID(MibNode.get("cseSysTelnetServiceActivation").getOid(), 0), new SnmpInt(isSelected ? 1 : 2));
        }
        this.sendPdu(pdu);
        ((JCheckBox)this._formVars[0]).setFont(null);
        ((JCheckBox)this._formVars[1]).setFont(null);
    }

    @Override
    protected void updateTable() {
        super.updateTable();
        this.enableButton('C', this._tableModel.getRowCount() < SSHIndexRenderer._protocols.length);
    }

    @Override
    protected void sendFetchPdu(SnmpPDU pdu) throws SnmpException {
        try {
            Thread.sleep(4000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.sendFetchPdu(pdu);
    }

    @Override
    protected String getInsertDlgTitle() {
        String title = super.getInsertDlgTitle();
        int offset = title.indexOf("Telnet");
        if (offset != -1) {
            title = title.substring(0, offset - 1);
        }
        return title;
    }
}

