/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.security;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.dmdb.andiamo.dialogs.security.InsertUser;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class InsertCommunity
extends InsertForm {
    static final int COMMUNITY = 1;
    static final int ROLE = 2;
    private boolean _exclusive = true;
    InsertUser.MyCheckBoxListPanel _listPanel;
    String[] _roles;

    public InsertCommunity(InsertDialog parent, EditTable table) {
        super(parent, table);
    }

    @Override
    protected void build() {
        super.build();
        this.setComponentVisibleAt(0, false);
    }

    @Override
    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == 2) {
            return new JLabel("Role(NoAuthNoPriv):", 4);
        }
        return new JLabel(this.trim(mibVar) + ":", 4);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 2) {
            Object[] list = Discover.isSysVersionlessThan("1.2(0)") ? InsertUser.getRoles(this.getPeer(), false) : InsertUser.getCommonRoles(this.getPeer());
            this._listPanel = new InsertUser.MyCheckBoxListPanel(list, this._exclusive);
            this._listPanel.clearSelection();
            JScrollPane sp = new JScrollPane(this._listPanel);
            this._listPanel.setUnitIncrement(sp);
            sp.setPreferredSize(new Dimension(170, 100));
            return sp;
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 2) {
            if (this._values[index] instanceof JLabel) {
                return null;
            }
            Object[] selected = this._listPanel.getSelectedValues();
            this._roles = new String[selected.length];
            for (int i = 0; i < selected.length; ++i) {
                this._roles[i] = selected[i].toString();
            }
            return new SnmpString(this._roles.length > 0 ? this._roles[0] : "");
        }
        return super.getComponentValue(index);
    }

    @Override
    protected int[] getInsertIndex(SnmpVar[] values) throws Exception {
        return SnmpString.valueOf(((SnmpString)values[1]).getValue(), true);
    }

    @Override
    protected void tableInsert(SnmpVar[] values, int[] index) throws Exception {
        int j;
        if (this._roles == null || this._roles.length == 0) {
            throw new SnmpException("No role selected");
        }
        boolean isMultipleRoleSupported = false;
        SnmpPDU pdu = this.buildInsertPDU(index, values);
        pdu.removeVarAt(pdu.getVariables().size() - 1);
        pdu.addVar(new SnmpOID(MibNode.get("snmpCommunitySecurityName").getOid(), index), values[1]);
        this.getPeer().set(pdu);
        String newSecurity = ((SnmpString)values[1]).toString();
        int[] groupIndex = new int[newSecurity.length() + 2];
        groupIndex[0] = 1;
        groupIndex[1] = newSecurity.length();
        int i = 2;
        for (j = 0; j < newSecurity.length(); ++j) {
            groupIndex[i++] = newSecurity.charAt(j);
        }
        pdu = new SnmpPDU(-93, new VarBindList());
        pdu.addVar(new SnmpOID(MibNode.get("vacmSecurityToGroupStatus").getOid(), groupIndex), new SnmpInt(4));
        pdu.addVar(new SnmpOID(MibNode.get("vacmGroupName").getOid(), groupIndex), new SnmpString(this._roles[0]));
        groupIndex[0] = 2;
        pdu.addVar(new SnmpOID(MibNode.get("vacmSecurityToGroupStatus").getOid(), groupIndex), new SnmpInt(4));
        pdu.addVar(new SnmpOID(MibNode.get("vacmGroupName").getOid(), groupIndex), new SnmpString(this._roles[0]));
        if (isMultipleRoleSupported) {
            for (j = 1; j < this._roles.length; ++j) {
                int[] nvcamIndex = new int[groupIndex.length + this._roles[j].length() + 1];
                System.arraycopy(groupIndex, 0, nvcamIndex, 0, groupIndex.length);
                int l = groupIndex.length;
                nvcamIndex[l++] = this._roles[j].length();
                for (int m = 0; l < nvcamIndex.length && m < this._roles[j].length(); ++l, ++m) {
                    nvcamIndex[l] = this._roles[j].charAt(m);
                }
                nvcamIndex[0] = 1;
                pdu.addVar(new SnmpOID(MibNode.get("cvacmSecurityGrpStatus").getOid(), nvcamIndex), new SnmpInt(4));
                nvcamIndex[0] = 2;
                pdu.addVar(new SnmpOID(MibNode.get("cvacmSecurityGrpStatus").getOid(), nvcamIndex), new SnmpInt(4));
            }
        }
        try {
            this.getPeer().set(pdu);
        }
        catch (SnmpException ex) {
            InsertCommunity.CommunityCreateRollback(this.getPeer(), index, groupIndex);
        }
    }

    public static void CommunityCreateRollback(SnmpPeer peer, int[] index, int[] vcamIndex) {
        try {
            SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
            pdu.addNull(new SnmpOID(MibNode.get("snmpCommunityName").getOid(), index));
            SnmpPDU resp = peer.send(pdu);
            SnmpVar v = resp.getVar(0);
            if (v.getType() == 5) {
                return;
            }
            pdu.reset();
            pdu.setCommand((byte)-93);
            pdu.addVar(new SnmpOID(MibNode.get("snmpCommunityStatus").getOid(), index), new SnmpInt(6));
            peer.send(pdu);
        }
        catch (Exception ex) {
            DefaultLogger._DefLogger.debug((Object)("communityRollback error : " + ex.getMessage()));
        }
    }
}

