/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.sme;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.GraphTable;
import com.cisco.dcbu.dmdb.andiamo.dialogs.sme.EditSMEIfTable;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Dimension;
import java.awt.event.ActionEvent;

public class GraphSMEIfTable
extends GraphTable {
    public static int[] _IfIndex_STOP = new int[]{318763008};
    int[] _interfaces = new int[0];
    boolean _isRepack = false;

    public GraphSMEIfTable(String[] vars) {
        super(vars);
    }

    @Override
    protected Array getButtons() {
        Array btns = super.getButtons();
        btns.insertElementAt("Update", 0);
        return btns;
    }

    @Override
    protected void updateAll(long upTime) {
        super.updateAll(upTime);
        this.enableButton('U', MS_INTERVALS[this._pollInterval.getSelectedIndex()] == 0);
    }

    @Override
    protected int getNumObjects() {
        if (this._interfaces == null) {
            return 0;
        }
        return this._interfaces.length;
    }

    @Override
    protected int[] getMultipleIndex(int row) {
        int[] index = new int[]{this._interfaces[this._interfaces.length > 1 ? row : 0]};
        return index;
    }

    @Override
    protected void get() {
        this.preGet();
        super.get();
    }

    @Override
    protected void preGet() {
        try {
            this._interfaces = this.fetchInterfaces();
        }
        catch (SnmpException ex) {
            // empty catch block
        }
        Array<Object[]> data = new Array<Object[]>();
        for (int i = 0; i < this.getNumObjects(); ++i) {
            Object[] row = new Object[this._vars.length + 1];
            row[0] = Discover.getRoot().ifIndexToName(this.getMultipleIndex(i)[0]);
            data.addElement(row);
        }
        this._data = data;
        this._model.setData(this._data);
        this._absolutes = new SnmpVar[this._data.size()][this._vars.length];
        this._cumulatives = new long[this._data.size()][this._vars.length];
        this._minimums = new long[this._data.size()][this._vars.length];
        this._maximums = new long[this._data.size()][this._vars.length];
        this._lastValues = new long[this._data.size()][this._vars.length];
        this._scrollPane.setPreferredSize(this._table.calcPreferredSize());
        if (this._interfaces == null || this._interfaces.length == 0) {
            Dimension d = this._table.calcPreferredSize();
            this._scrollPane.setPreferredSize(d);
            if (d.width > 1008) {
                this._table.setAutoResizeMode(0);
            }
            this._table.getTableHeader().resizeAndRepaint();
            ((KTableModel)this._table.getModel()).fireTableDataChanged();
            return;
        }
    }

    private int[] fetchInterfaces() throws SnmpException {
        VarBindList vbl = new VarBindList();
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cSmeInterfaceState").getOid())));
        SnmpPDU resp = SnmpFetch.getBulkWithStartIndexFix(Discover.getPeer(), vbl, 0, EditSMEIfTable._IfIndex, _IfIndex_STOP);
        vbl = resp.getVariables();
        if (vbl.size() == 0) {
            return null;
        }
        Array<Integer> interfaceList = new Array<Integer>();
        for (int i = 0; i < vbl.size(); ++i) {
            SnmpVarBind vb = vbl.get(i);
            int ifType = ((SnmpInt)vb.getVar()).getValue();
            int[] oid = vb.getOid().getValue();
            int ifIndex = oid[oid.length - 1];
            interfaceList.addElement(new Integer(ifIndex));
        }
        int[] smeInterfaces = new int[interfaceList.size()];
        for (int i = 0; i < interfaceList.size(); ++i) {
            smeInterfaces[i] = (Integer)interfaceList.elementAt(i);
        }
        return smeInterfaces;
    }

    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        super.callback(session, reqid, pdu, timedOut);
        if (this._isRepack) {
            this._isRepack = false;
            Dimension d = this._table.calcPreferredSize();
            this._scrollPane.setPreferredSize(d);
            if (d.width > 1008) {
                this._table.setAutoResizeMode(0);
            }
            this._table.getTableHeader().resizeAndRepaint();
            ((KTableModel)this._table.getModel()).fireTableDataChanged();
        }
    }

    @Override
    protected void doIt(char ch, ActionEvent e) throws Exception {
        if (ch == 'U') {
            this._isRepack = true;
            this.resetTable();
            this._pollVbl = null;
            this.get();
            int mSecs = MS_INTERVALS[this._pollInterval.getSelectedIndex()];
            boolean bl = this._isPolling = mSecs > 0;
            if (this._statusTimer != null) {
                if (this._isPolling) {
                    this._statusTimer.setInitialDelay(mSecs);
                    this._statusTimer.setDelay(mSecs);
                    if (this._statusTimer.isRunning()) {
                        this._statusTimer.restart();
                    } else {
                        this._statusTimer.start();
                    }
                } else {
                    this._statusTimer.stop();
                }
            }
        } else {
            if (ch == 'i') {
                this.getButton('U').setEnabled(MS_INTERVALS[this._pollInterval.getSelectedIndex()] == 0);
            }
            super.doIt(ch, e);
        }
    }
}

