/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.span;

import com.cisco.dcbu.dm.DMPanel;
import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.FieldPanelWithReset;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EditGlobalForm
extends EditForm {
    static final int ACTIVE = 1;
    JLabel _reasonLabel;
    FieldPanelWithReset _thresholdPanel;
    JLabel _thresholdLabel;
    static final int THRESHOLD_POS = 0;
    boolean _sessionActive;

    public EditGlobalForm(String[] vars) {
        super(vars);
    }

    @Override
    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == 0) {
            this._thresholdLabel = super.createFormLabel(mibVar, index);
            return this._thresholdLabel;
        }
        return super.createFormLabel(mibVar, index);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 0) {
            this._reasonLabel = new JLabel(" (Only available when no session is active)");
            this._reasonLabel.setFont(ChangedCellRenderer.getNormalFont());
            this._thresholdPanel = new FieldPanelWithReset(5, 1, mibNode.getHi(), -1, (String)SnmpTableModel._Units.get(mibVar));
            this._thresholdPanel.getField().addKeyListener(new DMPanel.ChangedFieldListener());
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)this._reasonLabel, "East");
            panel.add((Component)this._thresholdPanel, "West");
            this._reasonLabel.setVisible(false);
            panel.setPreferredSize(new Dimension(430, 2));
            return panel;
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected void setComponentValue(int i, SnmpVar v) {
        if (i == 0) {
            this._thresholdPanel.setText(v.toString());
        } else {
            super.setComponentValue(i, v);
        }
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 0) {
            try {
                return this.getVarFromString(this._thresholdPanel.getText(), index);
            }
            catch (NumberFormatException ex) {
                throw new NumberFormatException(this.trim(this._vars[index]) + ' ' + ex.getMessage());
            }
            catch (SnmpException ex) {
                throw new NumberFormatException(this.trim(this._vars[index]) + ' ' + ex.getMessage());
            }
        }
        return super.getComponentValue(index);
    }

    @Override
    protected boolean isChanged(int index) {
        if (index == 0) {
            return this._thresholdPanel.getField().getFont() == ChangedCellRenderer.getChangeFont();
        }
        return super.isChanged(index);
    }

    @Override
    protected void resetChanges() {
        super.resetChanges();
        if (this._thresholdPanel != null) {
            this._thresholdPanel.setFont(null);
        }
    }

    @Override
    protected void preGet() {
        try {
            this._sessionActive = false;
            VarBindList vbl = new VarBindList(1);
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cspanSessionOperStatus").getOid())));
            SnmpPDU resp = SnmpFetch.getBulk(this.getPeer(), vbl);
            vbl = resp.getVariables();
            if (vbl.size() == 0) {
                this._sessionActive = true;
                return;
            }
            for (int i = 0; i < vbl.size(); ++i) {
                boolean active;
                boolean bl = active = vbl.intValue(i) == 1;
                if (!active) continue;
                this._sessionActive = true;
                break;
            }
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    @Override
    protected void postProcessing() throws SnmpException {
        this._reasonLabel.setVisible(this._sessionActive);
        this._thresholdPanel.setEnabled(!this._sessionActive);
        this._thresholdLabel.setEnabled(!this._sessionActive);
    }
}

