/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.syslog;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dmdb.DmId;
import com.cisco.dcbu.lib.jnm.ExternalTools;
import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.jnm.Vsh;
import com.cisco.dcbu.lib.jnm.VshLog;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.ui.Util;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class AccountingLog
extends VshLog {
    static final String[] COLS = new String[]{"Switch Time", "Action", "Protocol & Source", "User", "Description"};
    static final int TIMESTAMP = 1;
    static final int FACILITY = 2;
    static final int SEVERITY = 3;
    static final int EVENT = 4;
    static final int VSAN_TIMESTAMP = 5;
    static final int VSAN = 6;
    static final int VSAN_ID = 7;
    static final int HOST_TIMESTAMP = 8;
    static final int ACTION = 9;
    static final int PROTOCOL_SOURCE = 10;
    static final int USER = 11;
    static final int DESCRIPTION = 12;
    static final String ACCT_REGEX = "(\\d* *[a-zA-Z]{3} +\\d+ +\\d{2}:\\d{2}:\\d{2}) +\\S+ +%([a-zA-Z_0-9\\-]+)-(\\d)-(\\w+):( +%\\$(VSAN (\\d+))?:? *(.*)%\\$)? +([^:]*):([^:]*):([^:]*):?(.*)";
    static final int TIMESTAMP2 = 1;
    static final int ACTION2 = 2;
    static final int PROTOCOL_SOURCE2 = 3;
    static final int USER2 = 4;
    static final int DESCRIPTION2 = 5;
    static final String ACCT_REGEX2 = "([a-zA-Z]{3} +[a-zA-Z]{3} +\\d+ +\\d{2}:\\d{2}:\\d{2} +\\d+):([^:]*):([^:]*):([^:]*):?(.*)";
    static Pattern _Pattern1 = Pattern.compile("(\\d* *[a-zA-Z]{3} +\\d+ +\\d{2}:\\d{2}:\\d{2}) +\\S+ +%([a-zA-Z_0-9\\-]+)-(\\d)-(\\w+):( +%\\$(VSAN (\\d+))?:? *(.*)%\\$)? +([^:]*):([^:]*):([^:]*):?(.*)");
    static Pattern _Pattern2 = Pattern.compile("([a-zA-Z]{3} +[a-zA-Z]{3} +\\d+ +\\d{2}:\\d{2}:\\d{2} +\\d+):([^:]*):([^:]*):([^:]*):?(.*)");

    public AccountingLog(JFrame parent, String cmd, SnmpPeer peer) throws IOException {
        super(parent, cmd, peer);
        this._btns[0].setVisible(!DmId.isN7K(Discover.getSysObjectID()));
    }

    public AccountingLog(JFrame parent, String title, String filename) {
        super(parent, title, filename);
        this._btns[0].setVisible(!DmId.isN7K(Discover.getSysObjectID()));
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        boolean isVisible = this._version != null && !this._version.lessThan(new SwitchVersion("2.0(0)")) && !DmId.isN7K(Discover.getSysObjectID());
        this._btns[0].setVisible(isVisible);
    }

    @Override
    protected String[] getHeaders() {
        return COLS;
    }

    @Override
    protected String[] tokenize(String line) {
        String[] tokens = new String[COLS.length];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = null;
        }
        line = line.trim();
        if (this.isFileMode()) {
            Matcher m = _Pattern1.matcher(line);
            if (m.matches()) {
                tokens[0] = m.group(1);
                tokens[1] = m.group(9);
                tokens[2] = m.group(10);
                tokens[3] = m.group(11);
                tokens[4] = m.group(12);
            } else {
                tokens[4] = line;
            }
        } else {
            Matcher m = _Pattern2.matcher(line);
            if (m.matches()) {
                tokens[0] = m.group(1);
                tokens[1] = m.group(2);
                tokens[2] = m.group(3);
                tokens[3] = m.group(4);
                tokens[4] = m.group(5);
            } else {
                tokens[4] = line;
            }
        }
        return tokens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = ((JButton)e.getSource()).getText();
        if (cmd.startsWith("Clear")) {
            Object[] options = new String[]{"Yes", "No"};
            if (JOptionPane.showOptionDialog(DeviceManager.getInstance(), "Are you sure you want to clear the log ?", DeviceManager.getInstance().getTitle(), 0, 3, null, options, "No") != 0) {
                return;
            }
            Vsh vsh = null;
            try {
                vsh = Vsh.get(this._parent, this._peer, ExternalTools.isUseSSH());
                if (vsh != null) {
                    vsh.sendAndReply("clear accounting log\n");
                    this.clear();
                    this._model.fireTableDataChanged();
                    this.enableButtons(false);
                }
                if (vsh == null) return;
            }
            catch (Exception ex) {
                try {
                    Util.errorMessage((Component)this._parent, ex.getMessage());
                    if (vsh == null) return;
                }
                catch (Throwable throwable) {
                    if (vsh == null) throw throwable;
                    Vsh.put(vsh);
                    throw throwable;
                }
                Vsh.put(vsh);
                return;
            }
            Vsh.put(vsh);
            return;
        }
        super.actionPerformed(e);
    }
}

