/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.vsif;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.dmdb.andiamo.FCoEPostPollUpdater;
import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.InterfaceIndex;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.mds.InterfacePortsCellEditor;
import com.cisco.dcbu.lib.mds.PortEditorCardAttribute;
import com.cisco.dcbu.lib.mds.PortEditorFilter;
import com.cisco.dcbu.lib.mds.PortSetCellCallbackIf;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.IntArray;
import com.cisco.dcbu.lib.util.vsif.VSifObj;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.event.ListSelectionEvent;

public class EditVSifTable
extends EditTable
implements PortSetCellCallbackIf {
    protected static final int NO_FILTER = 1;
    protected static final int FILTER_ON_BOUND_ETH_IFINDICES = 2;
    protected static final int FILTER_ON_VSIF_IFINDICES = 3;
    protected static final int SPEED_1G = 1000;
    public static final int BIND_TYPE_COL = 2;
    public static final int BIND_IFINDEX_COL = 3;
    public static final int BIND_MAC_COL = 4;
    public static final int FCF_PRIORITY_COL = 5;
    public static final int ADMIN_MODE_COL = 7;
    public static List<Integer> fcoeCardTypes = new ArrayList<Integer>();
    static final int[] VFC_BINDING_IFINDEX_OID;
    private int mVSifIfType;
    private boolean mAllowCreate = true;
    int[][] mFilterOnIfIndices;
    int[] mLastRetrievedFirstOid = new int[0];
    protected int mFilterType;
    protected IfIndexIf ifIndexIf;
    protected TreeMap<Integer, Integer> ethPortToSpeedMap;
    protected Set<Integer> mFexConnEthPortIfIndicesSet;
    protected PortEditorCardAttribute[] _cardAttrs = DmSystem.getCardAttributes();

    public EditVSifTable(String[] pVars, int pVsifType) {
        super(pVars);
        this.ifIndexIf = Discover.getRoot();
        if (pVsifType != this.ifIndexIf.getActualType(30) && pVsifType != this.ifIndexIf.getActualType(28)) {
            throw new IllegalArgumentException("Invalid value in vsifType parameter to EditSifTable constructor :" + pVsifType);
        }
        this.mVSifIfType = pVsifType;
    }

    @Override
    protected boolean validateChanges(Array cells, SnmpTableModel model, String[][] mibVars, String[] message, int offset) {
        for (int i = 0; i < cells.size(); ++i) {
            Cell cell = (Cell)cells.elementAt(i);
            if (cell._col == 3) {
                Object value = this._tableModel.getValueAt(cell._row, cell._col);
                if (value == null) continue;
                if (value instanceof InterfaceIndex) {
                    InterfaceIndex ifIndex = (InterfaceIndex)value;
                    if (this.isConnectedToFEX(ifIndex.getValue())) {
                        Util.errorMessage((Component)this._parent, "The Ethernet Interface : <" + ifIndex + "> is connected to a FEX.\n" + "Please select another 1G+ Ethernet Interface.");
                        return false;
                    }
                    if (this.validateSpeed(ifIndex.getValue())) continue;
                    Util.errorMessage((Component)this._parent, "The Bound Ethernet Interface : <" + ifIndex + "> is not running at 1G+.\n" + "Please select a 1G+ Ethernet Interface.");
                    return false;
                }
                throw new IllegalArgumentException("Bad Interface " + value);
            }
            return super.validateChanges(cells, model, mibVars, message, offset);
        }
        return true;
    }

    protected boolean isConnectedToFEX(int ifIndex) {
        return this.mFexConnEthPortIfIndicesSet.contains(ifIndex);
    }

    protected boolean validateSpeed(int ifIndex) {
        return Discover.getRoot().getType(ifIndex) == 22 || !Discover.getRoot().isN5K() || this.ethPortToSpeedMap == null || !this.ethPortToSpeedMap.containsKey(ifIndex) || this.ethPortToSpeedMap.get(ifIndex) >= 1000;
    }

    private void populateSpeeds() {
        try {
            VSifObj lVSifObj = VSifObj.get(Discover.getPeer(), Discover.getRoot(), 7);
            this.ethPortToSpeedMap = lVSifObj.getEthPortIfIndexToSpeedMap();
        }
        catch (SnmpException e) {
            if (SnmpSession.isTrace()) {
                DefaultLogger._DefLogger.debug((Object)e);
            }
            Util.errorMessage((Component)this._parent, "Unable to retrieve Speed for the Ethernet Interfaces: \n" + e.getMessage());
        }
    }

    @Override
    protected void buildTable() {
        super.buildTable();
        InterfacePortsCellEditor edtrRndr = new InterfacePortsCellEditor(Discover.getDeviceName(), 3, true, Discover.getRoot(), this._cardAttrs, new PortEditorFilter(FRUConstants.getAllFCoECapableCardTypes(), new int[]{this.ifIndexIf.getActualType(26), this.ifIndexIf.getActualType(31)}), Discover.getPeer(), 19);
        edtrRndr.setCellCallBack(this);
        edtrRndr.setAllowNoSelectionWhenExclusive(true);
        this._table.getColumnModel().getColumn(this._table.convertColumnIndexToView(3)).setCellEditor(edtrRndr);
    }

    @Override
    public boolean PortSetCellCB(int card, int port) {
        PortEditorCardAttribute cardAttr = this._cardAttrs[card - 1];
        if (!fcoeCardTypes.contains(cardAttr.getCardTypes())) {
            return false;
        }
        String ifName = this.ifIndexIf.ifTypeToifName(cardAttr.getIfTypes()[port - 1]);
        String cardPrefix = cardAttr.getCardStr() != null ? cardAttr.getCardStr() : String.valueOf(card);
        int ifIndex = Discover.getRoot().nameToIfIndex(ifName + cardPrefix + "/" + port);
        return this.validateSpeed(ifIndex) && !this.isConnectedToFEX(ifIndex);
    }

    @Override
    public void get() {
        this.populateSpeeds();
        this.mFexConnEthPortIfIndicesSet = FCoEPostPollUpdater.getInstance().getEthIfIndicesAttachedToFex(Discover.getRoot());
        super.get();
    }

    @Override
    public void preGet() {
        block12: {
            this.mLastRetrievedFirstOid = new int[0];
            if (this.mFilterType == 0) {
                int ifIndex = this._parent._multipleIndeces[0][0];
                if (ifIndex == 0) {
                    this.mFilterType = 1;
                } else {
                    int type = this.ifIndexIf.getType(ifIndex);
                    if (26 == type || 31 == type) {
                        this.mFilterType = 2;
                    } else if (30 == type || 28 == type) {
                        this.mFilterType = 3;
                    } else {
                        throw new IllegalArgumentException("No support for filter on ifindex :" + ifIndex);
                    }
                    this.mFilterOnIfIndices = this._parent._multipleIndeces;
                }
            }
            try {
                int[][] ethIfIndices = this.mFilterType == 2 ? this.mFilterOnIfIndices : (int[][])null;
                List<Integer> vsifIfIndices = VSifObj.getVSifIfIndices(this.getPeer(), Discover.getRoot(), this.mVSifIfType, ethIfIndices);
                if (this.mFilterType == 3) {
                    ArrayList<Integer> tempVsifIfIndices = new ArrayList<Integer>();
                    int size = this.mFilterOnIfIndices.length;
                    for (int i = 0; i < size; ++i) {
                        if (!vsifIfIndices.contains(this.mFilterOnIfIndices[i][0])) continue;
                        tempVsifIfIndices.add(this.mFilterOnIfIndices[i][0]);
                    }
                    vsifIfIndices = tempVsifIfIndices;
                }
                int count = vsifIfIndices.size();
                this._parent._multipleIndeces = new int[count][1];
                for (int i = 0; i < count; ++i) {
                    this._parent._multipleIndeces[i][0] = vsifIfIndices.get(i);
                }
            }
            catch (SnmpException ex) {
                this._parent._multipleIndeces = new int[0][0];
                Util.errorMessage((Component)DeviceManager.getInstance(), ex.getMessage());
                if (!SnmpSession.isTrace()) break block12;
                DefaultLogger._DefLogger.debug((Object)ex);
            }
        }
    }

    public void setShowCreateButton(boolean flag) {
        this.mAllowCreate = flag;
    }

    @Override
    protected Array getButtons() {
        Array buttons = super.getButtons();
        if (!this.mAllowCreate) {
            buttons.removeElement("Create...");
        }
        return buttons;
    }

    @Override
    protected void sendGetPdu(SnmpPDU pdu) throws SnmpException {
        if (this._state == -95) {
            SnmpVarBind vb;
            int[] firstOid;
            pdu.setCommand((byte)-96);
            if (this.isMultiple() && SnmpOID.equals(firstOid = (vb = pdu.getVariables().get(0)).getOid().getValue(), this.mLastRetrievedFirstOid)) {
                this.callback(null, pdu.getReqid(), pdu, false);
                return;
            }
        }
        super.sendGetPdu(pdu);
    }

    @Override
    protected boolean isAtEnd(int[] firstOid, SnmpVarBind vb, boolean isMultiple, SnmpPDU pdu) {
        if (isMultiple) {
            int[] vbFirstOid = vb.getOid().getValue();
            if (SnmpOID.equals(this.mLastRetrievedFirstOid, vbFirstOid)) {
                return true;
            }
            this.mLastRetrievedFirstOid = vb.getOid().getValue();
        }
        return super.isAtEnd(firstOid, vb, isMultiple, pdu);
    }

    @Override
    protected void updateTable() {
        super.updateTable();
        int rowCount = this._table.getRowCount();
        int[][] indices = new int[rowCount][1];
        for (int i = 0; i < rowCount; ++i) {
            indices[i][0] = ((SnmpOID)this._table.getValueAt(i, 0)).getValue()[0];
        }
        this._parent._multipleIndeces = indices;
    }

    @Override
    protected SnmpPDU processDeletedRow(SnmpPDU pdu, int rowN) {
        int vsifIfIndex = this._tableModel.getIndex(rowN)[0];
        pdu.addVar(new SnmpOID(this._rowStatus, IfIndexUtil.ifIndexToVfcTableIndex(vsifIfIndex, this.ifIndexIf)), new SnmpInt(this._deleteValue));
        return pdu;
    }

    @Override
    protected int[] getIndexForFetch(MibNode mibNode, int[] index) {
        return this.getIndexFor(mibNode, index);
    }

    @Override
    protected int[] getIndexFor(MibNode mibNode, int[] index) {
        int i;
        for (i = 1; i < this._mibNodes.length && !this._mibNodes[i].equals(mibNode); ++i) {
        }
        return this.getIndexFor(i, index);
    }

    protected int[] getIndexFor(int col, int[] index) {
        if (col == 3) {
            return IfIndexUtil.ifIndexToVfcTableIndex(index[0], this.ifIndexIf);
        }
        return index;
    }

    @Override
    public void valueChanged(ListSelectionEvent pEvent) {
        super.valueChanged(pEvent);
        if (pEvent.getValueIsAdjusting()) {
            return;
        }
        if (!DeviceManager.getInstance().showingPhysicalView()) {
            return;
        }
        PhysicalView view = DeviceManager.getInstance().getView();
        view.clearSelection();
        int[] rows = this._table.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        IntArray ifIndexList = new IntArray();
        for (int row : rows) {
            Object o = this._tableModel.getValueAt(row, 3);
            if (o == null || !(o instanceof InterfaceIndex)) continue;
            ifIndexList.add(((InterfaceIndex)o).getValue());
        }
        int[] ifIndex = ifIndexList.toArray();
        Array elements = view.getElements();
        block1: for (int i = elements.size() - 1; i >= 0; --i) {
            PhysicalElement el = (PhysicalElement)elements.elementAt(i);
            el.setSelected(false);
            for (int j = 0; j < ifIndex.length; ++j) {
                if (el.getIndex()[0] != ifIndex[j]) continue;
                el.setSelected(true);
                continue block1;
            }
        }
        view.repaint();
    }

    @Override
    protected DmTableModel buildTableModel() {
        return new VSIFTableModel();
    }

    static {
        int[] fcoeAllowedCardTypes = FRUConstants.getAllFCoECapableCardTypes();
        for (int i = 0; i < fcoeAllowedCardTypes.length; ++i) {
            fcoeCardTypes.add(fcoeAllowedCardTypes[i]);
        }
        VFC_BINDING_IFINDEX_OID = MibNode.get("cfcoeStaticVfcBindIfIndex").getOid();
    }

    protected class VSIFTableModel
    extends DmTableModel {
        protected VSIFTableModel() {
        }

        @Override
        public Object toCellEditTable(MibNode mibNode, SnmpPDU pdu, SnmpVarBind vb, String var, SnmpOID index, int row, int col) {
            SnmpVar v = vb.getVar();
            if (col == 3) {
                try {
                    return new InterfaceIndex((SnmpInt)v, this.getIfIndexIf(0));
                }
                catch (SnmpException ex) {
                    return null;
                }
            }
            return super.toCellEditTable(mibNode, pdu, vb, var, index, row, col);
        }

        @Override
        protected SnmpVar getChangedCell(int row, int col, MibNode[] mibNodes) throws Exception {
            if (col == 3) {
                Object o = this.getValueAt(row, col);
                if (o instanceof SnmpVar) {
                    return (SnmpVar)o;
                }
                if (o == null) {
                    return new SnmpInt(0);
                }
                throw new Exception("Bad Interface " + o.toString());
            }
            return super.getChangedCell(row, col, mibNodes);
        }

        @Override
        public Object getSetValueAt(Object aValue, int row, int col) {
            if (col == 3) {
                try {
                    aValue = new InterfaceIndex(aValue.toString().trim(), this.getIfIndexIf(row), true);
                }
                catch (Exception ex) {}
            } else {
                aValue = super.getSetValueAt(aValue, row, col);
                if (col == 2) {
                    int idx;
                    Object[] values = (Object[])this.getData().elementAt(row);
                    Object[] changed = (Object[])values[this.getHeaders().length];
                    int n = idx = ((MibEnum)aValue).getValue() == 1 ? 4 : 3;
                    if (changed != null && changed[idx] != null) {
                        values[idx] = changed[idx];
                        changed[idx] = null;
                    }
                }
            }
            return aValue;
        }

        @Override
        protected void assignCellValueSameClass(Object aValue, int row, int col, Object[] values) {
            if (col == 3 && aValue instanceof InterfaceIndex && ((InterfaceIndex)aValue).getValue() == 0) {
                aValue = null;
            }
            this.markUndo(row, col, aValue);
            values[col] = aValue;
        }

        @Override
        protected void assignCellValue(Object aValue, int row, int col, Object[] values) throws Exception {
            if (col == 3) {
                if (aValue instanceof InterfaceIndex) {
                    if (((InterfaceIndex)aValue).getValue() == 0) {
                        aValue = null;
                    }
                    this.markUndo(row, col, aValue);
                    values[col] = aValue;
                }
            } else {
                super.assignCellValue(aValue, row, col, values);
            }
        }

        @Override
        public int[] getIndex(int row, int col) {
            return EditVSifTable.this.getIndexFor(col, this.getIndex(row));
        }

        @Override
        protected Object getSortColumnObj(Object row) {
            return ((Object[])row)[this._sortColumn];
        }
    }
}

