/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.zeroTouch;

import com.cisco.dcbu.dmdb.andiamo.dialogs.zeroTouch.DhcpSwitch;
import com.cisco.dcbu.dmdb.andiamo.dialogs.zeroTouch.JWizardFrame;
import com.cisco.dcbu.dmdb.andiamo.dialogs.zeroTouch.ZeroTouchPanel;
import com.cisco.dcbu.dmdb.andiamo.dialogs.zeroTouch.ZeroTouchWizard;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.BorderCellRenderer;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;

public class FinalPanel
extends ZeroTouchPanel
implements ActionListener,
ListSelectionListener {
    SnmpKTable _table;
    JWizardFrame _wiz;
    JScrollPane _sp;
    JButton _launchDMBtn;

    public FinalPanel(JFrame parent, JWizardFrame wiz) {
        super("Step 2 of 2 - Show Status", "The \u0091Status\u0092 column will show \u0091success\u0092 when the password has been assigned.  Press \u0091Open Device Manager\u0092 to continue provisioning a selected switch. Switch Zero Touch mode will be disabled automatically after the password changed successfully, please start using the new password to manage the switches.", parent, wiz);
        Box box = new Box(1);
        Array data = new Array();
        String[] cols = new String[]{"IP Address", "Model", "WWN", "Serial #", "Switch Version", "DHCP Server", "Status"};
        boolean[] attrs = new boolean[]{false, false, false, false, false, false, false};
        this._wiz = wiz;
        JPanel p = new JPanel(new BorderLayout());
        this._table = this.buildTable(cols, attrs, new Array(), false);
        this.setAllowedAddRemoveColumn(this._table, false);
        this._table.setRowSelectionAllowed(true);
        this._table.setSortable(false);
        TableColumnModel cm = this._table.getColumnModel();
        cm.setColumnSelectionAllowed(true);
        cm.getColumn(0).setMaxWidth(160);
        cm.getColumn(6).setCellRenderer(new StatusRenderer());
        ListSelectionModel tableListener = this._table.getSelectionModel();
        tableListener.addListSelectionListener(this);
        this._table.registerKeyboardAction(this, "Cr", KeyStroke.getKeyStroke(155, 0), 0);
        this._table.registerKeyboardAction(this, "D", KeyStroke.getKeyStroke(127, 0), 0);
        this._sp = new JScrollPane(this._table);
        this._sp.setPreferredSize(this._table.calcPreferredSize());
        box.add(this._sp);
        p.add("Center", this._sp);
        box.add(p);
        JPanel p2 = new JPanel(new FlowLayout(2, 2, 7));
        this._launchDMBtn = new JButton("Open Device Manager");
        this._launchDMBtn.addActionListener(this);
        this.valueChanged(null);
        p2.add(this._launchDMBtn);
        box.add(p2);
        this.add(box);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            DhcpSwitch[] sws = ((ZeroTouchWizard)this._wiz).getSwitches();
            Array data = FinalPanel.getData(this._table);
            data.clear();
            for (int i = 0; i < sws.length; ++i) {
                DhcpSwitch sw = sws[i];
                String status = "Success";
                if (i == 1) {
                    status = "Failure: can't reach switch with the new password (Unknown User or Password)";
                } else if (i == 3) {
                    status = "Failure: can't reach switch with the new password ( timedout )";
                }
                Object[] row = new Object[]{sw, sw.getModel(), sw.getWWN(), sw.getSerialNumber(), sw.getSwVersion(), sw.getDHCPIpAddr(), status, null};
                data.addElement(row);
            }
            FinalPanel.getModel(this._table).fireTableDataChanged();
            this._sp.setPreferredSize(this._table.calcPreferredSize());
            JButton btn = this.getWizard().getNavigator().getNextBtn();
            btn.setEnabled(false);
            btn.setVisible(false);
            btn = this.getWizard().getNavigator().getBackBtn();
            btn.setEnabled(true);
            btn = this.getWizard().getNavigator().getCancel();
            btn.setText("Close");
            this._table.setSortable(false);
        }
        super.setVisible(b);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        String status;
        boolean isEnabled;
        boolean bl = isEnabled = this._table.getSelectedRowCount() == 1 && this._table.getSelectedRow() != -1;
        if (isEnabled && (status = (String)this._table.getValueAt(this._table.getSelectedRow(), 6)).indexOf("Success") == -1) {
            isEnabled = false;
        }
        this._launchDMBtn.setEnabled(isEnabled);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!(e.getSource() instanceof JButton)) {
            FinalPanel.getModel(this._table).fireTableDataChanged();
        }
    }

    @Override
    protected SnmpKTable createTable(SnmpTableModel model) {
        return new SnmpSwitchPanelTable(model);
    }

    class StatusRenderer
    extends BorderCellRenderer {
        StatusRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                String status = value.toString().toLowerCase();
                if (status.indexOf("fail") != -1) {
                    this.setBackground(Color.pink);
                } else {
                    this.setBackground(table.getBackground());
                }
            } else {
                this.setBackground(table.getBackground());
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    class SnmpSwitchPanelTable
    extends SnmpKTable
    implements ActionListener {
        KTableModel _model;
        String[][] _menuItems;

        public SnmpSwitchPanelTable(KTableModel model) {
            super(model);
            this._menuItems = new String[][]{{"Select All", "A"}, {"Select None", "N"}};
            this._model = model;
        }

        @Override
        protected void buildPopupMenu() {
            this._popup = new JPopupMenu();
            for (int i = 0; i < this._menuItems.length; ++i) {
                this._popup.add(Util.createMenuItem(this._menuItems[i][0], this._menuItems[i][1], this));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().charAt(0) == 'A' || e.getActionCommand().charAt(0) == 'N') {
                boolean none = e.getActionCommand().charAt(0) == 'N';
                this.setSelectionAll(none ? Boolean.FALSE : Boolean.TRUE);
            } else {
                super.actionPerformed(e);
            }
        }

        void setSelectionAll(Object value) {
            for (int i = 0; i < FinalPanel.this._table.getRowCount(); ++i) {
                FinalPanel.this._table.setValueAt(value, i, 0);
            }
        }
    }
}

