/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.zm;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dmdb.DmId;
import com.cisco.dcbu.dmdb.andiamo.dialogs.zm.ConfirmationPanel;
import com.cisco.dcbu.dmdb.andiamo.dialogs.zm.DmZoneAction;
import com.cisco.dcbu.dmdb.andiamo.dialogs.zm.SelectPortPanel;
import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.mds.zm.IfIndexCellRenderer;
import com.cisco.dcbu.lib.mds.zm.StatusIf;
import com.cisco.dcbu.lib.mds.zm.VersionPeer;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class DmZoneWizard
extends JWizard
implements StatusIf {
    private VersionPeer verPeer;
    private SelectPortPanel selectPortPanel;
    private ConfirmationPanel confirmationPanel;
    static ImageIcon _ImageFcip = Util.loadIcon("icons/zoneconfig.gif");

    public DmZoneWizard(JFrame parent, SnmpPeer peer, ArrayList ports, SwitchVersion swVer) throws SnmpException {
        super(parent);
        this.setTitle(Discover.getDeviceName() + " - Quick Config Wizard");
        this.setSize(800, 680);
        this.verPeer = new VersionPeer(peer, swVer, Discover.getRoot(), peer.toString(), true);
        ArrayList licensedPorts = DmZoneAction.discoverLicensedSwitchPorts(ports, this.verPeer);
        if (licensedPorts.size() == 0) {
            throw new SnmpException("WARNING: No licensed switch ports are available.");
        }
        this.selectPortPanel = new SelectPortPanel(this, this.verPeer, licensedPorts, swVer);
        if (this.selectPortPanel.getEPorts() == null || this.selectPortPanel.getEPorts().size() > 0) {
            return;
        }
        this.addPanel("select zone ports", this.selectPortPanel);
        this.confirmationPanel = new ConfirmationPanel(this, this.verPeer);
        this.addPanel("Confirm configuration", this.confirmationPanel);
        this.first();
        this.setLocationRelativeTo(this.getParent());
    }

    public boolean validateEportsPresent() {
        ArrayList ePorts = this.selectPortPanel.getEPorts();
        if (ePorts != null && ePorts.size() > 0) {
            StringBuffer indices = new StringBuffer();
            for (int i = 0; i < ePorts.size(); ++i) {
                indices.append(DmZoneWizard.getShortenedIfIndex2Name(Discover.getRoot(), (Integer)ePorts.get(i)));
                if (i >= ePorts.size() - 1) continue;
                indices.append(", ");
            }
            indices.insert(0, "This wizard only supports a single switch fabric.  The following ISL \nport(s) must be disabled.\nPort(s): ");
            Util.errorMessage((Component)this, indices.toString());
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
        if (this.isVisible() && this.getNavigator().getNextBtn().isEnabled() && this.selectPortPanel.isChanged() && JOptionPane.showConfirmDialog(this, "There are pending changes.  Exit configuration? ", Discover.getDeviceName() + " - Pending Changes", 0, 3) != 0) {
            return;
        }
        this.selectPortPanel.cleanup();
        this.confirmationPanel.cleanup();
        super.dispose();
    }

    @Override
    public void handleError(Exception[] ex) {
        this.confirmationPanel.handleError(ex);
    }

    @Override
    public void setStatus(String status) {
        this.confirmationPanel.setStatus(status);
        super.setStatus(status);
    }

    @Override
    public void actionFinished() {
        this.confirmationPanel.actionFinished();
        this._nav.getCancel().setText("Close");
    }

    static String getShortenedIfIndex2Name(IfIndexIf ifindexIf, int ifIndex) {
        boolean isChesterOrInagua = DmId.isChester(Discover.getSysObjectID()) || DmId.isCassino(Discover.getSysObjectID()) || DmId.isInagua(Discover.getSysObjectID());
        return IfIndexCellRenderer.getShortenedIfIndex2PortName(ifindexIf, ifIndex, isChesterOrInagua);
    }

    static String getIfIndex2Card(IfIndexIf ifindexIf, int ifIndex) {
        boolean isChesterOrInagua = DmId.isChester(Discover.getSysObjectID()) || DmId.isCassino(Discover.getSysObjectID()) || DmId.isInagua(Discover.getSysObjectID());
        return Integer.toString(ifindexIf.ifIndex2Card(ifIndex) + 1);
    }
}

