/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.elements;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dm.RediscoverException;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.dmdb.andiamo.elements.ActiveSupStatusLED;
import com.cisco.dcbu.dmdb.andiamo.elements.CardStatusLED;
import com.cisco.dcbu.dmdb.andiamo.elements.Card_1;
import com.cisco.dcbu.dmdb.andiamo.elements.Chassis_10;
import com.cisco.dcbu.dmdb.andiamo.elements.ConsolePort;
import com.cisco.dcbu.dmdb.andiamo.elements.MgmtPort;
import com.cisco.dcbu.dmdb.andiamo.elements.Pcmcia;
import com.cisco.dcbu.dmdb.andiamo.elements.Port;
import com.cisco.dcbu.dmdb.andiamo.elements.PowerMgmtStatusLED;
import com.cisco.dcbu.dmdb.andiamo.elements.SystemStatusLED;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class Card_40000001
extends Card_1 {
    private static final int[][] STATUS_VAR = new int[][]{MibNode.get("entPhysicalSoftwareRev").getOid(), MibNode.get("cRFStatusUnitId").getOid()};
    private static final Class[] CHILDREN = new Class[]{CardStatusLED.class, SystemStatusLED.class, PowerMgmtStatusLED.class, ActiveSupStatusLED.class, MgmtPort.class, Pcmcia.class, ConsolePort.class};
    private static final int[][] _PortPos = new int[][]{{9, 113}};
    private static final int[][] _PcmciaPos = new int[][]{{9, 182}};
    private static final int[][] _StatusLEDPos = new int[][]{{1, 12}};
    private static final int[][] _SystemLEDPos = new int[][]{{1, 24}};
    private static final int[][] _ActiveSupLEDPos = new int[][]{{1, 37}};
    private static final int[][] _PowerMgmtLEDPos = new int[][]{{1, 48}};
    private static final int[][] _ConsolePos = new int[][]{{9, 85}};
    private String _version;

    @Override
    public int[][] getChildPos(Class child) {
        if (!(this._parent instanceof Chassis_10)) {
            return super.getChildPos(child);
        }
        if (child == MgmtPort.class) {
            return _PortPos;
        }
        if (child == Pcmcia.class) {
            return _PcmciaPos;
        }
        if (child == ActiveSupStatusLED.class) {
            return _ActiveSupLEDPos;
        }
        if (child == PowerMgmtStatusLED.class) {
            return _PowerMgmtLEDPos;
        }
        if (child == SystemStatusLED.class) {
            return _SystemLEDPos;
        }
        if (child == ConsolePort.class) {
            return _ConsolePos;
        }
        return _StatusLEDPos;
    }

    @Override
    public Class[] getChildren() {
        return CHILDREN;
    }

    @Override
    public void disable() {
        Array elements = DeviceManager.getInstance().getView().getElements();
        for (int i = elements.size() - 1; i >= 0; --i) {
            PhysicalElement e = (PhysicalElement)elements.elementAt(i);
            if (!(e instanceof SystemStatusLED) && !(e instanceof PowerMgmtStatusLED)) continue;
            e.disable();
        }
    }

    @Override
    public SnmpVarBind[] getStatusVar() {
        return this.buildStatusVar(STATUS_VAR);
    }

    @Override
    public SnmpVarBind[] buildStatusVar(int[][] oids) {
        SnmpVarBind[] vb = new SnmpVarBind[oids.length];
        vb[0] = new SnmpVarBind(new SnmpOID(oids[0], this.getStatusVarIndex(this._index)));
        vb[1] = new SnmpVarBind(new SnmpOID(oids[1], new int[]{0}));
        return vb;
    }

    @Override
    public void setStatus(VarBindList varBindList, int offset, PhysicalView view) throws RediscoverException {
        AffineTransform at;
        Graphics2D g2d;
        String version = varBindList.get(offset).getVar().toString();
        int activeSup = ((SnmpInt)varBindList.get(offset + 1).getVar()).getValue();
        if (this._index[0] == activeSup && Discover.setSysVersionFrmSup(version)) {
            return;
        }
        if (this._version != null && version.equals(this._version)) {
            return;
        }
        Graphics g = view.getOffscreenImage().getGraphics();
        g.setFont(Port._ModeFont);
        Rectangle r = this.getRect();
        if (this._version != null) {
            if (this.getParent() instanceof Chassis_10) {
                g2d = (Graphics2D)g;
                g2d.setColor(new Color(66, 66, 66));
                g2d.setFont(Port._ModeFont);
                at = new AffineTransform();
                at.setToTranslation(r.x + r.width - 29, r.y + r.height - (30 + version.length() * 3));
                g2d.transform(at);
                at.setToRotation(1.5707963267948966);
                g2d.transform(at);
                g2d.drawString(version, 0.0f, 0.0f);
                g2d.transform(at);
                g2d.dispose();
            } else {
                g.setColor(new Color(66, 66, 66));
                g.drawString(this._version, r.x + r.width - (30 + this._version.length() * 3), r.y + r.height - 5);
            }
        }
        if (this.getParent() instanceof Chassis_10) {
            g2d = (Graphics2D)g;
            g2d.setColor(Color.white);
            g2d.setFont(Port._ModeFont);
            at = new AffineTransform();
            at.setToTranslation(r.x + r.width - 29, r.y + r.height - (30 + version.length() * 3));
            g2d.transform(at);
            at.setToRotation(1.5707963267948966);
            g2d.transform(at);
            g2d.drawString(version, 0.0f, 0.0f);
            g2d.transform(at);
            g2d.dispose();
        } else {
            g.setColor(Color.white);
            g.drawString(version, r.x + r.width - (30 + version.length() * 3), r.y + r.height - 20);
            g.dispose();
        }
        this._version = version;
    }

    @Override
    public String getToolTipText() {
        if (this._toolTipText == null) {
            StringBuffer sb = new StringBuffer(200);
            if (this.getIndex()[0] == this._activeSup) {
                sb.append("Active ");
            } else {
                sb.append("Standby ");
            }
            sb.append(". Status: ");
            sb.append(this.getStatus());
            this._toolTipText = sb.toString();
        }
        return this._toolTipText;
    }

    @Override
    public String getBitmap() {
        return this._parent instanceof Chassis_10 ? "card-40000001.gif" : "card-40000001_horizontal.gif";
    }

    @Override
    public void resetAction(PhysicalElement[] selected) {
        String msg;
        boolean hotStandby = DmSystem.getStandbySupStatus() == 9;
        boolean isActive = this.getIndex()[0] == this._activeSup;
        JFrame parent = (JFrame)SwingUtilities.windowForComponent(DeviceManager.getInstance().getView());
        String string = !isActive ? "Do you want to reset the module?" : (msg = hotStandby ? "<html>Do you want to switch to standby ? <br>A timeout may be seen because of the RESET." : "Reseting a non-HA switch may cause traffic disruption and lose pending config changes,<br>A timeout may be seen because of the RESET.\nContinue?");
        if (JOptionPane.showOptionDialog(parent, msg, parent.getTitle(), 0, 3, null, new String[]{"Yes", "No"}, "No") != 0) {
            return;
        }
        this.applyAll(selected, "cefcModuleAdminStatus", new SnmpInt(3), true);
    }
}

