/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.elements;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dm.RediscoverException;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.dmdb.andiamo.elements.ActiveSupStatusLED;
import com.cisco.dcbu.dmdb.andiamo.elements.CardStatusLED;
import com.cisco.dcbu.dmdb.andiamo.elements.Card_1;
import com.cisco.dcbu.dmdb.andiamo.elements.Chassis;
import com.cisco.dcbu.dmdb.andiamo.elements.FlashDev;
import com.cisco.dcbu.dmdb.andiamo.elements.MgmtPort;
import com.cisco.dcbu.dmdb.andiamo.elements.Port;
import com.cisco.dcbu.dmdb.andiamo.elements.PowerMgmtStatusLED;
import com.cisco.dcbu.dmdb.andiamo.elements.SystemStatusLED;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class Card_60000005
extends Card_1 {
    private static final int[][] STATUS_VAR = new int[][]{MibNode.get("entPhysicalSoftwareRev").getOid(), MibNode.get("cRFStatusUnitId").getOid()};
    private static final Class[] CHILDREN = new Class[]{CardStatusLED.class, SystemStatusLED.class, PowerMgmtStatusLED.class, ActiveSupStatusLED.class, MgmtPort.class, FlashDev.class};
    private static final int[][] _PortPos = new int[][]{{82, 21}};
    private static final int[][] _FlashDevPos = new int[][]{{108, 10}, {108, 29}};
    private static final String[] _FlashDevName = new String[]{"slot0", "usb1"};
    private static final int[][] _StatusLEDPos = new int[][]{{12, 36}};
    private static final int[][] _SystemLEDPos = new int[][]{{24, 36}};
    private static final int[][] _ActiveSupLEDPos = new int[][]{{37, 36}};
    private static final int[][] _PowerMgmtLEDPos = new int[][]{{49, 36}};
    private String _version;
    protected Class[] _FlashDevClass;

    @Override
    public int[][] getChildPos(Class child) {
        if (child == MgmtPort.class) {
            return _PortPos;
        }
        if (child == FlashDev.class) {
            return _FlashDevPos;
        }
        if (child == ActiveSupStatusLED.class) {
            return _ActiveSupLEDPos;
        }
        if (child == PowerMgmtStatusLED.class) {
            return _PowerMgmtLEDPos;
        }
        if (child == SystemStatusLED.class) {
            return _SystemLEDPos;
        }
        return _StatusLEDPos;
    }

    @Override
    public Class[] getChildren() {
        return CHILDREN;
    }

    @Override
    public Class[] getChildSubclass(Class child) throws Exception {
        if (child == FlashDev.class) {
            ((Chassis)this.getParent())._isFlashDeviceHotSwapNeed = true;
            this._FlashDevClass = new Class[_FlashDevPos.length];
            HashMap<String, HashMap<String, Long[]>> flashDevHash = ((Chassis)this.getParent())._FlashDevHash;
            String partitionName = this.getIndex()[0] == DmSystem.getActiveSupIndex() ? "sup-local" : "sup-remote";
            for (int i = 0; i < _FlashDevPos.length; ++i) {
                Long[] flashSlotInfo;
                String flashDevName = i == 0 ? _FlashDevName[0] : _FlashDevName[1];
                HashMap<String, Long[]> flashPartitionHash = flashDevHash.get(flashDevName);
                if (flashPartitionHash == null || (flashSlotInfo = flashPartitionHash.get(partitionName)) == null) continue;
                this._FlashDevClass[i] = FlashDev.class;
            }
            return this._FlashDevClass;
        }
        return super.getChildSubclass(child);
    }

    @Override
    public int[] getChildIndex(Class child, int index) {
        if (child == FlashDev.class) {
            Long[] flashSlotInfo;
            HashMap<String, HashMap<String, Long[]>> flashDevHash = ((Chassis)this.getParent())._FlashDevHash;
            String partitionName = this.getIndex()[0] == DmSystem.getActiveSupIndex() ? "sup-local" : "sup-remote";
            String flashDevName = index == 0 ? _FlashDevName[0] : _FlashDevName[1];
            HashMap<String, Long[]> flashPartitionHash = flashDevHash.get(flashDevName);
            if (flashPartitionHash != null && (flashSlotInfo = flashPartitionHash.get(partitionName)) != null) {
                int[] flashDevIndex = new int[]{flashSlotInfo[0].intValue(), flashSlotInfo[1].intValue()};
                return flashDevIndex;
            }
            return null;
        }
        return super.getChildIndex(child, index);
    }

    @Override
    public void disable() {
        Array elements = DeviceManager.getInstance().getView().getElements();
        for (int i = elements.size() - 1; i >= 0; --i) {
            PhysicalElement e = (PhysicalElement)elements.elementAt(i);
            if (!(e instanceof SystemStatusLED) && !(e instanceof PowerMgmtStatusLED)) continue;
            e.disable();
        }
    }

    @Override
    public SnmpVarBind[] getStatusVar() {
        return this.buildStatusVar(STATUS_VAR);
    }

    @Override
    public SnmpVarBind[] buildStatusVar(int[][] oids) {
        SnmpVarBind[] vb = new SnmpVarBind[oids.length];
        vb[0] = new SnmpVarBind(new SnmpOID(oids[0], this.getStatusVarIndex(this._index)));
        vb[1] = new SnmpVarBind(new SnmpOID(oids[1], new int[]{0}));
        return vb;
    }

    @Override
    public void setStatus(VarBindList varBindList, int offset, PhysicalView view) throws RediscoverException {
        String version = varBindList.get(offset).getVar().toString();
        int activeSup = ((SnmpInt)varBindList.get(offset + 1).getVar()).getValue();
        if (this._index[0] == activeSup && Discover.setSysVersionFrmSup(version)) {
            return;
        }
        if (this._version != null && version.equals(this._version)) {
            return;
        }
        Graphics g = view.getOffscreenImage().getGraphics();
        g.setFont(Port._ModeFont);
        Rectangle r = this.getRect();
        if (this._version != null) {
            g.setColor(new Color(66, 66, 66));
            g.drawString(this._version, r.x + r.width - (30 + this._version.length() * 3), r.y + r.height - 5);
        }
        g.setColor(Color.black);
        g.drawString(version, r.x + r.width - (15 + version.length() * 3), r.y + r.height - 33);
        g.dispose();
        this._version = version;
    }

    @Override
    public String getToolTipText() {
        if (this._toolTipText == null) {
            StringBuffer sb = new StringBuffer(200);
            if (this.getIndex()[0] == this._activeSup) {
                sb.append("Active ");
            } else {
                sb.append("Standby ");
            }
            sb.append("Supervisor");
            sb.append(". Status: ");
            sb.append(this.getStatus());
            this._toolTipText = sb.toString();
        }
        return this._toolTipText;
    }

    @Override
    public String getBitmap() {
        return "card-1-XBOW.gif";
    }

    @Override
    public void resetAction(PhysicalElement[] selected) {
        String msg;
        boolean hotStandby = DmSystem.getStandbySupStatus() == 9;
        boolean isActive = this.getIndex()[0] == this._activeSup;
        JFrame parent = (JFrame)SwingUtilities.windowForComponent(DeviceManager.getInstance().getView());
        String string = !isActive ? "Do you want to reset the module?" : (msg = hotStandby ? "<html>Do you want to switch to standby ? <br>A timeout may be seen because of the RESET." : "Reseting a non-HA switch may cause traffic disruption and lose pending config changes,<br>A timeout may be seen because of the RESET.\nContinue?");
        if (JOptionPane.showOptionDialog(parent, msg, parent.getTitle(), 0, 3, null, new String[]{"Yes", "No"}, "No") != 0) {
            return;
        }
        this.applyAll(selected, "cefcModuleAdminStatus", new SnmpInt(3), true);
    }
}

