/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.install;

import com.cisco.dcbu.install.VCProxy;
import com.vmware.vim25.Description;
import com.vmware.vim25.Extension;
import com.vmware.vim25.ExtensionClientInfo;
import com.vmware.vim25.ExtensionServerInfo;
import com.vmware.vim25.mo.ServiceInstance;
import java.util.Calendar;

public class RegisterPlugin {
    private static final String COMPANY_STR = "Cisco Systems,Inc.";
    private static final String DESCR_STR = "Manage Cisco DCNM";
    private static final String KEY_STR = "Cisco DCNM";
    private static final String ADMIN_EMAIL = "yuqi@cisco.com";
    private static final String VERSION_STR = "1.0.1";
    private static final String PLUGIN_DESCR_FILE = "dcnmplugin.xml";
    public static final int DEFAULT_DCNM_PORT = 80;
    private static String _DcnmServer = null;

    public static String getDCNMServer() {
        return _DcnmServer;
    }

    public static void setDCNMServer(String dcnmServer) {
        _DcnmServer = dcnmServer;
    }

    private static Extension createExtension(String dcnmServer, String pluginFile) {
        _DcnmServer = dcnmServer;
        String dcnmUrl = dcnmServer + "/" + pluginFile;
        Description description = new Description();
        description.setLabel("CISCO DCNM");
        description.setSummary(DESCR_STR);
        ExtensionServerInfo esi = new ExtensionServerInfo();
        esi.setUrl(dcnmUrl);
        esi.setDescription(description);
        esi.setCompany(COMPANY_STR);
        esi.setType("com.vmware.vim.viClientScripts");
        esi.setAdminEmail(new String[]{ADMIN_EMAIL});
        ExtensionClientInfo eci = new ExtensionClientInfo();
        eci.setVersion(VERSION_STR);
        eci.setDescription(description);
        eci.setCompany(COMPANY_STR);
        eci.setType("com.vmware.vim.viClientScripts");
        eci.setUrl(dcnmUrl);
        Extension ext = new Extension();
        ext.setDescription(description);
        ext.setCompany(COMPANY_STR);
        ext.setKey(KEY_STR);
        ext.setVersion(VERSION_STR);
        ext.setServer(new ExtensionServerInfo[]{esi});
        ext.setLastHeartbeatTime(Calendar.getInstance());
        return ext;
    }

    public static String createDCNMURL(String dcnmServerAddress, int dcnmPort, String pluginFile, boolean secure) {
        String protocol = "https";
        if (!secure) {
            protocol = "http";
        }
        String descrFile = PLUGIN_DESCR_FILE;
        if (pluginFile == null) {
            descrFile = pluginFile;
        }
        String port = ":" + dcnmPort;
        String dcnmUrl = protocol + "://" + dcnmServerAddress + port + "/" + pluginFile;
        return dcnmUrl;
    }

    public static void register(VCProxy vcProxy, Extension ext) throws Exception {
        ServiceInstance si = vcProxy.getServiceInstance();
        if (si == null) {
            throw new Exception("Cannot access virtual center web service interface, please make sure that the value of the virtual center server is correct or the virtual center is up and running");
        }
        Extension existExtension = si.getExtensionManager().findExtension(KEY_STR);
        if (existExtension != null) {
            si.getExtensionManager().unregisterExtension(KEY_STR);
        }
        si.getExtensionManager().registerExtension(ext);
    }

    public static void unregister(VCProxy vcProxy) throws Exception {
        ServiceInstance si = vcProxy.getServiceInstance();
        if (si == null) {
            throw new Exception("Cannot access virtual center web service interface, please make sure that the value of the virtual center server is correct or the virtual center is up and running");
        }
        Extension existExtension = si.getExtensionManager().findExtension(KEY_STR);
        if (existExtension != null) {
            si.getExtensionManager().unregisterExtension(KEY_STR);
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            System.out.println("Start plugin registration...");
            RegisterPlugin.validateInput(args);
            String action = args[0];
            if (action.equalsIgnoreCase("-add")) {
                RegisterPlugin.register(args[1], args[4], args[2], args[3], false);
            } else if (action.equalsIgnoreCase("-remove")) {
                RegisterPlugin.unregister(args[1], args[4], args[2], args[3], false);
            } else {
                throw new Exception("Error in user input.");
            }
            System.out.println("Done with plugin registration.");
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            RegisterPlugin.printHelpInfo();
        }
    }

    private static void validateInput(String[] args) throws Exception {
        if (args.length != 5) {
            throw new Exception("Error in user input.");
        }
    }

    private static void printHelpInfo() {
        System.out.println("Usage: \n\tRegisterPlugin.[bat|sh]\t [-add|-remove] <VC Server Ip Address> <VC Server username> <VC Server password> <DCNM server full url. Ex: [http|https]://IP:PORT >  Sample usage: \n \tRegisterPlugin.bat -add <ip> <uname> <pwd> http://localhost:80");
    }

    public static String register(String vcServer, String dcnmServerUrl, String user, String password, boolean secure) throws Exception {
        return RegisterPlugin.register(vcServer, 443, dcnmServerUrl, 80, user, password, secure);
    }

    public static String register(String vcServer, int vcPort, String dcnmServerUrl, int dcnmPort, String user, String password, boolean secure) throws Exception {
        VCProxy proxy = new VCProxy(vcServer, vcPort, user, password);
        Extension ext = RegisterPlugin.createExtension(dcnmServerUrl, "dcnmplugin.jsp");
        RegisterPlugin.register(proxy, ext);
        return proxy.getProductVersion();
    }

    public static String unregister(String vcServer, String Server, String user, String password, boolean secure) throws Exception {
        return RegisterPlugin.unregister(vcServer, 443, Server, user, password, secure);
    }

    public static String unregister(String vcServer, int vcPort, String Server, String user, String password, boolean secure) throws Exception {
        VCProxy proxy = new VCProxy(vcServer, vcPort, user, password);
        RegisterPlugin.unregister(proxy);
        return proxy.getProductVersion();
    }
}

