/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.install;

import com.cisco.dcbu.install.FMInstaller;
import com.cisco.dcbu.install.InstallInfo;
import com.cisco.dcbu.install.Installer;
import com.cisco.dcbu.install.Service;
import com.cisco.dcbu.install.Uninstaller;
import com.cisco.dcbu.install.Util;
import com.cisco.dcbu.install.model.SysInfo;
import com.cisco.dcbu.install.view.InstallPanel;
import com.cisco.dcbu.install.view.SHCollectPanel;
import com.cisco.dcbu.install.view.SHCompletePanel;
import com.cisco.dcbu.install.view.SHLocationPanel;
import com.cisco.dcbu.install.view.SHProgressPanel;
import com.cisco.dcbu.install.view.SHUninstallPanel;
import com.cisco.dcbu.install.view.SHUninstallProgressPanel;
import com.cisco.dcbu.install.view.SHWelcomePanel;
import com.cisco.dcbu.install.view.Wizard;
import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class SanHealthInstaller
extends Installer
implements ActionListener {
    protected SHWelcomePanel welcomePanel = new SHWelcomePanel();
    protected SHLocationPanel installPanel = new SHLocationPanel();
    protected SHCollectPanel discoverPanel = new SHCollectPanel();
    protected InstallPanel progressPanel = new InstallPanel();
    protected SHProgressPanel cpPanel = new SHProgressPanel();
    protected SHUninstallPanel uPanel = new SHUninstallPanel();
    protected SHUninstallProgressPanel uProgressPanel = new SHUninstallProgressPanel();
    protected SHCompletePanel uComPanel = new SHCompletePanel();
    protected Timer timer = null;
    Thread installThread = null;
    static final long ONE_HRS = 3600000L;
    Wizard wizard = new Wizard();
    Logger logger = Logger.getLogger(SanHealthInstaller.class.getName());
    String iDir = null;
    long collectPeriod = 3600000L;

    public SanHealthInstaller(HashMap args) {
        super(args, "Cisco Fabric Manager SAN Health Advisor");
    }

    public void collectInstallInfo2() {
        String dcnmInstallDir;
        String dcnmInstallDir2;
        SwitchVersion dmVer;
        String dmVersion;
        if (this.textMode && this.getArg("-dir") == null) {
            this.logger.severe("Invalid installation directory. Please specify an install directory using -dir=INSTALLDIR option.");
            System.exit(-1);
        }
        String nmsRoot = this.confProps.getProperty("mds.nmsRoot");
        String oldDir = this.findNMSRoot(nmsRoot);
        SwitchVersion oldVersion = this.getVersion(null);
        if (oldDir != null) {
            oldVersion = this.getVersion(oldDir);
            if (!oldVersion.isUnknown()) {
                if (oldVersion.lessThan(this.VER412)) {
                    String dcnmInstallDir3 = this.getDCNMDir();
                    this.iDir = dcnmInstallDir3 == null ? (this.textMode ? this.getArg("-dir") : this.getDefaultInstallDir()) : dcnmInstallDir3;
                } else {
                    this.iDir = this.confProps.getProperty("mds.ciscoRoot");
                    if (this.textMode && !Util.isSamePath(this.iDir, this.getArg("-dir"))) {
                        this.logger.severe("Cisco Management Software is already installed under " + this.iDir + ".  Please use the existing install directory.");
                        System.exit(-1);
                    }
                }
            } else {
                dmVersion = this.confProps.getProperty("mds.dm.version");
                if (dmVersion != null) {
                    dmVer = new SwitchVersion(dmVersion);
                    if (!dmVer.lessThan(this.VER412)) {
                        this.iDir = this.confProps.getProperty("mds.ciscoRoot");
                        if (this.textMode && Util.isSamePath(this.iDir, this.getArg("-dir"))) {
                            this.logger.severe("Cisco Management Software is already installed under " + this.iDir + ".  Please use the existing install directory.");
                            System.exit(-1);
                        }
                        if (this.iDir == null) {
                            dcnmInstallDir2 = this.getDCNMDir();
                            this.iDir = dcnmInstallDir2 == null ? (this.textMode ? this.getArg("-dir") : this.getDefaultInstallDir()) : dcnmInstallDir2;
                        }
                    } else {
                        dcnmInstallDir2 = this.getDCNMDir();
                        this.iDir = dcnmInstallDir2 == null ? (this.textMode ? this.getArg("-dir") : this.getDefaultInstallDir()) : dcnmInstallDir2;
                    }
                } else {
                    dcnmInstallDir = this.getDCNMDir();
                    this.iDir = dcnmInstallDir == null ? (this.textMode ? this.getArg("-dir") : this.getDefaultInstallDir()) : dcnmInstallDir;
                }
            }
        } else {
            dmVersion = this.confProps.getProperty("mds.dm.version");
            if (dmVersion != null) {
                dmVer = new SwitchVersion(dmVersion);
                if (!dmVer.lessThan(this.VER412)) {
                    this.iDir = this.confProps.getProperty("mds.ciscoRoot");
                    if (this.iDir == null) {
                        dcnmInstallDir2 = this.getDCNMDir();
                        this.iDir = dcnmInstallDir2 == null ? (this.textMode ? this.getArg("-dir") : this.getDefaultInstallDir()) : dcnmInstallDir2;
                    } else if (!this.checkInstallDir412(this.iDir)) {
                        dcnmInstallDir2 = this.getDCNMDir();
                        this.iDir = dcnmInstallDir2 == null ? (this.textMode ? this.getArg("-dir") : this.getDefaultInstallDir()) : dcnmInstallDir2;
                    }
                } else {
                    dcnmInstallDir2 = this.getDCNMDir();
                    this.iDir = dcnmInstallDir2 == null ? (this.textMode ? this.getArg("-dir") : this.getDefaultInstallDir()) : dcnmInstallDir2;
                }
            } else {
                dcnmInstallDir = this.getDCNMDir();
                this.iDir = dcnmInstallDir == null ? (this.textMode ? this.getArg("-dir") : this.getDefaultInstallDir()) : dcnmInstallDir;
            }
        }
        if (this.textMode && !Util.isSamePath(this.iDir, this.getArg("-dir"))) {
            this.logger.severe("Cisco Management Software is already installed under " + this.iDir + ".  Please use the existing install directory.");
            System.exit(-1);
        }
        this.iModel.setInstallDir(this.iDir);
        this.iModel.setOldVersion(oldVersion);
        this.iModel.setOldInstallDir(oldDir);
        SwitchVersion ver = this.getVersion();
        this.iModel.setVersion(ver);
        String pathToExistingDb = this.confProps.getProperty("mds.db.dir");
        if (pathToExistingDb != null) {
            this.iModel.setInstallPgDir(pathToExistingDb);
        } else {
            this.iModel.setInstallPgDir(this.iModel.getDBDir());
        }
        String stopPortStr = this.confProps.getProperty("mds.web.stopPort");
        if (stopPortStr != null) {
            this.iModel.setWebStopPort(Integer.parseInt(stopPortStr));
        }
    }

    @Override
    public void preInstall() {
        InstallInfo info = InstallInfo.collectInstallInfo(false, new HashMap<String, String>());
        System.out.println("FM Install dir: " + info.iDir);
        if (Util.exists(info.nmsRoot + SysInfo.FS + "install.conf") || Util.exists(InstallInfo.getDCNMDir())) {
            this.msgHelper.showError("There is a copy of Cisco Management Software (FM/DCNM) installed on this system.\nThis software cannot be installed on this system.");
            System.exit(1);
        }
        if (Service.isInstalled("pgsql-8.2")) {
            this.msgHelper.showError("PostgreSQL is already installed on this system. \nThis software cannot be installed on this system.");
            System.exit(1);
        }
        String time = this.getArg("-time");
        try {
            if (time != null && !"".equals(time)) {
                this.collectPeriod = Long.parseLong(time) * 1000L * 60L;
            }
        }
        catch (NumberFormatException e) {
            this.logger.severe(time + " is not a valid number.");
            System.exit(-1);
        }
        this.progressPanel.setDetailVisible(true);
        this.wizard.addCard(this.welcomePanel);
        this.wizard.addCard(this.installPanel);
        this.wizard.addCard(this.progressPanel);
        this.wizard.addCard(this.discoverPanel);
        this.wizard.addCard(this.cpPanel);
        this.wizard.addCard(this.uPanel);
        this.wizard.addCard(this.uProgressPanel);
        this.wizard.addCard(this.uComPanel);
        this.wizard.first();
        this.wizard.getNavigator().getBackButton().addActionListener(this);
        this.wizard.getNavigator().getBackButton().setVisible(false);
        this.wizard.getNavigator().getNextButton().addActionListener(this);
        this.wizard.getNavigator().getCancelButton().addActionListener(this);
        this.parent.getContentPane().add(this.wizard);
        this.parent.setLocationRelativeTo(null);
        this.parent.pack();
        this.parent.setVisible(true);
        this.pause();
    }

    public void collect() {
        String binDir = this.installPanel.getInstallFolder() + SysInfo.FS + "dcm" + SysInfo.FS + "fm" + SysInfo.FS + "bin";
        String confDir = this.installPanel.getInstallFolder() + SysInfo.FS + "dcm" + SysInfo.FS + "fm" + SysInfo.FS + "conf";
        try {
            Util.copy(confDir + SysInfo.FS + "server.properties", confDir + SysInfo.FS + "server.properties_tmp");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.discoverPanel.enablePm()) {
            this.collectPeriod = 82800000L;
        }
        Properties props = Util.loadProps(confDir + SysInfo.FS + "server.properties_tmp");
        props.put("sht.seedip", this.discoverPanel.getSeed());
        props.put("sht.seedip2", this.discoverPanel.getSeed2());
        props.put("sht.username", this.discoverPanel.getUserName());
        props.put("sht.password", this.discoverPanel.getPassword());
        props.put("sht.protocol", this.discoverPanel.getDigest().toString());
        props.put("sht.reportwaittime", Long.toString(this.collectPeriod));
        props.put("sht.reportpm", Boolean.toString(this.discoverPanel.enablePm()));
        try {
            Util.updateProperties(confDir + SysInfo.FS + "server.properties_tmp", confDir + SysInfo.FS + "server.properties", props.keySet().toArray(new String[0]), props.values().toArray(new String[0]), true);
            FMInstaller.startServer(binDir, confDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        SanHealthInstaller installer = new SanHealthInstaller(new HashMap());
        installer.preInstall();
    }

    public boolean validData(Wizard wizard) {
        if (wizard.isLast()) {
            return false;
        }
        String wizardName = wizard.getCurrent().getName();
        if ("Install Location".equals(wizardName)) {
            SHLocationPanel locationPane = (SHLocationPanel)wizard.getCurrent();
            if (!this.createInstallLocation(locationPane)) {
                return false;
            }
        } else if ("Fabric Options".equals(wizardName)) {
            SHCollectPanel discoverPane = (SHCollectPanel)wizard.getCurrent();
            String seed = discoverPane.getSeed();
            String username = discoverPane.getUserName();
            String password = discoverPane.getPassword();
            if ("".equals(seed.trim())) {
                this.msgHelper.showError("Invalid seed");
            } else if ("".equals(username.trim())) {
                this.msgHelper.showError("Invalid username");
            } else if ("".equals(password.trim())) {
                this.msgHelper.showError("Invalid password");
            }
            try {
                InetAddress.getByName(seed);
            }
            catch (Exception ex) {
                this.msgHelper.showError("Invalid seed " + seed + ".\n" + "Cause: " + ex.getMessage());
                return false;
            }
        }
        return true;
    }

    @Override
    public void install() {
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        char c = evt.getActionCommand().charAt(0);
        switch (c) {
            case 'N': {
                if (this.wizard.isLast()) {
                    this.install();
                    break;
                }
                if (this.validData(this.wizard)) {
                    this.wizard.doNext();
                }
                if (!this.wizard.getCurrent().getName().equals(this.installPanel.getName())) break;
                this.wizard.getNavigator().getNextButton().setText("Install");
                this.wizard.getNavigator().getNextButton().setIcon(null);
                this.wizard.getNavigator().getNextButton().setActionCommand("Install");
                break;
            }
            case 'B': {
                this.wizard.doBack();
                break;
            }
            case 'C': {
                if ("Close".equals(evt.getActionCommand())) {
                    System.exit(0);
                }
                this.parent.setCursor(Installer.origCursor);
                System.out.println("Canceling");
                int rc = JOptionPane.showConfirmDialog(this.parent, "Are you sure you want to cancel?", this.title, 0);
                if (rc != 0) break;
                if (this.installThread == null) {
                    System.exit(0);
                }
                this.installThread.interrupt();
                this.installThread.suspend();
                if (this.timer != null) {
                    this.timer.stop();
                }
                this.goToUninstall();
                this.uPanel.setBrief("SAN health collection has been interrupted.   Please click Uninstall to remove this program.");
                break;
            }
            case 'S': {
                final SHCollectPanel dPanel = (SHCollectPanel)this.wizard.getCurrent();
                if (!dPanel.validateInput()) break;
                String zipFile = new File(this.installPanel.getInstallFolder() + SysInfo.FS + "dcm" + SysInfo.FS + "SanHealthTool.zip").getAbsolutePath();
                this.uPanel.setBrief("Your analysis file is ready.  Please email " + zipFile + " to san-health-tool-report@cisco.com to receive the SAN Health reports.");
                new Thread(){

                    public void doEnabled(final boolean b) {
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    SanHealthInstaller.this.parent.setCursor(b ? Installer.origCursor : Installer.busyCursor);
                                    dPanel.setEnabled(b);
                                    SanHealthInstaller.this.wizard.getNavigator().getNextButton().setEnabled(b);
                                }
                            });
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        this.doEnabled(false);
                        String ERROR_MSG = "Unable to connect to ";
                        SnmpSession session = null;
                        SnmpPeer peer = null;
                        String seed = "";
                        try {
                            session = SnmpSession.getInstance();
                            session.open();
                            seed = dPanel.getSeed();
                            int authProtocol = dPanel.getDigest().getAuthProtocol();
                            int privProtocol = dPanel.getDigest().getPrivProtocol();
                            peer = new SnmpPeer(InetAddress.getByName(seed), session, dPanel.getUserName(), dPanel.getPassword(), authProtocol, dPanel.getPassword(), privProtocol);
                            seed = dPanel.getSeed2();
                            if (seed != null && !"".equals(seed.trim())) {
                                peer = new SnmpPeer(InetAddress.getByName(seed), session, dPanel.getUserName(), dPanel.getPassword(), authProtocol, dPanel.getPassword(), privProtocol);
                            }
                        }
                        catch (UnknownHostException e) {
                            e.printStackTrace();
                            JOptionPane.showMessageDialog(SanHealthInstaller.this.parent, "Unable to connect to " + seed + ": unknown host", SanHealthInstaller.this.name, 0);
                            return;
                        }
                        catch (SnmpException e) {
                            e.printStackTrace();
                            JOptionPane.showMessageDialog(SanHealthInstaller.this.parent, "Unable to connect to " + seed + ": " + e.getMessage(), SanHealthInstaller.this.name, 0);
                            return;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            JOptionPane.showMessageDialog(SanHealthInstaller.this.parent, "Unable to connect to " + seed + ": " + e.getMessage(), SanHealthInstaller.this.name, 0);
                            return;
                        }
                        finally {
                            if (peer != null) {
                                peer.close();
                            }
                            this.doEnabled(true);
                        }
                        int delay = 1000;
                        ActionListener taskPerformer = new ActionListener(){
                            private final float PERIOD;
                            private float elapse;
                            {
                                this.PERIOD = SanHealthInstaller.this.collectPeriod + (long)((SanHealthInstaller.this.discoverPanel.enablePm() ? 1500 : 25) * 1000 * 60);
                                this.elapse = 0.0f;
                            }

                            @Override
                            public void actionPerformed(ActionEvent evt) {
                                this.elapse += 1000.0f;
                                float pc = this.elapse / this.PERIOD;
                                SanHealthInstaller.this.cpPanel.updateProgress((int)(pc * 100.0f));
                                SanHealthInstaller.this.cpPanel.updateTime((long)(this.PERIOD - this.elapse));
                                SanHealthInstaller.this.cpPanel.revalidate();
                                if (this.PERIOD - this.elapse > 1000.0f) {
                                    SanHealthInstaller.this.timer.restart();
                                } else {
                                    SanHealthInstaller.this.wizard.doNext();
                                    SanHealthInstaller.this.wizard.getNavigator().getNextButton().setEnabled(true);
                                    SanHealthInstaller.this.wizard.getNavigator().getNextButton().setText("Uninstall");
                                    SanHealthInstaller.this.wizard.getNavigator().getNextButton().setActionCommand("Uninstall");
                                    SanHealthInstaller.this.wizard.getNavigator().getBackButton().setEnabled(false);
                                    SanHealthInstaller.this.wizard.getNavigator().getCancelButton().setEnabled(false);
                                    SanHealthInstaller.this.timer.stop();
                                }
                            }
                        };
                        SanHealthInstaller.this.timer = new Timer(delay, taskPerformer);
                        SanHealthInstaller.this.timer.start();
                        SanHealthInstaller.this.wizard.doNext();
                        SanHealthInstaller.this.wizard.getNavigator().getBackButton().setEnabled(false);
                        SanHealthInstaller.this.wizard.getNavigator().getNextButton().setEnabled(false);
                        SanHealthInstaller.this.collect();
                    }
                }.start();
                break;
            }
            case 'I': {
                this.parent.setCursor(Installer.busyCursor);
                this.installThread = new Thread(){
                    FMInstaller installer;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            boolean DONE = false;
                            SanHealthInstaller.this.args.put("-text", "");
                            SanHealthInstaller.this.args.put("-server", "");
                            SanHealthInstaller.this.args.put("-installpg", "");
                            SanHealthInstaller.this.args.put("-dburl", "jdbc:postgresql://localhost:5432/dcmdb");
                            SanHealthInstaller.this.args.put("-dbuser", "admin");
                            SanHealthInstaller.this.args.put("-dbpass", "password");
                            SanHealthInstaller.this.args.put("-local", "");
                            SanHealthInstaller.this.args.put("-dir", SanHealthInstaller.this.installPanel.getInstallFolder());
                            SanHealthInstaller.this.args.put("-nostart", "");
                            this.installer = new FMInstaller(SanHealthInstaller.this.args);
                            this.installer.getProgressMonitor().setUIComponents(SanHealthInstaller.this.progressPanel.getNote(), SanHealthInstaller.this.progressPanel.getBoard(), SanHealthInstaller.this.progressPanel.getProgressBar());
                            this.installer.getProgressMonitor().setMaximum(3755);
                            this.installer.preInstall();
                            this.installer.storeConf(true);
                            this.installer.install();
                            this.installer.postInstall();
                            String confDir = SanHealthInstaller.this.installPanel.getInstallFolder() + SysInfo.FS + "dcm" + SysInfo.FS + "fm" + SysInfo.FS + "conf";
                            try {
                                Util.copy(confDir + SysInfo.FS + "sht.config", confDir + SysInfo.FS + "service.config");
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        catch (Throwable t) {
                            SanHealthInstaller.this.goToUninstall();
                            SanHealthInstaller.this.uPanel.setBrief("Installation did not complete successfully: " + t.getMessage() + ".  Please click Uninstall to de-install this program.");
                            return;
                        }
                        finally {
                            SanHealthInstaller.this.parent.setCursor(Installer.origCursor);
                        }
                        SanHealthInstaller.this.wizard.getNavigator().getBackButton().setEnabled(false);
                        SanHealthInstaller.this.wizard.getNavigator().getNextButton().setEnabled(true);
                        SanHealthInstaller.this.wizard.doNext();
                        SanHealthInstaller.this.wizard.getNavigator().getNextButton().setText("Collect");
                        SanHealthInstaller.this.wizard.getNavigator().getNextButton().setIcon(null);
                        SanHealthInstaller.this.wizard.getNavigator().getNextButton().setActionCommand("Start");
                    }
                };
                this.installThread.start();
                if (this.validData(this.wizard)) {
                    this.wizard.doNext();
                }
                this.wizard.getNavigator().getNextButton().setEnabled(false);
                this.wizard.getNavigator().getBackButton().setEnabled(false);
                break;
            }
            case 'U': {
                this.wizard.doNext();
                this.wizard.getNavigator().getNextButton().setEnabled(false);
                this.wizard.getNavigator().getCancelButton().setEnabled(false);
                new Thread(){

                    @Override
                    public void run() {
                        SanHealthInstaller.this.uninstall();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SanHealthInstaller.this.wizard.doNext();
                                SanHealthInstaller.this.wizard.getNavigator().getCancelButton().setEnabled(false);
                                SanHealthInstaller.this.wizard.getNavigator().getBackButton().setEnabled(false);
                                SanHealthInstaller.this.wizard.getNavigator().getNextButton().setEnabled(true);
                                SanHealthInstaller.this.wizard.getNavigator().getNextButton().setText("Close");
                                SanHealthInstaller.this.wizard.getNavigator().getNextButton().setActionCommand("Close");
                            }
                        });
                    }
                }.start();
                break;
            }
            default: {
                throw new RuntimeException("Invalid wizard state.");
            }
        }
    }

    private void goToUninstall() {
        while (!"Complete".equals(this.wizard.getCurrent().getName())) {
            this.wizard.doNext();
        }
        this.wizard.getNavigator().getNextButton().setText("Uninstall");
        this.wizard.getNavigator().getNextButton().setActionCommand("Uninstall");
        this.wizard.getNavigator().getNextButton().setEnabled(true);
        this.wizard.getNavigator().getBackButton().setEnabled(false);
        this.wizard.getNavigator().getCancelButton().setEnabled(false);
    }

    @Override
    public void postInstall() {
    }

    public void uninstall() {
        System.out.println("Auto uninstalling");
        Uninstaller uninstaller = new Uninstaller();
        uninstaller.setPromptUser(false);
        uninstaller.setRemoveDB(true);
        uninstaller.setRemoveAll(true);
        uninstaller.execute();
    }
}

