/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.install;

import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.lib.util.jboss_4_2.JBoss_4_2Encrypter;
import com.cisco.dcbu.lib.util.jboss_4_2.JBoss_7_2XMLFileParser;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.security.ServerPropertyUtil;
import com.cisco.dcbu.sm.server.security.UserManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.xml.DOMConfigurator;
import org.jboss.security.plugins.FilePassword;

public class UserUtil {
    private static String _INVALID_USER = "Username cannot be blank or contain special characters.";
    private static String _INVALID_PASSWORD = "Password cannot be empty and should not contain space characters.";
    private static String _USER_EXISTS = "User exists.";
    private static String _MIS_MATCH = "Database password do not match.";

    public static void scriptAdd(String username, String role, String password, String dbPassword) throws Exception {
        if (!UserUtil.validateDBPassword(dbPassword)) {
            System.out.println("Add user : " + username + " failed!");
            return;
        }
        if (!UserUtil.validateUser(username)) {
            System.err.println(_INVALID_USER);
            return;
        }
        if (UserManager.findUserFromDB(username) != null) {
            System.err.println(_USER_EXISTS);
            return;
        }
        if (!UserUtil.validatePassword(password)) {
            System.err.println(_INVALID_PASSWORD);
            return;
        }
        UserManager.createUserInDB(username, StringEncrypter.DESedeEncrypt(password), role);
        if (UserManager.findUserFromDB(username) != null) {
            System.out.println("Added user : " + username + " successful!");
        } else {
            System.out.println("Add user : " + username + " failed!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean validateDBPassword(String dbPassword) {
        Connection conn = null;
        try {
            conn = ConnectionManager.checkDBConnection(dbPassword);
        }
        catch (Exception ex) {
            System.err.println("Failed to connection to the database with provided authentication!");
        }
        finally {
            if (conn == null) {
                System.out.println(_MIS_MATCH);
                return false;
            }
            System.out.println("Password validation is finished!");
            try {
                if (!conn.isClosed()) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                System.err.println("Error on closing DB connection during password validation");
            }
        }
        return true;
    }

    public static boolean validateUser(String username) {
        return GenUtil.validateUsername(username);
    }

    public static boolean validatePassword(String password) {
        return GenUtil.validatePassword(password);
    }

    private static void scriptEncrypt(String source) {
        UserUtil.scriptEncrypt(source, null, null);
    }

    private static void scriptEncrypt(String source, String password) {
        UserUtil.scriptEncrypt(source, password, null);
    }

    private static void scriptEncrypt(String source, String value1, String value2) {
        block6: {
            try {
                if (source.equalsIgnoreCase("db")) {
                    UserUtil.dbPwdEncrypt(value1);
                    break block6;
                }
                if (source.equalsIgnoreCase("ssl")) {
                    UserUtil.getSslPwd(value1, value2);
                    break block6;
                }
                if (source.equalsIgnoreCase("aaa")) {
                    UserUtil.aaaKeyEncrypt(value1, value2);
                    break block6;
                }
                if (source.equalsIgnoreCase("sftp")) {
                    UserUtil.sftpPwdEncrypt(value1);
                    break block6;
                }
                throw new Exception("Wrong format of command");
            }
            catch (Exception ex) {
                System.err.println("Password encryption failed, please try again!");
                ex.printStackTrace();
                UserUtil.showEncryptUsage();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void dbPwdEncrypt(String pw) throws Exception {
        String password = pw;
        if (password == null) {
            System.out.println("Please input the new database password: ");
            InputStreamReader isr = null;
            BufferedReader br = null;
            try {
                isr = new InputStreamReader(System.in);
                br = new BufferedReader(isr);
                password = br.readLine();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (isr != null) {
                        isr.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        String encryptedString = JBoss_4_2Encrypter.encrypt(password);
        UserUtil.updateServerProperty("db.password", encryptedString);
        System.out.println("Server.properties gets updated.");
        UserUtil.updateJBossLoginConfig(encryptedString);
        System.out.println("JBoss config gets updated.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sftpPwdEncrypt(String pw) throws Exception {
        String password = pw;
        if (password == null) {
            System.out.println("Please input the new SFTP password: ");
            InputStreamReader isr = null;
            BufferedReader br = null;
            try {
                isr = new InputStreamReader(System.in);
                br = new BufferedReader(isr);
                password = br.readLine();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (isr != null) {
                        isr.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        String encryptedString = JBoss_4_2Encrypter.encrypt(password);
        UserUtil.updateServerProperty("server.sftp.password", encryptedString);
        System.out.println("Server.properties is updated.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void aaaKeyEncrypt(String dpt, String key) throws Exception {
        BufferedReader br = null;
        String depth = dpt;
        String secretKey = key;
        boolean depthSet = false;
        String[] depthArray = new String[]{"primary", "secondary", "tertiary"};
        try {
            br = new BufferedReader(new InputStreamReader(System.in));
            if (depth == null) {
                System.out.println("Please input type of aaa server you try to use ( primary | secondary | tertiary): ");
                depth = br.readLine();
            } else {
                for (String d : depthArray) {
                    if (!depth.equalsIgnoreCase(d)) continue;
                    depthSet = true;
                    break;
                }
                if (!depthSet) {
                    UserUtil.showEncryptUsage();
                    System.exit(0);
                }
            }
            if (secretKey == null) {
                System.out.println("Please input the secret key: \n");
                secretKey = br.readLine();
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String encryptedString = StringEncrypter.DESedeEncrypt(secretKey);
        UserUtil.updateServerProperty("aaa.server." + depth + ".secret", encryptedString);
        System.out.println("AAA properties have been updated successfully.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getSslPwd(String keyStorePwd, String trustStorePwd) throws Exception {
        BufferedReader br = null;
        String keyStrPwd = keyStorePwd;
        String trustStrPwd = trustStorePwd;
        if (keyStrPwd == null || trustStrPwd == null) {
            try {
                br = new BufferedReader(new InputStreamReader(System.in));
                if (keyStrPwd == null) {
                    System.out.println("Please input the new ssl keystore password: ");
                    keyStrPwd = br.readLine();
                }
                if (trustStrPwd == null) {
                    System.out.println("Please input the new ssl truststore password: ");
                    trustStrPwd = br.readLine();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        UserUtil.updateSSLProperties(trustStrPwd, keyStrPwd);
    }

    public static void main(String[] args) {
        try {
            UserUtil.loadProperties();
            if (args[0].trim().toLowerCase().equals("add")) {
                if (args.length != 5) {
                    UserUtil.showAddUsage();
                    System.exit(0);
                }
                UserUtil.scriptAdd(args[1], args[2], args[3], args[4]);
            } else if (args[0].trim().toLowerCase().equals("encrypt")) {
                switch (args.length) {
                    case 2: {
                        UserUtil.scriptEncrypt(args[1]);
                        break;
                    }
                    case 3: {
                        UserUtil.scriptEncrypt(args[1], args[2]);
                        break;
                    }
                    case 4: {
                        UserUtil.scriptEncrypt(args[1], args[2], args[3]);
                        break;
                    }
                    default: {
                        UserUtil.showEncryptUsage();
                    }
                }
            }
            System.exit(0);
        }
        catch (Exception ex) {
            System.err.println("The command is not recognized, please read user manual and try again.");
            System.err.println(ex);
        }
    }

    private static void showAddUsage() {
        System.out.println("Usage : ");
        System.out.println("addUser(.bat|.sh) <user> <password> <dbpassword>");
    }

    private static void showEncryptUsage() {
        System.out.println("How to run : ");
        System.out.println("Usage 1. Encrypter(.bat|.sh) (db|ssl) (password) ");
        System.out.println("Usage 2. Encrypter(.bat|.sh) (aaa) (primary|secondary|tertiary) (secret_key) ");
        System.out.println("    db   the updated database password to be encypted");
        System.out.println("    ssl  the updated ssl password to be encrypted");
        System.out.println("    aaa  the updated aaa secret key to be encrypted");
    }

    private static void loadProperties() throws IOException {
        GenUtil.loadServerProperties(null);
        System.setProperty("log.dir", ClientCache.getInstallLocation() + File.separator + "logs");
        String logConfFile = System.getProperty("org.apache.log4j.file");
        if (logConfFile == null || logConfFile.length() == 0) {
            logConfFile = ClientCache.getConfDir() + "log4j_fms.xml";
        }
        DOMConfigurator.configure((String)logConfFile);
        System.out.println("Log4j loaded: " + logConfFile);
    }

    private static void updateServerProperty(String key, String value) throws Exception {
        ServerPropertyUtil.updateServerProperty(key, "#" + value);
    }

    private static void updateJBossLoginConfig(String password) throws Exception {
        JBoss_7_2XMLFileParser xmlParser = new JBoss_7_2XMLFileParser(JBoss_7_2XMLFileParser.jboss7_config);
        xmlParser.updateDsPwd(password);
    }

    private static void updateSSLProperties(String trustStrPwd, String keyStrPwd) throws Exception {
        String dstFile = ClientCache.getJBossHome() + File.separator + "server" + File.separator + "fm" + File.separator + "conf" + File.separator + "props" + File.separator + "ssl.properties";
        BufferedWriter bw = new BufferedWriter(new FileWriter(dstFile));
        bw.write("trustStorePassword=" + JBoss_4_2Encrypter.encrypt(trustStrPwd) + "\n");
        bw.write("keyStorePassword=" + JBoss_4_2Encrypter.encrypt(keyStrPwd));
        bw.close();
        System.out.println("Done updating the property file.");
        String keyStrFile = ClientCache.getJBossHome() + File.separator + "server" + File.separator + "fm" + File.separator + "conf" + File.separator + "keystore.password";
        FilePassword.main((String[])new String[]{"welcometojboss", "13", keyStrPwd, keyStrFile});
        System.out.println("SSL property updated successfully.");
    }
}

