/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.install.view;

import com.cisco.dcbu.install.view.WizardBanner;
import com.cisco.dcbu.install.view.WizardPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public abstract class DiscoverPanel
extends WizardPanel
implements ActionListener {
    public static final String NAME = "Fabric Options";
    JTextField seed = new JTextField(30);
    JTextField seed2 = new JTextField(30);
    JTextField user = new JTextField(30);
    JPasswordField pass = new JPasswordField(30);
    JComboBox digest = new JComboBox<SnmpDigest>(new SnmpDigest[]{SnmpDigest.MD5, SnmpDigest.SHA, SnmpDigest.MD5_DES, SnmpDigest.MD5_AES, SnmpDigest.SHA_DES, SnmpDigest.SHA_AES});

    public DiscoverPanel() {
        this(DiscoverPanel.createBanner(NAME, "Please enter the IP address of at least one fabric seed switch and provide its SNMP credential.", true), 0, true);
    }

    public DiscoverPanel(WizardBanner banner, int orientation, boolean createBrief) {
        super(banner, orientation, createBrief);
    }

    protected void buildContent() {
        JPanel main = new JPanel(new GridBagLayout());
        JComponent[] lbls = this.getLabels();
        JComponent[] comps = this.getComps();
        try {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 1;
            gbc.weightx = 1.0;
            main.add((Component)DiscoverPanel.createForm(lbls, comps), gbc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setContent(main);
    }

    protected JComponent[] getComps() {
        JComponent[] comps = new JComponent[]{this.seed, this.seed2, this.user, this.pass, this.digest};
        return comps;
    }

    protected JLabel[] getLabels() {
        JLabel[] lbls = new JLabel[]{new JLabel("Seed Switch:"), new JLabel("Seed Switch 2 (Optional):"), new JLabel("SNMPv3 Username:"), new JLabel("SNMPv3 Password:"), new JLabel("Auth-Privacy:")};
        return lbls;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
    }

    public String getSeed() {
        return this.seed.getText();
    }

    public String getSeed2() {
        return this.seed2.getText();
    }

    public String getUserName() {
        return this.user.getText();
    }

    public String getPassword() {
        return new String(this.pass.getPassword());
    }

    public SnmpDigest getDigest() {
        return (SnmpDigest)((Object)this.digest.getSelectedItem());
    }

    public boolean validateInput() {
        String seedSw = this.seed.getText();
        String username = this.user.getText();
        String password = new String(this.pass.getPassword());
        if ("".equals(seedSw.trim())) {
            JOptionPane.showConfirmDialog(this, "Invalid seed switch.", NAME, -1, 0);
            return false;
        }
        if ("".equals(username.trim())) {
            JOptionPane.showConfirmDialog(this, "Invalid username.", NAME, -1, 0);
            return false;
        }
        if ("".equals(password.trim())) {
            JOptionPane.showConfirmDialog(this, "Invalid password.", NAME, -1, 0);
            return false;
        }
        return true;
    }

    @Override
    public void setEnabled(boolean b) {
        this.seed.setEnabled(b);
        this.seed2.setEnabled(b);
        this.user.setEnabled(b);
        this.pass.setEnabled(b);
        this.digest.setEnabled(b);
    }

    public static enum SnmpDigest {
        MD5("MD5", 0, -1),
        SHA("SHA", 1, -1),
        MD5_DES("MD5-DES", 0, 0),
        MD5_AES("MD5-AES", 0, 1),
        SHA_DES("SHA-AES", 1, 0),
        SHA_AES("SHA-AES", 1, 1);

        String name;
        int auth;
        int priv;

        private SnmpDigest(String name, int auth, int priv) {
            this.name = name;
            this.auth = auth;
            this.priv = priv;
        }

        public int getAuthProtocol() {
            return this.auth;
        }

        public int getPrivProtocol() {
            return this.priv;
        }

        public String toString() {
            return this.name;
        }
    }
}

