/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.discv.ep;

import com.cisco.dcbu.jaxws.discv.ep.DiscoverySEI;
import com.cisco.dcbu.jaxws.discv.ep.LanNotifyMessageHandler;
import com.cisco.dcbu.jaxws.discv.wo.AuthPrivacyTypeDO;
import com.cisco.dcbu.jaxws.discv.wo.DiscAttrsDO;
import com.cisco.dcbu.jaxws.discv.wo.DiscFlagTypeDO;
import com.cisco.dcbu.jaxws.discv.wo.DiscStatusDO;
import com.cisco.dcbu.jaxws.discv.wo.DiscTaskKeyDO;
import com.cisco.dcbu.jaxws.discv.wo.DiscTaskTypeDO;
import com.cisco.dcbu.jaxws.discv.wo.LanObjectDO;
import com.cisco.dcbu.jaxws.ep.DiscoveryException;
import com.cisco.dcbu.jaxws.ep.IdentityManager;
import com.cisco.dcbu.jaxws.ep.InvalidArgumentException;
import com.cisco.dcbu.jaxws.handler.SecurityHandler;
import com.cisco.dcbu.jaxws.san.ep.SanWS;
import com.cisco.dcbu.jaxws.san.wo.CallResultDO;
import com.cisco.dcbu.jaxws.san.wo.SnmpCredentialDO;
import com.cisco.dcbu.jaxws.san.wo.SwitchLicenseStateDO;
import com.cisco.dcbu.jaxws.wo.DBEntryAdvDO;
import com.cisco.dcbu.jaxws.wo.DBEntryDO;
import com.cisco.dcbu.jaxws.wo.DBRowAdvDO;
import com.cisco.dcbu.jaxws.wo.DBRowDO;
import com.cisco.dcbu.sm.common.dto.LicenseInfoFlex;
import com.cisco.dcbu.sm.common.dto.SwitchAssignedLicenseInfo;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.type.DiscStateType;
import com.cisco.dcbu.sm.common.type.DiscStatusType;
import com.cisco.dcbu.sm.common.type.DiscTaskType;
import com.cisco.dcbu.sm.common.type.TaskKey;
import com.cisco.dcbu.sm.common.util.TraceLogger;
import com.cisco.dcbu.sm.server.db.LanPersistentManager;
import com.cisco.dcbu.sm.server.facade.FMServerImpl;
import com.cisco.dcbu.sm.server.licmgr.FileLicensingHelper;
import com.cisco.dcbu.sm.server.model.CdpSeedImpl;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.pm.PM;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ejb.Stateless;
import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.apache.log4j.Logger;
import org.jboss.ws.api.annotation.WebContext;

@SOAPBinding(style=SOAPBinding.Style.RPC, use=SOAPBinding.Use.LITERAL)
@HandlerChain(file="../../ep/fms-jaxws-handlers.xml")
@WebContext(contextRoot="/DiscoveryWSService", urlPattern="/DiscoveryWS")
@WebService(name="Discovery", serviceName="DiscoveryService", endpointInterface="com.cisco.dcbu.jaxws.discv.ep.DiscoverySEI")
@Stateless
public class DiscoveryWS
implements DiscoverySEI {
    static final TraceLogger _Tracer = new TraceLogger(Logger.getLogger((String)"fms.ws"), false, false, false, false);

    @Override
    @WebMethod
    @WebResult(name="result")
    public DiscTaskKeyDO discoverLANByUser(@WebParam(name="user") String user, @WebParam(name="pwd") String pwd, @WebParam(name="authPrivacy") AuthPrivacyTypeDO authPrivacy, @WebParam(name="enablePwd") String enablePwd, @WebParam(name="discAttrs") DiscAttrsDO discAttrs) throws DiscoveryException, InvalidArgumentException {
        if (user == null || pwd == null || authPrivacy == null) {
            throw new InvalidArgumentException("Invalid user credential");
        }
        SnmpUserOpt snmpUser = new SnmpUserOpt(user, pwd, null, authPrivacy.value(), true);
        if (discAttrs == null || discAttrs.getSwIPs() == null || discAttrs.getSwIPs().length == 0) {
            throw new InvalidArgumentException("Invalid discovery attributes");
        }
        return this.discoverLan(snmpUser, enablePwd, discAttrs);
    }

    @Override
    @WebMethod
    @WebResult(name="result")
    public DiscTaskKeyDO discoverLANByCommunity(@WebParam(name="commnityString") String communityString, @WebParam(name="discAttrs") DiscAttrsDO discAttrs) throws DiscoveryException, InvalidArgumentException {
        if (communityString == null) {
            throw new InvalidArgumentException("Invalid user credential");
        }
        SnmpUserOpt snmpUser = new SnmpUserOpt(null, null, communityString, 1, false);
        if (discAttrs == null || discAttrs.getSwIPs() == null || discAttrs.getSwIPs().length == 0) {
            throw new InvalidArgumentException("Invalid discovery attributes");
        }
        return this.discoverLan(snmpUser, null, discAttrs);
    }

    @Override
    @WebMethod
    @WebResult(name="result")
    public CallResultDO discoverLanByMaxHop(@WebParam(name="seedIp") String seedIp, @WebParam(name="userCredential") SnmpCredentialDO userCredential, @WebParam(name="maxHop") int maxHop, @WebParam(name="enablePwd") String enablePwd, @WebParam(name="groupDbId") long groupDbId, @WebParam(name="serverIpaddress") String serverIpaddress) {
        if (userCredential == null) {
            throw new InvalidArgumentException("Invalid user credential");
        }
        SnmpUserOpt snmpUser = userCredential.toUserOpt();
        if (seedIp == null) {
            throw new InvalidArgumentException("Invalid seed:" + seedIp);
        }
        DiscAttrsDO discAttrs = new DiscAttrsDO(DiscTaskType.LAN_MAXHOP.value(), maxHop, seedIp, groupDbId, null);
        try {
            this.discoverLan(snmpUser, enablePwd, discAttrs);
        }
        catch (Exception ex) {
            _Tracer.warn("DiscoveryWS failed to discover LAN", ex);
            return new CallResultDO(1, "Failed to discover LAN: " + ex.getMessage());
        }
        return new CallResultDO();
    }

    @Override
    @WebMethod
    @WebResult(name="result")
    public CallResultDO discoverLanByIPs(@WebParam(name="seedIps") String[] seedIps, @WebParam(name="userCredential") SnmpCredentialDO userCredential, @WebParam(name="enablePwd") String enablePwd, @WebParam(name="groupDbId") long groupDbId, @WebParam(name="serverIpaddress") String serverIpaddress) {
        if (userCredential == null) {
            throw new InvalidArgumentException("Invalid user credential");
        }
        SnmpUserOpt snmpUser = userCredential.toUserOpt();
        if (seedIps == null) {
            throw new InvalidArgumentException("Invalid seeds:" + seedIps);
        }
        DiscAttrsDO discAttrs = new DiscAttrsDO(DiscTaskType.LAN_IPLIST.value(), 1, seedIps, groupDbId, null);
        try {
            this.discoverLan(snmpUser, enablePwd, discAttrs);
        }
        catch (Exception ex) {
            _Tracer.warn("DiscoveryWS failed to discover LAN", ex);
            return new CallResultDO(1, "Failed to discover LAN: " + ex.getMessage());
        }
        return new CallResultDO();
    }

    private DiscTaskKeyDO discoverLan(SnmpUserOpt snmpUser, String enablePwd, DiscAttrsDO discAttrs) throws DiscoveryException, InvalidArgumentException {
        DCManager dcm = DCManager.getInstance();
        DiscTaskTypeDO discType = discAttrs.getTaskType();
        Object[] swIPs = discAttrs.getSwIPs();
        int maxHop = discAttrs.getMaxHop();
        long groupId = discAttrs.getGroupId();
        if (snmpUser.isV3()) {
            if (snmpUser.getUsername() == null || snmpUser.getUsername().length() < 1) {
                throw new InvalidArgumentException("Invalid username: " + snmpUser.getUsername());
            }
            if (snmpUser.getPassword() == null || snmpUser.getPassword() == null) {
                throw new InvalidArgumentException("Invalid password: " + snmpUser.getPassword());
            }
        } else if (snmpUser.getCommunity() == null) {
            throw new InvalidArgumentException("Invalid community: " + snmpUser.getCommunity());
        }
        if (discType == DiscTaskTypeDO.LAN_MAXHOP) {
            InetAddress seedIp = null;
            String ipAddr = null;
            try {
                ipAddr = swIPs[0];
                seedIp = InetAddress.getByName(ipAddr);
            }
            catch (Exception ex) {
                throw new InvalidArgumentException("Invalid seed ip address: " + ipAddr);
            }
            try {
                String dcnmUser = this.getCurrentUsername();
                CdpSeedImpl task = dcm.discoverLan(seedIp, maxHop, snmpUser, enablePwd, groupId, dcnmUser, true);
                DiscTaskKeyDO discTaskKeyDO = new DiscTaskKeyDO(task.getTaskKey().getId(), task.getTaskKey().getName(), task.getBase().getTaskType().value());
                return discTaskKeyDO;
            }
            catch (Exception ex) {
                _Tracer.warn("DiscoveryWS failed to discover LAN task with switches:" + Arrays.toString(swIPs), ex);
                throw new DiscoveryException("Cannot create LAN task with switches:" + Arrays.toString(swIPs));
            }
        }
        if (discType == DiscTaskTypeDO.LAN_IPLIST) {
            ArrayList<InetAddress> swList = new ArrayList<InetAddress>(swIPs.length);
            for (String string : swIPs) {
                try {
                    swList.add(InetAddress.getByName(string));
                }
                catch (Exception ex) {
                    _Tracer.warn("DiscoveryWS failed to discover LAN task for ip:" + string);
                }
            }
            if (swList.size() == 0) {
                throw new InvalidArgumentException("Invalid seed ip addresses: " + Arrays.toString(swIPs));
            }
            try {
                String dcnmUser = this.getCurrentUsername();
                CdpSeedImpl task = dcm.discoverLan(swList, snmpUser, enablePwd, groupId, dcnmUser, true);
                DiscTaskKeyDO taskKey = new DiscTaskKeyDO(task.getTaskKey().getId(), task.getTaskKey().getName(), task.getBase().getTaskType().value());
                return taskKey;
            }
            catch (Exception ex) {
                _Tracer.warn("DiscoveryWS failed to discover LAN task with switches:" + Arrays.toString(swIPs), ex);
                throw new DiscoveryException("Cannot create LAN task  with switches:" + Arrays.toString(swIPs));
            }
        }
        _Tracer.warn("DiscoveryWS failed to discover LAN task with type:" + discType);
        throw new DiscoveryException("Cannot create LAN task with type:" + discType);
    }

    @Override
    @WebMethod
    public void rediscoverLAN() throws DiscoveryException {
        DCManager dcm = DCManager.getInstance();
        try {
            dcm.rediscoverLan();
        }
        catch (Exception ex) {
            _Tracer.warn("DiscoveryWS failed to rediscover LAN", ex);
            throw new DiscoveryException("Failed to rediscover LAN:" + ex.getMessage());
        }
    }

    @Override
    @WebMethod
    public void rediscoverLANByFlag(@WebParam(name="discFlag") DiscFlagTypeDO discFlag) throws DiscoveryException, InvalidArgumentException {
        if (discFlag == null || discFlag == DiscFlagTypeDO.UNKNOWN) {
            throw new InvalidArgumentException("Invalid discovery flag:" + discFlag);
        }
        DCManager dcm = DCManager.getInstance();
        if (dcm.getLan() == null) {
            return;
        }
        try {
            if (discFlag == DiscFlagTypeDO.FULL) {
                dcm.rediscoverLan();
            } else if (discFlag == DiscFlagTypeDO.DEEP || discFlag == DiscFlagTypeDO.DEEPFAILED) {
                List<CdpSeedImpl> tasks = dcm.getLan().getCdpSeeds();
                for (CdpSeedImpl task : tasks) {
                    if (!task.getBase().haveDeepTask()) continue;
                    DiscTaskKeyDO deepTaskKey = new DiscTaskKeyDO(task.getDeepTaskId(), null, DiscTaskType.LAN_DEEP.value());
                    List<EthSwitchImpl> sws = task.getDiscoveredEthSwitches();
                    ArrayList<String> ipList = new ArrayList<String>();
                    ArrayList<Boolean> licList = new ArrayList<Boolean>();
                    for (EthSwitchImpl sw : sws) {
                        if (sw.getIpAddress() == null || !sw.getBase().allowDeepDiscovery()) continue;
                        ipList.add(sw.getIpAddress());
                        licList.add(sw.getBase().isLicensed());
                    }
                    String[] swIPs = new String[ipList.size()];
                    ipList.toArray(swIPs);
                    boolean[] lics = new boolean[licList.size()];
                    for (int i = 0; i < licList.size(); ++i) {
                        lics[i] = (Boolean)licList.get(i);
                    }
                }
            }
        }
        catch (Exception ex) {
            _Tracer.warn("DiscoveryWS failed to rediscover LAN", ex);
            throw new DiscoveryException("Failed to rediscover LAN with flag:" + discFlag);
        }
        _Tracer.warn("DiscoveryWS failed to rediscover LAN with flag:" + discFlag);
        throw new DiscoveryException("Failed to rediscover LAN with flag:" + discFlag);
    }

    @Override
    @WebMethod
    public void rediscoverLANByTask(@WebParam(name="taskKey") DiscTaskKeyDO taskKey, @WebParam(name="discFlag") DiscFlagTypeDO discFlag) throws DiscoveryException, InvalidArgumentException {
        if (taskKey == null) {
            throw new InvalidArgumentException("Invalid discovery task:" + taskKey);
        }
        if (discFlag == null || discFlag == DiscFlagTypeDO.UNKNOWN) {
            throw new InvalidArgumentException("Invalid discovery flag:" + discFlag);
        }
        DCManager dcm = DCManager.getInstance();
        try {
            CdpSeedImpl task = dcm.getLan().findTaskByDeepTask(taskKey.getTaskId());
            if (task == null) {
                return;
            }
            if (discFlag == DiscFlagTypeDO.DEEP || discFlag == DiscFlagTypeDO.DEEPFAILED) {
                List<EthSwitchImpl> sws = task.getDiscoveredEthSwitches();
                ArrayList<String> ipList = new ArrayList<String>();
                ArrayList<Boolean> licList = new ArrayList<Boolean>();
                for (EthSwitchImpl sw : sws) {
                    if (sw.getIpAddress() == null || !sw.getBase().allowDeepDiscovery()) continue;
                    ipList.add(sw.getIpAddress());
                    licList.add(sw.getBase().isLicensed());
                }
                String[] swIPs = new String[ipList.size()];
                ipList.toArray(swIPs);
                boolean[] lics = new boolean[licList.size()];
                for (int i = 0; i < licList.size(); ++i) {
                    lics[i] = (Boolean)licList.get(i);
                }
            }
        }
        catch (Exception ex) {
            _Tracer.warn("DiscoveryWS failed to rediscover LAN", ex);
            throw new DiscoveryException("Failed to rediscover LAN", ex);
        }
        _Tracer.warn("DiscoveryWS failed to rediscover LAN with task:" + taskKey + ", and flag:" + discFlag);
        throw new DiscoveryException("Failed to rediscover LAN with task:" + taskKey + ", and flag:" + discFlag);
    }

    @Override
    @WebMethod
    public void removeLAN(@WebParam(name="lanTaskKey") DiscTaskKeyDO lanTaskKey) throws DiscoveryException, InvalidArgumentException {
        if (lanTaskKey == null) {
            throw new InvalidArgumentException("Invalid discovery task:" + lanTaskKey);
        }
        DCManager dcm = DCManager.getInstance();
        try {
            TaskKey taskKey = new TaskKey(lanTaskKey.getTaskId());
            dcm.removeTask(taskKey, true);
        }
        catch (Exception ex) {
            _Tracer.warn("DiscoveryWS failed to remove LAN task:" + ex.getMessage(), ex);
            throw new DiscoveryException("Failed to remove LAN task:" + ex.getMessage());
        }
    }

    @Override
    @WebMethod
    public void cleanLAN() throws DiscoveryException {
        DCManager dcm = DCManager.getInstance();
        try {
            dcm.removeLan(null, true, true);
        }
        catch (Exception ex) {
            _Tracer.warn("DiscoveryWS failed to clean LAN:" + ex.getMessage(), ex);
            throw new DiscoveryException("Failed to clean LAN:" + ex.getMessage());
        }
    }

    @Override
    @WebMethod
    @WebResult(name="result")
    public DiscStatusDO[] getLANTaskStatus() throws DiscoveryException, InvalidArgumentException {
        DCManager dcm = DCManager.getInstance();
        try {
            List<CdpSeedImpl> tasks = dcm.getTasks();
            DiscStatusDO[] statusAry = new DiscStatusDO[tasks.size()];
            for (int i = 0; i < tasks.size(); ++i) {
                CdpSeedImpl task = tasks.get(i);
                statusAry[i] = new DiscStatusDO(task.getTaskKey(), task.getBase().getTaskType(), task.getDiscStatus());
            }
            return statusAry;
        }
        catch (Exception ex) {
            _Tracer.warn("DiscoveryWS failed to get LAN task status:" + ex.getMessage(), ex);
            throw new DiscoveryException("Failed to get LAN task status:" + ex.getMessage());
        }
    }

    @Override
    @WebMethod
    @WebResult(name="result")
    public DiscStatusDO getLANDiscoveryStatus() throws DiscoveryException {
        DCManager dcm = DCManager.getInstance();
        try {
            return new DiscStatusDO(dcm.getLanDiscoveryStatus());
        }
        catch (Exception ex) {
            _Tracer.warn("DiscoveryWS failed to get LAN discovery status:" + ex.getMessage(), ex);
            throw new DiscoveryException("Failed to get LAN discovery status:" + ex.getMessage());
        }
    }

    @Override
    public void setLANManaged(@WebParam(name="lanTaskKey") DiscTaskKeyDO lanTaskKey, @WebParam(name="managed") boolean managed) throws DiscoveryException {
        DCManager dcm = DCManager.getInstance();
        if (lanTaskKey == null) {
            throw new InvalidArgumentException("Invalid discovery task:" + lanTaskKey);
        }
        if (dcm.getLan() == null) {
            return;
        }
        try {
            TaskKey taskKey = new TaskKey(lanTaskKey.getTaskId());
            CdpSeedImpl task = dcm.getLan().findCdpSeedBySeedPK(taskKey);
            if (task == null) {
                throw new DiscoveryException("Cannot find the task by key:" + lanTaskKey);
            }
            task.setManageable(managed);
        }
        catch (Exception ex) {
            _Tracer.warn("DiscoveryWS failed to change LAN task manageability:" + ex.getMessage(), ex);
            throw new DiscoveryException("Failed to change LAN task manageability:" + ex.getMessage());
        }
    }

    @Override
    @WebMethod
    public void manageLAN() throws DiscoveryException {
        DCManager dcm = DCManager.getInstance();
        if (dcm.getLan() == null) {
            return;
        }
        try {
            dcm.manageLan();
        }
        catch (Exception ex) {
            _Tracer.warn("DiscoveryWS failed to manage LAN:" + ex.getMessage(), ex);
            throw new DiscoveryException("Failed to manage LAN:" + ex.getMessage());
        }
    }

    @Override
    @WebMethod
    public void unmanageLAN() throws DiscoveryException {
        DCManager dcm = DCManager.getInstance();
        if (dcm.getLan() == null) {
            return;
        }
        try {
            dcm.unmanageLan();
        }
        catch (Exception ex) {
            _Tracer.warn("DiscoveryWS failed to unmanage LAN:" + ex.getMessage(), ex);
            throw new DiscoveryException("Failed to unmanage LAN:" + ex.getMessage());
        }
    }

    @Override
    @WebMethod
    public void changeLANCredentialsByUser(@WebParam(name="lanTaskKey") DiscTaskKeyDO lanTaskKey, @WebParam(name="user") String user, @WebParam(name="pwd") String pwd, @WebParam(name="authPrivacy") AuthPrivacyTypeDO authPrivacy, @WebParam(name="enablePwd") String enablePwd, @WebParam(name="forceSet") boolean forceSet) throws DiscoveryException, InvalidArgumentException {
        if (lanTaskKey == null) {
            throw new InvalidArgumentException("Invalid discovery task:" + lanTaskKey);
        }
        if (user == null || pwd == null || authPrivacy == null) {
            throw new InvalidArgumentException("Invalid user credential info");
        }
        DCManager dcm = DCManager.getInstance();
        try {
            dcm.changeTaskCredentials(lanTaskKey.toBase(), user, pwd, null, authPrivacy.value(), true, enablePwd, forceSet);
        }
        catch (Exception ex) {
            _Tracer.warn("DiscoveryWS failed to change credential:" + ex.getMessage(), ex);
            throw new DiscoveryException("DiscoveryWS failed to change credential:" + ex.getMessage(), ex);
        }
    }

    @Override
    @WebMethod
    public void changeLANCredentialsByCommunity(@WebParam(name="lanTaskKey") DiscTaskKeyDO lanTaskKey, @WebParam(name="commnityString") String communityString, @WebParam(name="forceSet") boolean forceSet) throws DiscoveryException, InvalidArgumentException {
        if (lanTaskKey == null) {
            throw new InvalidArgumentException("Invalid discovery task:" + lanTaskKey);
        }
        if (communityString == null) {
            throw new InvalidArgumentException("Invalid user credential info");
        }
        DCManager dcm = DCManager.getInstance();
        try {
            dcm.changeTaskCredentials(lanTaskKey.toBase(), null, null, null, 0, false, null, forceSet);
        }
        catch (Exception ex) {
            _Tracer.warn("DiscoveryWS failed to change credential:" + ex.getMessage(), ex);
            throw new DiscoveryException("DiscoveryWS failed to change credential:" + ex.getMessage(), ex);
        }
    }

    @Override
    @WebMethod
    public void notifyDeepLANTaskStatus(@WebParam(name="discStatus") DiscStatusDO discStatus) throws DiscoveryException, InvalidArgumentException {
        if (discStatus == null) {
            throw new InvalidArgumentException("Invalid deep discovery task status:" + discStatus);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.info("Inside DiscoveryWS -> notifyDeepLANTaskStatus()");
            if (discStatus != null) {
                _Tracer.info("LAN discStatus.getTaskKey().getTaskId() ==> " + discStatus.getTaskKey().getTaskId());
                _Tracer.info("LAN discStatus.getStatus() ==> " + (Object)((Object)discStatus.getStatus()));
                _Tracer.info("LAN discStatus.getStatusBase() ==> " + (Object)((Object)discStatus.getStatusBase()));
            }
        }
        DCManager dcm = DCManager.getInstance();
        try {
            long deepTaskId = discStatus.getTaskKey().getTaskId();
            for (CdpSeedImpl task : dcm.getTasks()) {
                if (task.getDBID() != deepTaskId) continue;
                DiscStateType discState = task.getDiscState();
                DiscStatusDO.StatusType deepStatus = discStatus.getStatus();
                if (deepStatus == DiscStatusDO.StatusType.STARTED) {
                    return;
                }
                if (deepStatus == DiscStatusDO.StatusType.NONEXIST || deepStatus == DiscStatusDO.StatusType.UNMANAGED) {
                    if (deepStatus == DiscStatusDO.StatusType.NONEXIST) {
                        task.setDeepTaskId(-1L);
                    }
                    if (discState == DiscStateType.FULLMANAGE) {
                        task.setDiscState(DiscStateType.CDPMANAGE);
                    }
                    if (discState == DiscStateType.DEEPMANAGE) {
                        task.setDiscState(DiscStateType.UNMANAGE);
                    }
                } else {
                    if (discState == DiscStateType.CDPMANAGE) {
                        task.setDiscState(DiscStateType.FULLMANAGE);
                    }
                    if (discState == DiscStateType.UNMANAGE) {
                        task.setDiscState(DiscStateType.DEEPMANAGE);
                    }
                }
                task.getBase().setDeepDiscStatus(discStatus.getStatusBase());
                task.getBase().setDeepDiscDescription(discStatus.getStatusDetails());
                LanPersistentManager.getInstance().updateCdpTaskStatus(task);
                break;
            }
        }
        catch (Exception ex) {
            _Tracer.warn("DiscoveryWS failed update deep discovery status:" + ex.getMessage(), ex);
            throw new DiscoveryException("DiscoveryWS failed to deep discovery status:" + ex.getMessage(), ex);
        }
    }

    @Override
    @WebMethod
    public void notifyDeepTaskRemoved(@WebParam(name="deepTaskKey") DiscTaskKeyDO deepTaskKey) throws DiscoveryException, InvalidArgumentException {
        if (deepTaskKey == null) {
            throw new InvalidArgumentException("Invalid deep discovery task key:" + deepTaskKey);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.info("Inside DiscoveryWS -> notifyDeepTaskRemoved()");
            _Tracer.info("deepTaskKey ==> " + deepTaskKey);
        }
        DCManager dcm = DCManager.getInstance();
        try {
            long deepTaskId = deepTaskKey.getTaskId();
            for (CdpSeedImpl task : dcm.getTasks()) {
                if (task.getDeepTaskId() != deepTaskId) continue;
                DiscStateType discState = task.getDiscState();
                task.getBase().setDeepTaskId(-1L);
                if (discState == DiscStateType.FULLMANAGE) {
                    task.setDiscState(DiscStateType.CDPMANAGE);
                }
                if (discState == DiscStateType.DEEPMANAGE) {
                    task.setDiscState(DiscStateType.UNMANAGE);
                }
                task.getBase().setDeepDiscStatus(DiscStatusType.NONEXIST);
                task.setDeepUpdateTime(System.currentTimeMillis());
                List<EthSwitchImpl> sws = task.getDiscoveredEthSwitches();
                for (EthSwitchImpl sw : sws) {
                }
                break;
            }
        }
        catch (Exception ex) {
            _Tracer.warn("DiscoveryWS failed to update deep discovery task remove status:" + ex.getMessage(), ex);
            throw new DiscoveryException("DiscoveryWS failed to update deep discovery task remove status:" + ex.getMessage(), ex);
        }
    }

    @Override
    @WebMethod
    public void notifyDeepLANMemberChanged(@WebParam(name="deepTaskKey") DiscTaskKeyDO deepTaskKey, @WebParam(name="lanObject") LanObjectDO lanObject, @WebParam(name="attributeName") String attributeName, @WebParam(name="oldValue") String oldValue, @WebParam(name="newValue") String newValue) throws DiscoveryException {
        if (_Tracer.isTraceable()) {
            _Tracer.info("Inside DiscoveryWS -> notifyDeepLANMemberChanged()");
            _Tracer.info("TaskId from LAN  ==> " + deepTaskKey.getTaskId());
        }
        LanNotifyMessageHandler.getInstance().handleLANMemberChangeMsg(lanObject);
    }

    @Override
    @WebMethod(operationName="hasAtLeastOneLANLicenseFileInstalled")
    @WebResult(name="result", partName="result")
    public boolean hasAtLeastOneLANLicenseFileInstalled() {
        try {
            FMServerImpl fmServerRif = FMServerImpl.getInstance();
            List<LicenseInfoFlex> licenseFiles = fmServerRif.getFileLicenseInfo();
            for (LicenseInfoFlex nextLic : licenseFiles) {
                List<Integer> licProductTypes = FileLicensingHelper.getProductTypes(nextLic.getFeatureName());
                if (!licProductTypes.contains(2) || !nextLic.isValid()) continue;
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            _Tracer.warn("DbAdminWS caught exception in hasAtLeastOneLANLicenseFileInstalled():", e);
            return false;
        }
    }

    @Override
    @WebMethod(operationName="getLANSwitchesLicenseState")
    @WebResult(name="result", partName="result")
    public SwitchLicenseStateDO[] getLANSwitchesLicenseState() {
        try {
            List<SwitchAssignedLicenseInfo> swLicenses = FileLicensingHelper.getInstance().getLanLicenseInfoSwitchAssignment();
            ArrayList<SwitchLicenseStateDO> ret = new ArrayList<SwitchLicenseStateDO>();
            for (int i = 0; i < swLicenses.size(); ++i) {
                SwitchAssignedLicenseInfo nextSw = swLicenses.get(i);
                if (nextSw.getSwitchType() == -1 || nextSw.getSwitchKey() == null) continue;
                SwitchLicenseStateDO dto = new SwitchLicenseStateDO(nextSw.getSwitchKey(), nextSw.isLicensed());
                ret.add(dto);
            }
            return ret.toArray(new SwitchLicenseStateDO[ret.size()]);
        }
        catch (Throwable e) {
            _Tracer.warn("DbAdminWS caught exception in getLanSwitchLicenseState():", e);
            return new SwitchLicenseStateDO[0];
        }
    }

    @Override
    @WebMethod(operationName="getLANSwitchLicenseState")
    @WebResult(name="result", partName="result")
    public boolean getLANSwitchLicenseState(String serialNumber) {
        List<SwitchAssignedLicenseInfo> swLicenses = FileLicensingHelper.getInstance().getAllLanSwitchesWithSameChassis(serialNumber);
        for (SwitchAssignedLicenseInfo nextSw : swLicenses) {
            if (!nextSw.isLicensed()) continue;
            return true;
        }
        return false;
    }

    @Override
    @WebMethod(operationName="getLanWithCdpSeedSwitches_fromDB")
    @WebResult(name="result", partName="result")
    public DBEntryAdvDO getLanWithCdpSeedSwitches_fromDB() throws Exception {
        DBEntryDO resp = SanWS.getLanWithCdpSeedSwitches_fromDB_detail();
        DBEntryAdvDO dto = new DBEntryAdvDO();
        dto.setColumn(resp.getColumn());
        ArrayList<DBRowAdvDO> rlist = new ArrayList<DBRowAdvDO>();
        for (DBRowDO row : resp.getRows()) {
            DBRowAdvDO newRow = new DBRowAdvDO();
            newRow.setEntry(row.getEntry());
            rlist.add(newRow);
        }
        dto.setRow(rlist.toArray(new DBRowAdvDO[0]));
        return dto;
    }

    @Override
    @WebMethod(operationName="getEthSwitchByCdpSeedDbId")
    @WebResult(name="result", partName="result")
    public DBEntryAdvDO getEthSwitchByCdpSeedDbId(long lanTaskKey, boolean isFWSM) throws Exception {
        int deepDiscoveredOption = 0;
        DBEntryDO resp = SanWS.getEthSwitchByCdpSeedDbId_detail(lanTaskKey, isFWSM, deepDiscoveredOption);
        DBEntryAdvDO dto = new DBEntryAdvDO();
        dto.setColumn(resp.getColumn());
        ArrayList<DBRowAdvDO> rlist = new ArrayList<DBRowAdvDO>();
        for (DBRowDO row : resp.getRows()) {
            DBRowAdvDO newRow = new DBRowAdvDO();
            newRow.setEntry(row.getEntry());
            rlist.add(newRow);
        }
        dto.setRow(rlist.toArray(new DBRowAdvDO[0]));
        return dto;
    }

    @Override
    public CallResultDO deepDiscoverForSelectedLanMembers(DiscTaskKeyDO lanTaskKey, String[] ethSwDbIdList) throws Exception {
        try {
            if (!SanWS.isTaskV3(lanTaskKey.getTaskId())) {
                return new CallResultDO(1, "LAN task " + lanTaskKey.getTaskId() + " not V3");
            }
            String[] failSwList = SanWS.checkDiscoveryEthSwCandidates4List(ethSwDbIdList);
            if (failSwList.length > 0) {
                StringBuffer sb = new StringBuffer();
                for (String eth : failSwList) {
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(eth);
                }
                return new CallResultDO(1, "not candidate for fresh deep discovery: " + sb.toString());
            }
        }
        catch (Exception ex) {
            return new CallResultDO(1, ex.getMessage());
        }
        return SanWS.setEthSw4DeepDiscovery_detail(Long.toString(lanTaskKey.getTaskId()), Long.toString(lanTaskKey.getTaskId()), ethSwDbIdList, null);
    }

    @Override
    public CallResultDO deepDiscoverForTask(DiscTaskKeyDO lanTaskKey) throws Exception {
        if (!SanWS.isTaskV3(lanTaskKey.getTaskId())) {
            return new CallResultDO(1, "LAN task " + lanTaskKey.getTaskId() + " not V3");
        }
        String cdpSeedDbId = Long.toString(lanTaskKey.getTaskId());
        String[] ethSwDbIdList = SanWS.getDeepDiscoveryEthSwCandidates4Task(Long.parseLong(cdpSeedDbId));
        if (ethSwDbIdList == null || ethSwDbIdList.length == 0) {
            return new CallResultDO();
        }
        return SanWS.setEthSw4DeepDiscovery_detail(Long.toString(lanTaskKey.getTaskId()), cdpSeedDbId, ethSwDbIdList, null);
    }

    @Override
    public CallResultDO deepRediscoverForTask(DiscTaskKeyDO lanTaskKey) {
        return SanWS.rediscoverLanTask_detail(Long.toString(lanTaskKey.getTaskId()), null);
    }

    @Override
    public CallResultDO deepRediscoverForSelectedLanMembers(DiscTaskKeyDO lanTaskKey, String ethSwIP, Long ethSwId) {
        return SanWS.rediscoverEthSw_detail(Long.toString(lanTaskKey.getTaskId()), ethSwIP, ethSwId);
    }

    private String getCurrentUsername() {
        String token = SecurityHandler.getToken();
        if (token != null) {
            return IdentityManager.getInstance().extractToken(token).getUsername();
        }
        PM._Logger.warn((Object)"Unable to get logged in Username, returning default username Admin!!!!");
        return "admin";
    }
}

