/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.san.ep;

import com.cisco.dcbu.dcm.model.InstanceNameId;
import com.cisco.dcbu.jaxws.ep.SanServiceException;
import com.cisco.dcbu.jaxws.san.ep.ConfigTemplateSEI;
import com.cisco.dcbu.jaxws.san.wo.ConfigDeliveryTaskDO;
import com.cisco.dcbu.jaxws.san.wo.ConfigDeliveryTaskDeviceDO;
import com.cisco.dcbu.jaxws.san.wo.ConfigTemplateDO;
import com.cisco.dcbu.jaxws.san.wo.ConfigTemplateParserReportItemDO;
import com.cisco.dcbu.jaxws.san.wo.InstanceNameIdDO;
import com.cisco.dcbu.jaxws.san.wo.TemplateConfigDeliveryTaskDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.sm.server.web.cfgdelivery.ConfigDeliveryHandler;
import com.cisco.dcbu.sm.server.web.cfgtemplates.ConfigTemplateHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ejb.Stateless;
import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.ws.api.annotation.WebContext;

@SOAPBinding(style=SOAPBinding.Style.RPC, use=SOAPBinding.Use.LITERAL)
@HandlerChain(file="../../ep/fms-jaxws-handlers.xml")
@WebContext(contextRoot="/ConfigTemplateWSService", urlPattern="/ConfigTemplateWS")
@WebService(name="ConfigTemplateWS", serviceName="ConfigTemplateService", endpointInterface="com.cisco.dcbu.jaxws.san.ep.ConfigTemplateSEI")
@Stateless
public class ConfigTemplateWS
implements ConfigTemplateSEI {
    static Logger logger = LogManager.getLogger((String)"fms.ws");

    @Override
    @WebMethod(operationName="createTemplate")
    @WebResult(name="result", partName="result")
    public InstanceNameIdDO[] createTemplates(ConfigTemplateDO[] templateCol) throws SanServiceException {
        try {
            List<InstanceNameIdDO> tempIdList = ConfigTemplateHandler.getInstance().createTemplate(Arrays.asList(templateCol));
            InstanceNameIdDO[] retArr = new InstanceNameIdDO[tempIdList.size()];
            retArr = tempIdList.toArray(retArr);
            return retArr;
        }
        catch (Throwable e) {
            logger.warn((Object)"ConfigTemplateWS caught exception in createTemplate():", e);
            throw new SanServiceException("Cannot create template: " + e.getMessage(), e);
        }
    }

    @Override
    @WebMethod(operationName="deleteTemplates")
    @WebResult(name="result", partName="result")
    public void deleteTemplates(InstanceNameIdDO[] templateInstanceNameIdCol) throws SanServiceException {
        try {
            ConfigTemplateHandler.getInstance().deleteTemplates(Arrays.asList(templateInstanceNameIdCol));
        }
        catch (Throwable e) {
            logger.warn((Object)"ConfigTemplateWS caught exception in deleteTemplates():", e);
            throw new SanServiceException("Cannot delete template objects", e);
        }
    }

    @Override
    @WebMethod(operationName="getAllTemplates")
    @WebResult(name="result", partName="result")
    public ConfigTemplateDO[] getAllTemplates(DbFilterDO dbFilter, String status, int startIdx, int recordSize) throws SanServiceException {
        try {
            List<ConfigTemplateDO> templateList = ConfigTemplateHandler.getInstance().getAllTemplates(dbFilter, status, startIdx, recordSize);
            ConfigTemplateDO[] retArr = new ConfigTemplateDO[templateList.size()];
            return templateList.toArray(retArr);
        }
        catch (Throwable e) {
            logger.warn((Object)"ConfigTemplateWS caught exception in getAllTemplates():", e);
            throw new SanServiceException("Cannot get all templates", e);
        }
    }

    @Override
    @WebMethod(operationName="getTemplateContents")
    @WebResult(name="result", partName="result")
    public String[] getTemplateContents(InstanceNameIdDO[] templateInstanceNameIdCol) throws SanServiceException {
        try {
            List<String> contentList = ConfigTemplateHandler.getInstance().getTemplateContents(Arrays.asList(templateInstanceNameIdCol));
            String[] retArr = new String[contentList.size()];
            return contentList.toArray(retArr);
        }
        catch (Throwable e) {
            logger.warn((Object)"ConfigTemplateWS caught exception in getTemplateContents():", e);
            throw new SanServiceException("Cannot get template contents for templates", e);
        }
    }

    @Override
    @WebMethod(operationName="getTemplates")
    @WebResult(name="result", partName="result")
    public ConfigTemplateDO[] getTemplates(InstanceNameIdDO[] templateInstanceNameIdCol) throws SanServiceException {
        try {
            List<ConfigTemplateDO> templateList = ConfigTemplateHandler.getInstance().getTemplates(Arrays.asList(templateInstanceNameIdCol));
            ConfigTemplateDO[] retArr = new ConfigTemplateDO[templateList.size()];
            return templateList.toArray(retArr);
        }
        catch (Throwable e) {
            logger.warn((Object)"ConfigTemplateWS caught exception in getTemplates():", e);
            throw new SanServiceException("Cannot get template objects", e);
        }
    }

    @Override
    @WebMethod(operationName="modifyTemplates")
    @WebResult(name="result", partName="result")
    public void modifyTemplates(ConfigTemplateDO[] templateCol) throws SanServiceException {
        try {
            ConfigTemplateHandler.getInstance().modifyTemplates(Arrays.asList(templateCol));
        }
        catch (Throwable e) {
            logger.warn((Object)"ConfigTemplateWS caught exception in modifyTemplates():", e);
            throw new SanServiceException("Cannot modify template", e);
        }
    }

    @Override
    @WebMethod(operationName="populateTemplateRepository")
    @WebResult(name="result", partName="result")
    public void populateTemplateRepository() throws SanServiceException {
        try {
            ConfigTemplateHandler.getInstance().populateTemplateRepository();
        }
        catch (Throwable e) {
            logger.warn((Object)"ConfigTemplateWS caught exception in populateTemplateRepository():", e);
            throw new SanServiceException("Cannot populate template repository", e);
        }
    }

    @Override
    @WebMethod(operationName="validateTemplateContent")
    @WebResult(name="result", partName="result")
    public ConfigTemplateParserReportItemDO[] validateTemplateContent(String content) throws SanServiceException {
        try {
            List<ConfigTemplateParserReportItemDO> reportList = ConfigTemplateHandler.getInstance().validateTemplateContent(content);
            ConfigTemplateParserReportItemDO[] retArr = new ConfigTemplateParserReportItemDO[reportList.size()];
            return reportList.toArray(retArr);
        }
        catch (Throwable e) {
            logger.warn((Object)"ConfigTemplateWS caught exception in validateTemplateContent():", e);
            throw new SanServiceException("Cannot validate template content", e);
        }
    }

    @Override
    public InstanceNameIdDO createTemplateConfigDeliveryTask(TemplateConfigDeliveryTaskDO task) throws SanServiceException {
        InstanceNameIdDO retVal = null;
        try {
            retVal = ConfigDeliveryHandler.getInstance().createConfigDeliveryTask(task);
        }
        catch (Throwable e) {
            logger.warn((Object)"ConfigTemplateWS caught exception in createConfigDeliveryTasks():", e);
            throw new SanServiceException("Cannot create config delivery task", e);
        }
        return retVal;
    }

    @Override
    public void deleteConfigDeliveryTasks(InstanceNameIdDO[] taskInstanceNameIdCol) throws SanServiceException {
        try {
            ConfigDeliveryHandler.getInstance().deleteConfigDeliveryTasks(Arrays.asList(taskInstanceNameIdCol));
        }
        catch (Throwable e) {
            logger.warn((Object)"ConfigTemplateWS caught exception in deleteConfigDeliveryTasks():", e);
            throw new SanServiceException("Cannot delete config delivery tasks", e);
        }
    }

    @Override
    public ConfigDeliveryTaskDO[] getAllConfigDeliveryTasks(DbFilterDO dbFilter, String status, int startIdx, int recordSize) throws SanServiceException {
        try {
            List<ConfigDeliveryTaskDO> templateList = ConfigDeliveryHandler.getInstance().getAllConfigDeliveryTasks(dbFilter, status, startIdx, recordSize);
            ConfigDeliveryTaskDO[] retArr = new ConfigDeliveryTaskDO[templateList.size()];
            return templateList.toArray(retArr);
        }
        catch (Throwable e) {
            logger.warn((Object)"ConfigTemplateWS caught exception in getAllConfigDeliveryTasks():", e);
            throw new SanServiceException("Cannot get config delivery tasks", e);
        }
    }

    @Override
    public String getPopulatedCommands(InstanceNameIdDO templateInstanceNameId, String[] parameters, String[] paramValues, Boolean populateParamNames) throws SanServiceException {
        try {
            String commandStr = ConfigTemplateHandler.getInstance().getPopulatedCommands(templateInstanceNameId, parameters, paramValues, populateParamNames);
            return commandStr;
        }
        catch (Throwable e) {
            logger.warn((Object)"ConfigTemplateWS caught exception in getPopulatedCommands():", e);
            throw new SanServiceException("Cannot get config populated commands", e);
        }
    }

    @Override
    public ConfigDeliveryTaskDeviceDO[] getConfigDeliveryTaskDevices(DbFilterDO dbFilter, String status, int startIdx, int recordSize, String[] filterPlatforms) throws SanServiceException {
        try {
            ConfigDeliveryTaskDeviceDO[] retList = null;
            List<ConfigDeliveryTaskDeviceDO> deviceList = ConfigDeliveryHandler.getInstance().getConfigDeliveryTaskDevices(dbFilter, status, startIdx, recordSize, filterPlatforms);
            if (deviceList == null || deviceList.size() == 0) {
                deviceList = new ArrayList<ConfigDeliveryTaskDeviceDO>();
            }
            retList = new ConfigDeliveryTaskDeviceDO[deviceList.size()];
            return deviceList.toArray(retList);
        }
        catch (Throwable e) {
            logger.warn((Object)"ConfigTemplateWS caught exception in getConfigDeliveryTaskDevices():", e);
            throw new SanServiceException("Cannot get devices for config delivery task creation", e);
        }
    }

    @Override
    public String exportConfigDeliveryJobTable(DbFilterDO dbFilter, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        try {
            return ConfigDeliveryHandler.getInstance().exportConfigDeliveryJobTable(dbFilter, startIdx, recordSize, columnHeader);
        }
        catch (Throwable e) {
            logger.warn((Object)"ConfigTemplateWS caught exception in exportConfigDeliveryJobTable():", e);
            throw new SanServiceException("Cannot export config jobs", e);
        }
    }

    @Override
    public String exportConfigTemplateTable(DbFilterDO dbFilter, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        try {
            return ConfigTemplateHandler.getInstance().exportConfigTemplateTable(dbFilter, startIdx, recordSize, columnHeader);
        }
        catch (Throwable e) {
            logger.warn((Object)"ConfigTemplateWS caught exception in exportConfigTemplateTable():", e);
            throw new SanServiceException("Cannot export config templates", e);
        }
    }

    @Override
    public String printConfigDeliveryJobTable(DbFilterDO dbFilter, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        try {
            return ConfigDeliveryHandler.getInstance().printConfigDeliveryJobTable(dbFilter, startIdx, recordSize, columnHeader);
        }
        catch (Throwable e) {
            logger.warn((Object)"ConfigTemplateWS caught exception in printConfigDeliveryJobTable():", e);
            throw new SanServiceException("Cannot print config jobs", e);
        }
    }

    @Override
    public String printConfigTemplateTable(DbFilterDO dbFilter, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        try {
            return ConfigTemplateHandler.getInstance().printConfigTemplateTable(dbFilter, startIdx, recordSize, columnHeader);
        }
        catch (Throwable e) {
            logger.warn((Object)"ConfigTemplateWS caught exception in printConfigTemplateTable():", e);
            throw new SanServiceException("Cannot print config templates", e);
        }
    }

    @Override
    public int getConfigDeliveryJobLength(DbFilterDO dbFilter) throws SanServiceException {
        try {
            return ConfigDeliveryHandler.getInstance().getConfigDeliveryJobLength(dbFilter);
        }
        catch (Throwable e) {
            logger.warn((Object)"ConfigTemplateWS caught exception in getConfigDeliveryJobLength():", e);
            throw new SanServiceException("Cannot get config jobs count ", e);
        }
    }

    @Override
    public int getConfigTemplateLength(DbFilterDO dbFilter) throws SanServiceException {
        try {
            return ConfigTemplateHandler.getInstance().getConfigTemplateLength(dbFilter);
        }
        catch (Throwable e) {
            logger.warn((Object)"ConfigTemplateWS caught exception in getConfigTemplateLength():", e);
            throw new SanServiceException("Cannot get config templates count ", e);
        }
    }

    @Override
    @WebMethod(operationName="deleteTemplateJobs")
    @WebResult(name="result", partName="result")
    public void deleteTemplateJobs(InstanceNameIdDO templateInstNameID) throws SanServiceException {
        InstanceNameId instnameID = new InstanceNameId(templateInstNameID.getInstanceName(), Long.valueOf(templateInstNameID.getInstanceClassId()));
        ConfigTemplateHandler.getInstance().deleteConfigDeliveryjob(instnameID);
    }
}

