/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.san.ep;

import com.cisco.dcbu.jaxws.ep.InvalidArgumentException;
import com.cisco.dcbu.jaxws.ep.SanNotFoundException;
import com.cisco.dcbu.jaxws.ep.SanServiceException;
import com.cisco.dcbu.jaxws.san.ep.InventorySEI;
import com.cisco.dcbu.jaxws.san.helper.SanHelper;
import com.cisco.dcbu.jaxws.san.wo.CardDO;
import com.cisco.dcbu.jaxws.san.wo.HbaDO;
import com.cisco.dcbu.jaxws.san.wo.HwInventoryComponentDO;
import com.cisco.dcbu.jaxws.san.wo.LicenseFlagDO;
import com.cisco.dcbu.jaxws.san.wo.LicenseInfoDO;
import com.cisco.dcbu.jaxws.san.wo.PowerSupplyDO;
import com.cisco.dcbu.jaxws.san.wo.SerialNumKeyDO;
import com.cisco.dcbu.jaxws.san.wo.WwnDO;
import com.cisco.dcbu.jaxws.san.wo.WwnKeyDO;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.sm.common.dto.HwInventoryType;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.Hba;
import com.cisco.dcbu.sm.common.model.HwInventoryComponent;
import com.cisco.dcbu.sm.common.model.LicenseInfo;
import com.cisco.dcbu.sm.common.model.PowerSupply;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.SerialNumKey;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.inventory.InventoryManager;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.DCManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Stateless;
import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.ws.api.annotation.WebContext;

@SOAPBinding(style=SOAPBinding.Style.RPC, use=SOAPBinding.Use.LITERAL)
@HandlerChain(file="../../ep/fms-jaxws-handlers.xml")
@WebService(name="Inventory", serviceName="InventoryService", endpointInterface="com.cisco.dcbu.jaxws.san.ep.InventorySEI")
@WebContext(contextRoot="/InventoryWSService", urlPattern="/InventoryWS")
@Stateless
public class InventoryWS
implements InventorySEI {
    static Logger _Logger = LogManager.getLogger((String)"fms.ws");

    @Override
    public CardDO[] getCardsBySwitchWwnKey(WwnKeyDO swKey) throws SanServiceException, InvalidArgumentException {
        try {
            if (swKey == null) {
                throw new InvalidArgumentException("Invalid switch key:" + swKey);
            }
            WwnKey key = swKey.toWwnKey();
            return this.getCardsBySwitch(key);
        }
        catch (InvalidArgumentException e) {
            _Logger.warn((Object)"InventoryWS caught exception:", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            _Logger.warn((Object)"InventoryWS caught exception:", e);
            throw new SanServiceException("Cannot get switch's cards", e);
        }
    }

    @Override
    public CardDO[] getCardsBySwitchSnKey(SerialNumKeyDO swKey) throws SanServiceException, InvalidArgumentException {
        try {
            if (swKey == null) {
                throw new InvalidArgumentException("Invalid switch key:" + swKey);
            }
            SerialNumKey key = swKey.toSerialNumKey();
            return this.getCardsBySwitch(key);
        }
        catch (InvalidArgumentException e) {
            _Logger.warn((Object)"InventoryWS caught exception:", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            _Logger.warn((Object)"InventoryWS caught exception:", e);
            throw new SanServiceException("Cannot get switch's cards", e);
        }
    }

    @Override
    public CardDO[] getCardsBySwitchIP(String swIP) throws SanServiceException, InvalidArgumentException {
        try {
            PKIf swKey = this.getSwitchKeyByIP(swIP);
            return this.getCardsBySwitch(swKey);
        }
        catch (InvalidArgumentException e) {
            _Logger.warn((Object)"InventoryWS caught exception:", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            _Logger.warn((Object)"InventoryWS caught exception:", e);
            throw new SanServiceException("Cannot get switch's cards", e);
        }
    }

    @Override
    public HwInventoryComponentDO getChassisBySwitchWwnKey(WwnKeyDO swKey) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (swKey == null) {
                throw new InvalidArgumentException("Invalid switch key:" + swKey);
            }
            WwnKey key = swKey.toWwnKey();
            HwInventoryComponentDO[] hwDOs = this.getHwBySwitch(key, HwInventoryType.CHASSIS);
            if (hwDOs != null) {
                return hwDOs[0];
            }
            throw new SanNotFoundException();
        }
        catch (InvalidArgumentException e) {
            _Logger.warn((Object)"InventoryWS caught exception:", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            _Logger.warn((Object)"InventoryWS caught exception:", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            _Logger.warn((Object)"InventoryWS caught exception:", e);
            throw new SanServiceException("Cannot get switch's chassises", e);
        }
    }

    @Override
    public HwInventoryComponentDO getChassisBySwitchSnKey(SerialNumKeyDO swKey) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (swKey == null) {
                throw new InvalidArgumentException("Invalid switch key:" + swKey);
            }
            SerialNumKey key = swKey.toSerialNumKey();
            HwInventoryComponentDO[] hwDOs = this.getHwBySwitch(key, HwInventoryType.CHASSIS);
            if (hwDOs != null) {
                return hwDOs[0];
            }
            throw new SanNotFoundException();
        }
        catch (InvalidArgumentException e) {
            _Logger.warn((Object)"InventoryWS caught exception:", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            _Logger.warn((Object)"InventoryWS caught exception:", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            _Logger.warn((Object)"InventoryWS caught exception:", e);
            throw new SanServiceException("Cannot get switch's chassises", e);
        }
    }

    @Override
    public HwInventoryComponentDO getChassisBySwitchIP(String swIP) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            PKIf swKey = this.getSwitchKeyByIP(swIP);
            HwInventoryComponentDO[] hwDOs = this.getHwBySwitch(swKey, HwInventoryType.CHASSIS);
            if (hwDOs != null) {
                return hwDOs[0];
            }
            throw new SanNotFoundException();
        }
        catch (InvalidArgumentException e) {
            _Logger.warn((Object)"InventoryWS caught exception:", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            _Logger.warn((Object)"InventoryWS caught exception:", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            _Logger.warn((Object)"InventoryWS caught exception:", e);
            throw new SanServiceException("Cannot get switch's chassises", e);
        }
    }

    @Override
    public HwInventoryComponentDO[] getFansBySwitchWwnKey(WwnKeyDO swKey) throws SanServiceException, InvalidArgumentException {
        try {
            if (swKey == null) {
                throw new InvalidArgumentException("Invalid switch key:" + swKey);
            }
            WwnKey key = swKey.toWwnKey();
            return this.getHwBySwitch(key, HwInventoryType.FAN);
        }
        catch (InvalidArgumentException e) {
            _Logger.warn((Object)"InventoryWS caught exception:", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            _Logger.warn((Object)"InventoryWS caught exception:", e);
            throw new SanServiceException("Cannot get switch's fans", e);
        }
    }

    @Override
    public HwInventoryComponentDO[] getFansBySwitchSnKey(SerialNumKeyDO swKey) throws SanServiceException, InvalidArgumentException {
        try {
            if (swKey == null) {
                throw new InvalidArgumentException("Invalid switch key:" + swKey);
            }
            SerialNumKey key = swKey.toSerialNumKey();
            return this.getHwBySwitch(key, HwInventoryType.FAN);
        }
        catch (InvalidArgumentException e) {
            _Logger.warn((Object)"InventoryWS caught exception:", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            _Logger.warn((Object)"InventoryWS caught exception:", e);
            throw new SanServiceException("Cannot get switch's fans", e);
        }
    }

    @Override
    public HwInventoryComponentDO[] getFansBySwitchIP(String swIP) throws SanServiceException, InvalidArgumentException {
        try {
            PKIf swKey = this.getSwitchKeyByIP(swIP);
            return this.getHwBySwitch(swKey, HwInventoryType.FAN);
        }
        catch (InvalidArgumentException e) {
            _Logger.warn((Object)"InventoryWS caught exception:", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            _Logger.warn((Object)"InventoryWS caught exception:", e);
            throw new SanServiceException("Cannot get switch's fans", e);
        }
    }

    @Override
    public PowerSupplyDO[] getPowerSuppliesBySwitchWwnKey(WwnKeyDO swKey) throws SanServiceException, InvalidArgumentException {
        try {
            if (swKey == null) {
                throw new InvalidArgumentException("Invalid switch key:" + swKey);
            }
            WwnKey key = swKey.toWwnKey();
            return this.getPowerSuppliesBySwitch(key);
        }
        catch (InvalidArgumentException e) {
            _Logger.warn((Object)"InventoryWS caught exception:", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            _Logger.warn((Object)"InventoryWS caught exception:", e);
            throw new SanServiceException("Cannot get switch's power supplies", e);
        }
    }

    @Override
    public PowerSupplyDO[] getPowerSuppliesBySwitchSnKey(SerialNumKeyDO swKey) throws SanServiceException, InvalidArgumentException {
        try {
            if (swKey == null) {
                throw new InvalidArgumentException("Invalid switch key:" + swKey);
            }
            SerialNumKey key = swKey.toSerialNumKey();
            return this.getPowerSuppliesBySwitch(key);
        }
        catch (InvalidArgumentException e) {
            _Logger.warn((Object)"InventoryWS caught exception:", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            _Logger.warn((Object)"InventoryWS caught exception:", e);
            throw new SanServiceException("Cannot get switch's power supplies", e);
        }
    }

    @Override
    public PowerSupplyDO[] getPowerSuppliesBySwitchIP(String swIP) throws SanServiceException, InvalidArgumentException {
        try {
            PKIf swKey = this.getSwitchKeyByIP(swIP);
            return this.getPowerSuppliesBySwitch(swKey);
        }
        catch (InvalidArgumentException e) {
            _Logger.warn((Object)"InventoryWS caught exception:", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            _Logger.warn((Object)"InventoryWS caught exception:", e);
            throw new SanServiceException("Cannot get switch's power supplies", e);
        }
    }

    @Override
    public HbaDO[] getAllHbas() throws SanServiceException {
        try {
            Hba[] hbas = InventoryManager.getInstance().getHbas();
            ArrayList<HbaDO> hbaDOs = new ArrayList<HbaDO>();
            if (hbas != null) {
                for (int i = 0; i < hbas.length; ++i) {
                    if (hbas[i] == null || hbas[i].getSerialNumber() == null) continue;
                    hbaDOs.add(new HbaDO(hbas[i]));
                }
            }
            return hbaDOs.toArray(new HbaDO[0]);
        }
        catch (Throwable e) {
            _Logger.warn((Object)"InventoryWS caught exception:", e);
            throw new SanServiceException("Cannot get all hbas", e);
        }
    }

    @Override
    public HbaDO getHbaByWwn(WwnDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid wwn key:" + key);
            }
            Wwn hwwn = key.toWwn();
            Hba hba = InventoryManager.getInstance().findHbaByWwn(hwwn);
            if (hba != null) {
                return new HbaDO(hba);
            }
            throw new SanNotFoundException("InventoryWS caught SanNotFoundException");
        }
        catch (InvalidArgumentException e) {
            _Logger.warn((Object)"InventoryWS caught exception:", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException se) {
            _Logger.warn((Object)"InventoryWS caught exception:", (Throwable)se);
            throw se;
        }
        catch (Throwable e) {
            _Logger.warn((Object)"InventoryWS caught exception:", e);
            throw new SanServiceException("Cannot get all hbas", e);
        }
    }

    @Override
    public LicenseInfoDO[] getLicensesBySwitchWwnKey(WwnKeyDO swKey) throws SanServiceException, InvalidArgumentException {
        try {
            if (swKey == null) {
                throw new InvalidArgumentException("Invalid switch key:" + swKey);
            }
            WwnKey key = swKey.toWwnKey();
            return this.getLicensesBySwitch(key);
        }
        catch (InvalidArgumentException e) {
            _Logger.warn((Object)"InventoryWS caught exception:", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            _Logger.warn((Object)"InventoryWS caught exception:", e);
            throw new SanServiceException("Cannot get switch's licenses", e);
        }
    }

    @Override
    public LicenseInfoDO[] getLicensesBySwitchIP(String swIP) throws SanServiceException, InvalidArgumentException {
        try {
            PKIf swKey = this.getSwitchKeyByIP(swIP);
            if (swKey instanceof WwnKey) {
                return this.getLicensesBySwitch((WwnKey)swKey);
            }
            return new LicenseInfoDO[0];
        }
        catch (InvalidArgumentException e) {
            _Logger.warn((Object)"InventoryWS caught exception:", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            _Logger.warn((Object)"InventoryWS caught exception:", e);
            throw new SanServiceException("Cannot get switch's licenses", e);
        }
    }

    @Override
    public LicenseFlagDO[] getLicenseFlags() {
        return LicenseFlagDO.types;
    }

    private PKIf getSwitchKeyByIP(String swIP) throws UnknownHostException, InvalidArgumentException {
        if (swIP == null) {
            throw new InvalidArgumentException("Invalid switch IP:" + swIP);
        }
        InetAddress ip = InetAddress.getByName(swIP);
        AbstractModelObjectImpl swImpl = SanHelper.findSwitch(ip);
        if (swImpl == null) {
            swImpl = DCManager.getInstance().findEthSwitchBySwIp(ip);
        }
        if (swImpl == null || swImpl.getSwitchPK() == null) {
            throw new InvalidArgumentException("Cannot get switch key from IP: " + swIP);
        }
        return swImpl.getPK();
    }

    private CardDO[] getCardsBySwitch(PKIf swKey) {
        List<Card> invList = InventoryManager.getInstance().findCards(swKey);
        if (invList != null) {
            CardDO[] invDOs = new CardDO[invList.size()];
            for (int i = 0; i < invList.size(); ++i) {
                invDOs[i] = new CardDO(invList.get(i));
            }
            return invDOs;
        }
        return new CardDO[0];
    }

    private HwInventoryComponentDO[] getHwBySwitch(PKIf swKey, HwInventoryType type) {
        HwInventoryComponentDO[] hwDOs = null;
        List<HwInventoryComponent> hws = null;
        if (type == HwInventoryType.CHASSIS) {
            HwInventoryComponent hw = InventoryManager.getInstance().findChassis(swKey);
            if (hw != null) {
                hws = new ArrayList<HwInventoryComponent>();
                hws.add(hw);
            }
        } else if (type == HwInventoryType.FAN) {
            hws = InventoryManager.getInstance().findFans(swKey);
        }
        if (hws != null) {
            hwDOs = new HwInventoryComponentDO[hws.size()];
            for (int i = 0; i < hws.size(); ++i) {
                hwDOs[i] = new HwInventoryComponentDO(hws.get(i));
            }
        }
        _Logger.debug((Object)("getHwBySwitch for " + swKey + ":" + type.toString() + " returns " + (hwDOs == null ? 0 : hwDOs.length) + " HwInventoryComponents"));
        return hwDOs;
    }

    private PowerSupplyDO[] getPowerSuppliesBySwitch(PKIf swKey) {
        List<PowerSupply> invList = InventoryManager.getInstance().findPowerSupplies(swKey);
        if (invList != null) {
            PowerSupplyDO[] invDOs = new PowerSupplyDO[invList.size()];
            for (int i = 0; i < invList.size(); ++i) {
                invDOs[i] = new PowerSupplyDO(invList.get(i));
            }
            return invDOs;
        }
        return new PowerSupplyDO[0];
    }

    private LicenseInfoDO[] getLicensesBySwitch(WwnKey swKey) {
        List<LicenseInfo> invList = InventoryManager.getInstance().findLicenses(swKey);
        if (invList != null) {
            LicenseInfoDO[] invDOs = new LicenseInfoDO[invList.size()];
            for (int i = 0; i < invList.size(); ++i) {
                LicenseInfo lic = invList.get(i);
                if (lic == null) continue;
                invDOs[i] = new LicenseInfoDO(lic);
            }
            return invDOs;
        }
        return new LicenseInfoDO[0];
    }

    @Override
    @WebMethod
    @WebResult(name="result", partName="result")
    public CardDO getCardByPhysicalIndex(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey, @WebParam(name="index", partName="index") int index) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        List<Card> invList = InventoryManager.getInstance().findCards(swKey.toWwnKey());
        if (invList != null) {
            for (Card card : invList) {
                if (card.getPhysicalIndex() != index) continue;
                return new CardDO(card);
            }
        }
        throw new SanNotFoundException();
    }
}

