/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.san.ep;

import com.cisco.dcbu.jaxws.discv.wo.DiscTaskKeyDO;
import com.cisco.dcbu.jaxws.ep.AuthFailureException;
import com.cisco.dcbu.jaxws.ep.IdentityManager;
import com.cisco.dcbu.jaxws.ep.InvalidArgumentException;
import com.cisco.dcbu.jaxws.ep.InvalidCredentialException;
import com.cisco.dcbu.jaxws.ep.SanNotFoundException;
import com.cisco.dcbu.jaxws.ep.SanServiceException;
import com.cisco.dcbu.jaxws.ep.UnreachableServerException;
import com.cisco.dcbu.jaxws.ep.WSSnmpException;
import com.cisco.dcbu.jaxws.san.ep.FabricFindThread;
import com.cisco.dcbu.jaxws.san.ep.SanSEI;
import com.cisco.dcbu.jaxws.san.helper.SanHelper;
import com.cisco.dcbu.jaxws.san.helper.SnmpHelper;
import com.cisco.dcbu.jaxws.san.wo.AdminShallowDiscoverDO;
import com.cisco.dcbu.jaxws.san.wo.AliasDO;
import com.cisco.dcbu.jaxws.san.wo.CallResultDO;
import com.cisco.dcbu.jaxws.san.wo.CfsFeatureOpDO;
import com.cisco.dcbu.jaxws.san.wo.EnclosureDO;
import com.cisco.dcbu.jaxws.san.wo.EndPortDO;
import com.cisco.dcbu.jaxws.san.wo.EthPortDO;
import com.cisco.dcbu.jaxws.san.wo.EventEntityDO;
import com.cisco.dcbu.jaxws.san.wo.FabricDO;
import com.cisco.dcbu.jaxws.san.wo.FabricKeyDO;
import com.cisco.dcbu.jaxws.san.wo.FcPortCapabilitiesDO;
import com.cisco.dcbu.jaxws.san.wo.FcPortDO;
import com.cisco.dcbu.jaxws.san.wo.FcSwitchCapabilitiesDO;
import com.cisco.dcbu.jaxws.san.wo.HbaDO;
import com.cisco.dcbu.jaxws.san.wo.IndexBaseDO;
import com.cisco.dcbu.jaxws.san.wo.IslDO;
import com.cisco.dcbu.jaxws.san.wo.KeyValueDO;
import com.cisco.dcbu.jaxws.san.wo.NameKeyDO;
import com.cisco.dcbu.jaxws.san.wo.NpvLinkDO;
import com.cisco.dcbu.jaxws.san.wo.OperationStatusDO;
import com.cisco.dcbu.jaxws.san.wo.PhyInterfaceDO;
import com.cisco.dcbu.jaxws.san.wo.PmEntityBaseDO;
import com.cisco.dcbu.jaxws.san.wo.PortChannelDO;
import com.cisco.dcbu.jaxws.san.wo.SnmpCredentialDO;
import com.cisco.dcbu.jaxws.san.wo.SnmpV3AuthTypeDO;
import com.cisco.dcbu.jaxws.san.wo.SwitchDO;
import com.cisco.dcbu.jaxws.san.wo.SwitchIntKeyDO;
import com.cisco.dcbu.jaxws.san.wo.SwitchNameDO;
import com.cisco.dcbu.jaxws.san.wo.VmDO;
import com.cisco.dcbu.jaxws.san.wo.VsanDO;
import com.cisco.dcbu.jaxws.san.wo.VsanDomainCapabilitiesDO;
import com.cisco.dcbu.jaxws.san.wo.VsanDomainDO;
import com.cisco.dcbu.jaxws.san.wo.VsanKeyDO;
import com.cisco.dcbu.jaxws.san.wo.WwnDO;
import com.cisco.dcbu.jaxws.san.wo.WwnKeyDO;
import com.cisco.dcbu.jaxws.san.wo.ZoneDO;
import com.cisco.dcbu.jaxws.san.wo.ZoneMemUnitDO;
import com.cisco.dcbu.jaxws.san.wo.ZonePolicyDO;
import com.cisco.dcbu.jaxws.wo.DBEntryDO;
import com.cisco.dcbu.jaxws.wo.DBRowDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.jaxws.wo.DbRowDOComparator;
import com.cisco.dcbu.lan.webservice.client.generated.deepdiscv.DiscoveryException;
import com.cisco.dcbu.lan.webservice.client.generated.deepdiscv.LanObject;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.IpUtil;
import com.cisco.dcbu.lib.jnm.SnmpBitmap;
import com.cisco.dcbu.lib.jnm.SnmpLongList;
import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.jnm.Vsh;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.mds.flash.FileSystemModel;
import com.cisco.dcbu.lib.serviceconf.ServiceConfig;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.lib.snmp.security.UserEntry;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.IndexUtil;
import com.cisco.dcbu.lib.util.Log4jUtil;
import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.sm.common.dto.DiscoveryType;
import com.cisco.dcbu.sm.common.dto.FcPortAlias;
import com.cisco.dcbu.sm.common.dto.VsanDomain;
import com.cisco.dcbu.sm.common.event.LogEventType;
import com.cisco.dcbu.sm.common.event.PortLogEventType;
import com.cisco.dcbu.sm.common.event.Severity;
import com.cisco.dcbu.sm.common.event.SyslogEntry;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.CdpSeedBase;
import com.cisco.dcbu.sm.common.model.EndPortBase;
import com.cisco.dcbu.sm.common.model.FabricBase;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import com.cisco.dcbu.sm.common.model.Hba;
import com.cisco.dcbu.sm.common.model.IndexerBase;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.VsanBase;
import com.cisco.dcbu.sm.common.model.ZoneMemUnit;
import com.cisco.dcbu.sm.common.pm.PmEntityBase;
import com.cisco.dcbu.sm.common.rif.EMRif;
import com.cisco.dcbu.sm.common.rif.FMServerRif;
import com.cisco.dcbu.sm.common.rif.ModelFacadeRif;
import com.cisco.dcbu.sm.common.rif.PMRif;
import com.cisco.dcbu.sm.common.type.DiscStateType;
import com.cisco.dcbu.sm.common.type.DiscTaskType;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.LanPK;
import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.common.type.SwitchIntKey;
import com.cisco.dcbu.sm.common.type.TaskKey;
import com.cisco.dcbu.sm.common.type.VcenterPK;
import com.cisco.dcbu.sm.common.type.VsanPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.ServerMonitor;
import com.cisco.dcbu.sm.server.bean.SessionHelper;
import com.cisco.dcbu.sm.server.db.ClusterMapping;
import com.cisco.dcbu.sm.server.db.ClusterSequence;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.discovery.CdpDiscoveryStatusEnum;
import com.cisco.dcbu.sm.server.discovery.CdpDiscvHelper;
import com.cisco.dcbu.sm.server.discovery.CdpShallow;
import com.cisco.dcbu.sm.server.discovery.CdpWorker;
import com.cisco.dcbu.sm.server.discovery.DiscoveryManager;
import com.cisco.dcbu.sm.server.em.AlertNotifier;
import com.cisco.dcbu.sm.server.event.EmcCallHomeHandler;
import com.cisco.dcbu.sm.server.event.EventControllerService;
import com.cisco.dcbu.sm.server.event.EventEntity;
import com.cisco.dcbu.sm.server.event.EventUtil;
import com.cisco.dcbu.sm.server.facade.FMServerImpl;
import com.cisco.dcbu.sm.server.facade.FlexCliImpl;
import com.cisco.dcbu.sm.server.facade.PMImpl;
import com.cisco.dcbu.sm.server.facade.SessionImpl;
import com.cisco.dcbu.sm.server.inventory.InventoryManager;
import com.cisco.dcbu.sm.server.licmgr.LicenseManager;
import com.cisco.dcbu.sm.server.model.CdpSeedImpl;
import com.cisco.dcbu.sm.server.model.ChannelMemberIsl;
import com.cisco.dcbu.sm.server.model.ChannelMemberNpvl;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EnclosureImpl;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.GlobalDCManager;
import com.cisco.dcbu.sm.server.model.GlobalFabricManager;
import com.cisco.dcbu.sm.server.model.GlobalViManager;
import com.cisco.dcbu.sm.server.model.HostImpl;
import com.cisco.dcbu.sm.server.model.IslImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.model.NpvLinkImpl;
import com.cisco.dcbu.sm.server.model.PmExtraOidImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.VirtualCenterImpl;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import com.cisco.dcbu.sm.server.security.SecurityManager;
import com.cisco.dcbu.sm.server.security.ServerPropertyUtil;
import com.cisco.dcbu.sm.server.security.SnmpUserImpl;
import com.cisco.dcbu.sm.server.security.UserFabricImpl;
import com.cisco.dcbu.sm.server.web.ClusterProcessor;
import com.cisco.dcbu.sm.server.web.Indexer;
import com.cisco.dcbu.sm.server.web.admin.AdminServiceHandler;
import com.cisco.dcbu.sm.server.web.admin.FederationServer;
import com.cisco.dcbu.sm.server.web.admin.PerformanceHandler;
import com.cisco.dcbu.sm.server.web.inventory.EndDeviceHandler;
import com.cisco.dcbu.sm.server.web.inventory.IslHandler;
import com.cisco.dcbu.sm.server.web.inventory.SearchHandler;
import com.cisco.dcbu.sm.server.web.inventory.SwitchHandler;
import com.cisco.dcbu.sm.server.web.inventory.VsanHandler;
import com.cisco.dcbu.sm.server.web.inventory.ZoneHandler;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import com.cisco.dcbu.sm.server.web.util.WebUtil;
import com.cisco.dcbu.vi.model.ViManager;
import com.cisco.dcbu.vi.model.VirtualCenterBase;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.ws.api.annotation.EndpointConfig;
import org.jboss.ws.api.annotation.WebContext;

@SOAPBinding(style=SOAPBinding.Style.RPC, use=SOAPBinding.Use.LITERAL)
@HandlerChain(file="../../ep/fms-jaxws-handlers.xml")
@WebContext(contextRoot="/SanWSService", urlPattern="/SanWS")
@EndpointConfig(configName="Standard WSSecurity Endpoint")
@WebService(name="San", serviceName="SanService", endpointInterface="com.cisco.dcbu.jaxws.san.ep.SanSEI")
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
@Stateless
public class SanWS
implements SanSEI {
    static final String queryAllFabrics = "SELECT DISTINCT FABRIC.FID, FABRIC.NAME, FABRIC.LAST_UPDATE_TIME, SWITCH.SYS_NAME,SWITCH.IP_ADDRESS,FABRIC.IS_PERSISTENT,FABRIC.IS_MANAGEABLE,SNMPUSER.VERSION,SNMPUSER.USER_NAME,SNMPUSER.AUTH_PROTOCOL,SNMPUSER.PRIV_PROTOCOL, FABRIC.USE_GLOBAL_ALIAS, FABRIC.LICENSE_ID, FABRIC.VSANS_INCLUDED,FABRIC.VSANS_EXCLUDED, PL.IP_ADDR, PL.STATUS, SNMPUSER.AUTH_PASSWORD FROM FABRIC,SWITCH, SNMPUSER, PHYSICAL_LOGICSVR PL,LOGICSVR_FABRIC LF WHERE (FABRIC.SEED_SWITCH_ID=SWITCH.ID) AND (FABRIC.FMUSER_ID=SNMPUSER.ID) AND (FABRIC.FID = LF.F_ID) AND (LF.LSVR_ID = PL.LSVR_ID) ORDER BY FABRIC.NAME ASC";
    static final String queryEthSwitchByCdpSeedDbId_all = "select ethswitch.ip_address, ethswitch.id, ethswitch.is_manageable from ethswitch, ethswitch_seed, cdp_seed where (ethswitch.id=ethswitch_seed.switch_id) AND (ethswitch_seed.seed_id=cdp_seed.id) AND (cdp_seed.id=?)";
    static final String queryEthSwitchByCdpSeedDbId = "select ethswitch.sys_name, ethswitch.ip_address, ethswitch.is_manageable, ethswitch.is_present, ethswitch.last_scan_time, ethswitch.unmanageable_cause, ethswitch.id, ethswitch.disc_status, ethswitch.deep_desc, ethswitch.LAST_UPDATE_TIME, ethswitch.model_name, ethswitch.sys_location, ethswitch.sys_contact, ethswitch.is_fex, ethswitch.type, ethswitch.is_deep_disc, gm.mem_dbid, gm.group_id, g.name from ethswitch, ethswitch_seed, cdp_seed, nav_group_member gm, nav_groups g where (ethswitch.id=ethswitch_seed.switch_id) AND (ethswitch_seed.seed_id=cdp_seed.id) AND (cdp_seed.id=?) and gm.mem_dbid=ethswitch.id  and g.id=gm.group_id";
    static final String queryEthSwitchByCdpSeedDbId_4_FWSM = "select ethswitch.sys_name, ethswitch.ip_address, ethswitch.is_manageable, ethswitch.is_present, ethswitch.last_scan_time, ethswitch.unmanageable_cause, ethswitch.id, ethswitch.disc_status, ethswitch.deep_desc, ethswitch.LAST_UPDATE_TIME, ethswitch.model_name, ethswitch.sys_location, ethswitch.sys_contact, ethswitch.is_fex, ethswitch.type, ethswitch.is_deep_disc from ethswitch, ethswitch_seed, cdp_seed where (ethswitch.id=ethswitch_seed.switch_id) AND (ethswitch_seed.seed_id=cdp_seed.id) AND (cdp_seed.id=?) ";
    static final String queryEthSwitchByLan = "select ethswitch.sys_name, ethswitch.ip_address, ethswitch.is_manageable, ethswitch.is_present, ethswitch.last_scan_time, ethswitch.unmanageable_cause, ethswitch.id, ethswitch.disc_status, ethswitch.deep_desc, ethswitch.LAST_UPDATE_TIME, ethswitch.model_name, ethswitch.sys_location, ethswitch.sys_contact, ethswitch.is_fex, ethswitch.type, ethswitch.is_deep_disc, gm.mem_dbid, gm.group_id, g.name, cdp_seed.id from ethswitch, ethswitch_seed, cdp_seed, nav_group_member gm, nav_groups g, lan l where (ethswitch.id=ethswitch_seed.switch_id) AND (ethswitch_seed.seed_id=cdp_seed.id) AND l.id=cdp_seed.lan_id AND l.lan_id=? and gm.mem_dbid=ethswitch.id  and g.id=gm.group_id";
    static final String queryEthSwitchByLan_4_FWSM = "select ethswitch.sys_name, ethswitch.ip_address, ethswitch.is_manageable, ethswitch.is_present, ethswitch.last_scan_time, ethswitch.unmanageable_cause, ethswitch.id, ethswitch.disc_status, ethswitch.deep_desc, ethswitch.LAST_UPDATE_TIME, ethswitch.model_name, ethswitch.sys_location, ethswitch.sys_contact, ethswitch.is_fex, ethswitch.type, ethswitch.is_deep_disc, cdp_seed.id from ethswitch, ethswitch_seed, cdp_seed, lan l where (ethswitch.id=ethswitch_seed.switch_id) AND (ethswitch_seed.seed_id=cdp_seed.id) AND (cdp_seed.FWSM=true) AND l.id=cdp_seed.lan_id AND l.lan_id=? ";
    static final String SQL_Query_CdpSeedsByLanId = "select cs.id, cs.lan_id, cs.inet_addr, cs.ip_range, cs.subnet, cs.mask, cs.cred_id, cs.max_hops, cs.last_update_time, cs.serial_number, cs.platform, cs.seed_type, cs.disc_state, cs.ip_list, cs.group_id, cs.create_time, cs.enable_pwd, cs.deep_taskid, cs.deep_updatetime, cs.manageable, cs.deep_desc, cs.FWSM, p.ip_addr, p.status from cdp_seed cs, lan l, physical_logicsvr p, logicsvr_fabric lf where l.lan_id=lf.f_id and lf.lsvr_id=p.lsvr_id and l.id=cs.lan_id and l.lan_id=?";
    static final String queryEthSwIPByEthSwId = "select ethswitch.ip_address, ethswitch.is_manageable from ethswitch where ethswitch.id=?";
    static final String queryEthSwitch4DeepDiscovery = "select ethswitch.id, ethswitch.sys_name, ethswitch.is_deep_disc, ethswitch.is_manageable, ethswitch.is_fex, ethswitch.type from ethswitch where ethswitch.id in (";
    static final String queryTask = "select cdp_seed.cred_id, cdp_seed.manageable from cdp_seed where cdp_seed.id=?";
    static String fedQuery = "select p.lsvr_id, p.IP_ADDR, p.STATUS from PHYSICAL_LOGICSVR p";
    static Logger logger = LogManager.getLogger((String)"fms.ws");
    private DiscoveryManager discovery = DiscoveryManager.getInstance();
    static final int DISC_TIMEOUT = 2;
    public static final String EMAIL = "E-Mail";
    public static final int TRAP_FORWARD = 1;
    public static final int EMAIL_FORWARD = 2;
    public static final String EVENTLOGALL_PROPERTIES = "events.log.all";

    @Override
    @WebMethod
    @Deprecated
    public FabricDO[] getFabrics() throws SanServiceException, SanNotFoundException {
        try {
            FabricDO[] ret = null;
            Object[] fabs = SanManager.getInstance().getFabrics();
            if (fabs == null) {
                throw new SanNotFoundException("Fabric Not Found");
            }
            if (fabs != null && fabs.length > 0) {
                Arrays.sort(fabs);
            }
            ret = new FabricDO[fabs.length];
            for (int i = 0; i < fabs.length; ++i) {
                FabricDO fab;
                ret[i] = fab = new FabricDO((FabricImpl)fabs[i]);
            }
            if (ret.length == 0) {
                return new FabricDO[0];
            }
            return ret;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getFabrics():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getFabrics():", e);
            throw new SanServiceException("Cannot get fabrics", e);
        }
    }

    @Override
    @WebMethod
    @Deprecated
    public FabricDO getFabricByIP(String ipAddress) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            InetAddress ip = InetAddress.getByName(ipAddress);
            if (ip == null) {
                throw new InvalidArgumentException("Invalid IP Address:" + ipAddress);
            }
            FabricImpl fab = SanManager.getInstance().findFabric(ip);
            if (fab == null) {
                throw new SanNotFoundException("Fabrc Not Found by IP");
            }
            FabricBase base = fab.getFabricBase(new short[0]);
            if (base == null) {
                throw new SanNotFoundException("Fabrc Base Not Found");
            }
            FabricDO fabric = new FabricDO(base);
            return fabric;
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getFabricsByIP():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getFabricsByIP():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getFabricsByIP():", e);
            throw new SanServiceException("Cannot get fabric by ip:" + ipAddress, e);
        }
    }

    @Override
    @WebMethod
    public IndexBaseDO[] search(String queryField, String queryValue) throws SanServiceException, InvalidArgumentException {
        try {
            Map<Integer, List<IndexerBase>> searchResultsMap = Indexer.getInstance().search(queryField, queryValue);
            ArrayList<IndexerBase> totalList = new ArrayList<IndexerBase>();
            for (Integer category : searchResultsMap.keySet()) {
                List<IndexerBase> bases = searchResultsMap.get(category);
                totalList.addAll(bases);
            }
            IndexBaseDO[] results = new IndexBaseDO[totalList.size()];
            for (int i = 0; i < totalList.size(); ++i) {
                results[i] = new IndexBaseDO((IndexerBase)totalList.get(i));
            }
            return results;
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in search():", (Throwable)e);
            return new IndexBaseDO[]{new IndexBaseDO(e.getMessage())};
        }
        catch (SanServiceException e) {
            logger.warn((Object)"SanWS caught exception in search():", (Throwable)e);
            return new IndexBaseDO[]{new IndexBaseDO(e.getMessage())};
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in search():", e);
            return new IndexBaseDO[]{new IndexBaseDO(e.getMessage())};
        }
    }

    @Override
    @WebMethod
    public PmEntityBaseDO getPmEntity(String id, String dstId, String name, int type) throws SanServiceException, InvalidArgumentException {
        try {
            PmEntityBase base = PMImpl.getInstance().getPmEntity(id, dstId, type, name);
            return new PmEntityBaseDO(base);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getPmRecord():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getPmRecord():", e);
            throw new SanServiceException("SanWS caught exception in getPmRecord():" + e.getMessage());
        }
    }

    @Override
    @WebMethod
    public EventEntityDO getEvtEntity(String id) throws SanServiceException, InvalidArgumentException {
        try {
            EventEntity base = EventUtil.getInstance().getEvtEntity(Long.parseLong(id));
            return new EventEntityDO(base);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getEvtEntity():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getEvtEntity():", e);
            throw new SanServiceException("SanWS caught exception in getEvtEntity():" + e.getMessage());
        }
    }

    @Override
    @WebMethod
    public double[][] getPmChartData(String rrdFile, int pmType, int fid) throws SanServiceException, InvalidArgumentException {
        try {
            if (rrdFile == null) {
                throw new InvalidArgumentException();
            }
            PMRif pmRif = ClusterProcessor.getInstance().getPMByPK(new FabricPK(fid));
            return pmRif.getPmChartData(rrdFile, pmType);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getPmChartData():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getPmChartData():", e);
            throw new SanServiceException("SanWS caught exception in getPmChartData():" + e.getMessage());
        }
    }

    @Override
    @WebMethod
    public FabricDO getFabricByKey(FabricKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid fabric key:" + key);
            }
            FabricImpl fab = SanManager.getInstance().findFabric(key.toDomain());
            if (fab == null) {
                throw new SanNotFoundException("Cannot find fabric by fabric key");
            }
            FabricBase base = fab.getFabricBase(new short[0]);
            if (base == null) {
                throw new SanNotFoundException("Cannot find fabric base");
            }
            FabricDO fabric = new FabricDO(base);
            SwitchImpl sw = fab.getSeed();
            if (sw != null) {
                fabric.setSeedSwName(sw.toString());
            }
            return fabric;
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getFabricsByKey():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getFabricsByKey():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getFabricsByKey():", e);
            throw new SanServiceException("Cannot get fabric by fabric key:" + key, e);
        }
    }

    @Override
    @WebMethod
    public FabricDO getFabricBySwitchKey(WwnKeyDO swKey) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (swKey == null) {
                throw new InvalidArgumentException("Invalid switch key:" + swKey);
            }
            FabricImpl fab = SanManager.getInstance().findFabricBySwitchPK(swKey.toWwnKey(), null);
            if (fab == null) {
                throw new SanNotFoundException("Cannot find fabric by seed swkey");
            }
            FabricDO fabric = new FabricDO(fab.getFabricBase(new short[0]));
            return fabric;
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getFabricBySwitchKey():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getFabricBySwitchKey():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getFabricBySwitchKey():", e);
            throw new SanServiceException("Cannot get fabric by switch key" + swKey, e);
        }
    }

    @Override
    @WebMethod
    public SwitchDO[] getSwitchesByFabric(FabricKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid fabric key:" + key);
            }
            SwitchDO[] ret = null;
            FabricPK pk = new FabricPK(key.getFid());
            SwitchImpl[] sw = SanManager.getInstance().getSwitchesForFabric(pk);
            if (sw == null) {
                throw new SanNotFoundException("Swithces Not Found By Fabric");
            }
            ret = new SwitchDO[sw.length];
            for (int i = 0; i < sw.length; ++i) {
                ret[i] = new SwitchDO(sw[i]);
            }
            if (ret == null) {
                return new SwitchDO[0];
            }
            return ret;
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getSwitchesByFabric():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getFabricBySwitchKey():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getSwitchesByFabric():", e);
            throw new SanServiceException("Cannot get fabric by fabric key:" + key, e);
        }
    }

    @Override
    @WebMethod
    public SwitchDO[] getNeighborSwitches(WwnKeyDO swKey, FabricKeyDO fKey) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (swKey == null) {
                throw new InvalidArgumentException("Invalid switch key:" + swKey);
            }
            SwitchImpl swImpl = SanManager.getInstance().findSwitch(swKey.toWwnKey(), new FabricPK(fKey.getFid()));
            if (swImpl == null) {
                throw new SanNotFoundException("Cannot find switch by swkey:" + swKey);
            }
            SwitchImpl[] aSwitches = SanManager.getInstance().findAttachedSwitches(swImpl);
            if (aSwitches == null) {
                return new SwitchDO[0];
            }
            return SwitchDO.clone(aSwitches);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getNeighborSwitches():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getNeighborSwitches():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getNeighborSwitches():", e);
            throw new SanServiceException("Cannot get neightbor switches by switch key:" + swKey, e);
        }
    }

    @Override
    @WebMethod
    public SwitchNameDO[] getAllLanSwitchesForLanID(long lid) throws SanServiceException {
        try {
            ArrayList<SwitchDO> swLst = SwitchHandler.getInstance().getLanSwitchList(lid);
            Collections.sort(swLst);
            SwitchDO[] swDo = swLst.toArray(new SwitchDO[swLst.size()]);
            if (swDo != null) {
                SwitchNameDO[] swNmDO = new SwitchNameDO[swDo.length];
                for (int i = 0; i < swDo.length; ++i) {
                    swNmDO[i] = new SwitchNameDO();
                    swNmDO[i].name = swDo[i].getLogicalName();
                    swNmDO[i].ipAddress = swDo[i].getIpAddress();
                    swNmDO[i].isLicensed = !swDo[i].isLicenseViolation();
                    swNmDO[i].isManageble = swDo[i].isManagable();
                    WwnDO swWWN = swDo[i].getWwn();
                    swNmDO[i].wwn = swWWN == null || swWWN.toString().trim().length() == 0 ? new byte[]{} : swWWN.toWwn().getValue();
                    swNmDO[i].isMds = swDo[i].getModel().toUpperCase().indexOf("DS") != -1;
                    swNmDO[i].colId = lid;
                    List<CdpSeedBase> cdpSeeds = GlobalDCManager.getInstance().getCdpSeedsByLanPK(new LanPK((int)lid));
                    swNmDO[i].isV3 = cdpSeeds.size() > 0 ? cdpSeeds.get(0).isSnmpV3() : false;
                    swNmDO[i].isLanSwitch = true;
                    swNmDO[i].isCat = swDo[i].getModel().toUpperCase().indexOf("N7") == -1 && swDo[i].getModel().toUpperCase().indexOf("N5") == -1 && swDo[i].getModel().toUpperCase().indexOf("DS") == -1 && swDo[i].getModel().toUpperCase().indexOf("N2") == -1 && swDo[i].getModel().toUpperCase().indexOf("N4") == -1;
                }
                return swNmDO;
            }
            return new SwitchNameDO[0];
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getAllLanSwitchesForLanID():", e);
            throw new SanServiceException("Cannot get all switches for Lan", e);
        }
    }

    @Override
    @WebMethod
    public SwitchNameDO[] getAllLanSwitchesForGroupID(long gid) throws SanServiceException {
        try {
            return SwitchHandler.getInstance().getAllLanSwitchesForGroupID(gid);
        }
        catch (Exception ex) {
            throw new SanServiceException(ex.getMessage());
        }
    }

    @Override
    @WebMethod
    public SwitchNameDO[] getAllMdsQuailSwitchesForFabricID(int fid, boolean showQuail, boolean manageble) throws SanServiceException {
        try {
            ArrayList<SwitchNameDO> swLst = new ArrayList<SwitchNameDO>();
            List<SwitchNameDO> swAll = SwitchHandler.getInstance().getAllSwitches();
            for (int i = 0; i < swAll.size(); ++i) {
                SwitchNameDO sw = swAll.get(i);
                if (fid > 0 && (long)fid != sw.colId || manageble && !sw.isManageble || !sw.isMds || !showQuail && sw.type == 514) continue;
                swLst.add(sw);
            }
            Collections.sort(swLst);
            return swLst.toArray(new SwitchNameDO[swLst.size()]);
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getSwitches():", e);
            throw new SanServiceException("Cannot get all switches", e);
        }
    }

    @Override
    @WebMethod
    public SwitchNameDO[] getAllManagebleMdsQuailSwitchesForFabricDBID(long fDbid, boolean showQuail) throws SanServiceException {
        try {
            ArrayList<SwitchNameDO> swLst = new ArrayList<SwitchNameDO>();
            List<SwitchNameDO> swAll = SwitchHandler.getInstance().getAllSwitches();
            for (int i = 0; i < swAll.size(); ++i) {
                SwitchNameDO sw = swAll.get(i);
                if (fDbid > 0L && fDbid != sw.colDBId || !sw.isManageble || !sw.isMds || !showQuail && sw.type == 514) continue;
                swLst.add(sw);
            }
            Collections.sort(swLst);
            return swLst.toArray(new SwitchNameDO[swLst.size()]);
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getSwitches():", e);
            throw new SanServiceException("Cannot get all switches", e);
        }
    }

    @Override
    @WebMethod
    public SwitchNameDO[] getAllManagebleMdsQuailSwitchesForFabricID(int fid, boolean showQuail) throws SanServiceException {
        try {
            ArrayList<SwitchNameDO> swLst = new ArrayList<SwitchNameDO>();
            List<SwitchNameDO> swAll = SwitchHandler.getInstance().getAllSwitches();
            for (int i = 0; i < swAll.size(); ++i) {
                SwitchNameDO sw = swAll.get(i);
                if (fid > 0 && (long)fid != sw.colId || !sw.isManageble || !sw.isMds || !showQuail && sw.type == 514) continue;
                swLst.add(sw);
            }
            Collections.sort(swLst);
            return swLst.toArray(new SwitchNameDO[swLst.size()]);
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getSwitches():", e);
            throw new SanServiceException("Cannot get all switches", e);
        }
    }

    @Override
    @WebMethod
    public SwitchNameDO[] getAllManagebleMdsQuailSwitches(FabricKeyDO key, boolean showQuail) throws SanServiceException {
        try {
            ArrayList<SwitchNameDO> swLst = new ArrayList<SwitchNameDO>();
            if (key != null) {
                FabricPK pk = new FabricPK(key.getFid());
                SwitchImpl[] switches = SanManager.getInstance().getSwitchesForFabric(pk);
                for (int i = 0; i < switches.length; ++i) {
                    if (switches[i].getIpAddress() == null || switches[i].getIpAddress().length() == 0 || !showQuail && switches[i].isQuail()) continue;
                    SwitchNameDO swdo = new SwitchNameDO(switches[i].getSysName(), switches[i].getIpAddress(), switches[i].getModelType());
                    swdo.wwn = switches[i].getWwn().getValue();
                    swdo.isMds = switches[i].isMDS();
                    swdo.colId = key.getFid();
                    swdo.isManageble = switches[i].isManageable();
                    swdo.isV3 = swdo.isManageble && switches[i].getPeer() != null ? switches[i].getPeer().isV3() : false;
                    swLst.add(swdo);
                }
            } else {
                List<SwitchNameDO> swAll = SwitchHandler.getInstance().getAllSwitches();
                for (int i = 0; i < swAll.size(); ++i) {
                    SwitchNameDO sw = swAll.get(i);
                    if (!sw.isManageble || !sw.isMds || !showQuail && sw.type == 514) continue;
                    swLst.add(sw);
                }
            }
            Collections.sort(swLst);
            return swLst.toArray(new SwitchNameDO[swLst.size()]);
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getSwitches():", e);
            throw new SanServiceException("Cannot get all switches", e);
        }
    }

    @Override
    @WebMethod
    public SwitchNameDO[] getAllSanLanManagebleSwitches() throws SanServiceException {
        try {
            ArrayList<SwitchNameDO> swLst = new ArrayList<SwitchNameDO>();
            List<SwitchNameDO> swAll = SwitchHandler.getInstance().getAllSwitches();
            for (int i = 0; i < swAll.size(); ++i) {
                SwitchNameDO sw = swAll.get(i);
                if (!sw.isManageble || !sw.isMds && !sw.isLanSwitch && !sw.isN2K && !sw.isN5KLan && !sw.isN7KLan || sw.ipAddress == null || swLst.contains(sw)) continue;
                swLst.add(sw);
            }
            Collections.sort(swLst);
            return swLst.toArray(new SwitchNameDO[swLst.size()]);
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getSwitches():", e);
            throw new SanServiceException("Cannot get all switches", e);
        }
    }

    @Override
    @WebMethod
    public SwitchNameDO[] getManagebleMdsSwitches() throws SanServiceException {
        return this.getAllManagebleMdsQuailSwitches(null, false);
    }

    @Override
    @WebMethod
    public SwitchNameDO[] getSwitches() throws SanServiceException {
        try {
            List<SwitchNameDO> swLst = SwitchHandler.getInstance().getAllSwitches();
            return swLst.toArray(new SwitchNameDO[swLst.size()]);
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getSwitches():", e);
            throw new SanServiceException("Cannot get all switches", e);
        }
    }

    @Override
    @WebMethod
    public SwitchDO getSwitchByKey(WwnKeyDO swKey) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (swKey == null) {
                throw new InvalidArgumentException("Invalid switch key:" + swKey);
            }
            WwnKey wwn = swKey.toWwnKey();
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            if (sw == null) {
                throw new SanNotFoundException("Cannot find switch by swkey");
            }
            SwitchDO dto = new SwitchDO(sw);
            return dto;
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getSwitchByKey():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getSwitchByKey():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getSwitchByKey():", e);
            throw new SanServiceException("Cannot get switch by switch key:" + swKey, e);
        }
    }

    @Override
    @WebMethod
    public SwitchDO getSwitchByFabric(WwnKeyDO swKey, int fid) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (swKey == null) {
                throw new InvalidArgumentException("Invalid switch key:" + swKey);
            }
            WwnKey wwn = swKey.toWwnKey();
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey(), fid);
            if (sw == null) {
                throw new SanNotFoundException("Cannot find switch by fabric");
            }
            SwitchDO dto = new SwitchDO(sw);
            return dto;
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getSwitchByKey():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getSwitchByKey():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getSwitchByKey():", e);
            throw new SanServiceException("Cannot get switch by switch key:" + swKey, e);
        }
    }

    @Override
    @WebMethod
    public SwitchDO getSwitchByDbId(long swDbId, long fid, boolean isLan) throws SanServiceException, InvalidArgumentException {
        try {
            if (swDbId < 1L) {
                throw new InvalidArgumentException("Invalid switch key:" + swDbId);
            }
            if (isLan) {
                ArrayList<SwitchDO> switchList = SwitchHandler.getInstance().getLanSwitchList(swDbId, fid);
                return switchList.get(0);
            }
            ArrayList<SwitchDO> switchList = SwitchHandler.getInstance().getSwitchList(swDbId, fid);
            return switchList.get(0);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getSwitchByDbId():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getSwitchByDbId():", e);
            throw new SanServiceException("Cannot get switch by switch key:" + swDbId, e);
        }
    }

    @Override
    @WebMethod
    @Deprecated
    public String getSwitchIPByName(String sysName) throws SanServiceException, SanNotFoundException {
        try {
            String ip = SanManager.getInstance().findSwitchIpBySysName(sysName);
            if (ip != null) {
                return ip;
            }
            throw new SanNotFoundException("Couldn't get switchip by name");
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getSwitchIPByName():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getSwitchIPByName():", e);
            throw new SanServiceException("Cannot get switch IP by switch name:" + sysName, e);
        }
    }

    @Override
    @WebMethod
    @Deprecated
    public String getSwitchIPByKey(WwnKeyDO swKey) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (swKey == null) {
                throw new InvalidArgumentException("Invalid switch key:" + swKey);
            }
            FabricPK fPk = SanHelper.findFabricBySwitch(swKey.toWwnKey());
            String ip = SanManager.getInstance().findSwitchIpByPK(swKey.toWwnKey(), fPk);
            if (ip != null) {
                return ip;
            }
            throw new SanNotFoundException("Couldn't get switchip by key");
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getSwitchIPByKey():", (Throwable)e);
            throw e;
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getSwitchIPByKey():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getSwitchIPByKey():", e);
            throw new SanServiceException("Cannot get switch IP by switch key:" + swKey, e);
        }
    }

    @Override
    @WebMethod
    public VsanDO[] getVsans(FabricKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid fabric key:" + key);
            }
            FabricImpl fabric = SanManager.getInstance().findFabric(new FabricPK(key.getFid()));
            if (fabric == null) {
                throw new SanNotFoundException("Cannot find fabric by fabric key");
            }
            VsanImpl[] vsans = fabric.getVsans();
            if (vsans == null) {
                throw new SanNotFoundException(" Cannot find vsan for the given fabric");
            }
            VsanDO[] ret = new VsanDO[vsans.length];
            for (int i = 0; i < vsans.length; ++i) {
                ret[i] = new VsanDO((VsanBase)vsans[i].getBaseObject());
            }
            if (ret == null) {
                return new VsanDO[0];
            }
            return ret;
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getVsans():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getVsans():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getVsans():", e);
            throw new SanServiceException("Cannot get vsans by fabric key:" + key, e);
        }
    }

    @Override
    @WebMethod
    public VsanDO getVsan(VsanKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid vsan key:" + key);
            }
            VsanImpl vs = SanManager.getInstance().findVsan(key.toVsanPK());
            if (vs == null) {
                throw new SanNotFoundException("Cannot find vsan by vsan key");
            }
            VsanDO vsan = new VsanDO((VsanBase)vs.getBaseObject());
            return vsan;
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getVsan():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getVsan():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getVsan():", e);
            throw new SanServiceException("Cannot get vsan by vsan key:" + key, e);
        }
    }

    @Override
    @WebMethod
    public VsanDO getVsanByDbId(long vsanDbId) throws SanServiceException, InvalidArgumentException {
        try {
            if (vsanDbId < 1L) {
                throw new InvalidArgumentException("Invalid vsan key:" + vsanDbId);
            }
            ArrayList<VsanDO> switchList = VsanHandler.getInstance().getVsanList(vsanDbId);
            return switchList.get(0);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getVsanByDbId():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getVsanByDbId():", e);
            throw new SanServiceException("Cannot get vsan by vsan dbid:" + vsanDbId, e);
        }
    }

    @Override
    @WebMethod
    public IslDO getIslByDbId(long islDbId) throws SanServiceException, InvalidArgumentException {
        try {
            if (islDbId < 1L) {
                throw new InvalidArgumentException("Invalid isl key:" + islDbId);
            }
            ArrayList<IslDO> switchList = IslHandler.getInstance().getIslList(islDbId);
            return switchList.get(0);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getIslByDbId():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getIslByDbId():", e);
            throw new SanServiceException("Cannot get isl by isl dbid:" + islDbId, e);
        }
    }

    @Override
    @WebMethod
    public ZoneDO getZoneByDbId(long zoneDbId) throws SanServiceException, InvalidArgumentException {
        try {
            if (zoneDbId < 1L) {
                throw new InvalidArgumentException("Invalid zone key:" + zoneDbId);
            }
            ArrayList<ZoneDO> switchList = ZoneHandler.getInstance().getZoneList(zoneDbId, false);
            return switchList.get(0);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getZoneByDbId():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getZoneByDbId():", e);
            throw new SanServiceException("Cannot get zone by zone dbid:" + zoneDbId, e);
        }
    }

    @Override
    @WebMethod
    public ZoneDO[] getZoneListByZoneNameAndParentId(String zoneName, long parentID, boolean isivr) throws SanServiceException, InvalidArgumentException {
        try {
            if (parentID < 1L) {
                throw new InvalidArgumentException("Invalid zone parent DB ID:" + parentID);
            }
            ArrayList<ZoneDO> zoneList = ZoneHandler.getInstance().getZoneListByZoneNameAndParentId(zoneName, parentID, isivr);
            ZoneDO[] retDO = new ZoneDO[zoneList.size()];
            for (int i = 0; i < zoneList.size(); ++i) {
                retDO[i] = zoneList.get(i);
            }
            if (retDO == null) {
                return new ZoneDO[0];
            }
            return retDO;
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getZoneListByZoneNameAndParentId():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getZoneListByZoneNameAndParentId():", e);
            throw new SanServiceException("Cannot get zone by zone name:" + zoneName + ",and parentID:" + parentID, e);
        }
    }

    @Override
    @WebMethod
    public SwitchDO getSwitch(WwnDO wwn) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (wwn == null) {
                throw new InvalidArgumentException("Invalid switch wwn:" + wwn);
            }
            WwnKey wwnKey = new WwnKey(wwn.toWwn());
            SwitchImpl sw = SanHelper.findSwitch(wwnKey);
            if (sw == null) {
                throw new SanNotFoundException("Cannot find switch by switch wwn");
            }
            return new SwitchDO(sw);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getSwitch():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getSwitch:", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getSwitch:", e);
            throw new SanServiceException("Cannot get switch by switch wwn:" + wwn, e);
        }
    }

    @Override
    @WebMethod
    @Deprecated
    public IslDO getIsl(WwnDO key, int ifindex, int fid) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid switch wwn:" + key);
            }
            SwitchImpl swImpl = SanManager.getInstance().findSwitch(key.toWwn(), new FabricPK(fid));
            FabricImpl fImpl = swImpl.getFabric();
            IslImpl islImpl = fImpl.findIsl(swImpl, ifindex);
            if (islImpl != null) {
                return new IslDO(islImpl);
            }
            throw new SanNotFoundException("Unable to find isls");
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getIsl():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getIsl:", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getIsl():", e);
            throw new SanServiceException("Cannot get Isl:", e);
        }
    }

    @Override
    @WebMethod
    public IslDO[] getIsls(VsanKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid vsan key:" + key);
            }
            VsanImpl vsan = SanManager.getInstance().findVsan(key.toVsanPK());
            if (vsan == null) {
                throw new SanNotFoundException("Cannot find vsan by vsan key");
            }
            List<IslImpl> iList = vsan.getIsls();
            if (iList == null || iList.size() == 0) {
                throw new SanNotFoundException("Cannot get isls for vsan");
            }
            IslDO[] isls = new IslDO[iList.size()];
            Iterator<IslImpl> itr = iList.iterator();
            int cnt = 0;
            while (itr.hasNext()) {
                IslDO isl;
                isls[cnt] = isl = new IslDO(itr.next());
                ++cnt;
            }
            if (isls == null) {
                return new IslDO[0];
            }
            return isls;
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getIsls():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getIsls():", (Throwable)e);
            throw new SanServiceException("Cannot get Isls by vsan key:" + key, e);
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getIsls():", e);
            throw new SanServiceException("Cannot get Isls by vsan key:" + key, e);
        }
    }

    @Override
    @WebMethod
    public IslDO[] getIslsWithPCMembers(VsanKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid vsan key:" + key);
            }
            VsanImpl vsan = SanManager.getInstance().findVsan(key.toVsanPK());
            if (vsan == null) {
                throw new SanNotFoundException("Cannot find vsan by vsan key");
            }
            List<IslImpl> iList = vsan.getIsls();
            if (iList == null || iList.size() == 0) {
                throw new SanNotFoundException("Cannot get isls for vsan");
            }
            ArrayList<IslDO> retList = new ArrayList<IslDO>();
            for (IslImpl islImpl : iList) {
                IslDO isl = new IslDO(islImpl);
                if (islImpl.isPortChannel()) {
                    List<ChannelMemberIsl> memList = islImpl.getPCMemberLinks();
                    int cnt = 0;
                    IslDO[] isls = new IslDO[memList.size()];
                    for (ChannelMemberIsl channelMemberIsl : memList) {
                        isls[cnt] = new IslDO(channelMemberIsl);
                        ++cnt;
                    }
                    isl.setMemberIsl(isls);
                }
                retList.add(isl);
            }
            if (retList.size() == 0) {
                return new IslDO[0];
            }
            return retList.toArray(new IslDO[0]);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getIsls():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getIsls():", (Throwable)e);
            throw new SanServiceException("Cannot get Isls by vsan key:" + key, e);
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getIsls():", e);
            throw new SanServiceException("Cannot get Isls by vsan key:" + key, e);
        }
    }

    @Override
    @WebMethod(operationName="purgeFabric")
    @WebResult(name="result", partName="result")
    public CallResultDO purgeFabric(FabricKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            logger.info((Object)("SanWS purgeFabric... key " + key));
            if (key == null) {
                throw new InvalidArgumentException("Invalid fabric key:" + key);
            }
            FabricImpl fabric = SanManager.getInstance().findFabric(key.toDomain());
            if (fabric == null) {
                throw new SanNotFoundException("Cannot find fabric by fabric key:" + key);
            }
            logger.info((Object)"SanWS purgeFabric, calling purgeAll()...");
            fabric.purgeAll();
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in purgeFabric():", (Throwable)e);
            return new CallResultDO(1, "Failed to purge Fabric " + key + ": " + e.getMessage());
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in purgeFabric():", (Throwable)e);
            return new CallResultDO(1, "Failed to purge Fabric " + key + ": " + e.getMessage());
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in purgeFabric():", e);
            return new CallResultDO(1, "Failed to purge Fabric " + key + ": " + e.getMessage());
        }
        logger.info((Object)"SanWS purgeFabric, DONE");
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="purgeLanDownElements")
    @WebResult(name="result", partName="result")
    public CallResultDO purgeLanDownElements(FabricKeyDO key, String serverIpaddress) throws SanServiceException {
        try {
            logger.info((Object)("SanWS purgeLanDownElements... key/server " + key + "/" + serverIpaddress));
            if (key == null) {
                LanImpl lan = DCManager.getInstance().getLan();
                if (lan == null) {
                    logger.warn((Object)("LAN purge failed, key null, lan empty, server: " + serverIpaddress));
                    return new CallResultDO(1, "Failed to purge LAN, no LAN on server " + serverIpaddress);
                }
                lan.purgeAllDowns();
            } else {
                long systime = FMServerImpl.getInstance().getServerTime();
                String userName = IdentityManager.getInstance().getCurrentUsername();
                LanPK pk = new LanPK(key.getFid());
                FMServerImpl.getInstance().purgeLanDowns(pk, SecurityManager.getSSOToken(userName, systime));
            }
        }
        catch (Exception e) {
            logger.warn((Object)"SanWS caught exception in purgeLanDownElements():", (Throwable)e);
            logger.warn((Object)("LAN purge failed, key/server: " + key + "/" + serverIpaddress), (Throwable)e);
            return new CallResultDO(1, "Failed to purge LAN on server " + serverIpaddress + ": " + e.getMessage());
        }
        logger.info((Object)"SanWS purgeLanDownElements, DONE");
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="discoverFabricInVsanWithServer")
    @WebResult(name="result", partName="result")
    public CallResultDO discoverFabricInVsanWithServer(String seed, SnmpCredentialDO userCredential, String vsans, String serverIpaddress, String globalEnableNpvDiscovery) throws SanServiceException, InvalidArgumentException, InvalidCredentialException, AuthFailureException {
        byte[] b = null;
        try {
            String vsanInput = SnmpLongList.toSortedString(vsans);
            b = SnmpBitmap.parse(vsanInput);
        }
        catch (Exception ex) {
            return new CallResultDO(1, "Invalid Vsans");
        }
        int[] vsanList = SnmpBitmap.valueOf(b, false);
        if (vsanList.length == 0) {
            return new CallResultDO(1, "Invalid Vsans");
        }
        return this.discoverFabricInVsan(seed, userCredential, vsanList, globalEnableNpvDiscovery);
    }

    @Override
    @WebMethod(operationName="discoverFabricInVsan")
    @WebResult(name="result", partName="result")
    public CallResultDO discoverFabricInVsan(String seed, SnmpCredentialDO userCredential, int[] vsans, String globalEnableNpvDiscovery) throws SanServiceException, InvalidArgumentException, InvalidCredentialException, AuthFailureException {
        return this.discoverFabric(seed, userCredential, vsans, null, false, globalEnableNpvDiscovery);
    }

    @Override
    @WebMethod(operationName="discoverFabricNotInVsanWithServer")
    @WebResult(name="result", partName="result")
    public CallResultDO discoverFabricNotInVsanWithServer(String seed, SnmpCredentialDO userCredential, String vsans, String serverIpaddress, String globalEnableNpvDiscovery) throws SanServiceException, InvalidArgumentException, InvalidCredentialException, AuthFailureException {
        byte[] b = null;
        try {
            String vsanInput = SnmpLongList.toSortedString(vsans);
            b = SnmpBitmap.parse(vsanInput);
        }
        catch (SnmpException ex) {
            throw new InvalidArgumentException(ex.toString());
        }
        int[] vsanList = SnmpBitmap.valueOf(b, false);
        if (vsanList.length == 0) {
            return new CallResultDO(1, "Invalid Vsans");
        }
        return this.discoverFabricNotInVsan(seed, userCredential, vsanList, globalEnableNpvDiscovery);
    }

    @Override
    @WebMethod(operationName="discoverFabricNotInVsan")
    @WebResult(name="result", partName="result")
    public CallResultDO discoverFabricNotInVsan(String seed, SnmpCredentialDO userCredential, int[] vsans, String globalEnableNpvDiscovery) throws SanServiceException, InvalidArgumentException, InvalidCredentialException, AuthFailureException {
        return this.discoverFabric(seed, userCredential, null, vsans, false, globalEnableNpvDiscovery);
    }

    @Override
    @WebMethod(operationName="discoverFabricWithServer")
    @WebResult(name="result", partName="result")
    public CallResultDO discoverFabricWithServer(String seed, SnmpCredentialDO userCredential, String serverIpaddress, String globalEnableNpvDiscovery) throws SanServiceException, InvalidArgumentException, InvalidCredentialException, AuthFailureException {
        return this.discoverFabric(seed, userCredential, null, null, false, globalEnableNpvDiscovery);
    }

    @Override
    @WebMethod(operationName="discoverFabric")
    @WebResult(name="result", partName="result")
    public CallResultDO discoverFabric(String seed, SnmpCredentialDO userCredential, String globalEnableNpvDiscovery) throws SanServiceException, InvalidArgumentException, InvalidCredentialException, AuthFailureException {
        return this.discoverFabric(seed, userCredential, null, null, false, globalEnableNpvDiscovery);
    }

    @Override
    @WebMethod
    public CallResultDO discoverFabricWithBrocade(String seed, SnmpCredentialDO userCredential, String globalEnableNpvDiscovery) throws SanServiceException, InvalidArgumentException, InvalidCredentialException, AuthFailureException {
        return this.discoverFabric(seed, userCredential, null, null, true, globalEnableNpvDiscovery);
    }

    private CallResultDO discoverFabric(String seed, SnmpCredentialDO userCredential, int[] inVsans, int[] exVsans, boolean brocadeSeed, String globalEnableNpvDiscovery) throws SanServiceException, InvalidArgumentException, InvalidCredentialException, AuthFailureException {
        int i;
        StringBuffer sb;
        logger.info((Object)"SanWS discoverFabric...");
        ArrayList includeVsans = new ArrayList();
        ArrayList excludeVsans = new ArrayList();
        String inVsanStr = null;
        String exVsanStr = null;
        if (inVsans != null) {
            Collections.addAll(includeVsans, new int[][]{inVsans});
            sb = new StringBuffer();
            for (i = 0; i < inVsans.length; ++i) {
                sb.append(inVsans[i]);
                if (i == inVsans.length - 1) continue;
                sb.append(",");
            }
            inVsanStr = sb.toString();
        }
        if (exVsans != null) {
            Collections.addAll(excludeVsans, new int[][]{exVsans});
            sb = new StringBuffer();
            for (i = 0; i < exVsans.length; ++i) {
                sb.append(exVsans[i]);
                if (i == exVsans.length - 1) continue;
                sb.append(",");
            }
            exVsanStr = sb.toString();
        }
        try {
            if (userCredential == null) {
                throw new InvalidArgumentException("Invalid user credential:" + userCredential);
            }
            if (seed == null) {
                throw new InvalidArgumentException("Invalid seed:" + seed);
            }
            InetAddress seedIp = null;
            try {
                seedIp = InetAddress.getByName(seed);
            }
            catch (Exception ex) {
                return new CallResultDO(1, "Invalid seed address");
            }
            if (userCredential.isV3()) {
                if (userCredential.getUsername() == null) {
                    return new CallResultDO(1, "Invalid username: null");
                }
                if (userCredential.getV3Password() == null || userCredential.getV3Password().length() < 8) {
                    return new CallResultDO(1, "Invalid password: null or length < 8");
                }
                if (userCredential.getV3Protocol() == null) {
                    return new CallResultDO(1, "Invalid v3 protocol: null");
                }
            } else if (userCredential.getV2Community() == null) {
                return new CallResultDO(1, "Invalid community: null");
            }
            SnmpUserOpt userOpt = userCredential.toUserOpt();
            SnmpUser user = null;
            try {
                user = SessionImpl.convertSnmpUser(userOpt);
            }
            catch (Exception e) {
                return new CallResultDO(1, "Cannot get Snmp user from credentail");
            }
            if (user == null) {
                return new CallResultDO(1, "Cannot get Snmp user from credentail");
            }
            FabricPK fpk = GlobalFabricManager.getInstance().findFabricPK(seedIp, inVsanStr, exVsanStr);
            if (fpk != null) {
                return new CallResultDO(1, "fabric already exists");
            }
            if (globalEnableNpvDiscovery.equals("true") || globalEnableNpvDiscovery.equals("false")) {
                try {
                    logger.info((Object)"DbAdminWS updateServerProperties, updateServerProperties...");
                    logger.info((Object)("SanWS discoverFabric, entering WebUtil.updateServerProperties to update fabric.enableNpvDiscovery " + globalEnableNpvDiscovery));
                    WebUtil.updateServerProperties(new String[]{"fabric.enableNpvDiscovery"}, new String[]{globalEnableNpvDiscovery});
                }
                catch (Exception ex1) {
                    logger.warn((Object)("SanWS caught exception in discoverFabric(), set globalEnableNpvDiscovery property to " + globalEnableNpvDiscovery + ":"), (Throwable)ex1);
                }
            }
            FabricImpl fabric = null;
            try {
                UserEntry.authenticate(user, seedIp);
            }
            catch (SnmpException e) {
                return new CallResultDO(1, "Cannot authenticate snmp user:" + user.getSecurityName() + seedIp + " " + e.getMessage());
            }
            try {
                SanManager.getInstance().validateSeedSwitch(seedIp, user);
            }
            catch (Exception ex) {
                return new CallResultDO(1, ex.getMessage());
            }
            try {
                fabric = brocadeSeed ? SanManager.getInstance().openFabric(seedIp, user, true, inVsanStr, exVsanStr) : SanManager.getInstance().openFabric(seedIp, user, inVsanStr, exVsanStr);
            }
            catch (Exception e) {
                return new CallResultDO(1, "Cannot open fabric from snmp user:" + user.getSecurityName() + seedIp + " " + e.getMessage());
            }
            if (fabric == null) {
                return new CallResultDO(1, "Cannot open fabric from snmp user:" + user.getSecurityName() + seedIp);
            }
            UserFabricImpl.addSnmpUser(IdentityManager.getInstance().getCurrentUsername(), fabric.getPK(), user);
            String fabricName = fabric.getPK().toString();
            if (fabricName == null) {
                fabricName = "Fabric_" + fabric.getSeed().getInetAddress().getHostAddress().replace('.', '-');
            }
            int timeout = 120000;
            fabric.setClientIp(IdentityManager.getInstance().getClientIp());
            fabric.setFmUser(IdentityManager.getInstance().getCurrentUsername());
            while (!SanManager.getInstance().isOpened(fabric.getPK())) {
                Thread.sleep(1000L);
                if ((timeout -= 1000) >= 0) continue;
                if (SanManager.getInstance().findFabric(fabric.getPK()) == null) {
                    if (fabric.getSwitches() != null && fabric.getSwitches().length == 1) {
                        SwitchImpl sw;
                        SwitchImpl switchImpl = sw = fabric.getSwitches()[0] == null ? null : fabric.getSwitches()[0];
                        if (sw != null && sw.getNumVsans() == 0) {
                            return new CallResultDO(2, "Discovery terminated. No VSAN(s) configured. This is an empty fabric");
                        }
                    }
                    return new CallResultDO(2, "fabric empty");
                }
                return new CallResultDO(2, "Discovery is taking longer than 2 minutes. \nPlease return later to check status in table.");
            }
            logger.info((Object)"SanWS discoverFabric DONE");
            return new CallResultDO();
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in discoverFabric():", (Throwable)e);
            throw e;
        }
        catch (InvalidCredentialException e) {
            logger.warn((Object)"SanWS caught exception in discoverFabric():", (Throwable)e);
            throw e;
        }
        catch (AuthFailureException e) {
            logger.warn((Object)"SanWS caught exception in discoverFabric():", (Throwable)e);
            throw e;
        }
        catch (SanServiceException e) {
            logger.warn((Object)"SanWS caught exception in discoverFabric():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in discoverFabric():", e);
            return new CallResultDO(1, "Cannot open fabric from snmp user:" + userCredential + "," + seed + " " + e.getMessage());
        }
    }

    @Override
    public boolean isDiscovered(String seedIp) throws SanServiceException, UnreachableServerException {
        try {
            boolean isOpen;
            ModelFacadeRif model = SessionHelper.getInstance().getModelFacade();
            InetAddress ip = InetAddress.getByName(seedIp);
            FabricPK fKey = model.findFabricByIpAddress(ip);
            if (fKey == null) {
                return false;
            }
            String fabricName = model.getFabricName(fKey);
            if (fabricName != null) {
                fabricName = fabricName.trim();
            }
            if ((isOpen = model.isFabricOpened(fKey)) && fabricName != null && fabricName.length() > 0) {
                return true;
            }
        }
        catch (UnknownHostException e) {
            String errMsg = "Seed " + seedIp + "not reachable: " + e.getMessage();
            logger.error((Object)errMsg);
            throw new UnreachableServerException(errMsg);
        }
        catch (RemoteException e) {
            String errMsg = "Unable to find fabric by seed " + seedIp + ": " + e.getMessage();
            logger.error((Object)errMsg);
            throw new SanServiceException(errMsg);
        }
        return false;
    }

    @Override
    @WebMethod
    public CallResultDO manageFabric(FabricKeyDO key, String persistent) throws SanServiceException, InvalidArgumentException {
        logger.info((Object)("SanWS manageFabric... key/persistent=" + key + '/' + persistent));
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid fabric key:" + key);
            }
            boolean isPersistent = persistent.equals("true");
            FabricPK pk = key.toDomain();
            FabricImpl fab = null;
            try {
                boolean isManaged = GlobalFabricManager.getInstance().isFabricManageable(pk);
                logger.info((Object)("SanWS manageFabric fabric currently isManaged ? " + isManaged));
                if (!isManaged) {
                    logger.info((Object)"SanWS manageFabric !managed, SanManager.manageFabric()...");
                    fab = SanManager.getInstance().manageFabric(pk);
                } else {
                    logger.info((Object)"SanWS manageFabric managed,  SanManager.findFabric()...");
                    fab = SanManager.getInstance().findFabric(pk);
                }
                if (fab == null) {
                    logger.warn((Object)("SanWS manageFabric, " + pk.getName() + " return fabric " + key + " == null"));
                    return new CallResultDO(1, pk.getName() + " Cannot manage fabric");
                }
                boolean isCurrPersistent = GlobalFabricManager.getInstance().isFabricPersistent(pk);
                logger.warn((Object)("SanWS manageFabric, isCurrPersistent ? " + isCurrPersistent));
                if (isCurrPersistent != isPersistent) {
                    logger.warn((Object)"SanWS manageFabric, SanManager.persistFabric()...");
                }
                SanManager.getInstance().persistFabric(fab, isPersistent);
            }
            catch (Exception e) {
                logger.warn((Object)("SanWS manageFabric, " + pk.getName() + " Cannot manage fabric: " + key), (Throwable)e);
                return new CallResultDO(1, pk.getName() + " Cannot manage fabric:" + e.getMessage());
            }
            logger.info((Object)"SanWS manageFabric DONE");
            return new CallResultDO();
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)("SanWS caught exception in manageFabric():" + key.toDomain().getName() + " " + key + " " + e));
            throw new SanServiceException("Cannot manage fabric by fabric key " + key.toDomain().getName() + " :" + e.getMessage());
        }
        catch (Throwable e) {
            logger.warn((Object)("SanWS caught exception in manageFabric():" + key.toDomain().getName() + " " + key + " " + e));
            throw new SanServiceException("Cannot manage fabric by fabric key:" + key.toDomain().getName() + " :" + e.getMessage());
        }
    }

    @Override
    @WebMethod
    public CallResultDO unmanageFabric(FabricKeyDO key) throws SanServiceException, InvalidArgumentException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid fabric key: null");
            }
            FabricPK pk = key.toDomain();
            try {
                if (PMImpl.getInstance().isRunning() && FMServerImpl.getInstance().isFabricInPmCollection(pk)) {
                    return new CallResultDO(1, "Cannot unmanage fabric: PM is collecting stats on " + pk.getName() + ", please stop PM or remove this fabric from PM collection.");
                }
                SanManager.getInstance().unmanageFabric(pk);
            }
            catch (Exception e) {
                return new CallResultDO(1, pk.getName() + " Cannot unmanage fabric:" + key + " " + e.getMessage());
            }
            return new CallResultDO();
        }
        catch (InvalidArgumentException e) {
            if (key != null) {
                logger.warn((Object)("SanWS caught exception in unmanageFabric():" + key.toDomain().getName() + "  ," + e));
            } else {
                logger.warn((Object)("SanWS caught exception in unmanageFabric():" + e));
            }
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)("SanWS caught exception in unmanageFabric(): " + key.toDomain().getName() + "  ," + e));
            throw new SanServiceException(key.toDomain().getName() + " Cannot manage fabric by fabric key:" + key, e);
        }
    }

    private CallResultDO[] checkSeverHealth4Move(FabricKeyDO[] keys, String newServerIpaddress) {
        logger.info((Object)"SanWS checkSeverHealth4Move.... calling ClusterMapping to get ServerIP oldServers...");
        CallResultDO[] results = null;
        ArrayList svrCheckResult = new ArrayList();
        ArrayList<String> svrList = new ArrayList<String>();
        HashMap<String, FabricKeyDO> fedMap = new HashMap<String, FabricKeyDO>();
        for (FabricKeyDO key : keys) {
            logger.info((Object)("SanWS checkSeverHealth4Move.... check federation health for fabric/lan " + key));
            FabricPK pk = key.toDomain();
            String fmServerIP = null;
            try {
                fmServerIP = ClusterMapping.getInstance().qIPStrfromFID(key.getFid());
                if (fmServerIP == null) {
                    logger.info((Object)("SanWS checkSeverHealth4Move.... Failed to find serverIP(server possibly down) for fabric/lan " + key));
                    continue;
                }
                FMServerRif fmServer = ClusterProcessor.getInstance().getFmsByIp(fmServerIP);
                if (fmServer == null) {
                    logger.info((Object)("SanWS checkSeverHealth4Move.... Failed to resove FMServerRif(server possibly down) for fabric/lan " + key));
                    continue;
                }
                if (fedMap.get(fmServerIP) != null) continue;
                fedMap.put(fmServerIP, key);
                svrList.add(fmServerIP);
            }
            catch (Exception ex1) {
                logger.info((Object)("SanWS checkSeverHealth4Move,  check federation health failed ex=" + ex1));
            }
        }
        if (svrCheckResult.size() != 0) {
            results = new CallResultDO[svrCheckResult.size()];
            int i = 0;
            for (String result : svrCheckResult) {
                results[i++] = new CallResultDO(1, result);
            }
            logger.info((Object)"SanWS checkSeverHealth4Move DONE failed on federation Health check upon finding serverIP");
            return results;
        }
        logger.info((Object)"SanWS checkSeverHealth4Move, calling checkFederationHealth4Move()...");
        String[] fedCheckResult = this.checkFederationHealth4Move(newServerIpaddress, svrList.toArray(new String[svrList.size()]));
        if (fedCheckResult != null && fedCheckResult.length > 0) {
            results = new CallResultDO[fedCheckResult.length];
            int i = 0;
            for (String result : fedCheckResult) {
                results[i++] = new CallResultDO(1, result);
            }
            logger.info((Object)"SanWS checkSeverHealth4Move DONE failed on federation Health check upon checkFederationHealth4Move()");
            return results;
        }
        logger.info((Object)"SanWS checkSeverHealth4Move DONE federation Health check, succeeded");
        return results;
    }

    @Override
    @WebMethod
    public CallResultDO[] moveFabrics1Action(FabricKeyDO[] keys, String newServerIpaddress) throws SanServiceException, InvalidArgumentException {
        logger.info((Object)("SanWS moveFabric.... to newServerIpAddress=" + newServerIpaddress));
        if (keys == null) {
            throw new InvalidArgumentException("Invalid fabric key: null");
        }
        CallResultDO[] results = this.checkSeverHealth4Move(keys, newServerIpaddress);
        if (results != null && results.length > 0) {
            return results;
        }
        results = new CallResultDO[keys.length];
        int i = -1;
        for (FabricKeyDO key : keys) {
            boolean isOldServerDown;
            FabricPK pk;
            block15: {
                ++i;
                logger.info((Object)("SanWS moveFabrics1Action.... move fabric " + key));
                pk = key.toDomain();
                String fmServerIP = null;
                FMServerRif fmServer = null;
                isOldServerDown = false;
                try {
                    fmServerIP = ClusterMapping.getInstance().qIPStrfromFID(keys[i].getFid());
                    if (fmServerIP != null) {
                        fmServer = ClusterProcessor.getInstance().getFmsByIp(fmServerIP);
                        if (fmServer != null) {
                            try {
                                long systime = fmServer.getServerTime();
                                logger.info((Object)"SanWS moveFabrics1Action, calling FMServerImpl.moveFabric()...");
                                String userName = IdentityManager.getInstance().getCurrentUsername();
                                fmServer.moveFabric(pk, true, SecurityManager.getSSOToken(userName, systime));
                                logger.info((Object)("SanWS moveFabrics1Action,  remove Fabric DONE, key " + key));
                            }
                            catch (InvalidArgumentException e) {
                                results[i] = new CallResultDO(1, "failed to remove fabric, " + e.getMessage());
                                logger.info((Object)("SanWS moveFabrics1Action,  failed to remove Fabric, ex=" + e));
                                continue;
                            }
                            catch (Exception ex) {
                                results[i] = new CallResultDO(1, "failed to remove fabric, " + ex.getMessage());
                                logger.info((Object)("SanWS moveFabrics1Action,  failed to remove Fabric, ex=" + ex));
                                continue;
                            }
                            logger.info((Object)("SanWS moveFabrics1Action,  remove Fabric DONE, key " + key));
                            break block15;
                        }
                        try {
                            int svrStatus = ClusterMapping.getInstance().getStatus(InetAddress.getByName(fmServerIP));
                            if (svrStatus != 2 && svrStatus != 1) {
                                results[i] = new CallResultDO(1, "failed to contact original server " + fmServerIP + " (serverRif null, original server status " + svrStatus);
                                logger.info((Object)("SanWS moveFabrics1Action, failed to contact original server " + fmServerIP + " for fabric " + key + " and the server is not in failOver state(serverRif null, original server status " + svrStatus));
                                continue;
                            }
                            isOldServerDown = true;
                            logger.info((Object)("SanWS moveFabrics1Action,  failed to find serverRif for fabric " + key + ", serverRif null, determined oldServer down, original server status " + svrStatus));
                            break block15;
                        }
                        catch (Exception ex) {
                            results[i] = new CallResultDO(1, "failed to contact original server " + fmServerIP + " (serverRif null, ex=" + ex.getMessage());
                            logger.info((Object)("SanWS moveFabrics1Action, failed to contact original server " + fmServerIP + " for fabric " + key + " (serverRif null, ex=" + ex.getMessage()));
                            continue;
                        }
                    }
                    isOldServerDown = true;
                    logger.info((Object)("SanWS moveFabrics1Action,  failed to find server for fabric " + key + ", server null"));
                }
                catch (Exception ex1) {
                    isOldServerDown = true;
                    logger.info((Object)("SanWS moveFabrics1Action,  failed to find server for fabric " + key + ", " + ex1));
                }
            }
            try {
                SnmpUser snmpUser = FabricImpl.getSnmpUser(pk);
                logger.info((Object)("SanWS moveFabrics1Action Add fabric, found snmpUser " + snmpUser + ",  calling SanManager.moveFabric()..."));
                SanManager.getInstance().moveFabric(pk, snmpUser, false);
                logger.info((Object)("SanWS moveFabrics1Action Add Fabric DONE, key " + key));
            }
            catch (Exception ex) {
                results[i] = new CallResultDO(1, "failed to add fabric, " + ex.getMessage());
                logger.info((Object)("SanWS moveFabrics1Action,  failed to add Fabric, ex=" + ex));
                continue;
            }
            results[i] = isOldServerDown ? new CallResultDO(0, "Original Server down") : new CallResultDO();
        }
        logger.info((Object)("SanWS moveFabrics1Action DONE,  newServerIpAddress = " + newServerIpaddress));
        return results;
    }

    @Override
    @WebMethod
    public CallResultDO moveFabric(FabricKeyDO key, boolean isRemove, boolean isManaged, String newServerIpaddress) throws SanServiceException, InvalidArgumentException {
        logger.info((Object)("SanWS moveFabric.... key/isRmove/newServerIpAddress=" + key + "/" + isRemove + "/" + newServerIpaddress));
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid fabric key:" + key);
            }
            FabricPK pk = key.toDomain();
            try {
                SnmpUser snmpUser = null;
                if (!isRemove) {
                    try {
                        FMServerRif fmServer = null;
                        fmServer = ClusterProcessor.getInstance().getFmsByIp(newServerIpaddress);
                        if (fmServer == null) {
                            logger.warn((Object)"SanWS moveFabric() getFmsByIp() null");
                            throw new SanServiceException("Cannot move fabric by key " + pk + " : failed to reach " + newServerIpaddress + " ,null");
                        }
                    }
                    catch (Exception ex) {
                        logger.warn((Object)"SanWS moveFabric() caught exception in getFmsByIp(), ex :", (Throwable)ex);
                        throw new SanServiceException("Cannot move fabric by key " + pk + " : failed to reach " + newServerIpaddress + ", " + ex.getMessage());
                    }
                    String userName = IdentityManager.getInstance().getCurrentUsername();
                    logger.info((Object)("SanWS moveFabric Add, found userName " + userName));
                    snmpUser = FabricImpl.getSnmpUser(pk);
                    logger.info((Object)("SanWS moveFabric Add, found snmpUser " + snmpUser));
                }
                logger.info((Object)"SanWS moveFabric, calling SanManager moveFabric()...");
                SanManager.getInstance().moveFabric(pk, snmpUser, isRemove);
            }
            catch (Exception ex) {
                return new CallResultDO(1, pk.getName() + " Cannot move fabric: " + ex.getMessage());
            }
            try {
                if (!isRemove && isManaged) {
                    logger.info((Object)"SanWS moveFabric, calling SanManager manageFabric()...");
                    SanManager.getInstance().manageFabric(pk);
                }
            }
            catch (Exception ex) {
                return new CallResultDO(1, pk.getName() + " Cannot manage fabric: " + ex.getMessage());
            }
            return new CallResultDO();
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)("SanWS caught exception in moveFabric():" + key.toDomain().getName() + " " + key + " " + e));
            throw new SanServiceException("Cannot move fabric by fabric key " + key.toDomain().getName() + " :" + e.getMessage());
        }
        catch (Throwable e) {
            logger.warn((Object)("SanWS caught exception in moveFabric():" + key.toDomain().getName() + " " + key + " " + e));
            throw new SanServiceException("Cannot move fabric by fabric key:" + key.toDomain().getName() + " :" + e.getMessage());
        }
    }

    @Override
    @WebMethod
    public CallResultDO[] moveLanTasks1Action(String[] taskKeys, FabricKeyDO[] keys, String newServerIpaddress) throws SanServiceException, InvalidArgumentException {
        logger.info((Object)("SanWS moveLanTasks1Action,  to newServerIpAddress = " + newServerIpaddress));
        logger.info((Object)("SanWS moveLanTasks1Action,  taskCt/keyCt = " + taskKeys.length + "/" + keys.length));
        for (int i = 0; i < taskKeys.length && i < keys.length; ++i) {
            TaskKey pk = new TaskKey(Long.parseLong(taskKeys[i]));
            logger.info((Object)("SanWS moveLanTasks1Action,  move taskKey/lanId = " + taskKeys[i] + "/" + keys[i]));
        }
        CallResultDO[] results = this.checkSeverHealth4Move(keys, newServerIpaddress);
        if (results != null && results.length > 0) {
            return results;
        }
        results = new CallResultDO[taskKeys.length];
        boolean taskMoved = false;
        for (int i = 0; i < taskKeys.length && i < keys.length; ++i) {
            boolean isOldServerDown;
            TaskKey pk;
            String taskKey;
            block20: {
                if (taskKeys[i] == null || keys[i] == null) {
                    results[i] = new CallResultDO(1, "input null");
                    continue;
                }
                taskKey = taskKeys[i];
                pk = new TaskKey(Long.parseLong(taskKey));
                logger.info((Object)("SanWS moveLanTasks1Action,  moving taskKey/lan " + taskKey + "/" + keys[i] + " ...."));
                String fmServerIP = null;
                FMServerRif fmServer = null;
                isOldServerDown = false;
                try {
                    fmServerIP = ClusterMapping.getInstance().qIPStrfromFID(keys[i].getFid());
                    if (fmServerIP != null) {
                        fmServer = ClusterProcessor.getInstance().getFmsByIp(fmServerIP);
                        if (fmServer != null) {
                            try {
                                long systime = fmServer.getServerTime();
                                String userName = IdentityManager.getInstance().getCurrentUsername();
                                logger.info((Object)("SanWS moveLanTasks1Action, calling FmServerImpl.unhostTask()... , with userName " + userName));
                                fmServer.unHostLanTask(pk, SecurityManager.getSSOToken(userName, systime));
                            }
                            catch (InvalidArgumentException e) {
                                results[i] = new CallResultDO(1, "failed to remove task, " + e.getMessage());
                                logger.info((Object)("SanWS moveLanTasks1Action,  failed to unhostTask, ex=" + e));
                                continue;
                            }
                            catch (Exception ex) {
                                results[i] = new CallResultDO(1, "failed to remove task, " + ex.getMessage());
                                logger.info((Object)("SanWS moveLanTasks1Action,  failed to unhostTask, ex=" + ex));
                                continue;
                            }
                            logger.info((Object)("SanWS moveLanTasks1Action,  unHostLanTask DONE, taskKey/lan " + taskKey + "/" + keys[i]));
                            break block20;
                        }
                        try {
                            int svrStatus = ClusterMapping.getInstance().getStatus(InetAddress.getByName(fmServerIP));
                            if (svrStatus != 2 && svrStatus != 1) {
                                results[i] = new CallResultDO(1, "failed to contact original server " + fmServerIP + " (serverRif null, original server status " + svrStatus);
                                logger.info((Object)("SanWS moveLanTasks1Action, failed to contact original server " + fmServerIP + " for taskKey " + taskKey + " and the server is not in failOver state(serverRif null, original server status " + svrStatus));
                                continue;
                            }
                            isOldServerDown = true;
                            logger.info((Object)("SanWS moveLanTasks1Action,  failed to find serverRif for taskKey " + taskKey + ", serverRif null, determined oldServer down, original server status " + svrStatus));
                            break block20;
                        }
                        catch (Exception ex) {
                            results[i] = new CallResultDO(1, "failed to contact original server " + fmServerIP + " (serverRif null, ex=" + ex.getMessage());
                            logger.info((Object)("SanWS moveLanTasks1Action, failed to contact original server " + fmServerIP + " for taskKey " + taskKey + " (serverRif null, ex=" + ex.getMessage()));
                            continue;
                        }
                    }
                    isOldServerDown = true;
                    logger.info((Object)("SanWS moveLanTasks1Action,  failed to find server for taskKey " + taskKey + ", server null"));
                }
                catch (Exception ex) {
                    isOldServerDown = true;
                    logger.info((Object)("SanWS moveLanTasks1Action,  failed to find server for taskKey " + taskKey + ", " + ex));
                }
            }
            try {
                logger.info((Object)"SanWS moveLanTasks1Action, calling DCManager hostTask..., PM restart will be handled there...");
                DCManager.getInstance().hostTask(pk);
            }
            catch (Exception ex) {
                results[i] = new CallResultDO(1, "failed to add task, " + ex.getMessage());
                logger.info((Object)("SanWS moveLanTasks1Action,  failed to add task, ex=" + ex));
                continue;
            }
            logger.info((Object)("SanWS moveLanTasks1Action,  hostTask DONE, taskKey/lan " + taskKey + "/" + keys[i]));
            taskMoved = true;
            results[i] = isOldServerDown ? new CallResultDO(0, "Original Server down") : new CallResultDO();
        }
        if (taskMoved) {
            try {
                logger.info((Object)"SanWS moveLanTasks1Action --> DCManager.rediscoverLan()  with LAN_ONDEMAND_SHALLOW_ONLY ...");
                DCManager.getInstance().rediscoverLanforTaskMove();
                logger.info((Object)"SanWS moveLanTasks1Action rediscoverLan DONE");
            }
            catch (Exception e) {
                logger.warn((Object)"SanWS moveLanTasks1Action caught exception in rediscoverLan():", (Throwable)e);
                CallResultDO[] newResults = new CallResultDO[results.length + 1];
                System.arraycopy(results, 0, newResults, 0, results.length);
                if (e instanceof DiscoveryException) {
                    newResults[newResults.length - 1] = new CallResultDO(1, "Failed to rediscover LAN at " + newServerIpaddress + ": " + ((DiscoveryException)((Object)e)).getDetail());
                    logger.info((Object)("SanWS moveLanTasks1Action rediscoverLan failed, " + ((DiscoveryException)((Object)e)).getDetail()));
                }
                newResults[newResults.length - 1] = new CallResultDO(1, "Failed to rediscover LAN at " + newServerIpaddress + ": " + e.getMessage());
                logger.info((Object)("SanWS moveLanTasks1Action rediscoverLan failed, " + e));
            }
        }
        logger.info((Object)("moveLanTasks1Action DONE,  newServerIpAddress = " + newServerIpaddress));
        return results;
    }

    @Override
    @WebMethod
    public CallResultDO moveLanTask(String taskKey, FabricKeyDO key, boolean isRemove, boolean isManaged, String newServerIpaddress) throws SanServiceException, InvalidArgumentException {
        block7: {
            logger.info((Object)("moveLanTask,  taskKey/key/isRemove/newServerIpAddress = " + taskKey + "/" + key + "/" + isRemove + "/" + newServerIpaddress));
            TaskKey pk = new TaskKey(Long.parseLong(taskKey));
            try {
                if (isRemove) {
                    try {
                        FMServerRif fmServer = null;
                        fmServer = ClusterProcessor.getInstance().getFmsByIp(newServerIpaddress);
                        if (fmServer == null) {
                            logger.warn((Object)"SanWS moveLanTask() getFmsByIp() null");
                            throw new SanServiceException("Cannot move LAN Task by key " + pk + " : failed to reach " + newServerIpaddress + " ,null");
                        }
                    }
                    catch (Exception ex) {
                        logger.warn((Object)"SanWS moveLanTask() caught exception in getFmsByIp(), ex :", (Throwable)ex);
                        throw new SanServiceException("Cannot move LAN Task by key " + pk + " : failed to reach " + newServerIpaddress + ", " + ex.getMessage());
                    }
                    logger.info((Object)"SanWS moveLanTask, calling DCManager unhostTask()...");
                    DCManager.getInstance().unhostTask(pk);
                    break block7;
                }
                logger.info((Object)"SanWS moveLanTask, calling DCManager hostTask...");
                DCManager.getInstance().hostTask(pk);
            }
            catch (InvalidArgumentException e) {
                logger.warn((Object)("SanWS caught exception in moveLanTask():" + pk + " " + key + " " + e));
                throw new SanServiceException("Cannot move LAN Task by key " + pk + " :" + e.getMessage());
            }
            catch (Exception ex) {
                logger.warn((Object)("SanWS caught exception in moveLanTask():" + pk + " " + key + " " + ex));
                return new CallResultDO(1, pk + " Cannot move LAN Task: " + ex.getMessage());
            }
        }
        logger.info((Object)("moveLanTask DONE,  taskKey/key/isRemove/newServerIpAddress = " + taskKey + "/" + key + "/" + isRemove + "/" + newServerIpaddress));
        return new CallResultDO();
    }

    @Override
    @WebMethod
    @Deprecated
    public EndPortDO[] getEndports() throws SanServiceException, SanNotFoundException {
        try {
            EndPortImpl[] endports = SanManager.getInstance().getEndPorts();
            if (endports == null || endports.length < 1) {
                throw new SanNotFoundException("Could get end ports");
            }
            ArrayList<EndPortDO> retEP = new ArrayList<EndPortDO>();
            for (int i = 0; i < endports.length; ++i) {
                if (endports[i].getFabricPK() == null) continue;
                FcPortBase fcp = SanHelper.getSwitchPort(endports[i].getSwitchIntKey()._swPK, endports[i].getSwitchIntKey()._index);
                retEP.add(new EndPortDO(endports[i], fcp));
            }
            if (retEP.size() == 0) {
                return new EndPortDO[0];
            }
            return retEP.toArray(new EndPortDO[0]);
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getEndports():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getEndports():", e);
            throw new SanServiceException("Cannot get all endports in san", e);
        }
    }

    @Override
    @WebMethod
    public EndPortDO[] getEndportbyNwwn(WwnDO nWwn, boolean isHost, boolean isTarget) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (nWwn == null) {
                throw new InvalidArgumentException("Invalid nWwn:" + nWwn);
            }
            EndPortImpl[] endports = SanManager.getInstance().getEndPorts();
            if (endports == null || endports.length < 1) {
                throw new SanNotFoundException("Cannot get end ports by NWWN");
            }
            ArrayList<EndPortDO> retEP = new ArrayList<EndPortDO>();
            for (int i = 0; i < endports.length; ++i) {
                if (endports[i].getFabricPK() == null) continue;
                FcPortBase fcp = SanHelper.getSwitchPort(endports[i].getSwitchIntKey()._swPK, endports[i].getSwitchIntKey()._index);
                if (!nWwn.getValue().equals(SnmpString.toHexString(endports[i].getNodeWwn().getValue()))) continue;
                EndPortDO endPort = new EndPortDO(endports[i], fcp);
                if (endPort.isHost() && endPort.isTarget()) {
                    endPort.setTarget(false);
                    EndPortDO strgEndPort = new EndPortDO(endports[i], fcp);
                    strgEndPort.setHost(false);
                    strgEndPort.setTarget(true);
                    if (isHost && !isTarget) {
                        retEP.add(endPort);
                        continue;
                    }
                    if (!isHost && isTarget) {
                        retEP.add(strgEndPort);
                        continue;
                    }
                    retEP.add(endPort);
                    retEP.add(strgEndPort);
                    continue;
                }
                retEP.add(endPort);
            }
            if (retEP.size() == 0) {
                return new EndPortDO[0];
            }
            return retEP.toArray(new EndPortDO[0]);
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getEndports():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getEndports():", e);
            throw new SanServiceException("Cannot get all endports in san", e);
        }
    }

    @Override
    @WebMethod
    @Deprecated
    public EndPortDO[] getHostEndports() throws SanServiceException, SanNotFoundException {
        try {
            EndPortImpl[] endports = SanManager.getInstance().getEndPorts();
            if (endports == null || endports.length < 1) {
                throw new SanNotFoundException("Cannot get HostEndports");
            }
            ArrayList<EndPortDO> retEP = new ArrayList<EndPortDO>();
            for (int i = 0; i < endports.length; ++i) {
                if (endports[i].getFabricPK() == null || !endports[i].isIntiator()) continue;
                FcPortBase fcp = SanHelper.getSwitchPort(endports[i].getSwitchIntKey()._swPK, endports[i].getSwitchIntKey()._index);
                retEP.add(new EndPortDO(endports[i], fcp));
            }
            if (retEP.size() == 0) {
                return new EndPortDO[0];
            }
            return retEP.toArray(new EndPortDO[0]);
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getEndports():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getEndports():", e);
            throw new SanServiceException("Cannot get all endports in san", e);
        }
    }

    @Override
    @WebMethod
    public EndPortDO getEndPortByKey(WwnKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid endport key:" + key);
            }
            EndPortImpl ep = SanManager.getInstance().findEndPortByPK(key.toWwnKey());
            if (ep == null) {
                throw new SanNotFoundException("Unable to get endport by switchkey");
            }
            FcPortBase fcp = SanHelper.getSwitchPort(ep.getSwitchIntKey()._swPK, ep.getSwitchIntKey()._index);
            return new EndPortDO(ep, fcp);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getEndPortByKey():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getEndPortByKey():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getEndPortByKey():", e);
            throw new SanServiceException("Cannot get endports by endport key:" + key, e);
        }
    }

    @Override
    @WebMethod
    public EndPortDO getEndPortByDbId(long dbId) throws SanServiceException, InvalidArgumentException {
        try {
            ArrayList<EndPortDO> endPortList = EndDeviceHandler.getInstance().getEndDeviceList(dbId);
            return endPortList.get(0);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getEndPortByKey():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getEndPortByKey():", e);
            throw new SanServiceException("Cannot get endports by endport id:", e);
        }
    }

    @Override
    @WebMethod
    public EndPortDO[] getEndPortAttachedToSw(WwnKeyDO swKey) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (swKey == null) {
                throw new InvalidArgumentException("Invalid switch key:" + swKey);
            }
            SwitchImpl impl = SanHelper.findSwitch(swKey.toWwnKey());
            if (impl == null) {
                throw new SanNotFoundException("Cannot get endports attached to switch");
            }
            List eps = SanManager.getInstance().findAttachedEndPorts(impl);
            if (eps != null) {
                return EndPortDO.clone(eps);
            }
            return new EndPortDO[0];
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getEndPortAttachedToSw():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getEndPortAttachedToSw():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getEndPortAttachedToSw():", e);
            throw new SanServiceException("Cannot get endports by switch key:" + swKey, e);
        }
    }

    @Override
    @WebMethod
    public ZoneMemUnitDO getZoneMemberByName(String zoneMemName, boolean isivr) throws SanServiceException, InvalidArgumentException {
        try {
            if (zoneMemName == null) {
                throw new InvalidArgumentException("Invalid zoneMemName");
            }
            ZoneMemUnit zoneMem = IndexUtil.getInstance().getZoneMemberByName(zoneMemName, isivr);
            if (zoneMem == null) {
                throw new SanServiceException("Cannot find zone member by name: " + zoneMemName);
            }
            return new ZoneMemUnitDO(zoneMem);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getZoneMemberByName():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getZoneMemberByName():", e);
            throw new SanServiceException("Cannot run getZoneMemberByName", e);
        }
    }

    @Override
    @WebMethod
    public void updateEndportEnclosure(WwnKeyDO endportKey, NameKeyDO enclosureKey) throws SanServiceException, InvalidArgumentException {
        try {
            if (endportKey == null || enclosureKey == null) {
                throw new InvalidArgumentException("Invalid enclosure update keys:" + endportKey + "," + enclosureKey);
            }
            SanManager.getInstance().updateEndPortEnclosure(endportKey.toWwnKey(), enclosureKey.toDomain());
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in updateEndportEnclosure():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in updateEndportEnclosure():", e);
            throw new SanServiceException("Cannot update enclosures by keys:" + endportKey + "," + enclosureKey, e);
        }
    }

    @Override
    @WebMethod
    @Deprecated
    public EnclosureDO[] getEnclosures() throws SanServiceException, SanNotFoundException {
        try {
            EnclosureImpl[] ens = SanManager.getInstance().getEnclosures();
            if (ens == null) {
                throw new SanNotFoundException("Couldn't get Enclosures");
            }
            EnclosureDO[] ret = new EnclosureDO[ens.length];
            for (int i = 0; i < ens.length; ++i) {
                ret[i] = new EnclosureDO(ens[i]);
            }
            if (ret.length == 0) {
                return new EnclosureDO[0];
            }
            return ret;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getEnclosures():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getEnclosures():", e);
            throw new SanServiceException("Cannot get all enclosures", e);
        }
    }

    @Override
    @WebMethod
    @Deprecated
    public EnclosureDO getEnclosureByName(String name) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (name == null) {
                throw new InvalidArgumentException("Invalid enclosure name:" + name);
            }
            EnclosureImpl en = SanManager.getInstance().findEnclosureByName(name.trim());
            if (en == null) {
                throw new SanNotFoundException("Unable to get enclosure by name");
            }
            return new EnclosureDO(en);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getEnclosureByName():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getEnclosureByName():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getEnclosureByName():", e);
            throw new SanServiceException("Cannot get enclosure by name:" + name, e);
        }
    }

    @Override
    @WebMethod
    public EnclosureDO getEnclosureByDbId(long dbId) throws SanServiceException, InvalidArgumentException {
        try {
            if (dbId < 0L) {
                throw new InvalidArgumentException("Invalid enclosure db id :" + dbId);
            }
            EnclosureDO en = SearchHandler.getInstance().getEnclosureByDbId(dbId);
            return en;
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getEnclosureByDbId():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getEnclosureByDbId():", e);
            throw new SanServiceException("Cannot get enclosure by dbId:" + dbId, e);
        }
    }

    @Override
    @WebMethod
    public VmDO getVmByDbId(long dbId) throws SanServiceException, InvalidArgumentException {
        try {
            if (dbId < 0L) {
                throw new InvalidArgumentException("Invalid Vm db id :" + dbId);
            }
            VmDO en = SearchHandler.getInstance().getVmByDbId(dbId);
            return en;
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getVmByDbId():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getVmByDbId():", e);
            throw new SanServiceException("Cannot get vm by dbId:" + dbId, e);
        }
    }

    @Override
    @WebMethod
    public EnclosureDO getEnclosureByKey(NameKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid enclosure key:" + key);
            }
            EnclosureImpl en = SanManager.getInstance().findEnclosureByPK(new NameKey(key.getName()));
            if (en == null) {
                throw new SanNotFoundException("Could not get enclosure by key");
            }
            return new EnclosureDO(en);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getEnclosureByKey():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getEnclosureByKey():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getEnclosureByKey():", e);
            throw new SanServiceException("Cannot get enclosure by key:" + key, e);
        }
    }

    @Override
    @WebMethod
    public EnclosureDO getEnclosureByPWwn(WwnDO wwn) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (wwn == null || wwn.getValue() == null) {
                throw new InvalidArgumentException("Invalid enclosure pwwn:" + wwn);
            }
            EnclosureImpl en = SanManager.getInstance().findEnclosureByPortWwn(wwn.toWwn());
            if (en == null) {
                throw new SanNotFoundException("Couldn't get enclosure by PWWN");
            }
            return new EnclosureDO(en);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getEnclosureByPWwn():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getEnclosureByPWwn():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getEnclosureByPWwn():", e);
            throw new SanServiceException("Cannot get enclosure by pwwn:" + wwn, e);
        }
    }

    @Override
    @WebMethod
    public void updateEnclosure(EnclosureDO value) throws SanServiceException, InvalidArgumentException {
        try {
            if (value == null || value.getKey() == null) {
                throw new InvalidArgumentException("Invalid enclosure vaule:" + value);
            }
            NameKeyDO key = value.getKey();
            SanManager.getInstance().updateEnclosure(key.toDomain(), key.getName(), value.getIpAddress(), value.getDmPath(), value.getType().value(), value.getVendor(), value.getModel(), value.getVersion());
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in updateEnclosure():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in updateEnclosure():", e);
            throw new SanServiceException("Cannot update enclosure with:" + value, e);
        }
    }

    @Override
    @WebMethod
    @Deprecated
    public EnclosureDO[] getHosts() throws SanServiceException, SanNotFoundException {
        try {
            FabricImpl[] fabrics = SanManager.getInstance().getFabrics();
            if (fabrics == null) {
                throw new SanNotFoundException("Couldn't get fabrics");
            }
            ArrayList<EnclosureDO> retList = new ArrayList<EnclosureDO>();
            for (FabricImpl fabric : fabrics) {
                EnclosureImpl[] encls = fabric.getEnclosures(1);
                if (encls == null) continue;
                for (EnclosureImpl encl : encls) {
                    retList.add(new EnclosureDO(encl));
                }
            }
            if (retList.size() == 0) {
                return new EnclosureDO[0];
            }
            return retList.toArray(new EnclosureDO[0]);
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getHosts():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getHosts():", e);
            throw new SanServiceException("Cannot get all hosts", e);
        }
    }

    @Override
    @WebMethod
    public EnclosureDO[] getHost(VsanKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid host key:" + key);
            }
            VsanImpl vsan = SanManager.getInstance().findVsan(key.toVsanPK());
            if (vsan == null) {
                throw new SanNotFoundException("Couldnt get Vsan");
            }
            ArrayList<EnclosureImpl> encls = vsan.getHostEnclosures();
            if (encls == null) {
                throw new SanNotFoundException("Couldn't get Host Enclosure by vsan");
            }
            EnclosureDO[] ret = new EnclosureDO[encls.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = new EnclosureDO(encls.get(i));
            }
            if (ret == null) {
                return new EnclosureDO[0];
            }
            return ret;
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getHost():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getHost():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getHost():", e);
            throw new SanServiceException("Cannot get host by key:" + key, e);
        }
    }

    @Override
    public EnclosureDO[] getHostByFabric(FabricKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid fabric key:" + key);
            }
            FabricImpl fabric = SanManager.getInstance().findFabric(key.toDomain());
            if (fabric == null) {
                throw new SanNotFoundException("couldn't get fabric");
            }
            VsanImpl[] vsans = fabric.getVsans();
            ArrayList<EnclosureDO> ret = new ArrayList<EnclosureDO>();
            for (VsanImpl vsan : vsans) {
                ArrayList<EnclosureImpl> encls = vsan.getHostEnclosures();
                for (EnclosureImpl encl : encls) {
                    ret.add(new EnclosureDO(encl));
                }
            }
            if (ret.size() == 0) {
                return new EnclosureDO[0];
            }
            return ret.toArray(new EnclosureDO[0]);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getHostByFabric():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getHostByFabric():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getHostByFabric():", e);
            throw new SanServiceException("Cannot get hosts by fabric:" + key.getFid(), e);
        }
    }

    @Override
    @Deprecated
    public EnclosureDO[] getStorages() throws SanServiceException, SanNotFoundException {
        try {
            ArrayList<EnclosureDO> ret = new ArrayList<EnclosureDO>();
            FabricImpl[] fabrics = SanManager.getInstance().getFabrics();
            if (fabrics == null) {
                throw new SanNotFoundException("Cannot get fabric");
            }
            for (FabricImpl fabric : fabrics) {
                EnclosureImpl[] encls = fabrics[0].getEnclosures(2);
                if (encls == null) continue;
                for (EnclosureImpl encl : encls) {
                    ret.add(new EnclosureDO(encl));
                }
            }
            if (ret.size() == 0) {
                return new EnclosureDO[0];
            }
            return ret.toArray(new EnclosureDO[0]);
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getStorages():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getStorages():", e);
            throw new SanServiceException("Cannot get all storages", e);
        }
    }

    @Override
    public EnclosureDO[] getStorageByFabric(FabricKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid fabric key:" + key);
            }
            FabricImpl fabric = SanManager.getInstance().findFabric(key.toDomain());
            if (fabric == null) {
                throw new SanNotFoundException("Couldn't get fabric");
            }
            EnclosureImpl[] encls = fabric.getEnclosures(2);
            if (encls == null) {
                throw new SanNotFoundException("Couldn't get Enclosures By Fabric");
            }
            EnclosureDO[] ret = new EnclosureDO[encls.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = new EnclosureDO(encls[i]);
            }
            if (ret == null) {
                return new EnclosureDO[0];
            }
            return ret;
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getStoragesByFabric():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getStorageByFabric():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getStorageByFabric():", e);
            throw new SanServiceException("Cannot get storages by fabric:" + key, e);
        }
    }

    @Override
    @WebMethod
    public EndPortDO[] getHostPorts(FabricKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid fabric key:" + key);
            }
            FabricImpl fabric = SanManager.getInstance().findFabric(key.toDomain());
            ArrayList ePorts = fabric.getInitiators();
            if (ePorts == null || ePorts.size() == 0) {
                throw new SanNotFoundException("Cannot get HostPorts");
            }
            EndPortDO[] eps = new EndPortDO[ePorts.size()];
            for (int i = 0; i < eps.length; ++i) {
                EndPortBase base = (EndPortBase)((EndPortImpl)ePorts.get(i)).getBaseObject();
                FcPortBase fcp = SanHelper.getSwitchPort(base.getFPortPK()._swPK, base.getFPortPK()._index);
                eps[i] = new EndPortDO(base, fcp);
            }
            if (eps == null) {
                return new EndPortDO[0];
            }
            return eps;
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getHostPorts():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getHostPorts():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getHostPorts():", e);
            throw new SanServiceException("Cannot get host ports by fabric:" + key, e);
        }
    }

    @Override
    public int getDomainId(WwnKeyDO swKey, short vsanId) throws SanServiceException, InvalidArgumentException {
        try {
            FabricPK[] fPks;
            if (swKey == null) {
                throw new InvalidArgumentException("Invalid switch key:" + swKey);
            }
            int domainId = 0;
            for (FabricPK fPk : fPks = SanManager.getInstance().getFabricPKs()) {
                SwitchImpl sw = SanManager.getInstance().findSwitch(swKey.toWwnKey(), fPk);
                domainId = sw.getDomainId(vsanId);
                if (domainId <= 0) continue;
                return domainId;
            }
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getDomainId():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getDomainId():", e);
            throw new SanServiceException("Cannot get domain id:" + swKey, e);
        }
        throw new SanServiceException("Cannot get domain id:" + swKey);
    }

    @Override
    @Deprecated
    public String getVsanIp(WwnKeyDO swKey, short vsanId) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (swKey == null) {
                throw new InvalidArgumentException("Invalid switch key:" + swKey);
            }
            int i$ = 0;
            FabricPK[] fPks = SanManager.getInstance().getFabricPKs();
            FabricPK[] arr$ = fPks;
            int len$ = arr$.length;
            if (i$ < len$) {
                FabricPK fPk = arr$[i$];
                SwitchImpl sw = SanManager.getInstance().findSwitch(swKey.toWwnKey(), fPk);
                InetAddress ip = sw.getVsanIp(vsanId);
                if (ip != null) {
                    return ip.toString();
                }
                throw new SanNotFoundException("Error getting vsan ip");
            }
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getVsanIp():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getVsanIp():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getVsanIp():", e);
            throw new SanServiceException("Cannot get VSAN IP:" + swKey, e);
        }
        throw new SanServiceException("Cannot get VSAN IP:" + swKey);
    }

    @Override
    public VsanDomainDO[] getVsanDomains(WwnKeyDO swKey, FabricKeyDO fKey) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        VsanDomainDO[] retDomains = null;
        try {
            if (swKey == null) {
                throw new InvalidArgumentException("Invalid switch key:" + swKey);
            }
            if (fKey == null) {
                throw new InvalidArgumentException("Invalid fabric key:" + fKey);
            }
            FabricPK fPk = new FabricPK(fKey.getFid());
            FabricImpl fab = SanManager.getInstance().findFabric(fPk);
            if (fab == null) {
                throw new SanServiceException("Unable to find fabric by the specified key");
            }
            SwitchImpl sw = SanManager.getInstance().findSwitch(swKey.toWwnKey(), fPk);
            if (sw != null) {
                VsanDomain[] domains = sw.getVsanDomains();
                if (domains == null) {
                    throw new SanNotFoundException("Unable to find vsan domain by switch");
                }
                retDomains = new VsanDomainDO[domains.length];
                for (int i = 0; i < retDomains.length; ++i) {
                    retDomains[i] = new VsanDomainDO(domains[i]);
                }
            }
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getVsanIp():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getVsanIp():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getVsanIp():", e);
            throw new SanServiceException("Cannot get VSAN IP:" + swKey, e);
        }
        if (retDomains == null) {
            return new VsanDomainDO[0];
        }
        return retDomains;
    }

    @Override
    public VsanDomainCapabilitiesDO[] getVsanDomainCapabilitiesBySwWwn(WwnKeyDO swKey, FabricKeyDO fKey) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        VsanDomainCapabilitiesDO[] retDomains = null;
        try {
            if (swKey == null) {
                throw new InvalidArgumentException("Invalid switch key:" + swKey);
            }
            if (fKey == null) {
                throw new InvalidArgumentException("Invalid fabric key:" + fKey);
            }
            FabricPK fPk = new FabricPK(fKey.getFid());
            FabricImpl fab = SanManager.getInstance().findFabric(fPk);
            if (fab == null) {
                throw new SanServiceException("Unable to find fabric by the specified key");
            }
            SwitchImpl sw = SanManager.getInstance().findSwitch(swKey.toWwnKey(), fPk);
            if (sw != null) {
                VsanDomain[] domains = sw.getVsanDomains();
                if (domains == null) {
                    throw new SanNotFoundException("Couldn't get vsan domains from switch");
                }
                retDomains = new VsanDomainCapabilitiesDO[domains.length];
                for (int i = 0; i < retDomains.length; ++i) {
                    retDomains[i] = new VsanDomainCapabilitiesDO(sw.getBase(), domains[i]);
                }
            }
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getVsanDomainCapabilitiesBySwWwn():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getVsanDomainCapabilitiesBySwWwn():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getVsanDomainCapabilitiesBySwWwn():", e);
            throw new SanServiceException("Cannot get VSAN Domains:" + swKey, e);
        }
        if (retDomains == null) {
            return new VsanDomainCapabilitiesDO[0];
        }
        return retDomains;
    }

    @Override
    public AliasDO[] getAliases(@WebParam(name="key", partName="key") FabricKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid fabric key:" + key);
            }
            FabricImpl fab = SanManager.getInstance().findFabric(key.toDomain());
            if (fab == null) {
                throw new SanNotFoundException("Cannot find fabric by fabric key");
            }
            AliasDO[] aliases = null;
            FcPortAlias[] faliases = fab.getDeviceAliases();
            if (faliases == null) {
                aliases = null;
            } else {
                aliases = new AliasDO[faliases.length];
                for (int i = 0; i < faliases.length; ++i) {
                    aliases[i] = new AliasDO(faliases[i]);
                }
            }
            if (aliases == null) {
                return new AliasDO[0];
            }
            return aliases;
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getAliases():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getAliases():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getAliases():", e);
            throw new SanServiceException("Cannot get fabric aliases by fabric key:" + key, e);
        }
    }

    @Override
    public boolean useFcAlias(@WebParam(name="key", partName="key") FabricKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid fabric key:" + key);
            }
            FabricImpl fab = SanManager.getInstance().findFabric(key.toDomain());
            if (fab == null) {
                throw new SanNotFoundException("Cannot find fabric by fabric key");
            }
            return fab.useFcAlias();
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in useFcAlias():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in useFcAlias():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in useFcAlias():", e);
            throw new SanServiceException("Cannot check use fcalias by fabric key:" + key, e);
        }
    }

    @Override
    public AliasDO[] getFCAliases(FabricKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        throw new SanNotFoundException("Cannot get FcAliases");
    }

    @Override
    public AliasDO[] getFCAliasesByVsan(VsanKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid vsan key:" + key);
            }
            VsanImpl vsan = SanManager.getInstance().findVsan(key.toVsanPK());
            if (vsan == null) {
                throw new SanNotFoundException("Unable to get FCAliases By Vsan");
            }
            AliasDO[] aliases = null;
            FcPortAlias[] faliases = vsan.getFcAliases();
            if (faliases == null) {
                aliases = null;
            } else {
                aliases = new AliasDO[faliases.length];
                for (int i = 0; i < faliases.length; ++i) {
                    aliases[i] = new AliasDO(faliases[i]);
                }
            }
            if (aliases == null) {
                return new AliasDO[0];
            }
            return aliases;
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getFCAliasesByVsan():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getFCAliasesByVsan():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getFCAliasesByVsan():", e);
            throw new SanServiceException("Cannot get fabric aliases by vsan key:" + key, e);
        }
    }

    @Override
    public CfsFeatureOpDO[] getCFS(FabricKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid fabric key:" + key);
            }
            FabricPK pk = new FabricPK(key.getFid());
            SwitchImpl[] sw = SanManager.getInstance().getSwitchesForFabric(pk);
            if (sw == null) {
                throw new SanNotFoundException("cannot get CFS information by fabric key");
            }
            ArrayList<CfsFeatureOpDO> retList = new ArrayList<CfsFeatureOpDO>();
            for (int i = 0; i < sw.length; ++i) {
                ArrayList<CfsFeatureOpDO> cfsFOps = SnmpHelper.queryCFSFeatures(sw[i]);
                retList.addAll(cfsFOps);
            }
            if (retList.size() == 0) {
                return new CfsFeatureOpDO[0];
            }
            return retList.toArray(new CfsFeatureOpDO[0]);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getCFS():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getCFS():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getCFS():", e);
            throw new SanServiceException("Cannot get CFS information by fabric key:" + key, e);
        }
    }

    @Override
    public CfsFeatureOpDO[] getCFSBySwitch(WwnKeyDO key) throws SanServiceException, InvalidArgumentException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid switch key:" + key);
            }
            SwitchImpl sw = SanHelper.findSwitch(key.toWwnKey());
            if (sw != null) {
                ArrayList<CfsFeatureOpDO> retList = SnmpHelper.queryCFSFeatures(sw);
                return retList.toArray(new CfsFeatureOpDO[0]);
            }
            return new CfsFeatureOpDO[0];
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getCFSBySwitch():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getCFSBySwitch():", e);
            throw new SanServiceException("Cannot get CFS information by switch key:" + key, e);
        }
    }

    @Override
    public FcPortDO[] getSwitchPorts(WwnKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid switch key:" + key);
            }
            SwitchImpl sw = SanHelper.findSwitch(key.toWwnKey());
            if (sw == null) {
                throw new SanNotFoundException("Cannot get port by switch key");
            }
            ArrayList<FcPortDO> retList = new ArrayList<FcPortDO>();
            List<FcPortBase> fcplist = sw.getPorts();
            for (FcPortBase fpb : fcplist) {
                FcPortDO fcpDO = new FcPortDO(fpb);
                retList.add(fcpDO);
            }
            if (retList.size() == 0) {
                return new FcPortDO[0];
            }
            return retList.toArray(new FcPortDO[0]);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getSwitchPorts():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getSwitchPorts():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getSwitchPorts():", e);
            throw new SanServiceException("Cannot get port by switch key:" + key, e);
        }
    }

    @Override
    public boolean isIVREnabled(WwnKeyDO key) throws SanServiceException, InvalidArgumentException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid switch key:" + key);
            }
            SwitchImpl sw = SanHelper.findSwitch(key.toWwnKey());
            if (sw == null) {
                throw new SanServiceException("Cannot find switch key:" + key);
            }
            return sw.isIvrEnabled();
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in isIVREnabled():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in isIVREnabled():", e);
            throw new SanServiceException("Cannot get IVR status for switch key:" + key, e);
        }
    }

    @Override
    @WebMethod(operationName="getSwitchDateAndTime")
    @WebResult(name="result", partName="result")
    public String getSwitchDateAndTime(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.querySwDateAndTime(sw);
        }
        catch (SnmpException e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e);
        }
    }

    @Override
    public AliasDO getAlias(@WebParam(name="fabricKey", partName="fabricKey") FabricKeyDO fabricKey, @WebParam(name="wwn", partName="wwn") WwnDO wwn) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (fabricKey == null || wwn == null) {
                throw new InvalidArgumentException("Invalid alias key:" + fabricKey + "-" + wwn);
            }
            FabricImpl fab = SanManager.getInstance().findFabric(fabricKey.toDomain());
            if (fab == null) {
                logger.warn((Object)("Cannot get fabric aliases by fabric key:" + fabricKey));
                throw new SanNotFoundException("Cannot get fabric alias by fabric key");
            }
            AliasDO alias = null;
            FcPortAlias faliase = fab.findDeviceAliasByWwn(wwn.toWwn());
            if (faliase != null) {
                alias = new AliasDO(faliase);
            } else {
                logger.warn((Object)("Cannot get fabric alias by fabric key:" + fabricKey + " and wwn: " + wwn));
            }
            if (alias != null) {
                return alias;
            }
            throw new SanNotFoundException("Cannot get alias");
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getAliases():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getAliases():", (Throwable)e);
            throw new SanServiceException("Cannot get fabric alias by fabric key:" + fabricKey + " and wwn: " + wwn, e);
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getAliases():", e);
            throw new SanServiceException("Cannot get fabric alias by fabric key:" + fabricKey + " and wwn: " + wwn, e);
        }
    }

    @Override
    public OperationStatusDO saveConfig(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey) throws SanServiceException, InvalidArgumentException {
        OperationStatusDO ret = new OperationStatusDO();
        return ret;
    }

    @Override
    public OperationStatusDO checkSaveConfigStatus(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey) throws SanServiceException, InvalidArgumentException {
        OperationStatusDO ret = new OperationStatusDO();
        return ret;
    }

    @Override
    @WebMethod(operationName="getEthPorts")
    @WebResult(name="result", partName="result")
    public EthPortDO[] getEthPorts(@WebParam(name="key", partName="key") WwnKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            EthPortDO ethpDO;
            if (key == null) {
                throw new InvalidArgumentException("Invalid switch key:" + key);
            }
            SwitchImpl sw = SanHelper.findSwitch(key.toWwnKey());
            if (sw == null) {
                throw new SanNotFoundException("Cannot get ethernetports by switch key");
            }
            ArrayList<EthPortDO> retList = new ArrayList<EthPortDO>();
            List<FcPortBase> ethplist = sw.findGigaEthPorts();
            for (FcPortBase fpb : ethplist) {
                ethpDO = new EthPortDO(fpb);
                retList.add(ethpDO);
            }
            ethplist = sw.findNonIPSEthPorts();
            for (FcPortBase fpb : ethplist) {
                ethpDO = new EthPortDO(fpb);
                retList.add(ethpDO);
            }
            ethplist = sw.findMgmtPorts();
            for (FcPortBase fpb : ethplist) {
                ethpDO = new EthPortDO(fpb);
                retList.add(ethpDO);
            }
            ethplist = sw.findVEthPorts();
            for (FcPortBase fpb : ethplist) {
                ethpDO = new EthPortDO(fpb);
                retList.add(ethpDO);
            }
            ethplist = sw.findIscsiPorts();
            for (FcPortBase fpb : ethplist) {
                ethpDO = new EthPortDO(fpb);
                retList.add(ethpDO);
            }
            if (retList.size() == 0) {
                return new EthPortDO[0];
            }
            return retList.toArray(new EthPortDO[0]);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getEthPorts():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getEthPorts():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getEthPorts():", e);
            throw new SanServiceException("Cannot get ethernet ports by switch key:" + key, e);
        }
    }

    @Override
    @WebMethod(operationName="getEthPort")
    @WebResult(name="result", partName="result")
    public EthPortDO getEthPort(@WebParam(name="ethPortKey", partName="ethPortKey") SwitchIntKeyDO ethPortKey) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (ethPortKey == null) {
                throw new InvalidArgumentException("Invalid switch interface key:" + ethPortKey);
            }
            WwnKey wwnKey = new WwnKey(new Wwn(ethPortKey.getSwKey()));
            SwitchImpl sw = SanHelper.findSwitch(wwnKey);
            if (sw == null) {
                logger.warn((Object)("Cannot find switch by switch wwn:" + wwnKey));
                throw new SanNotFoundException("Cannot get ethernetport by key");
            }
            EthPortDO ethpDO = null;
            FcPortBase fpb = sw.findPort(ethPortKey.getIndex());
            if (fpb != null && (fpb.getIfType() == 117 || fpb.getIfType() == 6 || fpb.getIfType() == 135 || fpb.getIfType() == 62 || IfIndexUtil.getType(fpb.getIfIndex()) == 28)) {
                ethpDO = new EthPortDO(fpb);
            }
            if (ethpDO != null) {
                return ethpDO;
            }
            throw new SanNotFoundException("Cannot get ethernetport");
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getEthPort():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getEthPort():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getEthPort():", e);
            throw new SanServiceException("Cannot get ethernet port by  key:" + ethPortKey, e);
        }
    }

    @Override
    @WebMethod(operationName="getFcPorts")
    @WebResult(name="result", partName="result")
    public FcPortDO[] getFcPorts(@WebParam(name="key", partName="key") WwnKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid switch key:" + key);
            }
            SwitchImpl sw = SanHelper.findSwitch(key.toWwnKey());
            if (sw == null) {
                throw new SanNotFoundException("Cannot get fcport by switch key");
            }
            ArrayList<FcPortDO> retList = new ArrayList<FcPortDO>();
            List<FcPortBase> fcplist = sw.findFcPorts();
            for (FcPortBase fpb : fcplist) {
                FcPortDO fcpDO = new FcPortDO(fpb, sw);
                retList.add(fcpDO);
            }
            if (retList.size() == 0) {
                return new FcPortDO[0];
            }
            return retList.toArray(new FcPortDO[0]);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getFcPorts():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getFcPorts():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getFcPorts():", e);
            throw new SanServiceException("Cannot get FC ports by switch key:" + key, e);
        }
    }

    @Override
    @WebMethod(operationName="getFcipPorts")
    @WebResult(name="result", partName="result")
    public FcPortDO[] getFcipPorts(@WebParam(name="key", partName="key") WwnKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid switch key:" + key);
            }
            SwitchImpl sw = SanHelper.findSwitch(key.toWwnKey());
            if (sw == null) {
                throw new SanNotFoundException("Cannot get switch with the switch key");
            }
            ArrayList<FcPortDO> retList = new ArrayList<FcPortDO>();
            List<FcPortBase> fcplist = sw.findFcipPorts();
            for (FcPortBase fpb : fcplist) {
                FcPortDO fcpDO = new FcPortDO(fpb);
                retList.add(fcpDO);
            }
            if (retList.size() == 0) {
                return new FcPortDO[0];
            }
            return retList.toArray(new FcPortDO[0]);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getFcipPorts():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getFcipPorts():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getFcipPorts():", e);
            throw new SanServiceException("Cannot get FCIP ports by switch key:" + key, e);
        }
    }

    @Override
    @WebMethod(operationName="getFcPort")
    @WebResult(name="result", partName="result")
    public FcPortDO getFcPort(@WebParam(name="fcPortKey", partName="fcPortKey") SwitchIntKeyDO fcPortKey) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (fcPortKey == null) {
                throw new InvalidArgumentException("Invalid switch interface key:" + fcPortKey);
            }
            WwnKey wwnKey = new WwnKey(new Wwn(fcPortKey.getSwKey()));
            SwitchImpl sw = SanHelper.findSwitch(wwnKey);
            if (sw == null) {
                logger.warn((Object)("Cannot find switch by switch wwn:" + wwnKey));
                throw new SanNotFoundException("Cannot find siwtch");
            }
            FcPortDO fcpDO = null;
            FcPortBase fpb = sw.findPort(fcPortKey.getIndex());
            if (fpb != null && fpb.getIfType() == 56) {
                fcpDO = new FcPortDO(fpb, sw);
            }
            if (fcpDO != null) {
                return fcpDO;
            }
            throw new SanNotFoundException("Cannot find fcport");
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getFcPort():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getFcPort():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getFcPort():", e);
            throw new SanServiceException("Cannot get FC port by key:" + fcPortKey, e);
        }
    }

    @Override
    @WebMethod(operationName="getFcipPort")
    @WebResult(name="result", partName="result")
    public FcPortDO getFcipPort(@WebParam(name="fcPortKey", partName="fcPortKey") SwitchIntKeyDO fcPortKey) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (fcPortKey == null) {
                throw new InvalidArgumentException("Invalid switch interface key:" + fcPortKey);
            }
            WwnKey wwnKey = new WwnKey(new Wwn(fcPortKey.getSwKey()));
            SwitchImpl sw = SanHelper.findSwitch(wwnKey);
            if (sw == null) {
                logger.warn((Object)("Cannot find switch by switch wwn:" + wwnKey));
                throw new SanNotFoundException("Cannot find switch");
            }
            FcPortDO fcpDO = null;
            FcPortBase fpb = sw.findPort(fcPortKey.getIndex());
            if (fpb != null && fpb.getIfType() == 56 && fpb.getIfname().startsWith("fcip")) {
                fcpDO = new FcPortDO(fpb);
            }
            if (fcpDO != null) {
                return fcpDO;
            }
            throw new SanNotFoundException("Cannot get fcipports");
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getFcipPort():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getFcipPort():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getFcipPort():", e);
            throw new SanServiceException("Cannot get FCIP port by key:" + fcPortKey, e);
        }
    }

    @Override
    @WebMethod(operationName="getFcPortCapabilitiesBySwitch")
    @WebResult(name="result", partName="result")
    public FcPortCapabilitiesDO[] getFcPortCapabilitiesBySwitch(@WebParam(name="key", partName="key") WwnKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid switch key:" + key);
            }
            SwitchImpl sw = SanHelper.findSwitch(key.toWwnKey());
            if (sw == null) {
                throw new SanNotFoundException("Cannot find switch");
            }
            ArrayList<FcPortCapabilitiesDO> retList = new ArrayList<FcPortCapabilitiesDO>();
            List<FcPortBase> fcplist = sw.findFcPorts();
            for (FcPortBase fpb : fcplist) {
                FcPortCapabilitiesDO fcpDO = new FcPortCapabilitiesDO(fpb, sw);
                retList.add(fcpDO);
            }
            if (retList.size() == 0) {
                return new FcPortCapabilitiesDO[0];
            }
            return retList.toArray(new FcPortCapabilitiesDO[0]);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getFcPortCapabilitiesBySwitch():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getFcPortCapabilitiesBySwitch():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getFcPortCapabilitiesBySwitch():", e);
            throw new SanServiceException("Cannot get FC port capabilities by switch key:" + key, e);
        }
    }

    @Override
    @WebMethod(operationName="getFcPortCapabilities")
    @WebResult(name="result", partName="result")
    public FcPortCapabilitiesDO getFcPortCapabilities(@WebParam(name="fcPortKey", partName="fcPortKey") SwitchIntKeyDO fcPortKey) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (fcPortKey == null) {
                throw new InvalidArgumentException("Invalid switch interface key:" + fcPortKey);
            }
            WwnKey wwnKey = new WwnKey(new Wwn(fcPortKey.getSwKey()));
            SwitchImpl sw = SanHelper.findSwitch(wwnKey);
            if (sw == null) {
                logger.warn((Object)("Cannot find switch by switch wwn:" + wwnKey));
                throw new SanNotFoundException("Cannot find switch");
            }
            FcPortCapabilitiesDO fcpDO = null;
            FcPortBase fpb = sw.findPort(fcPortKey.getIndex());
            if (fpb != null) {
                fcpDO = new FcPortCapabilitiesDO(fpb, sw);
            }
            if (fcpDO != null) {
                return fcpDO;
            }
            throw new SanNotFoundException("Cannot get fcport capabilities");
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getFcPortCapabilities():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getFcPortCapabilities():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getFcPortCapabilities():", e);
            throw new SanServiceException("Cannot get FC ports capabilities by key:" + fcPortKey, e);
        }
    }

    @Override
    @WebMethod(operationName="getFcSwitchCapabilitiesByFabric")
    @WebResult(name="result", partName="result")
    public FcSwitchCapabilitiesDO[] getFcSwitchCapabilitiesByFabric(@WebParam(name="key", partName="key") FabricKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid fabric key:" + key);
            }
            FcSwitchCapabilitiesDO[] ret = null;
            FabricPK pk = new FabricPK(key.getFid());
            SwitchImpl[] sw = SanManager.getInstance().getSwitchesForFabric(pk);
            if (sw == null) {
                throw new SanNotFoundException("Cannot find switch by fabric key");
            }
            ret = new FcSwitchCapabilitiesDO[sw.length];
            for (int i = 0; i < sw.length; ++i) {
                ret[i] = new FcSwitchCapabilitiesDO(sw[i]);
            }
            if (ret == null) {
                return new FcSwitchCapabilitiesDO[0];
            }
            return ret;
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getFcSwitchCapabilitiesByFabric():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getFcSwitchCapabilitiesByFabric():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getFcSwitchCapabilitiesByFabric():", e);
            throw new SanServiceException("Cannot get switches by fabric key:" + key, e);
        }
    }

    @Override
    @WebMethod(operationName="getFcSwitchCapabilities")
    @WebResult(name="result", partName="result")
    public FcSwitchCapabilitiesDO getFcSwitchCapabilities(@WebParam(name="wwnKey", partName="wwnKey") WwnKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid switch key:" + key);
            }
            WwnKey wwn = key.toWwnKey();
            SwitchImpl sw = SanHelper.findSwitch(key.toWwnKey());
            if (sw == null) {
                throw new SanNotFoundException("Cannot find switch by switch key");
            }
            FcSwitchCapabilitiesDO ret = new FcSwitchCapabilitiesDO(sw);
            return ret;
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getFcSwitchCapabilities():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getFcSwitchCapabilities():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getFcSwitchCapabilities():", e);
            throw new SanServiceException("Cannot get switch by switch key:" + key, e);
        }
    }

    @Override
    @WebMethod(operationName="getHbasByVsan")
    @WebResult(name="result", partName="result")
    public HbaDO[] getHbasByVsan(@WebParam(name="vsanKey", partName="vsanKey") VsanKeyDO vsanKey) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (vsanKey == null) {
                throw new InvalidArgumentException("Invalid Vsan key:" + vsanKey);
            }
            VsanImpl vsan = SanManager.getInstance().findVsan(vsanKey.toVsanPK());
            if (vsan == null) {
                throw new SanNotFoundException("Cannot find vsan");
            }
            ArrayList<EnclosureImpl> encls = vsan.getHostEnclosures();
            if (encls == null) {
                throw new SanNotFoundException("Cannot find host enclosure by vsan");
            }
            ArrayList<HbaDO> ret = new ArrayList<HbaDO>();
            for (EnclosureImpl enc : encls) {
                Hba[] hbas = enc.getHbas();
                if (hbas == null) continue;
                for (Hba hba : hbas) {
                    if (hba == null || hba.getSerialNumber() == null) continue;
                    ret.add(new HbaDO(hba));
                }
            }
            if (ret.size() == 0) {
                return new HbaDO[0];
            }
            return ret.toArray(new HbaDO[0]);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getHbasByVsan():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getHbasByVsan():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getHbasByVsan():", e);
            throw new SanServiceException("Cannot get hbas by vsan key:" + vsanKey, e);
        }
    }

    @Override
    @WebMethod(operationName="getHba")
    @WebResult(name="result", partName="result")
    public HbaDO getHba(@WebParam(name="vsanKey", partName="vsanKey") VsanKeyDO vsanKey, @WebParam(name="wwn", partName="wwn") WwnDO wwn) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (vsanKey == null) {
                throw new InvalidArgumentException("Invalid Vsan key:" + vsanKey);
            }
            if (wwn == null) {
                throw new InvalidArgumentException("Invalid hba key:" + wwn);
            }
            EndPortImpl emImpl = SanManager.getInstance().findEndPort(wwn.toWwn());
            if (emImpl == null) {
                throw new SanNotFoundException("cannot find endport");
            }
            VsanImpl vsan = SanManager.getInstance().findVsan(vsanKey.toVsanPK());
            if (vsan == null) {
                throw new SanNotFoundException("cannot find vsan by vsan key");
            }
            ArrayList<EnclosureImpl> encls = vsan.getHostEnclosures();
            if (encls == null) {
                throw new SanNotFoundException("cannot find host enclosure by vsan");
            }
            for (EnclosureImpl enc : encls) {
                Hba[] hbas;
                if (!enc.hasEndPort(emImpl) || (hbas = enc.getHbas()) == null) continue;
                for (Hba hba : hbas) {
                    if (hba.getHbaWwn().compareTo(wwn.toWwn()) != 0) continue;
                    return new HbaDO(hba);
                }
            }
            throw new SanNotFoundException();
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getHbasByVsan():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getHbasByVsan():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getHbasByVsan():", e);
            throw new SanServiceException("Cannot get hbas by vsan key:" + vsanKey, e);
        }
    }

    @Override
    @WebMethod(operationName="getPortChannelsbySwitch")
    @WebResult(name="result", partName="result")
    public PortChannelDO[] getPortChannelsbySwitch(@WebParam(name="key", partName="key") WwnKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid switch key:" + key);
            }
            SwitchImpl sw = SanHelper.findSwitch(key.toWwnKey());
            if (sw == null) {
                throw new SanNotFoundException("Cannot find switch by switch key");
            }
            ArrayList<PortChannelDO> retList = new ArrayList<PortChannelDO>();
            ArrayList<PortChannelDO> pcs = SnmpHelper.queryPortChannels(sw);
            for (PortChannelDO pc : pcs) {
                short[] vsans;
                FcPortBase fpb;
                if (!pc.isTrunked() && (fpb = sw.findPort(pc.getIfIndex())) != null && fpb.getIfType() == 56 && (vsans = fpb.getVsanMembership()) != null && vsans.length > 0) {
                    pc.setVsanId(vsans[0]);
                }
                retList.add(pc);
            }
            if (retList.size() == 0) {
                return new PortChannelDO[0];
            }
            return retList.toArray(new PortChannelDO[0]);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getPortChannelsbySwitch():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getPortChannelsbySwitch():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getPortChannelsbySwitch():", e);
            throw new SanServiceException("Cannot get PortChannels information by switch key:" + key, e);
        }
    }

    @Override
    @WebMethod(operationName="getPortChannels")
    @WebResult(name="result", partName="result")
    public PortChannelDO[] getPortChannels(@WebParam(name="key", partName="key") FabricKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        int i = 0;
        ArrayList<PortChannelDO> retList = null;
        SwitchImpl[] sw = null;
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid fabric key:" + key);
            }
            FabricPK pk = new FabricPK(key.getFid());
            sw = SanManager.getInstance().getSwitchesForFabric(pk);
            if (sw == null) {
                throw new SanNotFoundException("Cannot get switch with fabric key");
            }
            retList = new ArrayList<PortChannelDO>();
            for (i = 0; i < sw.length; ++i) {
                ArrayList<PortChannelDO> pcs = SnmpHelper.queryPortChannels(sw[i]);
                for (PortChannelDO pc : pcs) {
                    short[] vsans;
                    FcPortBase fpb;
                    if (!pc.isTrunked() && (fpb = sw[i].findPort(pc.getIfIndex())) != null && fpb.getIfType() == 56 && (vsans = fpb.getVsanMembership()) != null && vsans.length > 0) {
                        pc.setVsanId(vsans[0]);
                    }
                    retList.add(pc);
                }
            }
            if (retList.size() == 0) {
                return new PortChannelDO[0];
            }
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getPortChannels():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)("SanWS caught exception in getPortChannels() for :" + sw[i]), e);
        }
        return retList.toArray(new PortChannelDO[0]);
    }

    @Override
    @WebMethod(operationName="getPortChannel")
    @WebResult(name="result", partName="result")
    public PortChannelDO getPortChannel(@WebParam(name="portKey", partName="portKey") SwitchIntKeyDO portKey) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (portKey == null) {
                throw new InvalidArgumentException("Invalid switch interface key:" + portKey);
            }
            WwnKey wwnKey = new WwnKey(new Wwn(portKey.getSwKey()));
            FabricPK fPK = SanHelper.findFabricBySwitch(wwnKey);
            FabricImpl fabric = SanManager.getInstance().findFabric(fPK);
            if (fabric == null) {
                throw new SanNotFoundException("Cannot find fabric by fabric key");
            }
            SwitchImpl sw = SanHelper.findSwitch(wwnKey);
            if (sw == null) {
                logger.warn((Object)("Cannot find switch by switch wwn:" + wwnKey));
                throw new SanNotFoundException("cannot find switch");
            }
            ArrayList<PortChannelDO> pcs = SnmpHelper.queryPortChannels(sw);
            for (PortChannelDO pc : pcs) {
                short[] vsans;
                FcPortBase fpb;
                if (pc.getIfIndex() != portKey.getIndex()) continue;
                if (!pc.isTrunked() && (fpb = sw.findPort(pc.getIfIndex())) != null && fpb.getIfType() == 56 && (vsans = fpb.getVsanMembership()) != null && vsans.length > 0) {
                    pc.setVsanId(vsans[0]);
                }
                return pc;
            }
            throw new SanNotFoundException();
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getPortChannes():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getPortChannes():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getPortChannes():", e);
            throw new SanServiceException("Cannot get getPortChannel by key:" + portKey, e);
        }
    }

    @Override
    @WebMethod(operationName="getVsanDomain")
    @WebResult(name="result", partName="result")
    public VsanDomainDO getVsanDomain(@WebParam(name="wwnKey", partName="wwnKey") WwnKeyDO wwnKey, @WebParam(name="vsanKey", partName="vsanKey") VsanKeyDO vsanKey) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            VsanDomain domain;
            if (wwnKey == null) {
                throw new InvalidArgumentException("Invalid switch key:" + wwnKey);
            }
            VsanDomainDO retDomain = null;
            SwitchImpl sw = SanManager.getInstance().findSwitch(wwnKey.toWwnKey(), null);
            if (sw != null && (domain = sw.getVsanDomain(new Integer(vsanKey.getVsanID()).shortValue())) != null) {
                retDomain = new VsanDomainDO(domain);
            }
            if (retDomain != null) {
                return retDomain;
            }
            throw new SanNotFoundException("Cannot fetch Vsan Domains");
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getVsanDomain():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getVsanDomain():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getVsanDomain():", e);
            throw new SanServiceException("Cannot get VSAN IP:" + wwnKey, e);
        }
    }

    @Override
    @WebMethod(operationName="getVsanDomainCapabilities")
    @WebResult(name="result", partName="result")
    public VsanDomainCapabilitiesDO getVsanDomainCapabilities(@WebParam(name="wwnKey", partName="wwnKey") WwnKeyDO wwnKey, @WebParam(name="vsanKey", partName="vsanKey") VsanKeyDO vsanKey) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            VsanDomain domain;
            if (wwnKey == null) {
                throw new InvalidArgumentException("Invalid switch key:" + wwnKey);
            }
            VsanDomainCapabilitiesDO retDomain = null;
            SwitchImpl sw = SanManager.getInstance().findSwitch(wwnKey.toWwnKey(), null);
            if (sw != null && (domain = sw.getVsanDomain(new Integer(vsanKey.getVsanID()).shortValue())) != null) {
                retDomain = new VsanDomainCapabilitiesDO(sw.getBase(), domain);
            }
            if (retDomain != null) {
                return retDomain;
            }
            throw new SanNotFoundException("Cannot find vsan domain capabilities");
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getVsanDomainCapabilities():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getVsanDomainCapabilities():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getVsanDomainCapabilities():", e);
            throw new SanServiceException("Cannot get VSAN Doamin:" + wwnKey, e);
        }
    }

    @Override
    @WebMethod(operationName="getPhysicalInterfaces")
    @WebResult(name="result", partName="result")
    public PhyInterfaceDO[] getPhysicalInterfaces(@WebParam(name="key", partName="key") WwnKeyDO key) throws SanServiceException, InvalidArgumentException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid switch key:" + key);
            }
            WwnKey swkey = key.toWwnKey();
            return this.getSwitchPortsBySwitch(swkey);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception:", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception:", e);
            throw new SanServiceException("Cannot get switch's cards", e);
        }
    }

    @Override
    @WebMethod(operationName="setFabricName")
    @WebResult(name="result", partName="result")
    public CallResultDO setFabricName(FabricKeyDO key, String newName) throws SanServiceException {
        if (newName == null) {
            return new CallResultDO(1, "Fabric name can not be blank");
        }
        FabricPK pk = new FabricPK(key.getFid());
        if (pk == null) {
            return new CallResultDO(1, "fabric doesn't exist");
        }
        FabricImpl fabric = SanManager.getInstance().findFabric(pk);
        if (fabric == null) {
            return new CallResultDO(1, "fabric doesn't exist");
        }
        try {
            if (fabric.getFabricName().equals(newName)) {
                return new CallResultDO();
            }
            boolean alreadyExists = SanManager.getInstance().checkIfFabricNameExists(newName);
            if (alreadyExists) {
                return new CallResultDO(1, "A fabric already exist with that name.");
            }
            fabric.setFabricName(newName);
        }
        catch (Exception ex) {
            throw new SanServiceException(ex.getMessage(), ex);
        }
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="setFabricCredentialsAndManage")
    @WebResult(name="result", partName="result")
    public CallResultDO setFabricCredentialsAndManage(FabricKeyDO key, SnmpCredentialDO userCredential, String persistent) throws SanServiceException, InvalidArgumentException {
        logger.info((Object)("SanWS setFabricCredentialsAndManage...  key/persistent=" + key + '/' + persistent));
        CallResultDO result1 = this.setFabricCredentials(key, userCredential);
        CallResultDO result2 = this.manageFabric(key, persistent);
        StringBuffer sb = new StringBuffer();
        boolean isErr = false;
        if (result1.getResultStatus() != 0) {
            logger.info((Object)("SanWS setFabricCredentialsAndManage...  setCredentials failed, result=" + result1.getResultMessage()));
            sb.append(result1.getResultMessage());
            isErr = true;
        }
        if (result2.getResultStatus() != 0) {
            logger.info((Object)("SanWS setFabricCredentialsAndManage...  manageFabric failed, result=" + result2.getResultMessage()));
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(result2.getResultMessage());
            isErr = true;
        }
        if (isErr) {
            logger.info((Object)("SanWS setFabricCredentialsAndManage...  DONE, failed err=" + sb.toString()));
            return new CallResultDO(1, sb.toString());
        }
        logger.info((Object)"SanWS setFabricCredentialsAndManage...  DONE, succeed");
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="setFabricCredentials")
    @WebResult(name="result", partName="result")
    public CallResultDO setFabricCredentials(FabricKeyDO key, SnmpCredentialDO userCredential) throws SanServiceException, InvalidArgumentException {
        logger.info((Object)("SanWS setFabricCredentials...  key=" + key));
        FabricPK pk = new FabricPK(key.getFid());
        if (pk == null) {
            return new CallResultDO(1, pk.getName() + " fabric doesn't exist");
        }
        FabricImpl fabric = SanManager.getInstance().findFabric(pk);
        if (fabric == null) {
            return new CallResultDO(1, pk.getName() + " fabric doesn't exist");
        }
        if (fabric.isManaged()) {
            return new CallResultDO(1, "Please unmanage fabric before changing credential");
        }
        if (userCredential.isV3() && (userCredential.getV3Password() == null || userCredential.getV3Password().length() < 8)) {
            return new CallResultDO(1, "Invalid password: null or length < 8");
        }
        logger.info((Object)("SanWS setFabricCredentials...  user=" + userCredential.getUsername()));
        SnmpUserOpt opt = new SnmpUserOpt(userCredential.getUsername(), userCredential.getV3Password(), userCredential.getV2Community(), userCredential.getV3Protocol().value(), userCredential.isV3());
        SnmpUser user = SessionImpl.convertSnmpUser(opt);
        try {
            if (fabric.getSwitches().length == 0) {
                logger.info((Object)"SanWS setFabricCredentials fabric switch count==0, fabric.setDBCredentials...");
                fabric.setDBCredentials(user);
            } else {
                logger.info((Object)"SanWS setFabricCredentials fabric switch count != 0, SecurityManager.authenticate...");
                SecurityManager.authenticate(user, fabric);
            }
            logger.info((Object)"SanWS setFabricCredentials fabric.setCredentials...");
            fabric.setCredentials(user, true);
        }
        catch (Exception ex) {
            return new CallResultDO(1, key.toDomain().getName() + " " + ex.getMessage());
        }
        logger.info((Object)"SanWS setFabricCredentials DONE");
        return new CallResultDO();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @WebMethod(operationName="deleteFabric")
    @WebResult(name="result", partName="result")
    public CallResultDO deleteFabric(@WebParam(name="key", partName="key") FabricKeyDO key, boolean removeFromPM) throws SanServiceException, InvalidArgumentException {
        logger.info((Object)("SanWS deleteFabric key=" + key + "  removeFromPM=" + removeFromPM));
        FabricPK pk = new FabricPK(key.getFid());
        if (pk != null) {
            boolean collected = false;
            try {
                logger.info((Object)"SanWS deleteFabric check if PM collected...");
                collected = FMServerImpl.getInstance().isFabricInPmCollection(pk);
                logger.info((Object)("SanWS deleteFabric PM Collected " + collected));
            }
            catch (RemoteException ex) {
                throw new SanServiceException(ex.getMessage(), ex);
            }
            boolean restartPM = false;
            if (collected) {
                if (!removeFromPM) return new CallResultDO(1, "Can not remove Fabric: " + pk + ", it is in PM collection. Remove it from PM collection first");
                try {
                    logger.info((Object)("SanWS deleteFabric removeCollections....  fabric " + key));
                    restartPM = PerformanceHandler.getInstance().removeCollections(new FabricKeyDO[]{key});
                    logger.info((Object)("SanWS deleteFabric restartPM ? " + restartPM));
                    if (restartPM) {
                        PMImpl pm = PMImpl.getInstance();
                        pm.restart();
                    }
                }
                catch (Throwable e) {
                    logger.info((Object)"SanWS caught exception in deleteFabric.removeCollections():", e);
                    return new CallResultDO(1, "Can not remove Fabric: " + pk + " and failed to remove from PM collection.");
                }
            }
            try {
                logger.info((Object)("SanWS deleteFabric findFabric for " + pk + "..."));
                FabricImpl fabric = SanManager.getInstance().findFabric(pk);
                logger.info((Object)("SanWS deleteFabric findFabric for " + pk + "..."));
                if (fabric != null) {
                    logger.info((Object)"SanWS deleteFabric purgeFabric...");
                    SanManager.getInstance().purgeFabric(fabric);
                }
                logger.info((Object)"SanWS deleteFabric purgeFabricfromDB...");
                SanManager.getInstance().purgeFabricfromDB(pk);
            }
            catch (Exception ex) {
                logger.info((Object)("SanWS deleteFabric ex=" + ex));
                return new CallResultDO(1, ex.getMessage());
            }
        } else {
            logger.info((Object)"SanWS deleteFabric pk NULL");
            return new CallResultDO(1, "Invalid fabric key " + pk);
        }
        logger.info((Object)"SanWS DONE deleteFabric");
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="rediscoverFabric")
    @WebResult(name="result", partName="result")
    public CallResultDO rediscoverFabric(@WebParam(name="key", partName="key") FabricKeyDO key) throws SanServiceException {
        logger.info((Object)("SanWS rediscoverFabric key=" + key));
        FabricPK pk = new FabricPK(key.getFid());
        if (pk != null) {
            try {
                logger.info((Object)("SanWS rediscoverFabric findFabric for " + pk + "..."));
                SanManager.getInstance().rediscoverFabric(pk, DiscoveryType.FABRIC_ONDEMAND);
            }
            catch (Exception ex) {
                logger.info((Object)("SanWS rediscoverFabric ex=" + ex));
                return new CallResultDO(1, ex.getMessage());
            }
        } else {
            logger.info((Object)"SanWS rediscoverFabric pk NULL");
            return new CallResultDO(1, "Invalid fabric key " + pk);
        }
        logger.info((Object)"SanWS DONE rediscoverFabric");
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="getPhysicalInterface")
    @WebResult(name="result", partName="result")
    public PhyInterfaceDO getPhysicalInterface(@WebParam(name="portKey", partName="portKey") SwitchIntKeyDO portKey) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (portKey == null) {
                throw new InvalidArgumentException("Invalid switchInt key:" + portKey);
            }
            SwitchIntKey swPortKey = new SwitchIntKey(portKey.toWwnKey(), portKey.getIndex());
            return this.getSwitchPort(swPortKey);
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS Caught exception", (Throwable)e);
            throw e;
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception:", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception:", e);
            throw new SanServiceException("Cannot get switch's cards", e);
        }
    }

    private PhyInterfaceDO getSwitchPort(SwitchIntKey swPortKey) throws SanServiceException, SanNotFoundException {
        try {
            if (swPortKey == null) {
                throw new SanNotFoundException("Cannot find switchportkey");
            }
            SwitchImpl sw = SanManager.getInstance().findSwitch(swPortKey.getSwitchKey(), null);
            FcPortBase port = sw.findPort(swPortKey.getIfindex());
            if (port == null) {
                throw new SanNotFoundException("Cannot find port");
            }
            if (port.isInternalPort()) {
                throw new SanNotFoundException();
            }
            int intType = IfIndexUtil.getType(port.getIfIndex());
            if (intType == 10 || intType == 4 || intType == 11) {
                throw new SanNotFoundException();
            }
            PhyInterfaceDO invDO = new PhyInterfaceDO(port);
            if (port.getIfType() == 56) {
                if (port.getFWwn() != null) {
                    invDO.setSerialNumber(port.getFWwn().toString());
                }
            } else if (port.getFWwn() != null) {
                invDO.setSerialNumber(port.getFWwn().toString());
            } else if (port.getIfType() == 117 || port.getIfType() == 6 || port.getIfType() == 5) {
                invDO.setSerialNumber(port.getIfPhysicalAddress().toString());
            }
            int slot = -1;
            slot = port.getIfType() == 5 ? sw.getActiveSupSlot() - 1 : IfIndexUtil.ifIndex2Card(port.getIfIndex());
            Card card = InventoryManager.getInstance().findCard(swPortKey.getSwitchKey(), slot + 1);
            if (card != null) {
                invDO.setModel(card.getModelName());
                invDO.setPartNumber(card.getAssetId());
                invDO.setManufacturer(card.getManufacturer());
                invDO.setVersion(card.getSoftwareRevision());
            }
            return invDO;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"Exception found in getSwitchPort");
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"Exception found in getSwitchPort");
            throw new SanServiceException("Exception found in getSwitchPort", e);
        }
    }

    private PhyInterfaceDO[] getSwitchPortsBySwitch(WwnKey swKey) throws SanServiceException, SanNotFoundException {
        try {
            SwitchImpl sw = SanManager.getInstance().findSwitch(swKey, null);
            List<FcPortBase> invList = null;
            if (sw != null) {
                invList = sw.getPorts();
            }
            if (invList != null) {
                ArrayList<PhyInterfaceDO> invDOs = new ArrayList<PhyInterfaceDO>();
                for (int i = 0; i < invList.size(); ++i) {
                    int intType;
                    FcPortBase port = invList.get(i);
                    if (port == null || port.isInternalPort() || (intType = IfIndexUtil.getType(invList.get(i).getIfIndex())) == 10 || intType == 4 || intType == 11) continue;
                    PhyInterfaceDO invDO = new PhyInterfaceDO(port);
                    if (port.getIfType() == 56) {
                        if (port.getFWwn() != null) {
                            invDO.setSerialNumber(port.getFWwn().toString());
                        }
                    } else if (port.getFWwn() != null) {
                        invDO.setSerialNumber(port.getFWwn().toString());
                    } else if (port.getIfType() == 117 || port.getIfType() == 6 || port.getIfType() == 5) {
                        invDO.setSerialNumber(port.getIfPhysicalAddress().toString());
                    }
                    int slot = -1;
                    slot = port.getIfType() == 5 ? sw.getActiveSupSlot() - 1 : IfIndexUtil.ifIndex2Card(invList.get(i).getIfIndex());
                    Card card = InventoryManager.getInstance().findCard(swKey, slot + 1);
                    if (card != null) {
                        invDO.setModel(card.getModelName());
                        invDO.setPartNumber(card.getAssetId());
                        invDO.setManufacturer(card.getManufacturer());
                        invDO.setVersion(card.getSoftwareRevision());
                    }
                    invDOs.add(invDO);
                }
                return invDOs.toArray(new PhyInterfaceDO[0]);
            }
            throw new SanNotFoundException();
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)("Exception found in getSwitchPortBySwitch " + e));
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)("Exception found in getSwitchPortBySwitch " + e));
            throw new SanServiceException("Exception Found in getSwitchPortBySwitch" + e);
        }
    }

    private static CallResultDO discoverEthswitchesDeepOnly(CdpSeedImpl task) {
        List<EthSwitchImpl> sws = task.getDiscoveredEthSwitches();
        ArrayList<EthSwitchImpl> swsd = new ArrayList<EthSwitchImpl>();
        for (int i = 0; i < sws.size(); ++i) {
            EthSwitchImpl sw = sws.get(i);
            if (!sw.isDeepDisc()) continue;
            swsd.add(sw);
        }
        LanObject[] ethSwitches = new LanObject[swsd.size()];
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ethSwitches.length; ++i) {
            EthSwitchImpl sw = (EthSwitchImpl)swsd.get(i);
            ethSwitches[i] = new LanObject();
            ethSwitches[i].setMgmtAddr(sw.getIpAddress());
            sb.append(sw.getIpAddress());
            if (i >= ethSwitches.length - 1) continue;
            sb.append(", ");
        }
        try {
            logger.info((Object)("rediscoverEthSw, --> DCManager.deepRediscoverForSelectedLanMembers() ...  for ethSwes = " + sb.toString()));
            DCManager.getInstance().deepRediscoverForSelectedLanMembers(IdentityManager.getInstance().getCurrentUsername(), task.getTaskKey(), ethSwitches);
            logger.info((Object)("rediscoverEthSw, finish DCManager.deepRediscoverForSelectedLanMembers() ...  for ethSwes = " + sb.toString()));
        }
        catch (Exception e) {
            logger.info((Object)"rediscoverEthSw, DCManager.deepRediscoverForSelectedLanMembers() exception thrown");
            if (e instanceof DiscoveryException) {
                return new CallResultDO(1, "Failed to rediscover LAN device: " + ((DiscoveryException)((Object)e)).getDetail());
            }
            if (e.getMessage() != null && e.getMessage().contains("Connection refused")) {
                return new CallResultDO(1, "Failed to rediscover LAN device:\n\nLAN server might not be running.\n\nPlease start the LAN server and try rediscover the device.");
            }
            return new CallResultDO(1, "Failed to rediscover LAN device: " + e.getMessage());
        }
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="getActiveServerNodes")
    @WebResult(name="result", partName="result")
    public DBEntryDO getActiveServerNodes() throws SanServiceException {
        logger.info((Object)"SanWS getActiveServerNodes....");
        try {
            List<String> list = ServerMonitor.getInstance().getActiveServerNodes();
            DBEntryDO dto = new DBEntryDO();
            ArrayList<DBRowDO> rList = new ArrayList<DBRowDO>();
            dto.setColumn(new String[]{"fmServer", "dnsName"});
            for (int i = 0; i < list.size(); ++i) {
                DBRowDO row = new DBRowDO();
                String dnsName = list.get(i);
                logger.info((Object)("SanWS getActiveServerNodes,  dnsName=" + dnsName));
                try {
                    dnsName = InetAddress.getByName(dnsName).getHostName();
                    logger.info((Object)("SanWS getActiveServerNodes,  dnsName.getHostName=" + dnsName));
                }
                catch (UnknownHostException ex1) {
                    logger.warn((Object)("SanWS getActiveServerNodes() failed to getHostName for fmserver:" + dnsName));
                }
                row.setEntry(new String[]{list.get(i), dnsName});
                rList.add(row);
            }
            dto.setRow(rList.toArray(new DBRowDO[0]));
            return dto;
        }
        catch (RemoteException ex) {
            return new DBEntryDO(1, "Fail to get all active server node: " + ex.getMessage() + " " + ex);
        }
    }

    @Override
    @WebMethod(operationName="discoverLan")
    @WebResult(name="result", partName="result")
    public CallResultDO discoverLan(String seed, boolean isFWSM, SnmpCredentialDO userCredential, String maxHop, String enablePwd, Long groupDbId, boolean isDeepDiscovery, String serverIpaddress) {
        List<InetAddress> ipList;
        InetAddress seedIp;
        block28: {
            logger.info((Object)("discoverLan,  discoverLan seed = " + seed));
            if (userCredential == null) {
                throw new InvalidArgumentException("Invalid user credential:" + userCredential);
            }
            if (seed == null) {
                return new CallResultDO(1, "Invalid seed:" + seed);
            }
            seedIp = null;
            ipList = null;
            if (maxHop != null && !maxHop.equals("noop")) {
                try {
                    seedIp = InetAddress.getByName(seed);
                }
                catch (Exception ex) {
                    return new CallResultDO(1, "Invalid seed address");
                }
                try {
                    long swDBId = GlobalDCManager.getInstance().getSwitchDBIDBySwIP(seedIp, true);
                    if (swDBId != -1L) {
                        return new CallResultDO(1, seedIp.getHostAddress() + " has been discovered in LAN");
                    }
                    break block28;
                }
                catch (Exception ex) {
                    return new CallResultDO(1, "Failed to validate seed: " + ex.getMessage());
                }
            }
            try {
                ipList = IpUtil.getIPListFromString(seed, ",");
            }
            catch (UnknownHostException ex) {
                return new CallResultDO(1, "Cannot resolve " + ex.getMessage() + " to InetAddress");
            }
            catch (Exception ex) {
                return new CallResultDO(1, "Failed to parse seed list: " + ex.getMessage());
            }
            for (InetAddress ip : ipList) {
                boolean discovered = true;
                try {
                    long swDBId = GlobalDCManager.getInstance().getSwitchDBIDBySwIP(ip, true);
                    if (swDBId == -1L) {
                        discovered = false;
                        break;
                    }
                }
                catch (Exception ex) {
                    return new CallResultDO(1, "Failed to validate seeds: " + ex.getMessage());
                }
                if (!discovered) continue;
                return new CallResultDO(1, ip.getHostAddress() + " has been discovered in LAN");
            }
        }
        if (isFWSM) {
            SnmpV3AuthTypeDO v3Protocol = SnmpV3AuthTypeDO.getType(0);
            userCredential.setV3Protocol(v3Protocol);
        }
        if (userCredential.isV3()) {
            if (userCredential.getUsername() == null) {
                return new CallResultDO(1, "Invalid username: null");
            }
            if (userCredential.getV3Password() == null || userCredential.getV3Password().length() < 8) {
                return new CallResultDO(1, "Invalid password: null or length < 8");
            }
            if (userCredential.getV3Protocol() == null) {
                return new CallResultDO(1, "Invalid v3 protocol: null");
            }
        } else if (userCredential.getV2Community() == null) {
            return new CallResultDO(1, "Invalid community: null");
        }
        SnmpUserOpt userOpt = userCredential.toUserOpt();
        userOpt.setFwsm(isFWSM);
        try {
            LanImpl lan = null;
            CdpSeedImpl task = null;
            if (enablePwd.length() == 0) {
                enablePwd = null;
            }
            String dcnmUser = IdentityManager.getInstance().getCurrentUsername();
            logger.info((Object)("discoverLan,  discoverLan seed = " + seed + "   -> DCManager.discoverLan()...."));
            task = maxHop != null && !maxHop.equals("noop") ? DCManager.getInstance().discoverLan(seedIp, Integer.parseInt(maxHop), userOpt, enablePwd, groupDbId, dcnmUser, isDeepDiscovery) : DCManager.getInstance().discoverLan(ipList, userOpt, enablePwd, groupDbId, dcnmUser, isDeepDiscovery);
            if (task != null) {
                lan = task.getLan();
            }
            int timeout = 120000;
            while (!GlobalDCManager.getInstance().isCdpSeedDBPersist(task.getTaskKey())) {
                Thread.sleep(1000L);
                if ((timeout -= 1000) >= 0) continue;
                return new CallResultDO(2, "LAN task is not finished due to timeout exceeding 2 minutes. LAN may still be in discovery.");
            }
            logger.info((Object)("discoverLan,  discoverLan seed = " + seed + " done"));
            return new CallResultDO();
        }
        catch (Exception ex) {
            logger.info((Object)("discoverLan failed, seed = " + seed + " ex =" + ex));
            if (ex instanceof DiscoveryException) {
                return new CallResultDO(1, "open LAN failed: " + ((DiscoveryException)((Object)ex)).getDetail());
            }
            return new CallResultDO(1, "open LAN failed: " + ex.getMessage());
        }
    }

    @Override
    @WebMethod(operationName="setLanName")
    @WebResult(name="result", partName="result")
    public CallResultDO setLanName(FabricKeyDO key, String newName) throws SanServiceException {
        if (newName == null) {
            return new CallResultDO(1, "LAN name can not be blank");
        }
        LanPK pk = new LanPK(key.getFid());
        try {
            DCManager.getInstance().findLan(pk);
        }
        catch (Exception ex) {
            logger.warn((Object)("Caught exception from setLanName, getLan for :" + pk), (Throwable)ex);
            return new CallResultDO(1, ex.getMessage());
        }
        try {
            DCManager.getInstance().setLanName(pk, newName);
        }
        catch (Exception ex) {
            logger.warn((Object)("Caught exception from setLanName for :" + pk), (Throwable)ex);
            if (ex instanceof DiscoveryException) {
                return new CallResultDO(1, ((DiscoveryException)((Object)ex)).getDetail());
            }
            return new CallResultDO(1, ex.getMessage());
        }
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="manageLan")
    @WebResult(name="result", partName="result")
    public CallResultDO manageLan(FabricKeyDO key) throws SanServiceException {
        logger.warn((Object)("SanWS manageLan key :" + key));
        LanPK pk = new LanPK(key.getFid());
        try {
            if (DCManager.getInstance().findLan(pk) != null) {
                DCManager.getInstance().manageLan();
            }
        }
        catch (Exception ex) {
            logger.warn((Object)("Caught exception from manageLan, openLan for :" + pk), (Throwable)ex);
            if (ex instanceof DiscoveryException) {
                return new CallResultDO(1, "failed to manage LAN: " + ((DiscoveryException)((Object)ex)).getDetail());
            }
            return new CallResultDO(1, "failed to manage LAN: " + ex.getMessage());
        }
        logger.warn((Object)"SanWS manageLan DONE");
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="unmanageLan")
    @WebResult(name="result", partName="result")
    public CallResultDO unmanageLan(FabricKeyDO key) throws SanServiceException {
        logger.warn((Object)("SanWS unmanageLan key = " + key));
        LanPK pk = new LanPK(key.getFid());
        try {
            if (DCManager.getInstance().findLan(pk) != null) {
                DCManager.getInstance().unmanageLan();
            }
        }
        catch (Exception ex) {
            logger.warn((Object)("Caught exception from unmanageLan, closeLan for :" + pk), (Throwable)ex);
            if (ex instanceof DiscoveryException) {
                return new CallResultDO(1, "failed to unmanage LAN: " + ((DiscoveryException)((Object)ex)).getDetail());
            }
            return new CallResultDO(1, "failed to unmanage LAN: " + ex.getMessage());
        }
        logger.warn((Object)("SanWS unmanageLan key = " + key + " DONE"));
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="connectSwitch")
    @WebResult(name="result", partName="result")
    public CallResultDO connectSwitch(String ipAddr, int sid, String uname, String pwd, long pid, boolean isLan) throws SanServiceException {
        CallResultDO rstDo = null;
        try {
            rstDo = FlexCliImpl.getInstance().connectSwitch(ipAddr, sid, uname, pwd, pid, isLan);
            rstDo.setResultId(ipAddr);
        }
        catch (Exception ex) {
            logger.warn((Object)"Caught exception from connectSwitch for :", (Throwable)ex);
            rstDo = new CallResultDO(-1, ex.getMessage());
        }
        return rstDo;
    }

    @Override
    @WebMethod(operationName="disConnectSwitch")
    @WebResult(name="result", partName="result")
    public CallResultDO disConnectSwitch(String ipAddr, int sid) throws SanServiceException {
        CallResultDO rstDo = null;
        try {
            rstDo = FlexCliImpl.getInstance().disConnectSwitch(ipAddr, sid);
        }
        catch (Exception ex) {
            logger.warn((Object)"Caught exception from connectSwitch for :", (Throwable)ex);
            rstDo = new CallResultDO(-1, ex.getMessage(), ipAddr);
        }
        return rstDo;
    }

    @Override
    @WebMethod(operationName="runCliCmd")
    @WebResult(name="result", partName="result")
    public CallResultDO runCliCmd(String ipAddr, int sid, String cmdStr, int cmdType, int msgIdx) throws SanServiceException {
        CallResultDO rstDo = null;
        try {
            rstDo = FlexCliImpl.getInstance().runCliCmd(ipAddr, sid, cmdStr, cmdType, msgIdx);
        }
        catch (Exception ex) {
            logger.warn((Object)"Caught exception from runCliCmd for :", (Throwable)ex);
            rstDo = new CallResultDO(-1, ex.getMessage(), ipAddr);
        }
        return rstDo;
    }

    @Override
    @WebMethod(operationName="fetchInterfaceData")
    @WebResult(name="result", partName="result")
    public void fetchInterfaceData(String ipAddr, boolean isLan) throws SanServiceException {
        logger.warn((Object)("CdpDiscvHelper.discoverAndPersistPorts for : " + ipAddr + " Start- " + System.currentTimeMillis()));
        CdpDiscvHelper.discoverAndPersistPorts(ipAddr, isLan);
        logger.warn((Object)("CdpDiscvHelper.discoverAndPersistPorts for : " + ipAddr + " End- " + System.currentTimeMillis()));
    }

    @Override
    @WebMethod(operationName="getCliResult")
    @WebResult(name="result", partName="result")
    public CallResultDO getCliResult(String ipAddr, int sid, int strIdx) throws SanServiceException {
        CallResultDO rstDo = null;
        try {
            rstDo = FlexCliImpl.getInstance().getCliResult(ipAddr, sid, strIdx);
        }
        catch (Exception ex) {
            logger.warn((Object)"Caught exception from getCliResult for :", (Throwable)ex);
            rstDo = new CallResultDO(-1, ex.getMessage(), ipAddr);
        }
        return rstDo;
    }

    @Override
    @WebMethod(operationName="getCliSwitches")
    @WebResult(name="result", partName="result")
    public SwitchDO[] getCliSwitches(DbFilterDO dbFilter) throws SanServiceException {
        try {
            List<SwitchDO> switchList = SwitchHandler.getInstance().getCliSwitches(dbFilter);
            ArrayList<SwitchDO> cliList = new ArrayList<SwitchDO>();
            for (int i = 0; i < switchList.size(); ++i) {
                SwitchDO sDo = switchList.get(i);
                if (sDo.getName() == null || sDo.getName().length() == 0) continue;
                cliList.add(switchList.get(i));
            }
            return cliList.toArray(new SwitchDO[0]);
        }
        catch (Exception ex) {
            logger.warn((Object)"Caught exception from cli switches for :", (Throwable)ex);
            throw new SanServiceException("Cannot get cli switches", ex);
        }
    }

    @Override
    @WebMethod(operationName="manageCdpTask")
    @WebResult(name="result", partName="result")
    public CallResultDO manageCdpTask(String taskKey, FabricKeyDO key) throws SanServiceException {
        logger.info((Object)("manageCdpTask,  taskKey = " + taskKey));
        TaskKey pk = new TaskKey(Long.parseLong(taskKey));
        try {
            logger.info((Object)"manageCdpTask --> DCManager.manageTask()....");
            DCManager.getInstance().manageTask(pk);
            logger.info((Object)"manageCdpTask --> DCManager.manageLanDeepDiscoveryTask()....");
            DCManager.getInstance().manageLanDeepDiscoveryTask(IdentityManager.getInstance().getCurrentUsername(), pk);
        }
        catch (Exception ex) {
            logger.warn((Object)("Caught exception from manageCdpTask for :" + pk), (Throwable)ex);
            if (ex instanceof DiscoveryException) {
                return new CallResultDO(1, ((DiscoveryException)((Object)ex)).getDetail());
            }
            if (ex.getMessage() != null && ex.getMessage().contains("Connection refused")) {
                return new CallResultDO(1, "LAN server might not be running.\nPlease start the LAN server and try manage the task.");
            }
            return new CallResultDO(1, ex.getMessage());
        }
        logger.info((Object)("manageCdpTask DONE taskKey = " + taskKey));
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="unmanageCdpTask")
    @WebResult(name="result", partName="result")
    public CallResultDO unmanageCdpTask(String taskKey, FabricKeyDO key) throws SanServiceException {
        logger.info((Object)("unmanageCdpTask,  taskKey = " + taskKey));
        TaskKey pk = new TaskKey(Long.parseLong(taskKey));
        try {
            logger.info((Object)"unmanageCdpTask --> DCManager.unmanageLanDeepDiscoveryTask()....");
            DCManager.getInstance().unManageLanDeepDiscoveryTask(IdentityManager.getInstance().getCurrentUsername(), pk);
            logger.info((Object)"unmanageCdpTask --> DCManager.unmanageTask()....");
            DCManager.getInstance().unmanageTask(pk);
        }
        catch (Exception ex) {
            logger.warn((Object)("Caught exception from unmanageCdpTask for :" + pk), (Throwable)ex);
            if (ex instanceof DiscoveryException) {
                return new CallResultDO(1, "Failed to unmanage CdpTask: " + ((DiscoveryException)((Object)ex)).getDetail());
            }
            if (ex.getMessage() != null && ex.getMessage().contains("Connection refused")) {
                return new CallResultDO(1, "Failed to unmanage CdpTask:\n\nLAN server might not be running.\nPlease start the LAN server and try unmanage the task.");
            }
            return new CallResultDO(1, "Failed to unmanage CdpTask: " + ex.getMessage());
        }
        logger.info((Object)("unmanageCdpTask DONE taskKey = " + taskKey));
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="rediscoverEthSw")
    @WebResult(name="result", partName="result")
    public CallResultDO rediscoverEthSw(String taskKey, String ethSwIP, Long ethSwId) {
        return SanWS.rediscoverEthSw_detail(taskKey, ethSwIP, ethSwId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CallResultDO rediscoverEthSw_detail(String taskKey, String ethSwIP, Long ethSwId) {
        logger.info((Object)("rediscoverEthSw, taskKey/ethSwIP/ethSwId = " + taskKey + "/" + ethSwIP + "/" + ethSwId));
        if (!SanWS.isTaskManageable(Long.parseLong(taskKey))) {
            logger.info((Object)("rediscoverEthSw, taskKey/ethSwIP/ethSwId = " + taskKey + "/" + ethSwIP + "/" + ethSwId + ", Failed to rediscover LAN device, task unmanaged"));
            return new CallResultDO(1, "Failed to rediscover LAN device, task unmanaged");
        }
        if (ethSwIP == null || ethSwIP.equals("")) {
            ResultSet rs;
            PreparedStatement stat;
            Connection con;
            block17: {
                Object b1;
                con = null;
                stat = null;
                rs = null;
                try {
                    con = ConnectionManager.getConnection();
                    stat = con.prepareStatement(queryEthSwIPByEthSwId);
                    stat.setLong(1, ethSwId);
                    rs = stat.executeQuery();
                    ethSwIP = "";
                    while (rs.next()) {
                        b1 = rs.getBytes(1);
                        if (b1 == null) continue;
                        try {
                            ethSwIP = InetAddress.getByAddress(b1).getHostAddress();
                        }
                        catch (UnknownHostException ue) {
                            logger.error((Object)"rediscoverEthSw failed to resolve ethSwIP from DB ", (Throwable)ue);
                            CallResultDO callResultDO = new CallResultDO(1, "Failed to rediscover LAN device/get IP for LAN device: " + ue.getMessage());
                            DbUtil.close(rs);
                            DbUtil.close(stat);
                            DbUtil.close(con);
                            return callResultDO;
                        }
                    }
                    if (!ethSwIP.equals("")) break block17;
                    b1 = new CallResultDO(1, "Failed to rediscover LAN device/No IP");
                }
                catch (SQLException ex) {
                    CallResultDO callResultDO;
                    try {
                        logger.error((Object)"getEthSwitchByLanId", (Throwable)ex);
                        callResultDO = new CallResultDO(1, "Failed to rediscover LAN device/SQL error: " + ex.getMessage());
                    }
                    catch (Throwable throwable) {
                        DbUtil.close(rs);
                        DbUtil.close(stat);
                        DbUtil.close(con);
                        throw throwable;
                    }
                    DbUtil.close(rs);
                    DbUtil.close(stat);
                    DbUtil.close(con);
                    return callResultDO;
                }
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                return b1;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        TaskKey taskK = new TaskKey(Long.parseLong(taskKey));
        try {
            LanObject[] ethSwitches = new LanObject[]{new LanObject()};
            ethSwitches[0].setMgmtAddr(ethSwIP);
            EthSwitchImpl ethSw = DCManager.getInstance().getLan().findEthSwitchByDBID(ethSwId);
            if (ethSw == null) {
                logger.info((Object)("rediscoverEthSw, DCManager.deepRediscoverForSelectedLanMembers() cannot find ethSwitchImpl for " + ethSwId + ", switch may still in discovery state"));
                return new CallResultDO(1, "Failed to rediscover LAN device, switch may still in discovery state: " + ethSwIP + '/' + ethSwId);
            }
            if (ethSw.isDeepDisc()) {
                logger.info((Object)("rediscoverEthSw, --> DCManager.deepRediscoverForSelectedLanMembers() ...  for ethSw = " + ethSwIP));
                DCManager.getInstance().deepRediscoverForSelectedLanMembers(IdentityManager.getInstance().getCurrentUsername(), taskK, ethSwitches);
                logger.info((Object)("rediscoverEthSw, finish DCManager.deepRediscoverForSelectedLanMembers() ...  for ethSw = " + ethSwIP));
            } else {
                logger.info((Object)("rediscoverEthSw, --> DCManager.deepRediscoverForSelectedLanMembers() ethSw " + ethSwId + " deepDiscovery False"));
            }
        }
        catch (Exception e) {
            logger.info((Object)"rediscoverEthSw, DCManager.deepRediscoverForSelectedLanMembers() exception thrown");
            if (e instanceof DiscoveryException) {
                logger.info((Object)("rediscoverEthSw, DiscoveryException=" + ((DiscoveryException)((Object)e)).getDetail()));
                return new CallResultDO(1, "Failed to rediscover LAN device: " + ((DiscoveryException)((Object)e)).getDetail());
            }
            logger.info((Object)("rediscoverEthSw, e=" + e.getMessage()));
            if (e.getMessage() != null && e.getMessage().contains("Connection refused")) {
                return new CallResultDO(1, "Failed to rediscover LAN device:\n\nLAN server might not be running.\n\nPlease start the LAN server and try rediscover the device.");
            }
            return new CallResultDO(1, "Failed to rediscover LAN device: " + e.getMessage());
        }
        logger.info((Object)"rediscoverEthSw DONE");
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="setEthSw4DeepDiscovery")
    @WebResult(name="result", partName="result")
    public CallResultDO setEthSw4DeepDiscovery(String taskKey, String cdpSeedDbId, String[] ethSwDbIdList, String serverIpaddress) {
        return SanWS.setEthSw4DeepDiscovery_detail(taskKey, cdpSeedDbId, ethSwDbIdList, serverIpaddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CallResultDO setEthSw4DeepDiscovery_detail(String taskKey, String cdpSeedDbId, String[] ethSwDbIdList, String serverIpaddress) {
        if (ethSwDbIdList == null || ethSwDbIdList.length == 0) {
            logger.info((Object)"setEthSw4DeepDiscovery ethSwDbIdList null or 0 length");
            return new CallResultDO(1, "Invalid EthSwList");
        }
        logger.info((Object)("setEthSw4DeepDiscovery taskKey/cdpSeedDbId " + taskKey + " / " + cdpSeedDbId + "   sw ct=" + ethSwDbIdList.length));
        ArrayList<InetAddress> swIpList = new ArrayList<InetAddress>();
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            String sqlStr = queryEthSwitchByCdpSeedDbId_all;
            stat = con.prepareStatement(sqlStr);
            stat.setLong(1, Long.parseLong(cdpSeedDbId));
            rs = stat.executeQuery();
            block8: while (rs.next()) {
                long swId = rs.getLong(2);
                byte[] b1 = rs.getBytes(1);
                for (String dbId : ethSwDbIdList) {
                    if (swId != Long.parseLong(dbId)) continue;
                    logger.info((Object)("setEthSw4DeepDiscovery, find ip for swId " + swId));
                    try {
                        swIpList.add(InetAddress.getByAddress(b1));
                    }
                    catch (UnknownHostException ue) {
                        logger.error((Object)("setEthSw4DeepDiscovery failed to resolve ethSwIP from DB for swId " + swId), (Throwable)ue);
                    }
                    continue block8;
                }
            }
        }
        catch (SQLException ex) {
            CallResultDO swId;
            try {
                logger.error((Object)"setEthSw4DeepDiscovery  ex ", (Throwable)ex);
                swId = new CallResultDO(1, ex.getMessage());
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
            return swId;
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        logger.info((Object)("setEthSw4DeepDiscovery, ---> getLan(),  sw ct=" + swIpList.size()));
        LanImpl lan = DCManager.getInstance().getLan();
        if (lan == null) {
            logger.info((Object)"setEthSw4DeepDiscovery, cannot find LAN, lan=null");
            return new CallResultDO(1, "cannot find LAN");
        }
        CdpSeedImpl taskImpl = lan.findCdpSeedBySeedPK(new TaskKey(Long.parseLong(taskKey)));
        if (taskImpl == null) {
            logger.info((Object)"setEthSw4DeepDiscovery, cannot find LAN task, taskImpl=null");
            return new CallResultDO(1, "cannot find LAN task");
        }
        logger.info((Object)"setEthSw4DeepDiscovery,  --> DCManager.setTask().....");
        try {
            DCManager.getInstance().setTask(taskImpl, swIpList);
        }
        catch (Exception ex) {
            logger.info((Object)"setEthSw4DeepDiscovery, failed to setTask, ex ", (Throwable)ex);
            if (ex instanceof DiscoveryException) {
                logger.info((Object)("setEthSw4DeepDiscovery, failed to set EthSwitch Deep Discovery, DiscoveryEx= " + ((DiscoveryException)((Object)ex)).getDetail()));
                return new CallResultDO(1, "Failed to EthSwitch Deep Discovery: " + ((DiscoveryException)((Object)ex)).getDetail());
            }
            logger.info((Object)("setEthSw4DeepDiscovery, ex=" + ex.getMessage()));
            if (ex.getMessage() != null && ex.getMessage().contains("Connection refused")) {
                return new CallResultDO(1, "Failed to set EthSwitch Deep Discovery:\n\nLAN server might not be running.\n\nPlease start the LAN server and try Deep discover the device.");
            }
            logger.info((Object)("setEthSw4DeepDiscovery, failed to set EthSwitch Deep Discovery, ex= " + ex.getMessage()));
            return new CallResultDO(1, "Failed to set EthSwitch Deep Discovery: " + ex.getMessage());
        }
        logger.info((Object)"setEthSw4DeepDiscovery  DONE");
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="setCdpSeed")
    @WebResult(name="result", partName="result")
    public CallResultDO setCdpSeed(String seedIp, String taskKey, String taskType, SnmpCredentialDO userCredential, String maxHops, String subnet, String mask, String ipRange, String enablePwd, Long groupDBID, String serverIpaddress) {
        logger.info((Object)("setCdpSeed,  taskId/seedIp = " + seedIp + "/" + taskKey));
        try {
            SnmpUserOpt user = null;
            if (userCredential != null) {
                if (userCredential.isV3() && (userCredential.getV3Password() == null || userCredential.getV3Password().length() < 8)) {
                    return new CallResultDO(1, "Invalid password: null or length < 8");
                }
                user = new SnmpUserOpt(userCredential.getUsername(), userCredential.getV3Password(), userCredential.getV2Community(), userCredential.isV3() ? userCredential.getV3Protocol().value() : -1, userCredential.isV3());
            }
            CdpSeedBase task = null;
            DiscTaskType taskTypeV = DiscTaskType.getType(taskType);
            List<InetAddress> ipList = IpUtil.getIPListFromString(seedIp, ",");
            String dcnmUser = IdentityManager.getInstance().getCurrentUsername();
            task = taskTypeV == DiscTaskType.LAN_MAXHOP ? new CdpSeedBase(new TaskKey(Long.parseLong(taskKey)), ipList.get(0), Integer.parseInt(maxHops), user, enablePwd, (long)groupDBID, 0L, dcnmUser, false) : new CdpSeedBase(new TaskKey(Long.parseLong(taskKey)), ipList, Integer.parseInt(maxHops), user, enablePwd, (long)groupDBID, 0L, dcnmUser, false);
            boolean credChange = DCManager.getInstance().setCredentialTest(task);
            LanImpl lan = DCManager.getInstance().getLan();
            CdpSeedImpl taskImpl = lan.findCdpSeedBySeedPK(new TaskKey(Long.parseLong(taskKey)));
            if (taskImpl.isManageable()) {
                return new CallResultDO(1, "Please unmanage LAN task before changing credential");
            }
            logger.info((Object)"setCdpSeed,  --> DCManager.changeLANCredentials().....");
            DCManager.getInstance().changeLANCredentials(IdentityManager.getInstance().getCurrentUsername(), taskKey, userCredential, enablePwd);
            logger.info((Object)"setCdpSeed,  --> DCManager.setTask().....");
            DCManager.getInstance().setTask(task, credChange, false);
            logger.info((Object)"setCdpSeed, DONE");
            return new CallResultDO();
        }
        catch (Exception e) {
            logger.warn((Object)"SanWS caught exception in modifyLan():", (Throwable)e);
            if (e instanceof DiscoveryException) {
                return new CallResultDO(1, "Failed to modify LAN cdp seed " + ((DiscoveryException)((Object)e)).getDetail());
            }
            if (e.getMessage() != null && e.getMessage().contains("Connection refused")) {
                return new CallResultDO(1, "Failed to modify LAN cdp seed " + seedIp + ":\n\nLAN server might not be running.\nPlease start the LAN server and try modify the cdp seed.");
            }
            return new CallResultDO(1, "Failed to modify LAN cdp seed " + seedIp + ": " + e.getMessage());
        }
    }

    @Override
    @WebMethod(operationName="removeCdpSeed")
    @WebResult(name="result", partName="result")
    public CallResultDO removeCdpSeed(String taskStr, String serverIpaddress) {
        try {
            if (taskStr == null) {
                return new CallResultDO(1, "Invalid lan task id:" + taskStr);
            }
            long taskId = Long.parseLong(taskStr);
            logger.info((Object)("removeCdpSeed,  remove CdpTask taskId = " + taskId + "   -> DCManager.removeLanTask...."));
            List<KeyValueDO> monitoredEthSws = PerformanceHandler.getInstance().getMonitoredEthSw(taskId);
            boolean restartPM = monitoredEthSws.size() > 0;
            DCManager.getInstance().removeLanTask(IdentityManager.getInstance().getCurrentUsername(), taskId);
            logger.info((Object)("removeCdpSeed,  remove CdpTask taskId = " + taskId + "   -> DCManager.removeTask...."));
            TaskKey taskKey = new TaskKey(taskId);
            DCManager.getInstance().removeTask(taskKey, true);
            HostImpl.cleanupLanHosts();
            logger.info((Object)("removeCdpSeed,  removeTask done, restartPM = " + restartPM));
            if (restartPM) {
                PMImpl pm = PMImpl.getInstance();
                pm.restart();
            }
            logger.info((Object)("removeCdpSeed,  DONE remove CdpTask taskId = " + taskId));
            return new CallResultDO();
        }
        catch (Exception e) {
            logger.warn((Object)"SanWS caught exception in removeCdpSeed():", (Throwable)e);
            if (e instanceof DiscoveryException) {
                return new CallResultDO(1, "Failed to remove Cdp seed switch: " + ((DiscoveryException)((Object)e)).getDetail());
            }
            if (e.getMessage() != null && e.getMessage().contains("Connection refused")) {
                return new CallResultDO(1, "Failed to remove Cdp seed switch:\n\nLAN server might not be running.\nPlease start the LAN server and try deleting the task.");
            }
            return new CallResultDO(1, "Failed to remove Cdp seed switch: " + e.getMessage());
        }
    }

    @WebMethod(operationName="removeCdpSeed")
    @WebResult(name="result", partName="result")
    public CallResultDO removeCdpSeed(DiscTaskKeyDO taskKey, String serverIpaddress) {
        try {
            if (taskKey == null) {
                return new CallResultDO(1, "Invalid lan task key:" + taskKey);
            }
            DCManager.getInstance().removeTask(taskKey.toBase(), true);
            return new CallResultDO();
        }
        catch (Exception e) {
            logger.warn((Object)"SanWS caught exception in removeCdpSeed():", (Throwable)e);
            if (e instanceof DiscoveryException) {
                return new CallResultDO(1, "Failed to remove Cdp seed switch: " + ((DiscoveryException)((Object)e)).getDetail());
            }
            return new CallResultDO(1, "Failed to remove Cdp seed switch: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WebMethod(operationName="removeEthSwitch")
    @WebResult(name="result", partName="result")
    public CallResultDO removeEthSwitch(String switchIp, String serverIpaddress) {
        logger.info((Object)("removeEthSwitch, switchIp: " + switchIp + "/serverIpaddress: " + serverIpaddress));
        try {
            if (switchIp == null) {
                logger.warn((Object)("removeEthSwitch, Invalid lan switch IP : " + switchIp));
                return new CallResultDO(1, "Invalid lan switch IP:" + switchIp);
            }
            LanImpl lan = DCManager.getInstance().getLan();
            if (lan == null) {
                logger.warn((Object)"removeEthSwitch, cannot find LAN, lan=null");
                return new CallResultDO(1, "Failed to remove switch, cannot find LAN");
            }
            EthSwitchImpl ethSwitchImpl = lan.findEthSwitchByIp(InetAddress.getByName(switchIp));
            if (ethSwitchImpl == null) {
                logger.warn((Object)("removeEthSwitch, cannot find EthSwitchImpl for the IP address: " + switchIp + ", switch may still in discovery state "));
                return new CallResultDO(1, "Failed to remove switch, switch may still in discovery state: " + switchIp);
            }
            InetAddress clientIp = IdentityManager.getInstance().getClientAddress();
            String userName = IdentityManager.getInstance().getCurrentUsername();
            ethSwitchImpl.setClientIp(clientIp);
            ethSwitchImpl.setUserName(userName);
            try {
                CdpSeedImpl seed = lan.findCdpSeedFromNodePK(ethSwitchImpl.getPK());
                if (seed != null && seed.getNumOfEthSwitches() == 1) {
                    logger.info((Object)("removeEthSwitch, sw ct 1, removeCdpSeed()... " + switchIp));
                    return this.removeCdpSeed(Long.toString(seed.getTaskKey().getId()), serverIpaddress);
                }
                if (ethSwitchImpl.isDeepDisc()) {
                    String[] devices = new String[]{ethSwitchImpl.getIpAddress()};
                    logger.info((Object)("removeEthSwitch, isDeepDisc, removeDeepLANDevices()... " + switchIp));
                    DCManager.getInstance().removeDeepLANDevices(IdentityManager.getInstance().getCurrentUsername(), devices);
                }
            }
            catch (Exception e) {
                logger.warn((Object)"SanWS caught exception in removeEthSwitch():", (Throwable)e);
                if (e instanceof DiscoveryException) {
                    return new CallResultDO(1, "Failed to remove switch: " + ethSwitchImpl.getIpAddress() + " " + ((DiscoveryException)((Object)e)).getDetail());
                }
                if (e.getMessage() != null && e.getMessage().contains("Connection refused")) {
                    return new CallResultDO(1, "Failed to remove switch: " + ethSwitchImpl.getIpAddress() + "\n\nLAN server might not be running.\nPlease start the LAN server and try deleting the task.");
                }
                return new CallResultDO(1, "Failed to remove switch: " + ethSwitchImpl.getIpAddress() + " " + e.getMessage());
            }
            logger.info((Object)("removeEthSwitch, DCManager.getWorker()... " + switchIp));
            CdpWorker cdpWorker = DCManager.getInstance().getLan().getWorker();
            if (cdpWorker == null) {
                logger.warn((Object)("removeEthSwitch, cannot find cdpworker for the switch: " + switchIp));
                return new CallResultDO(1, "Failed to remove switch, cannot find cdpworkder for the switch: " + switchIp);
            }
            long grp = NavigationUtil.getInstance().getGroupIdBySw(ethSwitchImpl.getDBID());
            long group = grp > 0L ? grp : 2L;
            cdpWorker.stopEthNodeWorker(ethSwitchImpl);
            boolean removed = lan.removeEthSwitchAndComponents(ethSwitchImpl, true);
            if (!removed) {
                logger.warn((Object)("removeEthSwitch, failed to remove switch, lan.removeEthSwitchAndComponents : " + switchIp));
                return new CallResultDO(1, "failed to remove switch : " + switchIp);
            }
            int deletedRows = PmExtraOidImpl.deletePMExtraOidBySWid(ethSwitchImpl.getDBID());
            if (deletedRows > 0) {
                PMImpl pm = PMImpl.getInstance();
                pm.restart();
            }
            if (ethSwitchImpl.getIpAddress() != null) {
                ((EventControllerService)ServiceConfig.findService("Event Controller Service")).publishAccounting(new SyslogEntry(ethSwitchImpl.getLan().getPK(), ethSwitchImpl.getClientIp(), ethSwitchImpl.getLan().getDBID(), "DCNM-LAN", LogEventType.LAN.toString(), ethSwitchImpl.getUserName(), "LAN switch '" + switchIp + "' removed", Severity.INFO.getValue(), 1, group));
            }
            logger.info((Object)("removeEthSwitch DONE " + switchIp));
            return new CallResultDO();
        }
        catch (Exception e) {
            logger.warn((Object)"SanWS caught exception in removeEthSwitch():", (Throwable)e);
            if (e instanceof DiscoveryException) {
                return new CallResultDO(1, "Failed to remove switch: " + ((DiscoveryException)((Object)e)).getDetail());
            }
            return new CallResultDO(1, "Failed to remove switch: " + e.getMessage());
        }
    }

    @Override
    @WebMethod(operationName="rediscoverLanTask")
    @WebResult(name="result", partName="result")
    public CallResultDO rediscoverLanTask(String taskKey, String serverIpaddress) {
        return SanWS.rediscoverLanTask_detail(taskKey, serverIpaddress);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CallResultDO rediscoverLanTask_detail(String taskKey, String serverIpaddress) {
        CallResultDO callResultDO;
        logger.info((Object)"rediscoverLanTask .....");
        if (!SanWS.isTaskManageable(Long.parseLong(taskKey))) {
            logger.info((Object)("rediscoverLanTask, failed to discover LAN Task " + taskKey + ",  task unmanaged"));
            return new CallResultDO(1, "Failed to rediscover LAN Task " + taskKey + ",  task unmanaged");
        }
        CallResultDO result = null;
        LanImpl lan = DCManager.getInstance().getLan();
        if (lan == null) {
            logger.info((Object)"rediscoverLanTask, cannot find LAN, lan=null");
            return new CallResultDO(1, "cannot find LAN");
        }
        CdpSeedImpl taskImpl = lan.findCdpSeedBySeedPK(new TaskKey(Long.parseLong(taskKey)));
        if (taskImpl == null) {
            logger.info((Object)"rediscoverLanTask, cannot find LAN task, taskImpl=null");
            return new CallResultDO(1, "cannot find LAN task");
        }
        logger.info((Object)"rediscoverLanTask,  --> DCManager.setTask().....");
        try {
            taskImpl.setNeedDisc(true);
            DiscoveryManager.getInstance().discoverLan(lan, DiscoveryType.LAN_ONDEMAND);
        }
        catch (Exception ex) {
            logger.info((Object)"rediscoverLanTask, failed to discover lan task, ex ", (Throwable)ex);
            return new CallResultDO(1, "Failed to rediscover LAN Task at: " + serverIpaddress + ": " + ex.getMessage());
        }
        logger.error((Object)"rediscoverLanTask  DONE");
        if (result == null) {
            callResultDO = new CallResultDO();
            return callResultDO;
        }
        callResultDO = result;
        return callResultDO;
    }

    @Override
    @WebMethod(operationName="rediscoverLan")
    @WebResult(name="result", partName="result")
    public CallResultDO rediscoverLan(String serverIpaddress) {
        try {
            logger.info((Object)"rediscoverLan --> DCManager.rediscoverLan()  with LAN_ONDEMAND_SHALLOW_ONLY ...");
            DCManager.getInstance().rediscoverLan(DiscoveryType.LAN_ONDEMAND_SHALLOW_ONLY);
            logger.info((Object)"rediscoverLan DONE");
            return new CallResultDO();
        }
        catch (Exception e) {
            logger.warn((Object)"SanWS caught exception in rediscoverLan():", (Throwable)e);
            if (e instanceof DiscoveryException) {
                return new CallResultDO(1, "Failed to rediscover LAN at " + serverIpaddress + ": " + ((DiscoveryException)((Object)e)).getDetail());
            }
            return new CallResultDO(1, "Failed to rediscover LAN at " + serverIpaddress + ": " + e.getMessage());
        }
    }

    @Override
    @WebMethod(operationName="getFabricKeys4Lan")
    @WebResult(name="result", partName="result")
    public FabricKeyDO[] getFabricKeys4Lan() throws SanServiceException {
        try {
            List<LanPK> pks = GlobalDCManager.getInstance().getAllLanPKs();
            FabricKeyDO[] keys = new FabricKeyDO[pks.size()];
            for (int i = 0; i < pks.size(); ++i) {
                FabricPK pk = pks.get(i);
                keys[i] = new FabricKeyDO(pk);
            }
            return keys;
        }
        catch (Exception ex) {
            logger.warn((Object)"SanWS caught exception in getFabricKeys4Lan():", (Throwable)ex);
            throw new SanServiceException("Cannot get Fabric Keys for LAN:" + ex);
        }
    }

    @Override
    @WebMethod(operationName="getEthSwitchByLAN")
    @WebResult(name="result", partName="result")
    public DBEntryDO getEthSwitchAll() throws SanServiceException, InvalidArgumentException {
        return SanWS.getEthSwitchByCdpSeedDbId_detail(-1L, false, 0);
    }

    @Override
    @WebMethod(operationName="getEthSwitchByCdpSeedDbId")
    @WebResult(name="result", partName="result")
    public DBEntryDO getEthSwitchByCdpSeedDbId(long cdpSeedDbId, boolean isFWSM, int deepDiscoveredOption) throws SanServiceException, InvalidArgumentException {
        return SanWS.getEthSwitchByCdpSeedDbId_detail(cdpSeedDbId, isFWSM, deepDiscoveredOption);
    }

    /*
     * Unable to fully structure code
     */
    public static DBEntryDO getEthSwitchByCdpSeedDbId_detail(long cdpSeedDbId, boolean isFWSM, int deepDiscoveredOption) throws SanServiceException, InvalidArgumentException {
        SanWS.logger.info((Object)("getEthSwitchByLanId,  retrieve ethSwIP from DB for cdpSeedDbId = " + cdpSeedDbId));
        dto = new DBEntryDO();
        rList = new ArrayList<DBRowDO>();
        dto.setColumn(new String[]{"Switch", "Status", "groupMemDbId", "groupDbId", "groupName", "swIP", "swId", "discoverState", "discoverDesc", "lastUpdate", "model", "location", "contact", "ismanageable", "isFex", "isMDS", "isDeepDiscovered"});
        lanList = new ArrayList<E>();
        nextLan_query_state = false;
        nextLan = -1;
        done = false;
        while (!done) {
            block17: {
                con = null;
                stat = null;
                rs = null;
                sqlStr = "";
                if (cdpSeedDbId == -1L && lanList.size() == 0) {
                    try {
                        SanWS.logger.info((Object)"getEthSwitchByLanId getAllDevices --->  GlobalDCManager.getAllLanPKs()");
                        lanList = GlobalDCManager.getInstance().getAllLanPKs();
                    }
                    catch (SQLException ex) {
                        SanWS.logger.error((Object)"getEthSwitchByLanId getAllDevices ex=", (Throwable)ex);
                        throw new SanServiceException(ex.getMessage());
                    }
                    nextLan_query_state = false;
                } else if (cdpSeedDbId != -1L) {
                    SanWS.logger.info((Object)("getEthSwitchByLanId,  getDevices for cdpSeedDbId = " + cdpSeedDbId));
                    done = true;
                }
                con = ConnectionManager.getConnection();
                if (cdpSeedDbId != -1L) ** GOTO lbl56
                SanWS.logger.info((Object)("getEthSwitchByLanId,  getAllDevices... isFWSM=" + isFWSM));
                if (nextLan_query_state) ** GOTO lbl48
                isFWSM = false;
                if (lanList != null && ++nextLan < lanList.size()) break block17;
                SanWS.logger.info((Object)"getEthSwitchByLanId,  getAllDevices done true, lanList null or exceed lanList.size()");
                done = true;
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                continue;
            }
            try {
                block18: {
                    SanWS.logger.info((Object)("getEthSwitchByLanId,  getAllDevices on LAN " + ((LanPK)lanList.get(nextLan)).getId() + " ,isFWSM=" + isFWSM + " query..."));
                    sqlStr = "select ethswitch.sys_name, ethswitch.ip_address, ethswitch.is_manageable, ethswitch.is_present, ethswitch.last_scan_time, ethswitch.unmanageable_cause, ethswitch.id, ethswitch.disc_status, ethswitch.deep_desc, ethswitch.LAST_UPDATE_TIME, ethswitch.model_name, ethswitch.sys_location, ethswitch.sys_contact, ethswitch.is_fex, ethswitch.type, ethswitch.is_deep_disc, gm.mem_dbid, gm.group_id, g.name, cdp_seed.id from ethswitch, ethswitch_seed, cdp_seed, nav_group_member gm, nav_groups g, lan l where (ethswitch.id=ethswitch_seed.switch_id) AND (ethswitch_seed.seed_id=cdp_seed.id) AND l.id=cdp_seed.lan_id AND l.lan_id=? and gm.mem_dbid=ethswitch.id  and g.id=gm.group_id";
                    stat = con.prepareStatement(sqlStr);
                    stat.setLong(1, ((LanPK)lanList.get(nextLan)).getId());
                    nextLan_query_state = true;
                    break block18;
lbl48:
                    // 1 sources

                    if (nextLan_query_state) {
                        isFWSM = true;
                        SanWS.logger.info((Object)("getEthSwitchByLanId,  getAllDevices on LAN " + ((LanPK)lanList.get(nextLan)).getId() + " ,isFWSM=" + isFWSM + " query..."));
                        sqlStr = "select ethswitch.sys_name, ethswitch.ip_address, ethswitch.is_manageable, ethswitch.is_present, ethswitch.last_scan_time, ethswitch.unmanageable_cause, ethswitch.id, ethswitch.disc_status, ethswitch.deep_desc, ethswitch.LAST_UPDATE_TIME, ethswitch.model_name, ethswitch.sys_location, ethswitch.sys_contact, ethswitch.is_fex, ethswitch.type, ethswitch.is_deep_disc, cdp_seed.id from ethswitch, ethswitch_seed, cdp_seed, lan l where (ethswitch.id=ethswitch_seed.switch_id) AND (ethswitch_seed.seed_id=cdp_seed.id) AND (cdp_seed.FWSM=true) AND l.id=cdp_seed.lan_id AND l.lan_id=? ";
                        stat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(sqlStr));
                        stat.setLong(1, ((LanPK)lanList.get(nextLan)).getId());
                        nextLan_query_state = false;
                    }
                    break block18;
lbl56:
                    // 1 sources

                    SanWS.logger.info((Object)("getEthSwitchByLanId,  getDevices for cdpSeedDbId = " + cdpSeedDbId + " ,isFWSM=" + isFWSM + " query..."));
                    sqlStr = isFWSM != false ? "select ethswitch.sys_name, ethswitch.ip_address, ethswitch.is_manageable, ethswitch.is_present, ethswitch.last_scan_time, ethswitch.unmanageable_cause, ethswitch.id, ethswitch.disc_status, ethswitch.deep_desc, ethswitch.LAST_UPDATE_TIME, ethswitch.model_name, ethswitch.sys_location, ethswitch.sys_contact, ethswitch.is_fex, ethswitch.type, ethswitch.is_deep_disc from ethswitch, ethswitch_seed, cdp_seed where (ethswitch.id=ethswitch_seed.switch_id) AND (ethswitch_seed.seed_id=cdp_seed.id) AND (cdp_seed.id=?) " : "select ethswitch.sys_name, ethswitch.ip_address, ethswitch.is_manageable, ethswitch.is_present, ethswitch.last_scan_time, ethswitch.unmanageable_cause, ethswitch.id, ethswitch.disc_status, ethswitch.deep_desc, ethswitch.LAST_UPDATE_TIME, ethswitch.model_name, ethswitch.sys_location, ethswitch.sys_contact, ethswitch.is_fex, ethswitch.type, ethswitch.is_deep_disc, gm.mem_dbid, gm.group_id, g.name from ethswitch, ethswitch_seed, cdp_seed, nav_group_member gm, nav_groups g where (ethswitch.id=ethswitch_seed.switch_id) AND (ethswitch_seed.seed_id=cdp_seed.id) AND (cdp_seed.id=?) and gm.mem_dbid=ethswitch.id  and g.id=gm.group_id";
                    stat = con.prepareStatement(sqlStr);
                    stat.setLong(1, cdpSeedDbId);
                }
                rs = stat.executeQuery();
                while (rs.next()) {
                    isDeep_discovery = rs.getBoolean(16);
                    if (deepDiscoveredOption == 1 && isDeep_discovery) continue;
                    row = new DBRowDO();
                    sysName = rs.getString(1);
                    b1 = rs.getBytes(2);
                    ethSwIP = "";
                    if (b1 != null) {
                        try {
                            ethSwIP = InetAddress.getByAddress(b1).getHostAddress();
                        }
                        catch (UnknownHostException ue) {
                            SanWS.logger.error((Object)"getEthSwitchByLanId failed to resolve ethSwIP from DB ", (Throwable)ue);
                        }
                    }
                    isManageable = rs.getBoolean(3);
                    groupMemDBId = isFWSM != false ? 1L : rs.getLong(17);
                    groupDBId = isFWSM != false ? 1L : rs.getLong(18);
                    groupName = isFWSM != false ? "" : rs.getString(19);
                    isPresent = rs.getBoolean(4);
                    lastScanTime = rs.getLong(5);
                    unmanagableCause = rs.getString(6);
                    swId = rs.getLong(7);
                    status = SanWS.getEthSwStatus(isPresent, lastScanTime, isManageable, ethSwIP, unmanagableCause);
                    swName = sysName != null && sysName.length() > 0 ? sysName + '/' + ethSwIP : ethSwIP;
                    SanWS.logger.info((Object)("getEthSwitchByLanId,  got ethSwIP from DB : " + swName));
                    discStateV = rs.getInt(8);
                    discState = DiscStateType.getType(discStateV);
                    deepDiscDescp = rs.getString(9);
                    lastUpdate = rs.getTimestamp(10);
                    model = rs.getString(11);
                    location = rs.getString(12);
                    contact = rs.getString(13);
                    isFex = rs.getBoolean(14);
                    type = rs.getInt(15);
                    isMDS = FRUConstants.isMdsFamilyType(type);
                    isUCS = FRUConstants.isUCS(type);
                    csSeedDbId = null;
                    if (cdpSeedDbId == -1L) {
                        csSeedDbId = isFWSM != false ? rs.getLong(17) : rs.getLong(20);
                        SanWS.logger.info((Object)("getLanWithCdpSeedSwitches_fromDB found CdpTasks DbId = " + csSeedDbId));
                    }
                    SanWS.logger.info((Object)("getEthSwitchByLanId,  retrieving ethSwIP from DB:  cdpSeedDbId/ethSwIP/swName/swId/ = " + cdpSeedDbId + '/' + ethSwIP + '/' + swName + '/' + swId));
                    SanWS.logger.info((Object)("getEthSwitchByLanId,  retrieving ethSwIP from DB:  isManageable/isPresent/unmanagableCause/statusString = " + isManageable + '/' + isPresent + '/' + unmanagableCause + '/' + status));
                    SanWS.logger.info((Object)("getEthSwitchByLanId,  retrieving ethSwIP from DB:  discStateV/discStateString/deepDiscDescp/lastUpdate/lastScanTime/ = " + discStateV + '/' + discState.toDisplayString() + '/' + deepDiscDescp + '/' + lastUpdate + '/' + lastScanTime));
                    SanWS.logger.info((Object)("getEthSwitchByLanId,  retrieving ethSwIP from DB:  groupMemDBId/groupDBId/groupName = " + groupMemDBId + '/' + groupDBId + '/' + groupName));
                    SanWS.logger.info((Object)("getEthSwitchByLanId,  retrieving ethSwIP from DB:  isFex/isMDS/isDeep_discovery = " + isFex + '/' + isMDS + '/' + isDeep_discovery));
                    row.setEntry(new String[]{swName, status, Long.toString(groupMemDBId), Long.toString(groupDBId), groupName, ethSwIP, Long.toString(swId), discState.toDisplayString(), deepDiscDescp, lastUpdate.toString(), model, location, contact, isManageable != false ? "true" : "false", isFex != false ? "true" : "false", isMDS != false ? "true" : "false", isDeep_discovery != false ? "true" : "false", isUCS != false ? "true" : "false", csSeedDbId == null ? null : csSeedDbId.toString()});
                    rList.add(row);
                }
            }
            catch (SQLException ex) {
                try {
                    SanWS.logger.error((Object)"getEthSwitchByLanId", (Throwable)ex);
                    throw new SanServiceException(ex.getMessage());
                }
                catch (Throwable var45_43) {
                    DbUtil.close(rs);
                    DbUtil.close(stat);
                    DbUtil.close(con);
                    throw var45_43;
                }
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        SanWS.logger.info((Object)("getEthSwitchByLanId,  DONE retrieve ethSwIP from DB for cdpSeedDbId = " + cdpSeedDbId));
        Collections.sort(rList, new DbRowDOComparator(0));
        dto.setRow(rList.toArray(new DBRowDO[0]));
        return dto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTaskManageable(Long taskKey) {
        ResultSet rs;
        PreparedStatement stat;
        Connection con;
        block6: {
            boolean bl;
            block5: {
                logger.info((Object)("SanWS isTaskManageable... task " + taskKey));
                con = null;
                stat = null;
                rs = null;
                con = ConnectionManager.getConnection();
                stat = con.prepareStatement(queryTask);
                stat.setLong(1, taskKey);
                rs = stat.executeQuery();
                if (rs != null) break block5;
                logger.warn((Object)"SanWS isTaskManageable  cannot load task from DB record, rs null");
                boolean bl2 = false;
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                return bl2;
            }
            try {
                if (!rs.next()) break block6;
                boolean manageable = rs.getBoolean(2);
                logger.info((Object)("SanWS isTaskManageable... task ismanaged = " + manageable));
                bl = manageable;
            }
            catch (SQLException ex) {
                boolean bl3;
                try {
                    logger.warn((Object)("SanWS isTaskManageable, sql ex=" + ex.getMessage()));
                    bl3 = false;
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stat);
                    DbUtil.close(con);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                return bl3;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
            return bl;
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTaskV3(Long taskKey) {
        ResultSet rs;
        PreparedStatement stat;
        Connection con;
        block10: {
            boolean bl;
            logger.info((Object)("SanWS isTaskV3... task " + taskKey));
            con = null;
            stat = null;
            rs = null;
            try {
                con = ConnectionManager.getConnection();
                stat = con.prepareStatement(queryTask);
                stat.setLong(1, taskKey);
                rs = stat.executeQuery();
                if (rs != null) break block10;
                logger.warn((Object)"SanWS isTaskV3  cannot load credential from DB record, rs null");
                bl = false;
            }
            catch (SQLException ex) {
                boolean bl2;
                try {
                    logger.warn((Object)("SanWS isTaskV3, sql ex=" + ex.getMessage()));
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stat);
                    DbUtil.close(con);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                return bl2;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
            return bl;
        }
        while (true) {
            Long userDBId;
            block11: {
                if (!rs.next()) break;
                userDBId = rs.getLong(1);
                SnmpUser credential = null;
                try {
                    credential = SnmpUserImpl.loadFromDB(userDBId);
                }
                catch (Exception ex) {
                    logger.warn((Object)"SanWS isTaskV3  cannot load credential from DB record, ex=", (Throwable)ex);
                }
                SnmpUserOpt opt = null;
                if (credential == null) break block11;
                opt = SnmpUserOpt.convertToSnmpUserOpt(credential);
                if (opt == null) {
                    logger.warn((Object)("SanWS isTaskV3  opt null from SnmpUserOpt, userDbId=" + userDBId));
                }
                boolean bl = opt == null ? false : opt.isV3();
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                return bl;
            }
            logger.warn((Object)("SanWS isTaskV3  credentail null from SnmpUserImpl, userDbId=" + userDBId));
            continue;
            break;
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        logger.info((Object)"SanWS isTaskV3 DONE");
        return false;
    }

    public static String[] checkDiscoveryEthSwCandidates4List(String[] ethSwitchDbIdList) throws SanServiceException, InvalidArgumentException {
        if (ethSwitchDbIdList == null) {
            throw new SanServiceException("getDeepDiscoveryEthSwCandidates4List Failed: swith list null");
        }
        logger.info((Object)("getDeepDiscoveryEthSwCandidates4List... switch list length " + ethSwitchDbIdList.length));
        String query_statement = queryEthSwitch4DeepDiscovery;
        ArrayList<String> failSwList = new ArrayList<String>();
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        for (String ethSw : ethSwitchDbIdList) {
            if (query_statement.length() > queryEthSwitch4DeepDiscovery.length()) {
                query_statement = query_statement + ",";
            }
            query_statement = query_statement + ethSw;
            logger.info((Object)("getDeepDiscoveryEthSwCandidates4List, ethSwitch " + ethSw));
        }
        if (query_statement.length() > queryEthSwitch4DeepDiscovery.length()) {
            query_statement = query_statement + ")";
            try {
                con = ConnectionManager.getConnection();
                stat = con.prepareStatement(query_statement);
                logger.info((Object)("getDeepDiscoveryEthSwCandidates4List, sql statement=" + query_statement));
                rs = stat.executeQuery();
                while (rs.next()) {
                    boolean deep_desc_candidate;
                    long swId = rs.getLong(1);
                    String name = rs.getString(2);
                    boolean isDeep_discovery = rs.getBoolean(3);
                    if (isDeep_discovery) {
                        failSwList.add(Long.toString(swId));
                        logger.info((Object)("getDeepDiscoveryEthSwCandidates4List,  found ethSwIP deepDiscovery TRUE id/name = " + swId + '/' + name));
                        continue;
                    }
                    boolean isFex = rs.getBoolean(5);
                    int type = rs.getInt(6);
                    boolean isMDS = FRUConstants.isMdsFamilyType(type);
                    boolean isManageable = rs.getBoolean(4);
                    boolean bl = deep_desc_candidate = !isFex && !isMDS;
                    if (!deep_desc_candidate) {
                        failSwList.add(Long.toString(swId));
                        logger.info((Object)("getDeepDiscoveryEthSwCandidates4List,  found ethSwIP deepDiscovery NOT candidate id/name/isManageable/type/isMDS/isFEX = " + swId + '/' + name + '/' + isManageable + '/' + type + '/' + isMDS + '/' + isFex));
                        continue;
                    }
                    logger.info((Object)("getDeepDiscoveryEthSwCandidates4List,  found ethSwIP deepDiscovery candidate id/name = " + swId + '/' + name));
                }
            }
            catch (SQLException ex) {
                try {
                    logger.warn((Object)("getDeepDiscoveryEthSwCandidates4List, ex=" + ex.getMessage()));
                    throw new SanServiceException("getDeepDiscoveryEthSwCandidates4List Failed: " + ex.getMessage());
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stat);
                    DbUtil.close(con);
                    throw throwable;
                }
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        logger.info((Object)("getDeepDiscoveryEthSwCandidates4List,  DONE, failed sw list length " + failSwList.size()));
        return failSwList.toArray(new String[0]);
    }

    public static String[] getDeepDiscoveryEthSwCandidates4Task(long cdpSeedDbId) throws SanServiceException, InvalidArgumentException {
        logger.info((Object)("getDeepDiscoveryEthSwCandidates4Task,  retrieve ethSwIP deepDiscovery candidate from DB for cdpSeedDbId = " + cdpSeedDbId));
        ArrayList<String> swList = new ArrayList<String>();
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(queryEthSwitchByCdpSeedDbId);
            stat.setLong(1, cdpSeedDbId);
            rs = stat.executeQuery();
            while (rs.next()) {
                boolean deep_desc_candidate;
                boolean isDeep_discovery = rs.getBoolean(16);
                if (isDeep_discovery) continue;
                boolean isFex = rs.getBoolean(14);
                int type = rs.getInt(15);
                boolean isMDS = FRUConstants.isMdsFamilyType(type);
                boolean isManageable = rs.getBoolean(3);
                boolean bl = deep_desc_candidate = !isFex && !isMDS;
                if (!deep_desc_candidate) continue;
                long swId = rs.getLong(7);
                logger.info((Object)("getDeepDiscoveryEthSwCandidates4Task,  found ethSwIP deepDiscovery candidate swId/isManageable/type/isMDS/isFEX = " + swId + '/' + isManageable + '/' + type + '/' + isMDS + '/' + isFex));
                swList.add(Long.toString(swId));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"getEthSwitchByLanId", (Throwable)ex);
                throw new SanServiceException(ex.getMessage());
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        logger.info((Object)("getDeepDiscoveryEthSwCandidates4Task,  DONE retrieve ethSwIP from DB for cdpSeedDbId = " + cdpSeedDbId));
        return swList.toArray(new String[0]);
    }

    private static String getEthSwStatus(boolean isPresent, long lastScanTime, boolean isManagable, String ip, String unmanagableCause) {
        if (!isPresent) {
            return "last seen " + SnmpTimeticks.getDateFormat().format(new Date(lastScanTime));
        }
        if (!isManagable) {
            if (ip == null || ip.length() == 0) {
                return "No IP Address";
            }
            if (unmanagableCause != null) {
                return unmanagableCause;
            }
            return "UnmanagableCause not available";
        }
        return "ok";
    }

    @Override
    @WebMethod(operationName="getLanWithCdpSeedSwitches_fromDB")
    @WebResult(name="result", partName="result")
    public DBEntryDO getLanWithCdpSeedSwitches_fromDB() throws SanServiceException {
        return SanWS.getLanWithCdpSeedSwitches_fromDB_detail();
    }

    public static DBEntryDO getLanWithCdpSeedSwitches_fromDB_detail() throws SanServiceException {
        logger.info((Object)"getLanWithCdpSeedSwitches_fromDB...");
        DBEntryDO dto = new DBEntryDO();
        ArrayList<DBRowDO> rlist = new ArrayList<DBRowDO>();
        dto.setColumn(new String[]{"lanId", "lanName", "seedSwIP", "fmserver", "userName", "useV3", "v3Protocol", "maxHops", "subnet", "Mask", "ipRange", "status", "lanTaskKey", "fmServer", "fmServerIPString", "cdpSeedDBId", "discState", "groupDBId", "enablePwd", "createTime", "deepUpdateTime", "deepTaskId", "taskType", "taskIPString", "deepDiscDesc", "deepUpdtTime", "v3password", "isFWSM", "serverOperStatus"});
        boolean isFederation = false;
        try {
            List<String> serverList = ClusterMapping.getInstance().qALlIPStrings();
            isFederation = serverList != null && serverList.size() > 1;
        }
        catch (Exception ex) {
            logger.warn((Object)"SanWS getLanWithCdpSeedSwitches() failed on qALlIPStrings(), default to federation false");
        }
        try {
            logger.info((Object)"getLanWithCdpSeedSwitches_fromDB --->  GlobalDCManager.getAllLanPKs()");
            List<LanPK> list = GlobalDCManager.getInstance().getAllLanPKs();
            for (int i = 0; i < list.size(); ++i) {
                ResultSet rs;
                PreparedStatement stat;
                Connection con;
                String lanName;
                String fmServerIPString;
                String fmServer;
                int fid;
                block33: {
                    block32: {
                        fid = list.get((int)i)._fid;
                        fmServer = isFederation ? "" : "-";
                        fmServerIPString = ClusterMapping.getInstance().qIPFromSId(ClusterSequence.getSequence().getServerId()).getHostAddress();
                        if (isFederation) {
                            try {
                                fmServerIPString = GlobalDCManager.getInstance().getServerForLan(list.get(i));
                                try {
                                    fmServer = InetAddress.getByName(fmServerIPString).getHostName();
                                }
                                catch (UnknownHostException ex1) {
                                    logger.warn((Object)("SanWS getLanWithCdpSeedSwitches() failed to getHostName for fmServer: " + fmServerIPString));
                                }
                            }
                            catch (Exception ex) {
                                logger.warn((Object)"SanWS getLanWithCdpSeedSwitches() caught exception in getServerForLan():", (Throwable)ex);
                                if (!fmServerIPString.equals("") && fmServerIPString != null) break block32;
                                logger.warn((Object)"SanWS getLanWithCdpSeedSwitches() lan fmServer blank or null");
                            }
                        }
                    }
                    lanName = list.get(i).getName();
                    logger.info((Object)("getLanWithCdpSeedSwitches_fromDB found LAN = " + lanName));
                    con = null;
                    stat = null;
                    rs = null;
                    con = ConnectionManager.getConnection();
                    stat = con.prepareStatement(SQL_Query_CdpSeedsByLanId);
                    logger.info((Object)("getLanWithCdpSeedSwitches_fromDB retrieve CdpTasks for LanId = " + list.get(i).getId()));
                    stat.setInt(1, list.get(i).getId());
                    rs = stat.executeQuery();
                    if (rs != null) break block33;
                    DbUtil.close(rs);
                    DbUtil.close(stat);
                    DbUtil.close(con);
                    continue;
                }
                try {
                    while (rs.next()) {
                        List<InetAddress> iplist;
                        Long csSeedDbId = rs.getLong(1);
                        logger.info((Object)("getLanWithCdpSeedSwitches_fromDB found CdpTasks DbId = " + csSeedDbId));
                        TaskKey taskKey = new TaskKey(csSeedDbId);
                        Long lan_id = rs.getLong(2);
                        HashSet<InetAddress> ipSet = new HashSet<InetAddress>();
                        byte[] b = rs.getBytes(3);
                        try {
                            if (b != null) {
                                ipSet.add(InetAddress.getByAddress(b));
                            }
                        }
                        catch (UnknownHostException ex) {
                            logger.warn((Object)("SanWS getLanWithCdpSeedSwitches()  Cannot get cdp seed ip:" + Arrays.toString(b)), (Throwable)ex);
                        }
                        String ipRange = rs.getString(4);
                        String subnet = rs.getString(5);
                        String mask = rs.getString(6);
                        Long userDBId = rs.getLong(7);
                        SnmpUser credential = null;
                        try {
                            credential = SnmpUserImpl.loadFromDB(userDBId);
                        }
                        catch (Exception ex) {
                            logger.warn((Object)"SanWS getLanWithCdpSeedSwitches()  cannot load credential from DB record", (Throwable)ex);
                        }
                        SnmpUserOpt opt = null;
                        if (credential != null) {
                            opt = SnmpUserOpt.convertToSnmpUserOpt(credential);
                            SnmpV3AuthTypeDO.getType(opt.getSnmpV3Security());
                        }
                        int maxHop = rs.getInt(8);
                        String platform = rs.getString(11);
                        DiscTaskType taskType = DiscTaskType.getType(rs.getInt(12));
                        DiscStateType discState = DiscStateType.getType(rs.getInt(13));
                        String deepDiscDescp = rs.getString(21);
                        String ipStr = rs.getString(14);
                        if (ipStr != null && ipStr.length() > 0 && (iplist = IpUtil.getIPListFromString(ipStr, ",")) != null) {
                            ipSet.addAll(iplist);
                        }
                        ArrayList ipList = new ArrayList(ipSet);
                        StringBuffer seedString = new StringBuffer();
                        for (InetAddress ip : ipList) {
                            if (seedString.length() > 0) {
                                seedString.append(", ");
                            }
                            seedString.append(ip.getHostAddress());
                        }
                        long groupDBID = rs.getLong(15);
                        Date createTime = new Date(rs.getLong(16));
                        String enablePwd = rs.getString(17);
                        Long deepTaskId = rs.getLong(18);
                        Timestamp lastUpdate = rs.getTimestamp(9);
                        boolean manageable = rs.getBoolean(20);
                        boolean isFWSM = rs.getBoolean(22);
                        String ipRangeString = "";
                        String subnetString = "";
                        String maskString = "";
                        if (ipRange != null && ipRange.trim().length() > 0) {
                            ipRangeString = ipRange;
                        } else if (subnet != null && subnet.trim().length() > 0) {
                            subnetString = subnet;
                            maskString = mask;
                        }
                        byte[] b2 = rs.getBytes(23);
                        int svrStatus = rs.getInt(24);
                        boolean isManagedOper = manageable;
                        if (isFederation && b2 != null) {
                            try {
                                String fmServerIP_fromDB = InetAddress.getByAddress(b2).getHostAddress();
                                if (fmServerIP_fromDB.equals(fmServerIPString) && svrStatus != 0 && svrStatus != 3) {
                                    isManagedOper = false;
                                }
                            }
                            catch (UnknownHostException ue) {
                                logger.error((Object)"getFabricWithSnmpCredentail_fromDB failed to resolve fmServerIP from DB ", (Throwable)ue);
                            }
                        }
                        DBRowDO row = new DBRowDO();
                        logger.info((Object)("getLanWithCdpSeedSwitches_fromDB add CdpTasks taskDbId/fid/lanName/seed/fmServer/fmServerIPString = " + csSeedDbId + "/" + fid + "/" + lanName + "/" + seedString.toString() + '/' + fmServer + '/' + fmServerIPString));
                        String[] stringArray = new String[28];
                        stringArray[0] = Integer.toString(fid);
                        stringArray[1] = lanName;
                        stringArray[2] = seedString.toString();
                        stringArray[3] = "";
                        String string = opt == null ? null : (stringArray[4] = opt.isV3() ? opt.getUsername() : opt.getCommunity());
                        stringArray[5] = opt == null ? null : (opt.isV3() ? "true" : "false");
                        stringArray[6] = opt == null ? null : SnmpV3AuthTypeDO.getType(opt.getSnmpV3Security()).toString();
                        stringArray[7] = Integer.toString(maxHop);
                        stringArray[8] = subnetString;
                        stringArray[9] = maskString;
                        stringArray[10] = ipRangeString;
                        stringArray[11] = manageable ? "true" : "false";
                        stringArray[12] = Long.toString(taskKey.getId());
                        stringArray[13] = fmServer;
                        stringArray[14] = fmServerIPString;
                        stringArray[15] = Long.toString(csSeedDbId);
                        stringArray[16] = discState.toDisplayString();
                        stringArray[17] = Long.toString(groupDBID);
                        stringArray[18] = enablePwd;
                        stringArray[19] = createTime.toString();
                        stringArray[20] = ((Date)lastUpdate).toString();
                        stringArray[21] = Long.toString(deepTaskId);
                        stringArray[22] = taskType.toString();
                        stringArray[23] = ipStr;
                        stringArray[24] = deepDiscDescp;
                        stringArray[25] = opt == null ? null : (opt.isV3() ? opt.getPassword() : null);
                        stringArray[26] = isFWSM ? "true" : "false";
                        stringArray[27] = isManagedOper ? "true" : "false";
                        row.setEntry(stringArray);
                        rlist.add(row);
                    }
                }
                catch (SQLException ex) {
                    try {
                        logger.warn((Object)("SanWS getLanWithCdpSeedSwitches() getCdpSeedsByLanPK failed" + list.get(i)), (Throwable)ex);
                        throw ex;
                    }
                    catch (Throwable throwable) {
                        DbUtil.close(rs);
                        DbUtil.close(stat);
                        DbUtil.close(con);
                        throw throwable;
                    }
                }
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                continue;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.info((Object)"getLanWithCdpSeedSwitches_fromDB DONE");
        Collections.sort(rlist, new DbRowDOComparator(2));
        dto.setRow(rlist.toArray(new DBRowDO[0]));
        return dto;
    }

    @Override
    @WebMethod(operationName="getLanWithCdpSeedSwitches")
    @WebResult(name="result", partName="result")
    public DBEntryDO getLanWithCdpSeedSwitches() throws SanServiceException {
        DBEntryDO dto = new DBEntryDO();
        ArrayList<DBRowDO> rlist = new ArrayList<DBRowDO>();
        dto.setColumn(new String[]{"lanId", "lanName", "seedSwIP", "fmserver", "userName", "useV3", "v3Protocol", "maxHops", "subnet", "Mask", "ipRange", "status", "seedKey", "fmServer"});
        boolean isFederation = false;
        try {
            List<String> serverList = ClusterMapping.getInstance().qALlIPStrings();
            isFederation = serverList != null && serverList.size() > 1;
        }
        catch (Exception ex) {
            logger.warn((Object)"SanWS getLanWithCdpSeedSwitches() failed on qALlIPStrings(), default to federation false");
        }
        try {
            List<LanPK> list = GlobalDCManager.getInstance().getAllLanPKs();
            for (int i = 0; i < list.size(); ++i) {
                String fmServerIPString;
                String fmServer;
                int fid;
                block12: {
                    fid = list.get((int)i)._fid;
                    fmServer = isFederation ? "" : "-";
                    fmServerIPString = ClusterMapping.getInstance().qIPFromSId(ClusterSequence.getSequence().getServerId()).getHostAddress();
                    if (isFederation) {
                        try {
                            fmServerIPString = GlobalDCManager.getInstance().getServerForLan(list.get(i));
                            try {
                                fmServer = InetAddress.getByName(fmServerIPString).getHostName();
                            }
                            catch (UnknownHostException ex1) {
                                logger.warn((Object)("SanWS getLanWithCdpSeedSwitches() failed to getHostName for fmServer: " + fmServerIPString));
                            }
                        }
                        catch (Exception ex) {
                            logger.warn((Object)"SanWS getLanWithCdpSeedSwitches() caught exception in getServerForLan():", (Throwable)ex);
                            if (!fmServerIPString.equals("") && fmServerIPString != null) break block12;
                            logger.warn((Object)"SanWS getLanWithCdpSeedSwitches() lan fmServer blank or null");
                        }
                    }
                }
                String lanName = list.get(i).getName();
                boolean isManaged = false;
                isManaged = GlobalDCManager.getInstance().getLanManagedByLanPK(list.get(i));
                List<CdpSeedBase> seedSws = GlobalDCManager.getInstance().getCdpSeedsByLanPK(list.get(i));
                for (int j = 0; j < seedSws.size(); ++j) {
                    SnmpUser user = seedSws.get(j).getCredential();
                    SnmpUserOpt opt = null;
                    if (user != null) {
                        opt = SnmpUserOpt.convertToSnmpUserOpt(user);
                        SnmpV3AuthTypeDO.getType(opt.getSnmpV3Security());
                    }
                    DBRowDO row = new DBRowDO();
                    String[] stringArray = new String[15];
                    stringArray[0] = Integer.toString(fid);
                    stringArray[1] = lanName;
                    stringArray[2] = seedSws.get(j).getSeedIp().getHostAddress();
                    stringArray[3] = "";
                    String string = opt == null ? null : (stringArray[4] = opt.isV3() ? opt.getUsername() : "****");
                    stringArray[5] = opt == null ? null : (opt.isV3() ? "true" : "false");
                    stringArray[6] = opt == null ? null : SnmpV3AuthTypeDO.getType(opt.getSnmpV3Security()).toString();
                    stringArray[7] = Integer.toString(seedSws.get(j).getMaxHop());
                    stringArray[8] = seedSws.get(j).getSubnetStr() == null ? "" : seedSws.get(j).getSubnetStr();
                    stringArray[9] = seedSws.get(j).getMaskStr() == null ? "" : seedSws.get(j).getMaskStr();
                    stringArray[10] = seedSws.get(j).getIpRangeStr() == null ? "" : seedSws.get(j).getIpRangeStr();
                    stringArray[11] = isManaged ? "true" : "false";
                    stringArray[12] = seedSws.get(j).getTaskKey().toString();
                    stringArray[13] = fmServer;
                    stringArray[14] = fmServerIPString;
                    row.setEntry(stringArray);
                    rlist.add(row);
                }
            }
        }
        catch (Exception ex) {
            logger.warn((Object)"SanWS caught exception:", (Throwable)ex);
        }
        Collections.sort(rlist, new DbRowDOComparator(1));
        dto.setRow(rlist.toArray(new DBRowDO[0]));
        return dto;
    }

    @Override
    @WebMethod(operationName="getFabricLicensedInfo")
    @WebResult(name="result", partName="result")
    public DBEntryDO getFabricLicensedInfo(@WebParam(name="key", partName="key") FabricKeyDO key) throws SanServiceException, InvalidArgumentException {
        DBEntryDO dto = new DBEntryDO();
        ArrayList<DBRowDO> rList = new ArrayList<DBRowDO>();
        dto.setColumn(new String[]{"fabrickey", "Licensed"});
        DBRowDO row = new DBRowDO();
        FabricPK fpk = new FabricPK(key.getFid());
        row.setEntry(new String[]{Integer.toString(fpk.get_fid()), LicenseManager.getInstance().isFmLicensed(fpk) ? "true" : "false"});
        rList.add(row);
        dto.setRow(rList.toArray(new DBRowDO[0]));
        return dto;
    }

    private boolean getLicenseStatus(int licenseStatusCode) {
        switch (licenseStatusCode) {
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    @Override
    @WebMethod(operationName="getFabricWithSnmpCredentail_fromDB")
    @WebResult(name="result", partName="result")
    public DBEntryDO getFabricWithSnmpCredentail_fromDB() throws SanServiceException, InvalidArgumentException {
        logger.info((Object)"getFabricWithSnmpCredentail_fromDB...");
        DBEntryDO dto = new DBEntryDO();
        ArrayList<DBRowDO> rList = new ArrayList<DBRowDO>();
        dto.setColumn(new String[]{"fabricName", "includedList", "excludedList", "managed", "persistent", "useFcAlias", "licensed", "username", "useV3", "v3Protocol", "seedSwitch", "lastopen", "fabrickey", "fmServer", "serverOperStatus"});
        boolean isFederation = false;
        try {
            List<String> serverList = ClusterMapping.getInstance().qALlIPStrings();
            isFederation = serverList != null && serverList.size() > 1;
        }
        catch (Exception ex) {
            logger.warn((Object)"SanWS getFabricWithSnmpCredentail_fromDB on qALlIPStrings(), default to federation false");
        }
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(queryAllFabrics);
            rs = stat.executeQuery();
            while (rs.next()) {
                String fmServerIP;
                DBRowDO row = new DBRowDO();
                long fid = rs.getLong(1);
                String fabricName = rs.getString(2);
                Timestamp lastUpdate = rs.getTimestamp(3);
                String seedSwSysName = rs.getString(4);
                byte[] b1 = rs.getBytes(5);
                String seedSwIPHostAddress = "";
                if (b1 != null) {
                    try {
                        seedSwIPHostAddress = InetAddress.getByAddress(b1).getHostAddress();
                    }
                    catch (UnknownHostException ue) {
                        logger.error((Object)"getFabricWithSnmpCredentail_fromDB failed to resolve seedSwIP from DB ", (Throwable)ue);
                    }
                }
                boolean persist = rs.getBoolean(6);
                boolean isManaged = rs.getBoolean(7);
                boolean isV3 = rs.getInt(8) == 3;
                String user = "";
                try {
                    user = StringEncrypter.decryptString("DES", rs.getString(9));
                }
                catch (Exception userEx) {
                    logger.error((Object)"getFabricWithSnmpCredentail_fromDB failed to decrypt user from DB ", (Throwable)userEx);
                }
                int authProtocol = rs.getInt(10);
                int privProtocol = rs.getInt(11);
                String v3Protocol = SnmpV3AuthTypeDO.getType(SnmpUserOpt.getSnmpV3SecurityVal(authProtocol, privProtocol)).toString();
                String v3Password = rs.getString(18);
                boolean isUseFCAlias = !rs.getBoolean(12);
                boolean isLicensed = this.getLicenseStatus((int)rs.getLong(13));
                String includedVSANList = rs.getString(14) != null && !rs.getString(14).equals("-1") ? rs.getString(14) : "";
                String excludedVSANList = rs.getString(15) != null && !rs.getString(15).equals("-1") ? rs.getString(15) : "";
                byte[] b2 = rs.getBytes(16);
                int svrStatus = rs.getInt(17);
                boolean isManagedOper = isManaged;
                if (svrStatus != 0 && svrStatus != 3) {
                    isManagedOper = false;
                }
                String string = fmServerIP = isFederation ? "" : "-";
                if (isFederation && b2 != null) {
                    try {
                        fmServerIP = InetAddress.getByAddress(b2).getHostName();
                    }
                    catch (UnknownHostException ue) {
                        logger.error((Object)"getFabricWithSnmpCredentail_fromDB failed to resolve fmServerIP from DB ", (Throwable)ue);
                    }
                }
                logger.info((Object)("getFabricWithSnmpCredentail_fromDB add fabric fid/fabricName/isManaged/persist/isUseFCAlias/isLicensed/isV3/user/isManagedOper/fmServerIP = " + fid + '/' + fabricName + '/' + isManaged + '/' + persist + '/' + isUseFCAlias + '/' + isLicensed + '/' + isV3 + '/' + user + '/' + isManagedOper + '/' + fmServerIP));
                row.setEntry(new String[]{fabricName, includedVSANList, excludedVSANList, isManaged ? "true" : "false", persist ? "true" : "false", isUseFCAlias ? "true" : "false", isLicensed ? "true" : "false", user, isV3 ? "true" : "false", isV3 ? v3Protocol : null, seedSwIPHostAddress, ((Date)lastUpdate).toString(), Long.toString(fid), fmServerIP, isManagedOper ? "true" : "false", isV3 ? v3Password : ""});
                rList.add(row);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"getFabricWithSnmpCredentail_fromDB", (Throwable)ex);
                throw new SanServiceException(ex.getMessage());
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        Collections.sort(rList, new DbRowDOComparator(0));
        dto.setRow(rList.toArray(new DBRowDO[0]));
        return dto;
    }

    @Override
    @WebMethod(operationName="getFabricWithSnmpCredentail")
    @WebResult(name="result", partName="result")
    public DBEntryDO getFabricWithSnmpCredentail() throws SanServiceException, InvalidArgumentException {
        int i;
        DBEntryDO dto = new DBEntryDO();
        ArrayList<DBRowDO> rList = new ArrayList<DBRowDO>();
        dto.setColumn(new String[]{"fabricName", "includedList", "excludedList", "managed", "persistent", "useFcAlias", "licensed", "username", "useV3", "v3Protocol", "seedSwitch", "lastopen", "fabrickey", "fmServer"});
        List<FabricPK> fabrics = GlobalFabricManager.getInstance().getAllFabricPKs();
        ArrayList<FabricFindThread> threadList = new ArrayList<FabricFindThread>();
        for (i = 0; i < fabrics.size(); ++i) {
            FabricPK fpk = fabrics.get(i);
            FabricFindThread th = new FabricFindThread(fpk);
            threadList.add(th);
            th.start();
        }
        for (i = 0; i < threadList.size(); ++i) {
            FabricFindThread th = (FabricFindThread)threadList.get(i);
            try {
                th.join();
            }
            catch (Throwable e) {
                logger.error((Object)"getFabricWithSnmpCredentail", e);
            }
            if (th.getRow() == null) continue;
            rList.add(th.getRow());
        }
        Collections.sort(rList, new DbRowDOComparator(0));
        dto.setRow(rList.toArray(new DBRowDO[0]));
        return dto;
    }

    @Override
    @WebMethod(operationName="getVirtualCenters")
    @WebResult(name="result", partName="result")
    public DBEntryDO getVirtualCenters() throws SanServiceException {
        DBEntryDO dto = new DBEntryDO();
        ArrayList<DBRowDO> rlist = new ArrayList<DBRowDO>();
        dto.setColumn(new String[]{"ip", "userName", "ismanaged", "lastupdate", "fmServer", "fmServerString", "statusdescription"});
        try {
            VirtualCenterBase[] vms = GlobalViManager.getInstance().getAllVCenters();
            boolean isFederation = false;
            try {
                List<String> serverList = ClusterMapping.getInstance().qALlIPStrings();
                isFederation = serverList != null && serverList.size() > 1;
            }
            catch (Exception ex) {
                logger.warn((Object)"SanWS getVirtualCentersfailed on qALlIPStrings(), default to federation false");
            }
            for (int i = 0; vms != null && i < vms.length; ++i) {
                String fmServerIPString;
                String fmServer;
                block10: {
                    fmServer = isFederation ? "" : "-";
                    fmServerIPString = ClusterMapping.getInstance().qIPFromSId(ClusterSequence.getSequence().getServerId()).getHostAddress();
                    if (isFederation) {
                        try {
                            fmServerIPString = GlobalViManager.getInstance().getServerForVCenter((VcenterPK)vms[i].getVcPK());
                            try {
                                fmServer = InetAddress.getByName(fmServerIPString).getHostName();
                            }
                            catch (UnknownHostException ex1) {
                                logger.warn((Object)("SanWS getVirtualCenters() failed to getHostName for fmServer: " + fmServerIPString));
                            }
                        }
                        catch (Exception ex) {
                            logger.warn((Object)"SanWS getVirtualCenters() caught exception in getServerForVCenter():", (Throwable)ex);
                            if (!fmServerIPString.equals("") && fmServerIPString != null) break block10;
                            logger.warn((Object)"SanWS getVirtualCenters() VMWare fmServer blank or null");
                        }
                    }
                }
                DBRowDO row = new DBRowDO();
                String lastUpdate = new Date(vms[i].getLastUpdateTime()).toString();
                String isManaged = vms[i].getManageState() ? "true" : "false";
                row.setEntry(new String[]{vms[i].getVcIP().getHostAddress(), vms[i].getUserName(), isManaged, lastUpdate, fmServer, fmServerIPString, vms[i].getStatusDescription()});
                rlist.add(row);
            }
        }
        catch (Exception ex) {
            throw new SanServiceException(ex.getMessage());
        }
        Collections.sort(rlist, new DbRowDOComparator(0));
        dto.setRow(rlist.toArray(new DBRowDO[0]));
        return dto;
    }

    @Override
    @WebMethod(operationName="addVirtualCenter")
    @WebResult(name="result", partName="result")
    public CallResultDO addVirtualCenter(String vcIP, String username, String passwd, String fmServer) {
        if (username == null || passwd == null) {
            throw new InvalidArgumentException("Invalid user credential:" + username + "," + passwd);
        }
        if (vcIP == null) {
            return new CallResultDO(1, "Invalid IP:" + vcIP);
        }
        try {
            InetAddress.getByName(vcIP);
        }
        catch (Exception ex) {
            return new CallResultDO(1, "Invalid VMWare server address");
        }
        VirtualCenterImpl vc = null;
        try {
            vc = ViManager.getInstance().createVirtualCenter(InetAddress.getByName(vcIP), username, passwd);
        }
        catch (Exception ex) {
            return new CallResultDO(1, "open Virtual Center failed: " + ex.getMessage());
        }
        if (vc == null) {
            return new CallResultDO(1, "Cannot open virtual center from user:" + username + "," + vcIP);
        }
        try {
            int timeout = 120000;
            while (!ViManager.getInstance().isOpened(vc.getIpAddress())) {
                Thread.sleep(1000L);
                if ((timeout -= 1000) >= 0) continue;
                return new CallResultDO(1, "Cannot open virtual center timeout at 2 minutes. Virtual center may still be in discovery.");
            }
        }
        catch (Exception e) {
            return new CallResultDO(1, "Cannot open virtual center from user:" + username + "," + vcIP);
        }
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="updateVirtualCenter")
    @WebResult(name="result", partName="result")
    public CallResultDO updateVirtualCenter(String vcIP, String username, String passwd, String status, String fmServer) {
        if (username != null && username.equals("noOp1")) {
            username = null;
        }
        if (passwd != null && passwd.equals("noOp2")) {
            passwd = null;
        }
        if (username != null && passwd == null) {
            throw new InvalidArgumentException("Invalid user credential:" + username + "," + passwd);
        }
        try {
            if (username != null) {
                ViManager.getInstance().updateVirtualCenter(InetAddress.getByName(vcIP), username, passwd, false);
            }
            if (status != null) {
                if (status.equals("managed")) {
                    ViManager.getInstance().manageVirtualCenter(InetAddress.getByName(vcIP));
                } else if (status.equals("unmanaged")) {
                    ViManager.getInstance().unManageVirtualCenter(InetAddress.getByName(vcIP));
                }
            }
        }
        catch (Exception ex) {
            return new CallResultDO(1, "modify Virtual Center failed: " + ex.getMessage());
        }
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="removeVirtualCenter")
    @WebResult(name="result", partName="result")
    public CallResultDO removeVirtualCenter(String vcIP, String fmServer) {
        if (vcIP == null) {
            throw new InvalidArgumentException("Invalid IP:" + vcIP);
        }
        try {
            ViManager.getInstance().removeVirtualCenter(InetAddress.getByName(vcIP));
        }
        catch (Exception ex) {
            return new CallResultDO(1, "remove Virtual Center failed: " + ex.getMessage());
        }
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="rediscoverVirtualCenter")
    @WebResult(name="result", partName="result")
    public CallResultDO rediscoverVirtualCenter(String vcIP, String fmServer) {
        if (vcIP == null) {
            throw new InvalidArgumentException("Invalid IP:" + vcIP);
        }
        try {
            ViManager.getInstance().rediscoverVirtualCenter(InetAddress.getByName(vcIP));
        }
        catch (Exception ex) {
            return new CallResultDO(1, "rediscover Virtual Center failed: " + ex.getMessage());
        }
        return new CallResultDO();
    }

    @Override
    public void changeSwitchName(SwitchDO key) throws SanServiceException, InvalidArgumentException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid switch key:" + key);
            }
            SwitchImpl sw = SanHelper.findSwitch(new WwnKey(key.getWwn().toWwn()));
            if (sw == null) {
                throw new InvalidArgumentException("Failed to get switch by:" + key.getSwWwn().toWwn());
            }
            int[] featureIdx = new int[]{0};
            SnmpHelper.setSwitchName(sw, featureIdx, key.getName());
            sw.setSysName(key.getName());
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in changeSwitchName():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in changeSwitchName():", e);
            throw new SanServiceException("Failed to set new swtich name for switch key:" + key.getSwWwn().toWwn(), e);
        }
    }

    @Override
    public void disableFcPort(SwitchIntKeyDO key) throws SanServiceException, InvalidArgumentException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid fcport key:" + key);
            }
            WwnKey wwnKey = new WwnKey(new Wwn(key.getSwKey()));
            SwitchImpl sw = SanHelper.findSwitch(wwnKey);
            if (sw == null) {
                throw new SanServiceException("Failed to get switch by:" + key.getSwKey());
            }
            int[] featureIdx = new int[]{key.getIndex()};
            SnmpHelper.setPortStatus(sw, featureIdx, false);
            FcPortBase fpb = sw.findPort(key.getIndex());
            if (fpb != null) {
                fpb.setIfAdminStatus((short)2);
                fpb.setIfOperStatus((short)2);
            }
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in disableFcPort():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in disableFcPort():", e);
            throw new SanServiceException("Failed to disable port " + key.getIndex() + " for swtich name for switch key:" + key.getSwKey(), e);
        }
    }

    @Override
    public void enableFcPort(SwitchIntKeyDO key) throws SanServiceException, InvalidArgumentException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid fcport key:" + key);
            }
            WwnKey wwnKey = new WwnKey(new Wwn(key.getSwKey()));
            SwitchImpl sw = SanHelper.findSwitch(wwnKey);
            if (sw == null) {
                throw new SanServiceException("Failed to get switch by:" + key.getSwKey());
            }
            int[] featureIdx = new int[]{key.getIndex()};
            SnmpHelper.setPortStatus(sw, featureIdx, true);
            FcPortBase fpb = sw.findPort(key.getIndex());
            if (fpb != null) {
                fpb.setIfAdminStatus((short)1);
                fpb.setIfOperStatus((short)1);
            }
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in enableFcPort():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in enableFcPort():", e);
            throw new SanServiceException("Failed to enable port " + key.getIndex() + " for swtich name for switch key:" + key.getSwKey(), e);
        }
    }

    @Override
    public void setPortName(FcPortDO key) throws SanServiceException, InvalidArgumentException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid fcport key:" + key);
            }
            WwnKey wwnKey = new WwnKey(key.getSwWwn().toWwn());
            SwitchImpl sw = SanHelper.findSwitch(wwnKey);
            if (sw == null) {
                throw new SanServiceException("Failed to get switch by:" + key.getSwWwn().getValue());
            }
            int[] featureIdx = new int[]{key.getIfIndex()};
            SnmpHelper.setPortName(sw, featureIdx, key.getIfAlias());
            FcPortBase fpb = sw.findPort(key.getIfIndex());
            if (fpb != null) {
                fpb.setIfAlias(key.getIfAlias());
            }
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in setPortName():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in setPortName():", e);
            throw new SanServiceException("Failed to change port name " + key.getIfIndex() + " for swtich name for switch key:" + key.getSwWwn().getValue(), e);
        }
    }

    @Override
    public void setPortSpeed(FcPortDO key) throws SanServiceException, InvalidArgumentException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid fcport key:" + key);
            }
            WwnKey wwnKey = new WwnKey(key.getSwWwn().toWwn());
            SwitchImpl sw = SanHelper.findSwitch(wwnKey);
            if (sw == null) {
                throw new SanServiceException("Failed to get switch by:" + key.getSwWwn().getValue());
            }
            int[] featureIdx = new int[]{key.getIfIndex()};
            SnmpHelper.setPortSpeed(sw, featureIdx, key.getFcIfAdminSpeed());
            FcPortBase fpb = sw.findPort(key.getIfIndex());
            if (fpb != null) {
                fpb.setFcIfAdminSpeed(key.getFcIfAdminSpeed());
            }
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in setPortSpeed():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in setPortSpeed():", e);
            throw new SanServiceException("Failed to change port speed " + key.getIfIndex() + " for swtich name for switch key:" + key.getSwWwn().getValue(), e);
        }
    }

    @Override
    public void setPortType(FcPortDO key) throws SanServiceException, InvalidArgumentException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid fcport key:" + key);
            }
            WwnKey wwnKey = new WwnKey(key.getSwWwn().toWwn());
            SwitchImpl sw = SanHelper.findSwitch(wwnKey);
            if (sw == null) {
                throw new SanServiceException("Failed to get switch by:" + key.getSwWwn().getValue());
            }
            int[] featureIdx = new int[]{key.getIfIndex()};
            SnmpHelper.setPortType(sw, featureIdx, key.getFcIfAdminMode());
            FcPortBase fpb = sw.findPort(key.getIfIndex());
            if (fpb != null) {
                fpb.setFcifAdminMode((short)key.getFcIfAdminMode());
            }
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in setPortType():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in setPortType():", e);
            throw new SanServiceException("Failed to change port type " + key.getIfIndex() + " for swtich name for switch key:" + key.getSwWwn().getValue(), e);
        }
    }

    @Override
    public void disableSwitch(WwnKeyDO key) throws SanServiceException, InvalidArgumentException {
        throw new SanServiceException("Operation not supported");
    }

    @Override
    public void setSwitchPreferedDomainId(SwitchDO key) throws SanServiceException, InvalidArgumentException {
        throw new SanServiceException("Operation not supported");
    }

    @Override
    public void setSwitchPrinPriority(SwitchDO key) throws SanServiceException, InvalidArgumentException {
        throw new SanServiceException("Operation not supported");
    }

    @Override
    public void enableSwitch(WwnKeyDO key) throws SanServiceException, InvalidArgumentException {
        throw new SanServiceException("Operation not supported");
    }

    @Override
    public void lockSwitchDomainId(SwitchDO key) throws SanServiceException, InvalidArgumentException {
        throw new SanServiceException("Operation not supported");
    }

    @Override
    public void resetSwitch(WwnKeyDO key) throws SanServiceException, InvalidArgumentException {
        throw new SanServiceException("Operation not supported");
    }

    @Override
    public VsanDO getVsanByPrinwwn(WwnKeyDO key) throws SanServiceException, SanNotFoundException {
        try {
            FabricImpl[] fabrics = SanManager.getInstance().getFabrics();
            for (int i = 0; i < fabrics.length; ++i) {
                VsanPK vsankey = fabrics[i].getVsanByPrinwwn(key.getWwn().toWwn());
                if (vsankey == null) continue;
                VsanImpl vs = SanManager.getInstance().findVsan(vsankey);
                if (vs == null) {
                    throw new SanNotFoundException("Cannot find vsan");
                }
                VsanDO vsan = new VsanDO((VsanBase)vs.getBaseObject());
                return vsan;
            }
            throw new SanNotFoundException("Cannot find fabrics");
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)("Exception caught in getVsanByPrinwwn" + e));
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)("Exception caught in getVsanByPrinwwn" + e));
            throw new SanServiceException("Exception caught in getVsanByPrinwwn" + e);
        }
    }

    @Override
    public SwitchDO getSwitchByVsanPrinwwn(WwnKeyDO key) throws SanServiceException, SanNotFoundException {
        try {
            FabricImpl[] fabrics = SanManager.getInstance().getFabrics();
            for (int i = 0; i < fabrics.length; ++i) {
                VsanPK vsankey = fabrics[i].getVsanByPrinwwn(key.getWwn().toWwn());
                if (vsankey == null) continue;
                VsanImpl vs = SanManager.getInstance().findVsan(vsankey);
                if (vs == null) {
                    throw new SanNotFoundException("Cannot find vsan");
                }
                return new SwitchDO(vs.getPrincipalSwitch());
            }
            throw new SanNotFoundException("Cannot find fabrics");
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)("Exception caught in getSwitchByPrinwwn" + e));
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)("Exception caught in getSwitchByPrinwwn" + e));
            throw new SanServiceException("Exception caught in getSwitchByPrinwwn" + e);
        }
    }

    @Override
    public SwitchDO getSwitchbyVsanWwn(WwnKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            byte[] vwwn = key.getWwn().getValue().getBytes();
            if (WwnDictionary.isCiscoWwn(vwwn) && !WwnDictionary.isQuailWwn(vwwn)) {
                byte[] bswwn = new byte[8];
                System.arraycopy(vwwn, 0, bswwn, 0, 8);
                WwnDictionary.vsanWwnToSwwn(bswwn);
                return this.getSwitch(new WwnDO(bswwn));
            }
            for (SwitchImpl sw0 : SanManager.getInstance().getSwitches()) {
                short[] vids = sw0.getVsanIds();
                if (vids == null || vids.length == 0) continue;
                for (int j = 0; j < vids.length; ++j) {
                    if (!sw0.getVsanWwn(vids[j]).toHexString(true).equals(key.getWwn().getValue())) continue;
                    return new SwitchDO(sw0);
                }
            }
            throw new SanNotFoundException("Cannot Find Switch");
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)("Exception caught in getSwitcbyhVsanWwn" + e));
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)("Exception caught in getSwitcbyhVsanWwn" + e));
            throw new SanServiceException("Exception caught in getSwitcbyhVsanWwn" + e);
        }
    }

    private HashMap parseList(String[] excludedSwList) throws Exception {
        if (excludedSwList == null || excludedSwList.length == 0) {
            return null;
        }
        HashMap<Long, String> list = new HashMap<Long, String>();
        for (int i = 0; i < excludedSwList.length; ++i) {
            if (excludedSwList[i].equals("")) continue;
            list.put(new Long(Long.parseLong(excludedSwList[i])), "");
        }
        if (list.size() == 0) {
            return null;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WebMethod(operationName="testForwarding")
    @WebResult(name="result", partName="result")
    public DBEntryDO testForwarding(String fabricKey, String[] excludedSwList, String smtpServer, boolean isForwardingTesting) throws SanServiceException {
        boolean SWITCH_NAME = false;
        boolean SWITCH_IP = true;
        int LOCATION = 2;
        int CONTACT = 3;
        int MODEL = 4;
        int STATUS = 5;
        int TRAP_REGISTER = 6;
        int VERSION = 7;
        int DELAY = 8;
        String callhomePropertyDir = "server.callhome.xmlDir";
        DBEntryDO result = new DBEntryDO();
        result.setColumn(new String[]{"SwitchName", "SwitchIP", "SMTP Server Status", "Location", "model", "Contact", "Status"});
        ArrayList<DBRowDO> rlist = new ArrayList<DBRowDO>();
        HashMap<InetAddress, String[]> resultDetail = new HashMap<InetAddress, String[]>();
        Logger _emcCallhomelog = null;
        String timestamp = Long.toString(System.currentTimeMillis());
        StringBuffer name = new StringBuffer();
        name.append(ClientCache.getInstallLocation() + "logs" + File.separator);
        name.append("web_emccallhome_");
        name.append(".log");
        _emcCallhomelog = Log4jUtil.createNewLog(timestamp, name.toString(), "ALL", "15M", 20);
        _emcCallhomelog.debug((Object)"=============================================================");
        HashMap excludedSws = null;
        try {
            excludedSws = this.parseList(excludedSwList);
        }
        catch (Exception ex) {
            _emcCallhomelog.debug((Object)("parseExcludedSwList error: " + ex.getMessage()));
            return new DBEntryDO(1, "parseExcludedSwList error: " + ex.getMessage());
        }
        FabricPK fpk = null;
        try {
            fpk = new FabricPK(Integer.parseInt(fabricKey));
        }
        catch (Exception ex) {
            _emcCallhomelog.debug((Object)("Wrong fabric key: " + ex.getMessage()));
            return new DBEntryDO(1, "Wrong fabric key: " + ex.getMessage());
        }
        boolean isSmtpServerOK = true;
        if (smtpServer != null && smtpServer.length() > 0) {
            int DEFAULT_TFTP_PORT = 25;
            Socket sock = null;
            try {
                InetAddress addr = InetAddress.getByName(smtpServer);
                sock = new Socket(addr, DEFAULT_TFTP_PORT);
            }
            catch (Exception e) {
                isSmtpServerOK = false;
            }
            finally {
                try {
                    if (sock != null) {
                        sock.close();
                    }
                }
                catch (Exception ex1) {}
            }
        }
        if (!isSmtpServerOK) {
            DBRowDO row = new DBRowDO();
            row.setEntry(new String[]{"", "", "false", "", "", "", ""});
            rlist.add(row);
            result.setRow(rlist.toArray(new DBRowDO[0]));
            return result;
        }
        if (isForwardingTesting && !LicenseManager.getInstance().isFmLicensed(fpk)) {
            DBRowDO row = new DBRowDO();
            row.setEntry(new String[]{"", "", "FabricNotLicensed", "", "", "", ""});
            rlist.add(row);
            result.setRow(rlist.toArray(new DBRowDO[0]));
            return result;
        }
        String xmlDir = System.getProperty("server.callhome.xmlDir", "logs");
        String xmlFilePath = ClientCache.getInstallLocation() + xmlDir;
        File xmldir = new File(xmlFilePath);
        if (!xmldir.exists()) {
            StringBuffer sb = new StringBuffer("server.callhome.xmlDir");
            sb.append(" ");
            sb.append(xmlFilePath);
            sb.append(" does not exist");
            DBRowDO row = new DBRowDO();
            row.setEntry(new String[]{"", "", sb.toString(), "", "", "", ""});
            rlist.add(row);
            result.setRow(rlist.toArray(new DBRowDO[0]));
            return result;
        }
        boolean turnOnEventLogAll = false;
        boolean failedToTurnOnEventLogAll = false;
        if (isForwardingTesting) {
            String[] keys = new String[]{EVENTLOGALL_PROPERTIES};
            DBEntryDO serverProperties = AdminServiceHandler.getInstance().getServerProperties(keys);
            if (serverProperties != null && serverProperties.getRows().length > 0 && serverProperties.getRows()[0].getEntry()[0].equals(EVENTLOGALL_PROPERTIES)) {
                boolean isEventLogAllOn = serverProperties.getRows()[0].getEntry()[1].equals("true");
                _emcCallhomelog.debug((Object)("Event.log.all server properties = " + serverProperties.getRows()[0].getEntry()[1]));
                if (!isEventLogAllOn) {
                    try {
                        ServerPropertyUtil.updateServerProperty(keys, new String[]{"true"}, false);
                        turnOnEventLogAll = true;
                        _emcCallhomelog.debug((Object)"Set Event.log.all server properties to TRUE");
                    }
                    catch (Exception ex) {
                        _emcCallhomelog.debug((Object)"failed to set Event.log.all server properties to TRUE");
                        failedToTurnOnEventLogAll = true;
                    }
                }
            }
        }
        if (failedToTurnOnEventLogAll) {
            DBRowDO row = new DBRowDO();
            row.setEntry(new String[]{"", "", "FailToTurnOnEventLogAll", "", "", "", ""});
            rlist.add(row);
            result.setRow(rlist.toArray(new DBRowDO[0]));
            return result;
        }
        FabricImpl fabric = SanManager.getInstance().findFabric(fpk);
        ArrayList<SnmpPeer> peerList = new ArrayList<SnmpPeer>();
        if (fabric != null) {
            SwitchImpl[] sws = fabric.getSwitches();
            for (int k = 0; k < sws.length; ++k) {
                String location = sws[k].getBase().getSysLocation();
                if (excludedSws != null && excludedSws.get(new Long(sws[k].getDBID())) != null || !sws[k].getBase().isMdsFamilyType() && !sws[k].getBase().isN7K() && (!sws[k].getBase().isN5K() || sws[k].getBase().isUCS())) continue;
                String contact = sws[k].getBase().getSysContact();
                String swModel = sws[k].getBase().getModelName();
                String delayTrap = sws[k].getBase().isDelayLinkEnabled() ? "true" : "false";
                String swIP = sws[k].getBase().getIpAddress();
                String version = sws[k].getBase().getVersion();
                String[] swDetail = new String[]{sws[k].getName(), swIP, location, contact, swModel, "", "", version, delayTrap};
                _emcCallhomelog.debug((Object)("Switch " + swDetail[0] + "/IP " + swDetail[1] + " /Location " + swDetail[2] + " /Contact " + swDetail[3] + " /model " + swDetail[4] + " /Version " + swDetail[7] + " /delayTrap" + swDetail[8]));
                if (sws[k].isPeerCreated() && sws[k].isManageableMDS()) {
                    peerList.add(sws[k].getPeer());
                } else {
                    swDetail[5] = "Unmanageable";
                    _emcCallhomelog.debug((Object)("switch " + swDetail[0] + ": switch unmanageable"));
                }
                resultDetail.put(sws[k].getBase().getInetAddress(), swDetail);
            }
        } else {
            _emcCallhomelog.debug((Object)"Failed to verify if trap registered for all switches: em null");
            return new DBEntryDO(1, "Failed to verify if trap registered for all switches: em null");
        }
        SnmpPeer[] peers = peerList.toArray(new SnmpPeer[peerList.size()]);
        try {
            InetAddress seedSwIp = GlobalFabricManager.getInstance().getSeedSwitchAddress(fpk);
            if (seedSwIp == null) {
                _emcCallhomelog.debug((Object)"Failed to verify if trap registered for all switches: cannot find seedSwIP");
                return new DBEntryDO(1, "Failed to verify if trap registered for all switches: cannot find seedSwIP");
            }
            EMRif em = ClusterProcessor.getInstance().getEMByPK(fpk);
            if (em == null) {
                _emcCallhomelog.debug((Object)"Failed to verify if trap registered for all switches: em null");
                return new DBEntryDO(1, "Failed to verify if trap registered for all switches: em null");
            }
            String seed = InetAddress.getByAddress(seedSwIp.getAddress()).getHostAddress();
            Object[][] status = em.getSourceState(seed);
            if (status != null) {
                for (int k = 0; k < status.length; ++k) {
                    if (status[k][0] == null) {
                        _emcCallhomelog.debug((Object)("em.getSourceState(" + seed + "), device null: [" + k + "][0]= null"));
                        continue;
                    }
                    InetAddress device = (InetAddress)status[k][0];
                    if (device == null) continue;
                    String[] swDetail = (String[])resultDetail.get(device);
                    if (swDetail != null) {
                        _emcCallhomelog.debug((Object)("switch " + swDetail[0] + "....."));
                        if (status[k][1] == null) {
                            _emcCallhomelog.debug((Object)("em.getSourceState(" + seed + "), swDetail not found for [" + k + "][0] device"));
                            swDetail[6] = "n/a(possibly snmp timedout)";
                            continue;
                        }
                        Boolean receivedTrap = (Boolean)status[k][1];
                        swDetail[6] = receivedTrap != false ? "true" : "false";
                        _emcCallhomelog.debug((Object)("switch " + swDetail[0] + ": register trap? " + swDetail[6]));
                        continue;
                    }
                    _emcCallhomelog.debug((Object)("em.getSourceState(" + seed + "), swDetail not found for [" + k + "][0] device"));
                }
            } else {
                _emcCallhomelog.debug((Object)("em.getSourceState(" + seed + ") null"));
            }
        }
        catch (Exception ex) {
            _emcCallhomelog.debug((Object)("Failed to verify event registration, e=" + ex));
            return new DBEntryDO(1, "Failed to validate if trap register for all the switches: " + ex.getMessage());
        }
        EmcCallHomeHandler.getInstance().setOptionalLogger(_emcCallhomelog);
        AlertNotifier.getInstance().setOptionalLogger(_emcCallhomelog);
        for (int i = 0; i < peers.length; ++i) {
            String[] swDetail = (String[])resultDetail.get(peers[i].getAddress());
            if (swDetail == null) continue;
            if (isSmtpServerOK && swDetail[6].equals("true")) {
                try {
                    this.runCLICmd(peers[i], this.getCmd(swDetail[7]), _emcCallhomelog);
                    swDetail[5] = swDetail[8].equals("true") ? "Successfully executed CLI trap test command - check email" : "Successfully executed CLI trap test command - check email (delayed traps not enabled)";
                }
                catch (Exception ex) {
                    swDetail[5] = "CLI failed - " + ex.getMessage();
                }
            } else {
                swDetail[5] = "Not registered for traps";
            }
            _emcCallhomelog.debug((Object)("Switch " + swDetail[0] + " status :" + swDetail[5]));
        }
        for (String[] detail : resultDetail.values()) {
            DBRowDO row = new DBRowDO();
            row.setEntry(new String[]{detail[0], detail[1], isSmtpServerOK ? "true" : "false", detail[2], detail[3], detail[4], detail[5]});
            rlist.add(row);
        }
        result.setRow(rlist.toArray(new DBRowDO[0]));
        try {
            Thread.sleep(10000L);
            EmcCallHomeHandler.getInstance().setOptionalLogger(null);
            AlertNotifier.getInstance().setOptionalLogger(null);
        }
        catch (Exception ex) {
            try {
                _emcCallhomelog.debug((Object)("Thread sleep ex=" + ex));
                EmcCallHomeHandler.getInstance().setOptionalLogger(null);
                AlertNotifier.getInstance().setOptionalLogger(null);
            }
            catch (Throwable throwable) {
                EmcCallHomeHandler.getInstance().setOptionalLogger(null);
                AlertNotifier.getInstance().setOptionalLogger(null);
                _emcCallhomelog.debug((Object)"stop logger on EmcCallHomeHandler & AlertNotifier");
                if (turnOnEventLogAll) {
                    try {
                        String[] keys = new String[]{EVENTLOGALL_PROPERTIES};
                        ServerPropertyUtil.updateServerProperty(keys, new String[]{"false"}, false);
                        turnOnEventLogAll = true;
                        _emcCallhomelog.debug((Object)"Set Event.log.all server properties back to FALSE");
                    }
                    catch (Exception ex2) {
                        _emcCallhomelog.debug((Object)"failed to set Event.log.all server properties back to FALSE");
                        failedToTurnOnEventLogAll = true;
                    }
                }
                throw throwable;
            }
            _emcCallhomelog.debug((Object)"stop logger on EmcCallHomeHandler & AlertNotifier");
            if (turnOnEventLogAll) {
                try {
                    String[] keys = new String[]{EVENTLOGALL_PROPERTIES};
                    ServerPropertyUtil.updateServerProperty(keys, new String[]{"false"}, false);
                    turnOnEventLogAll = true;
                    _emcCallhomelog.debug((Object)"Set Event.log.all server properties back to FALSE");
                }
                catch (Exception ex3) {
                    _emcCallhomelog.debug((Object)"failed to set Event.log.all server properties back to FALSE");
                    failedToTurnOnEventLogAll = true;
                }
            }
        }
        _emcCallhomelog.debug((Object)"stop logger on EmcCallHomeHandler & AlertNotifier");
        if (turnOnEventLogAll) {
            try {
                String[] keys = new String[]{EVENTLOGALL_PROPERTIES};
                ServerPropertyUtil.updateServerProperty(keys, new String[]{"false"}, false);
                turnOnEventLogAll = true;
                _emcCallhomelog.debug((Object)"Set Event.log.all server properties back to FALSE");
            }
            catch (Exception ex) {
                _emcCallhomelog.debug((Object)"failed to set Event.log.all server properties back to FALSE");
                failedToTurnOnEventLogAll = true;
            }
        }
        return result;
    }

    @Override
    @WebMethod(operationName="removeForwarder")
    @WebResult(name="result", partName="result")
    public CallResultDO removeForwarder(boolean isLAN, String id, FabricKeyDO fpk, String serverIpaddress) throws SanServiceException {
        try {
            EMRif em = null;
            if (isLAN) {
                em = ClusterProcessor.getInstance().getEMByServerIp(serverIpaddress);
            } else {
                FabricPK pk = new FabricPK(fpk.getFid());
                em = ClusterProcessor.getInstance().getEMByPK(pk);
            }
            em.removeEventForward(Long.parseLong(id));
        }
        catch (Exception e) {
            logger.warn((Object)"SanWS caught exception in removeForwarder():", (Throwable)e);
            return new CallResultDO(1, "Failed to remove Forwarder: " + e.getMessage());
        }
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="addForwarder")
    @WebResult(name="result", partName="result")
    public CallResultDO addForwarder(boolean isLAN, FabricKeyDO fpk, String vsanScope, String method, String address, String strSeverity, String eventType, String eventSubType, String facility, String syslogType, String desRegx, String serverIpaddress, String portGroupIdStr) throws SanServiceException {
        try {
            if (eventType.equals("All Traps") || eventType.equals("All")) {
                eventType = "All Events";
            }
            int type = method.equals(EMAIL) ? 2 : 1;
            int severity = Severity.stringOf(strSeverity).getValue();
            int portGroupId = portGroupIdStr == null ? -1 : Integer.parseInt(portGroupIdStr);
            EMRif em = null;
            Long fid = new Long(-1L);
            Long grpId = new Long(-1L);
            if (isLAN || portGroupId != -1) {
                em = ClusterProcessor.getInstance().getEMByServerIp(serverIpaddress);
                if (isLAN) {
                    grpId = new Long(fpk.getFid());
                }
            } else {
                FabricPK pk = new FabricPK(fpk.getFid());
                em = ClusterProcessor.getInstance().getEMByPK(pk);
                fid = new Long(fpk.getFid());
            }
            if (em == null) {
                return new CallResultDO(1, "Cannot find EventMgr instance");
            }
            LogEventType eventTypeObj = LogEventType.valueOfByString(eventType);
            PortLogEventType eventSubTypeObj = PortLogEventType.valueOfByString(eventSubType);
            if (eventTypeObj == null || eventSubTypeObj == null) {
                return new CallResultDO(1, "wrong event type or event subtype");
            }
            em.addEventForward(type, address, eventTypeObj, eventSubTypeObj.value(), fid, vsanScope, severity, grpId.intValue(), isLAN ? 1 : 0, facility, syslogType, desRegx, portGroupId);
        }
        catch (Exception e) {
            logger.warn((Object)"SanWS caught exception in addForwarder():", (Throwable)e);
            return new CallResultDO(1, "Failed to add forwarder: " + e.getMessage());
        }
        return new CallResultDO();
    }

    private String getCmd(String version) {
        SwitchVersion targetVersion = new SwitchVersion(version);
        SwitchVersion devVersion = new SwitchVersion("4.0(0)");
        return targetVersion.lessThan(devVersion) ? "test pfm test-SNMP-trap fan" : "test pfm snmp test-trap fan";
    }

    private String runCLICmd(SnmpPeer peer, String cmd, Logger log) throws Exception {
        String result;
        block14: {
            Vsh vsh = null;
            result = "";
            log.debug((Object)("runCLICmd swip=" + peer.getAddress().getHostAddress() + " user=" + peer.getUserName() + " cmd=" + cmd));
            try {
                try {
                    vsh = Vsh.get(null, peer, false);
                }
                catch (Exception exAuth) {
                    throw new Exception("Bad credentials");
                }
                Vsh.put(vsh);
                if (vsh != null) {
                    String command = cmd.toString().trim();
                    vsh.send(command + "\n");
                    String aa = vsh.readPrompt();
                    String output = vsh.getReply();
                    if (output.equals("")) {
                        if (log != null) {
                            log.debug((Object)(peer.getAddress().getHostAddress() + ": send error, no output"));
                        }
                        throw new Exception("send error, no output");
                    }
                    output = this.stripFooter(output);
                    if ((output = this.stripHeader(output)).indexOf("invalid") != -1) {
                        if (log != null) {
                            log.debug((Object)(peer.getAddress().getHostAddress() + ": Bad syntax"));
                        }
                        throw new Exception("Bad syntax");
                    }
                    result = output;
                    if (vsh != null) {
                        vsh.close();
                    }
                    break block14;
                }
                log.debug((Object)(peer.getAddress().getHostAddress() + ": vsh.get() null"));
                throw new Exception("Bad credentials");
            }
            catch (Exception ex) {
                log.debug((Object)(peer.getAddress().getHostAddress() + ": ex=" + ex));
                throw new Exception(ex.getMessage());
            }
            finally {
                if (vsh != null) {
                    Vsh.put(vsh);
                }
            }
        }
        return result;
    }

    private String stripFooter(String input) {
        if (input == null) {
            return input;
        }
        StringTokenizer st = new StringTokenizer(input, "\n");
        String newOutput = "";
        int totalLines = st.countTokens();
        int i = 0;
        while (st.hasMoreTokens()) {
            String currToken = st.nextToken();
            if (i != totalLines - 1 && !currToken.trim().equals("")) {
                newOutput = newOutput + currToken + "\n";
            }
            ++i;
        }
        return newOutput;
    }

    private String stripHeader(String input) {
        if (input == null) {
            return input;
        }
        StringTokenizer st = new StringTokenizer(input, "\n");
        String newOutput = "";
        int i = 0;
        while (st.hasMoreTokens()) {
            String currToken = st.nextToken();
            if (i != 0 && !currToken.trim().equals("")) {
                newOutput = newOutput + currToken + "\n";
            }
            ++i;
        }
        return newOutput;
    }

    private boolean findProblem(Vsh vsh) throws IOException {
        vsh.send("show eol status \n");
        vsh.readPrompt();
        String swResult = vsh.getReply();
        String actualResult = FileSystemModel.stripFooter(swResult);
        actualResult = FileSystemModel.stripHeader(actualResult);
        return Integer.parseInt(actualResult.trim()) != 0;
    }

    @Override
    @WebMethod(operationName="importTS")
    @WebResult(name="result", partName="result")
    public CallResultDO importTS(String certFile, String serverIPAddress) {
        String keytool = System.getProperty("java.home") + File.separator + "bin" + File.separator + "keytool";
        String trustStore = ClientCache.getJBossHome() + File.separator + "server" + File.separator + "fm" + File.separator + "conf" + File.separator + "fmtrust.jks";
        String cmd = "\"" + keytool + "\" " + " -importcert -trustcacerts -keystore " + "\"" + trustStore + "\" -file \"" + certFile + "\"";
        try {
            int rc = Runtime.getRuntime().exec(cmd).waitFor();
            if (rc != 0) {
                System.out.println("Here");
            }
        }
        catch (Exception ex) {
            System.out.println("here");
        }
        return new CallResultDO();
    }

    @Override
    public NpvLinkDO[] getNpvLinks(FabricKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            NpvLinkImpl[] npvlinks;
            if (key == null) {
                throw new InvalidArgumentException("Invalid fabric key:" + key);
            }
            FabricImpl fabric = SanManager.getInstance().findFabric(key.toDomain());
            if (fabric == null) {
                throw new SanNotFoundException("Couldn't find fabrics");
            }
            ArrayList<NpvLinkDO> ret = new ArrayList<NpvLinkDO>();
            for (NpvLinkImpl npvlink : npvlinks = fabric.getNpvLinks()) {
                NpvLinkDO nlnk = new NpvLinkDO(npvlink);
                ret.add(nlnk);
            }
            if (ret.size() == 0) {
                return new NpvLinkDO[0];
            }
            return ret.toArray(new NpvLinkDO[0]);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getNpvLinks():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getNpvLinks():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getNpvLinks():", e);
            throw new SanServiceException("Cannot get npvlinks by fabric:" + key.getFid(), e);
        }
    }

    @Override
    public NpvLinkDO[] getNpvLinksWithPCMembers(FabricKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            NpvLinkImpl[] npvlinks;
            if (key == null) {
                throw new InvalidArgumentException("Invalid fabric key:" + key);
            }
            FabricImpl fabric = SanManager.getInstance().findFabric(key.toDomain());
            if (fabric == null) {
                throw new SanNotFoundException("Couldn't find fabrics");
            }
            ArrayList<NpvLinkDO> ret = new ArrayList<NpvLinkDO>();
            for (NpvLinkImpl npvlink : npvlinks = fabric.getNpvLinks()) {
                NpvLinkDO nlnk = new NpvLinkDO(npvlink);
                if (npvlink.isPortChannel()) {
                    List<ChannelMemberNpvl> memList = npvlink.getPCMemberLinks();
                    int cnt = 0;
                    NpvLinkDO[] nplinks = new NpvLinkDO[memList.size()];
                    for (ChannelMemberNpvl channelMemberNpvL : memList) {
                        NpvLinkDO memNpvlink = new NpvLinkDO(channelMemberNpvL);
                        memNpvlink.setVsanMembership(npvlink.getVsanMembership());
                        nplinks[cnt] = memNpvlink;
                        ++cnt;
                    }
                    nlnk.setMemberNpvLink(nplinks);
                }
                ret.add(nlnk);
            }
            if (ret.size() == 0) {
                return new NpvLinkDO[0];
            }
            return ret.toArray(new NpvLinkDO[0]);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getNpvLinks():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getNpvLinks():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getNpvLinks():", e);
            throw new SanServiceException("Cannot get npvlinks by fabric:" + key.getFid(), e);
        }
    }

    @Override
    public NpvLinkDO getNpvLink(SwitchIntKeyDO npvLinkKey) throws SanNotFoundException, SanServiceException {
        try {
            if (npvLinkKey == null) {
                throw new InvalidArgumentException("Invalid switch interface key:" + npvLinkKey);
            }
            WwnKey wwnKey = new WwnKey(new Wwn(npvLinkKey.getSwKey()));
            SwitchImpl sw = SanHelper.findSwitch(wwnKey);
            if (sw == null) {
                logger.warn((Object)("Cannot find switch by switch wwn:" + wwnKey));
                throw new SanNotFoundException("Cannot find switch");
            }
            SwitchIntKey key = new SwitchIntKey(npvLinkKey.toWwnKey(), npvLinkKey.getIndex());
            NpvLinkImpl impl = sw.getFabric().findNpvLink(key);
            if (impl != null) {
                return new NpvLinkDO(impl);
            }
            throw new SanNotFoundException("Cannot find NPV Links");
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getNpvLink():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getNpvLink():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getNpvLink():", e);
            throw new SanServiceException("Cannot get npv Link by key:" + npvLinkKey, e);
        }
    }

    @Override
    @WebMethod(operationName="shallowLanDiscover")
    @WebResult(name="result", partName="result")
    public AdminShallowDiscoverDO shallowLanDiscover(String seed, SnmpCredentialDO userCredential, int maxHop, int secTimeout) {
        AdminShallowDiscoverDO disco = new AdminShallowDiscoverDO();
        logger.info((Object)("shallow lan discovery initiated for " + seed));
        SnmpUserOpt snmpUserOpt = userCredential.toUserOpt();
        ArrayList<String> ipList = null;
        try {
            ipList = IpUtil.getIPStringListFromString(seed, ",");
        }
        catch (Exception e) {
            logger.error((Object)"shallow lan discovery IP address parsing failed");
            disco.setStatus("The supplied list of IP addresses could not be parsed");
            return disco;
        }
        CdpShallow cdps = new CdpShallow(snmpUserOpt, maxHop, secTimeout);
        long start = System.currentTimeMillis();
        cdps.discover(ipList);
        while (!cdps.getStatus().equals((Object)CdpDiscoveryStatusEnum.Complete)) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        long end = System.currentTimeMillis();
        long runtime = end - start;
        logger.debug((Object)("shallow lan discovery took " + runtime / 1000L + " seconds "));
        cdps.cleanup();
        disco.setNodes(cdps.getDisplayNodes());
        disco.setEdges(cdps.getDisplayEdges());
        disco.setHidden(cdps.getHiddenEdges());
        return disco;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @WebMethod(operationName="checkFederationHealth4Move")
    @WebResult(name="result", partName="result")
    public String[] checkFederationHealth4Move(String targetSvr, String[] oldServerIPs) {
        block31: {
            SanWS.logger.info((Object)("SanWS checkFederationHealth4Move... targetSvr " + targetSvr));
            for (String svr : oldServerIPs) {
                SanWS.logger.info((Object)("SanWS checkFederationHealth4Move... oldServer " + svr));
            }
            MAX_OUTSYNC = 10000;
            results = new ArrayList<String>();
            fedMap = new HashMap<String, FederationServer>();
            stmt = null;
            rs = null;
            con = null;
            try {
                SanWS.logger.info((Object)"SanWS checkFederationHealth4Move, get all servers from DB...");
                con = ConnectionManager.getConnection();
                sql = SanWS.fedQuery;
                stmt = con.prepareStatement(sql);
                rs = SQLLoader.execute(stmt);
                while (rs.next()) {
                    sid = rs.getInt(1);
                    addr = rs.getBytes(2);
                    status = rs.getInt(3);
                    inetAddr = null;
                    try {
                        inetAddr = InetAddress.getByAddress(addr);
                    }
                    catch (UnknownHostException e) {
                        SanWS.logger.info((Object)"checkFederationHealth: Skipped federation view addition due to ", (Throwable)e);
                        continue;
                    }
                    ipaddr = inetAddr.getHostAddress();
                    hostname = inetAddr.getHostName();
                    fed = (FederationServer)fedMap.get(ipaddr);
                    SanWS.logger.info((Object)("SanWS checkFederationHealth4Move  server sid/ipaddr/name/status " + sid + '/' + ipaddr + '/' + hostname + '/' + status));
                    if (fed != null) continue;
                    localTime = -1L;
                    fmServer = null;
                    try {
                        fmServer = ClusterProcessor.getInstance().getFmsByIp(ipaddr);
                        if (fmServer != null) {
                            localTime = fmServer.getServerTime();
                            SanWS.logger.info((Object)("SanWS checkFederationHealth4Move  server localtime " + localTime));
                        } else {
                            SanWS.logger.info((Object)("FederationHandler, failed to get fmServer localTime for " + ipaddr + " , fmServer null, failed to contact server"));
                        }
                    }
                    catch (Exception ex) {
                        SanWS.logger.info((Object)("FederationHandler, failed to get fmServer localTime for " + ipaddr + " , ex=" + ex));
                    }
                    fed = new FederationServer(hostname, ipaddr, localTime, status);
                    fedMap.put(ipaddr, fed);
                }
                if (rs == null) break block31;
            }
            catch (SQLException ex) {
                block32: {
                    try {
                        SanWS.logger.info((Object)"SQL Exception in SanWS checkFederationHealth ", (Throwable)ex);
                        if (rs == null) break block32;
                    }
                    catch (Throwable var21_29) {
                        if (rs != null) {
                            DbUtil.close(rs);
                        }
                        if (stmt != null) {
                            DbUtil.close(stmt);
                        }
                        if (con != null) {
                            DbUtil.close(con);
                        }
                        throw var21_29;
                    }
                    DbUtil.close(rs);
                }
                if (stmt != null) {
                    DbUtil.close(stmt);
                }
                if (con != null) {
                    DbUtil.close(con);
                } else {
                    ** GOTO lbl76
                }
            }
            DbUtil.close(rs);
        }
        if (stmt != null) {
            DbUtil.close(stmt);
        }
        if (con != null) {
            DbUtil.close(con);
        }
        localTimeList = new ArrayList<Long>();
        SanWS.logger.info((Object)("SanWS checkFederationHealth4Move, checking targetSvr " + targetSvr));
        fed = (FederationServer)fedMap.get(targetSvr);
        if (fed == null) {
            results.add("target server " + targetSvr + " not found at federation server list");
            SanWS.logger.info((Object)"SanWS checkFederationHealth4Move,  targetSvr not found at federation server list");
        } else if (fed.getStatus() != 0) {
            results.add("target server " + targetSvr + " status not RUNNING");
            SanWS.logger.info((Object)"SanWS checkFederationHealth4Move, targetSvr status not Running");
        } else if (fed.getLocalTime() == -1L) {
            results.add("failed to get localTime for server " + targetSvr);
            SanWS.logger.info((Object)"SanWS checkFederationHealth4Move, targetSvr failed to get localTime");
        } else {
            localTimeList.add(new Long(fed.getLocalTime()));
        }
        for (String oldSvr : oldServerIPs) {
            SanWS.logger.info((Object)("SanWS checkFederationHealth4Move, checking " + oldSvr));
            fed = (FederationServer)fedMap.get(oldSvr);
            if (fed == null) {
                results.add(oldSvr + " not found at federation server list");
                SanWS.logger.info((Object)("SanWS checkFederationHealth4Move,  not found at federation server list for " + oldSvr));
                continue;
            }
            if (fed.getLocalTime() == -1L) {
                if (fed.getStatus() != 1 || fed.getStatus() != 2) {
                    results.add("failed to get localTime for server " + oldSvr);
                    SanWS.logger.info((Object)("SanWS checkFederationHealth4Move,   failed to get localTime for " + oldSvr));
                    continue;
                }
                SanWS.logger.info((Object)("SanWS checkFederationHealth4Move,   skip server " + oldSvr + " (server down) due to status " + fed.getStatus()));
                continue;
            }
            localTimeList.add(new Long(fed.getLocalTime()));
        }
        if (localTimeList.size() > 1) {
            localTimes = localTimeList.toArray(new Long[localTimeList.size()]);
            Arrays.sort(localTimes);
            max = localTimes[localTimes.length - 1].longValue();
            min = localTimes[0].longValue();
            SanWS.logger.info((Object)("SanWS checkFederationHealth4Move,  localTime min/max " + min + '/' + max));
            SanWS.logger.info((Object)("SanWS checkFederationHealth4Move,  localTimeString min " + SnmpTimeticks.getDateFormat().format(new Date(min))));
            SanWS.logger.info((Object)("SanWS checkFederationHealth4Move,  localTimeString max " + SnmpTimeticks.getDateFormat().format(new Date(max))));
            if (max - min > 10000L) {
                results.add("Please keep server localTime difference < 10 sec");
            }
        }
        return results.toArray(new String[results.size()]);
    }

    public static void main(String[] args) {
        SanWS a = new SanWS();
        try {
            FabricDO[] rstList = a.getFabrics();
            boolean bl = false;
        }
        catch (Exception ex) {
            // empty catch block
        }
        boolean i = false;
    }

    @Override
    @WebMethod(operationName="getZonePolicyData")
    @WebResult(name="result", partName="result")
    public ZonePolicyDO getZonePolicyData() throws SanServiceException, InvalidArgumentException {
        return null;
    }
}

