/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.san.ep;

import com.cisco.dcbu.jaxws.ep.InvalidArgumentException;
import com.cisco.dcbu.jaxws.ep.SanNotFoundException;
import com.cisco.dcbu.jaxws.ep.SanServiceException;
import com.cisco.dcbu.jaxws.san.ep.StatisticsSEI;
import com.cisco.dcbu.jaxws.san.helper.SanHelper;
import com.cisco.dcbu.jaxws.san.helper.SnmpHelper;
import com.cisco.dcbu.jaxws.san.wo.CallResultDO;
import com.cisco.dcbu.jaxws.san.wo.EthPortStatisticsDO;
import com.cisco.dcbu.jaxws.san.wo.FcPortStatisticsDO;
import com.cisco.dcbu.jaxws.san.wo.IPEndPointStatisticsDO;
import com.cisco.dcbu.jaxws.san.wo.N3KBufferStatDataDO;
import com.cisco.dcbu.jaxws.san.wo.N3KBufferStatItemDataDO;
import com.cisco.dcbu.jaxws.san.wo.StatDO;
import com.cisco.dcbu.jaxws.san.wo.StatisticsDataDO;
import com.cisco.dcbu.jaxws.san.wo.SwitchIntKeyDO;
import com.cisco.dcbu.jaxws.san.wo.TCPEndPointStatisticsDO;
import com.cisco.dcbu.jaxws.san.wo.WwnKeyDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.jaxws.wo.NameValueDO;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.pm.N3KBufferIfCountData;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import com.cisco.dcbu.sm.common.rif.PMRif;
import com.cisco.dcbu.sm.common.type.LanPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.pm.PmChart;
import com.cisco.dcbu.sm.server.web.ClusterProcessor;
import com.cisco.dcbu.sm.server.web.inventory.EndDeviceStatHandler;
import com.cisco.dcbu.sm.server.web.inventory.FlowStatHandler;
import com.cisco.dcbu.sm.server.web.inventory.GigEStatHandler;
import com.cisco.dcbu.sm.server.web.inventory.HostEnclHandler;
import com.cisco.dcbu.sm.server.web.inventory.IslStatHandler;
import com.cisco.dcbu.sm.server.web.inventory.N3KBufferStatHandler;
import com.cisco.dcbu.sm.server.web.inventory.NpvLinkStatHandler;
import com.cisco.dcbu.sm.server.web.inventory.OidStatHandler;
import com.cisco.dcbu.sm.server.web.inventory.PortGroupStatHandler;
import com.cisco.dcbu.sm.server.web.inventory.SwitchBandwidthHandler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Stateless;
import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.ws.api.annotation.WebContext;

@SOAPBinding(style=SOAPBinding.Style.RPC, use=SOAPBinding.Use.LITERAL)
@HandlerChain(file="../../ep/fms-jaxws-handlers.xml")
@WebContext(contextRoot="/StatisticsWSService", urlPattern="/StatisticsWS")
@WebService(name="Statistics", serviceName="StatisticsService", endpointInterface="com.cisco.dcbu.jaxws.san.ep.StatisticsSEI")
@Stateless
public class StatisticsWS
implements StatisticsSEI {
    static Logger logger = LogManager.getLogger((String)"fms.ws");
    public static final String[] fcpmoids = new String[]{"1.3.6.1.2.1.31.1.1.1.6.", "1.3.6.1.2.1.31.1.1.1.10.", "1.3.6.1.2.1.2.2.1.13.", "1.3.6.1.2.1.2.2.1.19.", "1.3.6.1.2.1.2.2.1.14.", "1.3.6.1.2.1.2.2.1.20.", "1.3.6.1.2.1.2.2.1.11.", "1.3.6.1.2.1.2.2.1.17.", "1.3.6.1.4.1.9.9.289.1.2.1.1.6.", "1.3.6.1.2.1.75.1.3.1.1.1."};
    public static final String[] tcpoids = new String[]{"1.3.6.1.2.1.6.5.", "1.3.6.1.2.1.6.6.", "1.3.6.1.2.1.6.7.", "1.3.6.1.2.1.6.8.", "1.3.6.1.2.1.6.9.", "1.3.6.1.2.1.6.10.", "1.3.6.1.2.1.6.11.", "1.3.6.1.2.1.6.14.", "1.3.6.1.2.1.6.15."};
    public static final String[] ipoids = new String[]{"1.3.6.1.2.1.4.3.", "1.3.6.1.2.1.4.4.", "1.3.6.1.2.1.4.5.", "1.3.6.1.2.1.4.1.2.", "1.3.6.1.2.1.4.7.", "1.3.6.1.2.1.4.8.", "1.3.6.1.2.1.4.9.", "1.3.6.1.2.1.4.10.", "1.3.6.1.2.1.4.11.", "1.3.6.1.2.1.4.12.", "1.3.6.1.2.1.4.14.", "1.3.6.1.2.1.4.15.", "1.3.6.1.2.1.4.16.", "1.3.6.1.2.1.4.17.", "1.3.6.1.2.1.4.18.", "1.3.6.1.2.1.4.19.", "1.3.6.1.2.1.4.23."};
    private static String querySQL = "SELECT S.SRC_ID,STAT.DEST_ID,S.AVG_RX , S.AVG_TX, S.MAX_RX,S.MAX_TX,  S.LAST_WEEK_AVG_RX, S.LAST_WEEK_AVG_TX,  S.LAST_WEEK_MAX_RX, S.LAST_WEEK_MAX_TX,  S.LAST_MONTH_AVG_RX, S.LAST_MONTH_AVG_TX,  S.LAST_MONTH_MAX_RX, S.LAST_MONTH_MAX_TX,  S.LAST_YEAR_AVG_RX, S.LAST_YEAR_AVG_TX,  S.LAST_YEAR_MAX_RX, S.LAST_YEAR_MAX_TX,  END_PORT.ID, END_PORT.ALIAS, END_PORT.WWN  FROM STATISTICS S, END_PORT, SWITCH_PORT SP  WHERE ( END_PORT.WWN=? ) AND  (S.SRC_ID=END_PORT.ID) AND (( S.TYPE=3) OR (S.TYPE=4))";
    private static String querySQLByAlias = "SELECT S.SRC_ID,STAT.DEST_ID,S.AVG_RX , S.AVG_TX, S.MAX_RX,S.MAX_TX,  S.LAST_WEEK_AVG_RX, S.LAST_WEEK_AVG_TX,  S.LAST_WEEK_MAX_RX, S.LAST_WEEK_MAX_TX,  S.LAST_MONTH_AVG_RX, S.LAST_MONTH_AVG_TX,  S.LAST_MONTH_MAX_RX, S.LAST_MONTH_MAX_TX,  S.LAST_YEAR_AVG_RX, S.LAST_YEAR_AVG_TX,  S.LAST_YEAR_MAX_RX, S.LAST_YEAR_MAX_TX, END_PORT.ID, END_PORT.ALIAS, END_PORT.WWN  FROM STATISTICS S, END_PORT, SWITCH_PORT SP  WHERE ( END_PORT.ALIAS=? ) AND  (S.SRC_ID=END_PORT.ID) AND (( S.TYPE=3) OR (S.TYPE=4))";

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WebMethod(operationName="getEndDeviceStatistics")
    @WebResult(name="result", partName="result")
    public StatisticsDataDO getEndDeviceStatistics(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey) throws InvalidArgumentException, SanNotFoundException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StatisticsDataDO ret = null;
        try {
            conn = ConnectionManager.getConnection();
            stmt = conn.prepareStatement(querySQL);
            stmt.setBytes(1, swKey.getWwn().toWwn().getValue());
            rs = stmt.executeQuery();
            if (!rs.next()) throw new InvalidArgumentException("can not find stats for :" + swKey.toString());
            ret = this.getStat(swKey, rs);
            if (ret == null) {
                throw new SanNotFoundException("can not find stats for :" + swKey.toString());
            }
        }
        catch (SanNotFoundException e) {
            try {
                logger.warn((Object)"StatisticsWS caught exception in getEndDeviceStatistics():", (Throwable)e);
                throw e;
                catch (SQLException ex) {
                    throw new InvalidArgumentException(ex.getMessage());
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(stmt);
                DbUtil.close(rs);
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(stmt);
        DbUtil.close(rs);
        DbUtil.close(conn);
        return ret;
    }

    private StatisticsDataDO getStat(WwnKeyDO swKey, ResultSet rs) throws SQLException {
        StatisticsDataDO ret = new StatisticsDataDO(rs.getLong(1), rs.getLong(2));
        ret.setLastDayAvgRx(rs.getDouble(3));
        ret.setLastDayAvgTx(rs.getDouble(4));
        ret.setLastDayMaxRx(rs.getDouble(5));
        ret.setLastDayMaxTx(rs.getDouble(6));
        ret.setLastWeekAvgRx(rs.getDouble(7));
        ret.setLastWeekAvgTx(rs.getDouble(8));
        ret.setLastWeekMaxRx(rs.getDouble(9));
        ret.setLastWeekMaxTx(rs.getDouble(10));
        ret.setLastMonthAvgRx(rs.getDouble(11));
        ret.setLastMonthAvgTx(rs.getDouble(12));
        ret.setLastMonthMaxRx(rs.getDouble(13));
        ret.setLastMonthMaxTx(rs.getDouble(14));
        ret.setLastYearAvgRx(rs.getDouble(15));
        ret.setLastYearAvgTx(rs.getDouble(16));
        ret.setLastYearMaxRx(rs.getDouble(17));
        ret.setLastYearMaxTx(rs.getDouble(18));
        ret.setTitle(rs.getString(20) + ":" + swKey.getWwn());
        return ret;
    }

    @Override
    @WebMethod(operationName="getEndDeviceStatisticsByAlias")
    @WebResult(name="result", partName="result")
    public StatisticsDataDO[] getEndDeviceStatisticsByAlias(@WebParam(name="deviceAlias", partName="deviceAlias") String alias) throws InvalidArgumentException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<StatisticsDataDO> ret = new ArrayList<StatisticsDataDO>();
        try {
            conn = ConnectionManager.getConnection();
            stmt = conn.prepareStatement(querySQLByAlias);
            stmt.setString(1, alias);
            rs = stmt.executeQuery();
            while (rs.next()) {
                Wwn wwn = new Wwn(rs.getBytes(15));
                WwnKey key = new WwnKey(wwn);
                WwnKeyDO keyDo = new WwnKeyDO(key);
                ret.add(this.getStat(keyDo, rs));
            }
        }
        catch (SQLException ex) {
            try {
                throw new InvalidArgumentException(ex.getMessage());
            }
            catch (Throwable throwable) {
                DbUtil.close(stmt);
                DbUtil.close(rs);
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(stmt);
        DbUtil.close(rs);
        DbUtil.close(conn);
        StatisticsDataDO[] result = ret.size() != 0 ? ret.toArray(new StatisticsDataDO[ret.size()]) : new StatisticsDataDO[]{};
        return result;
    }

    @Override
    @WebMethod(operationName="getFcPortStatisticsByKey")
    @WebResult(name="result", partName="result")
    public FcPortStatisticsDO getFcPortStatisticsByKey(@WebParam(name="fcPortKey", partName="fcPortKey") SwitchIntKeyDO key) throws InvalidArgumentException {
        FcPortStatisticsDO ret = null;
        byte[] bytes = SnmpString.fromHexString(key.getSwKey());
        WwnKey sKey = new WwnKey(new Wwn(bytes));
        int ifindex = key.getIndex();
        try {
            ret = this.getFcPortStatistics(sKey, ifindex);
            ret.setFcPortKey(key);
        }
        catch (Exception ex) {
            throw new InvalidArgumentException("getFcPortStatisticsByKey failed:", ex);
        }
        return ret;
    }

    private FcPortStatisticsDO getFcPortStatistics(WwnKey sKey, int ifindex) throws SnmpException, SanNotFoundException {
        FcPortStatisticsDO ret = new FcPortStatisticsDO();
        SwitchImpl sw = SanHelper.findSwitch(sKey);
        SnmpOID[] oids = FcPortStatisticsDO.getOid(ifindex);
        VarBindList vbl = SnmpHelper.get(sw, oids);
        try {
            if (vbl.size() < 8) {
                throw new SanNotFoundException("Cannot find varBindList :" + vbl.toString());
            }
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"StatisticsWS caught exception in getFcPortStatistics():", (Throwable)e);
            throw e;
        }
        ret.setStatisticTime(System.currentTimeMillis());
        ret.setFcIfC2OutOctets(vbl.get(0).longValue());
        ret.setFcIfC3OutOctets(vbl.get(1).longValue());
        ret.setFcIfC2InOctets(vbl.get(2).longValue());
        ret.setFcIfC3InOctets(vbl.get(3).longValue());
        ret.setFcIfC2OutFrames(vbl.get(4).longValue());
        ret.setFcIfC3OutFrames(vbl.get(5).longValue());
        ret.setFcIfC2InFrames(vbl.get(6).longValue());
        ret.setFcIfC3InFrames(vbl.get(7).longValue());
        ret.setFcIfLipF8In(vbl.get(8).intValue());
        ret.setFcIfNOSIn(vbl.get(9).intValue());
        ret.setFcIfFramingErrorFrames(vbl.get(10).intValue());
        ret.setFcIfFramesDiscard(vbl.get(11).intValue());
        ret.setFcIfLinkFailures(vbl.get(12).intValue());
        ret.setFcIfSigLosses(vbl.get(13).intValue());
        ret.setFcIfSyncLosses(vbl.get(14).intValue());
        ret.setFcIfPrimSeqProtoErrors(vbl.get(15).intValue());
        ret.setFcIfInvalidCrcs(vbl.get(16).intValue());
        ret.setFcIfInvalidTxWords(vbl.get(17).intValue());
        ret.setFcIfFramesTooShort(vbl.get(18).intValue());
        ret.setFcIfFramesTooLong(vbl.get(19).intValue());
        ret.setFcIfAddressIdErrors(vbl.get(20).intValue());
        ret.setFcIfBBCreditTransistionFromZero(vbl.get(21).intValue());
        ret.setFcIfDelimiterErrors(vbl.get(22).intValue());
        ret.setFcIf8b10bDisparityErrors(vbl.get(23).intValue());
        ret.setFcIfLinkResetIns(vbl.get(24).intValue());
        ret.setFcIfLinkResetOuts(vbl.get(25).intValue());
        ret.setIfInMulticastPkts(vbl.get(26).longValue());
        ret.setIfOutMulticastPkts(vbl.get(25).longValue());
        ret.setFcIfC2FbsyFrames(vbl.get(28).intValue());
        ret.setFcIfC2PBSYFrames(vbl.get(29).intValue());
        ret.setFcIfC2FrjtFrames(vbl.get(30).intValue());
        ret.setFcIfC2PRJTFrames(vbl.get(31).intValue());
        ret.setFcIfC2Discards(vbl.get(32).intValue());
        ret.setFcIfC3Discards(vbl.get(33).intValue());
        return ret;
    }

    private SnmpOID[] getIpStatsOids(int index) {
        SnmpOID[] ret = new SnmpOID[ipoids.length];
        for (int i = 0; i < ret.length; ++i) {
            SnmpOID tmp = ipoids[i].endsWith(".") ? new SnmpOID(ipoids[i].substring(0, ipoids[i].length() - 1)) : new SnmpOID(ipoids[i]);
            ret[i] = new SnmpOID(tmp.getValue(), index);
        }
        return ret;
    }

    private SnmpOID[] getTcpStatsOids(int index) {
        SnmpOID[] ret = new SnmpOID[tcpoids.length];
        for (int i = 0; i < ret.length; ++i) {
            SnmpOID tmp = tcpoids[i].endsWith(".") ? new SnmpOID(tcpoids[i].substring(0, tcpoids[i].length() - 1)) : new SnmpOID(tcpoids[i]);
            ret[i] = new SnmpOID(tmp.getValue(), index);
        }
        return ret;
    }

    private SnmpOID[] getFCStatsOids(int index) {
        SnmpOID[] ret = new SnmpOID[fcpmoids.length];
        for (int i = 0; i < ret.length; ++i) {
            SnmpOID tmp = fcpmoids[i].endsWith(".") ? new SnmpOID(fcpmoids[i].substring(0, fcpmoids[i].length() - 1)) : new SnmpOID(fcpmoids[i]);
            ret[i] = new SnmpOID(tmp.getValue(), index);
        }
        return ret;
    }

    @Override
    @WebMethod(operationName="getEthPortStatisticsByKey")
    @WebResult(name="result", partName="result")
    public EthPortStatisticsDO getEthPortStatisticsByKey(@WebParam(name="ethPortKey", partName="ethPortKey") SwitchIntKeyDO key) throws InvalidArgumentException {
        EthPortStatisticsDO ret = null;
        byte[] bytes = SnmpString.fromHexString(key.getSwKey());
        WwnKey sKey = new WwnKey(new Wwn(bytes));
        SwitchImpl sw = SanHelper.findSwitch(sKey);
        int intf = key.getIndex();
        try {
            ret = this.getEthPortStats(sw, intf);
            ret.setEthPortKey(key);
        }
        catch (Exception ex) {
            throw new InvalidArgumentException("getEthPortStatisticsByKey failed:", ex);
        }
        return ret;
    }

    private EthPortStatisticsDO getEthPortStats(SwitchImpl sw, int intf) throws SnmpException {
        EthPortStatisticsDO ret = new EthPortStatisticsDO();
        SnmpOID[] oids = this.getFCStatsOids(intf);
        VarBindList vbl = SnmpHelper.get(sw, oids);
        ret.setBytesReceived(vbl.get(0).longValue());
        ret.setBytesTransmitted(vbl.get(1).longValue());
        ret.setPacketsReceived(vbl.get(6).longValue());
        ret.setPacketsTransmitted(vbl.get(7).longValue());
        ret.setCrcErrors(vbl.get(8).longValue());
        ret.setLinkFailures(vbl.get(9).longValue());
        ret.setStatisticTime(System.currentTimeMillis());
        return ret;
    }

    private IPEndPointStatisticsDO getIpPortStats(SwitchImpl sw, int intf) throws SnmpException {
        IPEndPointStatisticsDO ret = new IPEndPointStatisticsDO();
        SnmpOID[] oids = this.getIpStatsOids(intf);
        VarBindList vbl = SnmpHelper.get(sw, oids);
        ret.setReceivedPDUs(vbl.get(0).longValue());
        ret.setReceivedPDUHeaderErrors(vbl.get(1).longValue());
        ret.setReceivedPDUAddressErrors(vbl.get(2).longValue());
        ret.setReceivedPDUForwards(vbl.get(3).longValue());
        ret.setReceivedPDUUnknownProtocolErrors(vbl.get(4).longValue());
        ret.setReceivedPDUDiscards(vbl.get(5).longValue());
        ret.setPDUDelivers(vbl.get(6).longValue());
        ret.setSentPDUs(vbl.get(7).longValue());
        ret.setSentPDUDiscards(vbl.get(8).longValue());
        ret.setSentPDUNoRouteErrors(vbl.get(9).longValue());
        ret.setReassemblyRequireds(vbl.get(10).longValue());
        ret.setReassembledPackets(vbl.get(11).longValue());
        ret.setReassemblyFailed(vbl.get(12).longValue());
        ret.setFragmentation(vbl.get(13).longValue());
        ret.setFragmentedPDUCreates(vbl.get(14).longValue());
        ret.setFragmentationFaileds(vbl.get(15).longValue());
        ret.setRouteEntriesDiscards(vbl.get(16).longValue());
        ret.setStatisticTime(System.currentTimeMillis());
        return ret;
    }

    private TCPEndPointStatisticsDO getTcpPortStats(SwitchImpl sw, int intf) throws SnmpException {
        TCPEndPointStatisticsDO ret = new TCPEndPointStatisticsDO();
        SnmpOID[] oids = this.getTcpStatsOids(intf);
        VarBindList vbl = SnmpHelper.get(sw, oids);
        ret.setActiveOpenConnections(vbl.get(0).longValue());
        ret.setPassiveOpenConnections(vbl.get(1).longValue());
        ret.setAttemptsFail(vbl.get(2).longValue());
        ret.setEstablishedResets(vbl.get(3).longValue());
        ret.setEstablishedConnections(vbl.get(4).longValue());
        ret.setReceivedSegments(vbl.get(5).longValue());
        ret.setSentSegments(vbl.get(6).longValue());
        ret.setReceivedSegmentsInError(vbl.get(7).longValue());
        ret.setSentResetSegments(vbl.get(8).longValue());
        ret.setStatisticTime(System.currentTimeMillis());
        return ret;
    }

    @Override
    @WebMethod(operationName="getFcPortStatisticsBySwitch")
    @WebResult(name="result", partName="result")
    public FcPortStatisticsDO[] getFcPortStatisticsBySwitch(@WebParam(name="key", partName="key") WwnKeyDO key) throws InvalidArgumentException {
        SwitchImpl sw;
        WwnKey sKey = key.toWwnKey();
        List<FcPortStatisticsDO> portstats = this.getFcStatsBySwitchImpl(sKey, sw = SanHelper.findSwitch(sKey));
        FcPortStatisticsDO[] result = portstats.size() != 0 ? portstats.toArray(new FcPortStatisticsDO[portstats.size()]) : new FcPortStatisticsDO[]{};
        return result;
    }

    private List<FcPortStatisticsDO> getFcStatsBySwitchImpl(WwnKey sKey, SwitchImpl sw) {
        List<FcPortBase> fcPorts = sw.findFcPorts();
        ArrayList<FcPortStatisticsDO> portstats = new ArrayList<FcPortStatisticsDO>();
        try {
            for (int i = 0; i < fcPorts.size(); ++i) {
                FcPortStatisticsDO stat;
                if (fcPorts.get(i).getIfname().startsWith("fcip") || fcPorts.get(i).getIfname().startsWith("channel") || (stat = this.getFcPortStatistics(sKey, fcPorts.get(i).getIfIndex())) == null) continue;
                String str = SnmpString.toHexString(sKey._wwn.getValue(), 0, sKey._wwn.getValue().length);
                SwitchIntKeyDO portkey = new SwitchIntKeyDO(str, fcPorts.get(i).getIfIndex());
                stat.setFcPortKey(portkey);
                portstats.add(stat);
            }
        }
        catch (Exception ex) {
            throw new InvalidArgumentException("getFcPortStatisticsBySwitch failed:", ex);
        }
        return portstats;
    }

    private List<EthPortStatisticsDO> getEthStatsBySwitchImpl(WwnKey sKey, SwitchImpl sw) {
        List<FcPortBase> etherports = sw.findGigaEthPorts();
        List<FcPortBase> tmp = sw.findNonIPSEthPorts();
        if (tmp != null) {
            etherports.addAll(tmp);
        }
        if ((tmp = sw.findMgmtPorts()) != null) {
            etherports.addAll(tmp);
        }
        ArrayList<EthPortStatisticsDO> portstats = new ArrayList<EthPortStatisticsDO>();
        try {
            for (int i = 0; i < etherports.size(); ++i) {
                EthPortStatisticsDO stat = this.getEthPortStats(sw, etherports.get(i).getIfIndex());
                if (stat == null) continue;
                String str = SnmpString.toHexString(sKey._wwn.getValue(), 0, sKey._wwn.getValue().length);
                SwitchIntKeyDO portkey = new SwitchIntKeyDO(str, etherports.get(i).getIfIndex());
                stat.setEthPortKey(portkey);
                portstats.add(stat);
            }
        }
        catch (Exception ex) {
            throw new InvalidArgumentException("getFcPortStatisticsBySwitch failed:", ex);
        }
        return portstats;
    }

    @Override
    @WebMethod(operationName="getEthPortStatisticsBySwitch")
    @WebResult(name="result", partName="result")
    public EthPortStatisticsDO[] getEthPortStatisticsBySwitch(@WebParam(name="key", partName="key") WwnKeyDO key) throws InvalidArgumentException {
        SwitchImpl sw;
        WwnKey sKey = key.toWwnKey();
        List<EthPortStatisticsDO> portstats = this.getEthStatsBySwitchImpl(sKey, sw = SanHelper.findSwitch(sKey));
        EthPortStatisticsDO[] result = portstats.size() != 0 ? portstats.toArray(new EthPortStatisticsDO[portstats.size()]) : new EthPortStatisticsDO[]{};
        return result;
    }

    @Override
    @WebMethod(operationName="getFcPortStatistics")
    @WebResult(name="result", partName="result")
    public FcPortStatisticsDO[] getFcPortStatistics() throws InvalidArgumentException {
        SwitchImpl[] sws = SanManager.getInstance().getSwitches();
        ArrayList<FcPortStatisticsDO> portstats = new ArrayList<FcPortStatisticsDO>();
        for (int i = 0; i < sws.length; ++i) {
            portstats.addAll(this.getFcStatsBySwitchImpl(sws[i].getSwitchPK(), sws[i]));
        }
        FcPortStatisticsDO[] result = portstats.size() != 0 ? portstats.toArray(new FcPortStatisticsDO[portstats.size()]) : new FcPortStatisticsDO[]{};
        return result;
    }

    @Override
    @WebMethod(operationName="getTCPEndPointStatisticsBySwitch")
    @WebResult(name="result", partName="result")
    public TCPEndPointStatisticsDO[] getTCPEndPointStatisticsBySwitch(@WebParam(name="key", partName="key") WwnKeyDO key) throws InvalidArgumentException {
        WwnKey sKey = key.toWwnKey();
        SwitchImpl sw = SanHelper.findSwitch(sKey);
        List<FcPortBase> etherports = sw.findFcipPorts();
        ArrayList<TCPEndPointStatisticsDO> portstats = new ArrayList<TCPEndPointStatisticsDO>();
        try {
            for (int i = 0; i < etherports.size(); ++i) {
                TCPEndPointStatisticsDO stat = this.getTcpPortStats(sw, etherports.get(i).getIfIndex());
                if (stat == null) continue;
                String str = SnmpString.toHexString(sKey._wwn.getValue(), 0, sKey._wwn.getValue().length);
                SwitchIntKeyDO portkey = new SwitchIntKeyDO(str, etherports.get(i).getIfIndex());
                stat.setPortKey(portkey);
                portstats.add(stat);
            }
        }
        catch (Exception ex) {
            throw new InvalidArgumentException("getFcPortStatisticsBySwitch failed:", ex);
        }
        TCPEndPointStatisticsDO[] result = portstats.size() != 0 ? portstats.toArray(new TCPEndPointStatisticsDO[portstats.size()]) : new TCPEndPointStatisticsDO[]{};
        return result;
    }

    @Override
    @WebMethod(operationName="getTCPEndPointStatisticsByKey")
    @WebResult(name="result", partName="result")
    public TCPEndPointStatisticsDO getTCPEndPointStatisticsByKey(@WebParam(name="portKey", partName="portKey") SwitchIntKeyDO key) throws InvalidArgumentException {
        TCPEndPointStatisticsDO ret = null;
        byte[] bytes = SnmpString.fromHexString(key.getSwKey());
        WwnKey sKey = new WwnKey(new Wwn(bytes));
        SwitchImpl sw = SanHelper.findSwitch(sKey);
        int intf = key.getIndex();
        try {
            ret = this.getTcpPortStats(sw, intf);
            ret.setPortKey(key);
        }
        catch (Exception ex) {
            throw new InvalidArgumentException("getTCPEndPointStatisticsByKey failed:", ex);
        }
        return ret;
    }

    @Override
    @WebMethod(operationName="getIPEndPointStatisticsBySwitch")
    @WebResult(name="result", partName="result")
    public IPEndPointStatisticsDO[] getIPEndPointStatisticsBySwitch(@WebParam(name="key", partName="key") WwnKeyDO key) throws InvalidArgumentException {
        WwnKey sKey = key.toWwnKey();
        SwitchImpl sw = SanHelper.findSwitch(sKey);
        List<FcPortBase> etherports = sw.findFcipPorts();
        ArrayList<IPEndPointStatisticsDO> portstats = new ArrayList<IPEndPointStatisticsDO>();
        try {
            for (int i = 0; i < etherports.size(); ++i) {
                IPEndPointStatisticsDO stat = this.getIpPortStats(sw, etherports.get(i).getIfIndex());
                if (stat == null) continue;
                String str = SnmpString.toHexString(sKey._wwn.getValue(), 0, sKey._wwn.getValue().length);
                SwitchIntKeyDO portkey = new SwitchIntKeyDO(str, etherports.get(i).getIfIndex());
                stat.setPortKey(portkey);
                portstats.add(stat);
            }
        }
        catch (Exception ex) {
            throw new InvalidArgumentException("getFcPortStatisticsBySwitch failed:", ex);
        }
        IPEndPointStatisticsDO[] result = portstats.size() != 0 ? portstats.toArray(new IPEndPointStatisticsDO[portstats.size()]) : new IPEndPointStatisticsDO[]{};
        return result;
    }

    @Override
    @WebMethod(operationName="getIPEndPointStatisticsByKey")
    @WebResult(name="result", partName="result")
    public IPEndPointStatisticsDO getIPEndPointStatisticsByKey(@WebParam(name="portKey", partName="portKey") SwitchIntKeyDO key) throws InvalidArgumentException {
        IPEndPointStatisticsDO ret = null;
        byte[] bytes = SnmpString.fromHexString(key.getSwKey());
        WwnKey sKey = new WwnKey(new Wwn(bytes));
        SwitchImpl sw = SanHelper.findSwitch(sKey);
        int intf = key.getIndex();
        try {
            ret = this.getIpPortStats(sw, intf);
            ret.setPortKey(key);
        }
        catch (Exception ex) {
            throw new InvalidArgumentException("getIPEndPointStatisticsByKey failed:", ex);
        }
        return ret;
    }

    @Override
    @WebMethod(operationName="getIslStatList")
    @WebResult(name="result", partName="result")
    public StatisticsDataDO[] getIslStatList(DbFilterDO dbFilter, String interval, int startIdx, int recordSize) throws SanServiceException {
        try {
            ArrayList<StatisticsDataDO> statList = IslStatHandler.getInstance().getIslStatList(dbFilter, interval, startIdx, recordSize, false);
            if (statList.size() < recordSize) {
                recordSize = statList.size();
            }
            StatisticsDataDO[] retEP = new StatisticsDataDO[recordSize];
            for (int i = 0; i < statList.size(); ++i) {
                retEP[i] = statList.get(i);
            }
            return retEP;
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getIslStatList():", e);
            throw new SanServiceException("Cannot isl stat in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getPmPcMem")
    @WebResult(name="result", partName="result")
    public StatisticsDataDO[] getPmPcMem(long islId, String interval) throws SanServiceException {
        try {
            ArrayList<StatisticsDataDO> statList = IslStatHandler.getInstance().getPcMemList(islId, interval);
            StatisticsDataDO[] retEP = new StatisticsDataDO[statList.size()];
            for (int i = 0; i < statList.size(); ++i) {
                retEP[i] = statList.get(i);
            }
            return retEP;
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getIslStatList():", e);
            throw new SanServiceException("Cannot isl stat in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getIslStatDataLength")
    @WebResult(name="result", partName="result")
    public int getIslStatDataLength(DbFilterDO dbFilter, String interval) throws SanServiceException {
        try {
            return IslStatHandler.getInstance().getIslStatDataLength(dbFilter, interval);
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getIslStatDataLength():", e);
            throw new SanServiceException("Cannot get all isl stat length in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getEnclChartData")
    @WebResult(name="result", partName="result")
    public CallResultDO getEnclChartData(long encId, int pmType, int chartType) throws SanServiceException, InvalidArgumentException {
        try {
            return HostEnclHandler.getInstance().getEnclChartData(encId, pmType, chartType);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getEnclChartData():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getEnclChartData():", e);
            throw new SanServiceException("SanWS caught exception in getEnclChartData():" + e.getMessage());
        }
    }

    @Override
    @WebMethod(operationName="getEnclChartData")
    @WebResult(name="result", partName="result")
    public CallResultDO getEnclFlowChartData(long srcId, long desId, int chartType) throws SanServiceException, InvalidArgumentException {
        try {
            return HostEnclHandler.getInstance().getEnclFlowChartData(srcId, desId, chartType);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getEnclFlowChartData():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getEnclFlowChartData():", e);
            throw new SanServiceException("SanWS caught exception in getEnclChartData():" + e.getMessage());
        }
    }

    @Override
    @WebMethod(operationName="getEnclDataArray")
    @WebResult(name="result", partName="result")
    public double[][] getEnclDataArray(long encId, int pmType, int chartType) throws SanServiceException, InvalidArgumentException {
        try {
            return EndDeviceStatHandler.getInstance().getDataInEnclosure(encId, pmType, chartType);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getEnclDataArray():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getEnclDataArray():", e);
            throw new SanServiceException("SanWS caught exception in getEnclDataArray():" + e.getMessage());
        }
    }

    @Override
    @WebMethod(operationName="getVmChartData")
    @WebResult(name="result", partName="result")
    public CallResultDO getVmChartData(String ipAddrStr, String vmType, int chartType, long vhostId) throws SanServiceException, InvalidArgumentException {
        try {
            return HostEnclHandler.getInstance().getVmChartData(ipAddrStr, vmType, chartType, vhostId);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getVmChartData():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getVmChartData():", e);
            throw new SanServiceException("SanWS caught exception in getVmChartData():" + e.getMessage());
        }
    }

    @Override
    @WebMethod(operationName="getVmDiskIOData")
    @WebResult(name="result", partName="result")
    public CallResultDO getVmDiskIOData(String ipAddrStr, String vmType, int chartType, long vhostId) throws SanServiceException, InvalidArgumentException {
        try {
            return HostEnclHandler.getInstance().getVmDiskIOData(ipAddrStr, vmType, chartType, vhostId);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getVmChartData():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getVmChartData():", e);
            throw new SanServiceException("SanWS caught exception in getVmChartData():" + e.getMessage());
        }
    }

    @Override
    @WebMethod(operationName="getVHostNetworkIOData")
    @WebResult(name="result", partName="result")
    public CallResultDO getVHostNetworkIOData(String ipAddrStr, String vmType, int chartType, long vhostId) throws SanServiceException, InvalidArgumentException {
        try {
            return HostEnclHandler.getInstance().getVHostNetworkIOData(ipAddrStr, vmType, chartType, vhostId);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getVHostNetworkIOData():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getVHostNetworkIOData():", e);
            throw new SanServiceException("SanWS caught exception in getVHostNetworkIOData():" + e.getMessage());
        }
    }

    @Override
    @WebMethod(operationName="getVHostLatencyData")
    @WebResult(name="result", partName="result")
    public CallResultDO getVHostLatencyData(String ipAddrStr, String vmType, int chartType, long vhostId) throws SanServiceException, InvalidArgumentException {
        try {
            return HostEnclHandler.getInstance().getVHostLatencyData(ipAddrStr, vmType, chartType, vhostId);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getVHostLatencyData():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getVHostLatencyData():", e);
            throw new SanServiceException("SanWS caught exception in getVHostLatencyData():" + e.getMessage());
        }
    }

    @Override
    @WebMethod(operationName="getPmChartData")
    @WebResult(name="result", partName="result")
    public double[][] getPmChartData(String rrdFile, int pmType, int fid, int interval) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (rrdFile == null) {
                throw new InvalidArgumentException();
            }
            PMRif pmRif = ClusterProcessor.getInstance().getPMByPK(new LanPK(fid));
            if (pmRif.getPmChartData(rrdFile, pmType, interval) == null) {
                throw new SanNotFoundException("can not data in getPmChartData");
            }
            return pmRif.getPmChartData(rrdFile, pmType, interval);
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"StatisticsWS caught exception in getPmChartData():", (Throwable)e);
            throw e;
        }
        catch (InvalidArgumentException e) {
            logger.error((Object)"SanWS caught exception in getPmChartData():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.error((Object)"SanWS caught exception in getPmChartData():", e);
            throw new SanServiceException("SanWS caught exception in getPmChartData():" + e.getMessage());
        }
    }

    @Override
    @WebMethod(operationName="getInterfacePmChartData")
    @WebResult(name="result", partName="result")
    public CallResultDO getInterfacePmChartData(long interfaceDbId, int fid, int interval) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        CallResultDO result = new CallResultDO();
        try {
            NameValueDO[] nv = EndDeviceStatHandler.getInstance().getInterfacePmData(interfaceDbId);
            if (nv == null || nv.length == 0) {
                result.setResultMessage("No performance data for this interface.");
                result.setResultStatus(1);
                return result;
            }
            StatDO[] statArr = null;
            String rrdFile = nv[0].getValue();
            int pmType = Integer.parseInt(nv[1].getValue());
            PMRif pmRif = ClusterProcessor.getInstance().getPMByPK(new LanPK(fid));
            double[][] stats = pmRif.getPmChartData(rrdFile, pmType, interval);
            if (stats == null || stats.length == 0) {
                result.setResultMessage("Performance data not yet available for this interface.");
                result.setResultStatus(2);
                return result;
            }
            statArr = new StatDO[stats.length];
            for (int i = 0; i < stats.length; ++i) {
                statArr[i] = new StatDO(stats[i][0], stats[i][1], stats[i][2]);
            }
            result.setResultStats(statArr);
            return result;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SatisticsWS caught exception in getInterfacePmChartData():", (Throwable)e);
            throw e;
        }
        catch (InvalidArgumentException e) {
            logger.error((Object)"SanWS caught exception in getPmChartData():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.error((Object)"SanWS caught exception in getPmChartData():", e);
            throw new SanServiceException("SanWS caught exception in getPmChartData():" + e.getMessage());
        }
    }

    @Override
    @WebMethod(operationName="getISLPmChartData")
    @WebResult(name="result", partName="result")
    public CallResultDO getISLPmChartData(long interfaceDbId, int fid, int interval) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        CallResultDO result = new CallResultDO();
        try {
            NameValueDO[] nv = EndDeviceStatHandler.getInstance().getInterfacePmData(interfaceDbId);
            if (nv == null || nv.length == 0) {
                result.setResultMessage("No performance data for this ISL.");
                result.setResultStatus(1);
                return result;
            }
            StatDO[] statArr = null;
            String rrdFile = "";
            int pmType = 0;
            for (int i = 0; i < nv.length; ++i) {
                rrdFile = nv[i].getValue();
                if ((pmType = Integer.parseInt(nv[++i].getValue())) == 1 || pmType == 10) break;
            }
            if (rrdFile == "") {
                result.setResultMessage("Performance data not yet available for this ISL.");
                result.setResultStatus(2);
                return result;
            }
            PMRif pmRif = ClusterProcessor.getInstance().getPMByPK(new LanPK(fid));
            double[][] stats = pmRif.getPmChartData(rrdFile, pmType, interval);
            if (stats == null || stats.length == 0) {
                result.setResultMessage("Performance data not yet available for this ISL.");
                result.setResultStatus(2);
                return result;
            }
            statArr = new StatDO[stats.length];
            for (int i = 0; i < stats.length; ++i) {
                statArr[i] = new StatDO(stats[i][0], stats[i][1], stats[i][2]);
            }
            result.setResultStats(statArr);
            return result;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SatisticsWS caught exception in getISLPmChartData():", (Throwable)e);
            throw e;
        }
        catch (InvalidArgumentException e) {
            logger.error((Object)"SanWS caught exception in getPmChartData():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.error((Object)"SanWS caught exception in getPmChartData():", e);
            throw new SanServiceException("SanWS caught exception in getPmChartData():" + e.getMessage());
        }
    }

    @Override
    @WebMethod(operationName="getCustomPmChartData")
    @WebResult(name="result", partName="result")
    public double[][] getCustomPmChartData(String rrdFile, int pmType, int fid, int interval, long start, long end) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (rrdFile == null) {
                throw new InvalidArgumentException();
            }
            PMRif pmRif = ClusterProcessor.getInstance().getPMByPK(new LanPK(fid));
            if (pmRif.getPmChartData(rrdFile, pmType, interval, start, end) == null) {
                throw new SanNotFoundException("can not data in getPmChartData");
            }
            return pmRif.getPmChartData(rrdFile, pmType, interval, start, end);
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"StatisticsWS caught exception in getCustomPmChartData():", (Throwable)e);
            throw e;
        }
        catch (InvalidArgumentException e) {
            logger.error((Object)"SanWS caught exception in getPmChartData():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.error((Object)"SanWS caught exception in getPmChartData():", e);
            throw new SanServiceException("SanWS caught exception in getPmChartData():" + e.getMessage());
        }
    }

    @Override
    @WebMethod(operationName="getNpvLinkStatList")
    @WebResult(name="result", partName="result")
    public StatisticsDataDO[] getNpvLinkStatList(DbFilterDO dbFilter, String interval, int startIdx, int recordSize) throws SanServiceException {
        try {
            ArrayList<StatisticsDataDO> statList = NpvLinkStatHandler.getInstance().getNpvLinkStatList(dbFilter, interval, startIdx, recordSize);
            if (statList.size() < recordSize) {
                recordSize = statList.size();
            }
            StatisticsDataDO[] retEP = new StatisticsDataDO[recordSize];
            for (int i = 0; i < statList.size(); ++i) {
                retEP[i] = statList.get(i);
            }
            return retEP;
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getNpvLinkStatList():", e);
            throw new SanServiceException("Cannot get NPV Link stat in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getNpvLinkStatDataLength")
    @WebResult(name="result", partName="result")
    public int getNpvLinkStatDataLength(DbFilterDO dbFilter, String interval) throws SanServiceException {
        try {
            return NpvLinkStatHandler.getInstance().getNpvLinkStatDataLength(dbFilter, interval);
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getNpvLinkStatDataLength():", e);
            throw new SanServiceException("Cannot get all NPV Link stat length in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getNpvLinkPmPcMem")
    @WebResult(name="result", partName="result")
    public StatisticsDataDO[] getNpvLinkPmPcMem(long linkId, String interval) throws SanServiceException {
        try {
            ArrayList<StatisticsDataDO> statList = NpvLinkStatHandler.getInstance().getPcMemList(linkId, interval);
            StatisticsDataDO[] retEP = new StatisticsDataDO[statList.size()];
            for (int i = 0; i < statList.size(); ++i) {
                retEP[i] = statList.get(i);
            }
            return retEP;
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getNpvLinkPmPcMem():", e);
            throw new SanServiceException("Cannot isl stat in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getSwitchBandwidthStatList")
    @WebResult(name="result", partName="result")
    public StatisticsDataDO[] getSwitchBandwidthStatList(DbFilterDO dbFilter, String interval, int startIdx, int recordSize) throws SanServiceException {
        try {
            ArrayList<StatisticsDataDO> statList = SwitchBandwidthHandler.getInstance().getSwitchBandwidthStatList(dbFilter, interval, startIdx, recordSize);
            if (statList.size() < recordSize) {
                recordSize = statList.size();
            }
            StatisticsDataDO[] retEP = new StatisticsDataDO[recordSize];
            for (int i = 0; i < statList.size(); ++i) {
                retEP[i] = statList.get(i);
            }
            return retEP;
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getSwitchBandwidthStatList():", e);
            throw new SanServiceException("Cannot get NPV Link stat in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getSwitchBandwidthStatDataLength")
    @WebResult(name="result", partName="result")
    public int getSwitchBandwidthStatDataLength(DbFilterDO dbFilter, String interval) throws SanServiceException {
        try {
            return SwitchBandwidthHandler.getInstance().getSwitchBandwidthStatDataLength(dbFilter, interval);
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getNpvLinkStatDataLength():", e);
            throw new SanServiceException("Cannot get all NPV Link stat length in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getEndDeviceStatList")
    @WebResult(name="result", partName="result")
    public StatisticsDataDO[] getEndDeviceStatList(DbFilterDO dbFilter, String type, String interval, int startIdx, int recordSize) throws SanServiceException {
        try {
            ArrayList<StatisticsDataDO> statList = EndDeviceStatHandler.getInstance().getEndDeviceStatList(dbFilter, type, interval, startIdx, recordSize, false);
            StatisticsDataDO[] retEP = new StatisticsDataDO[statList.size()];
            for (int i = 0; i < statList.size(); ++i) {
                retEP[i] = (StatisticsDataDO)statList.get(i);
            }
            return retEP;
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getEndDeviceStatList():", e);
            throw new SanServiceException("Cannot get all end device stat length in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getEndDeviceStatDataLength")
    @WebResult(name="result", partName="result")
    public int getEndDeviceStatDataLength(DbFilterDO dbFilter, String type, String interval) throws SanServiceException {
        try {
            return EndDeviceStatHandler.getInstance().getEndDeviceStatDataLength(dbFilter, type, interval);
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getEndDeviceStatData():", e);
            throw new SanServiceException("Cannot get all end device stat in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getPortGroupStatList")
    @WebResult(name="result", partName="result")
    public StatisticsDataDO[] getPortGroupStatList(DbFilterDO dbFilter, String type, String interval, int startIdx, int recordSize) throws SanServiceException {
        try {
            ArrayList<StatisticsDataDO> statList = PortGroupStatHandler.getInstance().getPortGroupStatList(dbFilter, type, interval, startIdx, recordSize);
            StatisticsDataDO[] retEP = new StatisticsDataDO[statList.size()];
            for (int i = 0; i < statList.size(); ++i) {
                retEP[i] = (StatisticsDataDO)statList.get(i);
            }
            return retEP;
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getPortGroupStatList():", e);
            throw new SanServiceException("Cannot get all port group stat in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getPortGroupStatDataLength")
    @WebResult(name="result", partName="result")
    public int getPortGroupStatDataLength(DbFilterDO dbFilter, String type, String interval) throws SanServiceException {
        try {
            return PortGroupStatHandler.getInstance().getPortGroupStatDataLength(dbFilter, type, interval);
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getPortGroupStatDataLength():", e);
            throw new SanServiceException("Cannot get all port group stat in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getPmPgMem")
    @WebResult(name="result", partName="result")
    public StatisticsDataDO[] getPmPgMem(long encId, String interval) throws SanServiceException {
        try {
            List<StatisticsDataDO> statList = PortGroupStatHandler.getInstance().getPgMemList(encId, interval);
            StatisticsDataDO[] retEP = new StatisticsDataDO[statList.size()];
            for (int i = 0; i < statList.size(); ++i) {
                retEP[i] = statList.get(i);
            }
            return retEP;
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getIslStatList():", e);
            throw new SanServiceException("Cannot isl stat in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getGigEStatDataLength")
    @WebResult(name="result", partName="result")
    public int getGigEStatDataLength(DbFilterDO dbFilter, String interval) throws SanServiceException {
        try {
            return GigEStatHandler.getInstance().getGigEStatDataLength(dbFilter, interval);
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getGigEStatDataLength():", e);
            throw new SanServiceException("Cannot get all GigE stats", e);
        }
    }

    @Override
    @WebMethod(operationName="getGigEStatList")
    @WebResult(name="result", partName="result")
    public StatisticsDataDO[] getGigEStatList(DbFilterDO dbFilter, String interval, int startIdx, int recordSize) throws SanServiceException {
        try {
            ArrayList<StatisticsDataDO> statList = GigEStatHandler.getInstance().getGigEStatList(dbFilter, interval, startIdx, recordSize, false);
            if (statList.size() < recordSize) {
                recordSize = statList.size();
            }
            StatisticsDataDO[] retEP = new StatisticsDataDO[recordSize];
            for (int i = 0; i < statList.size(); ++i) {
                retEP[i] = (StatisticsDataDO)statList.get(i);
            }
            return retEP;
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getGigEStatList():", e);
            throw new SanServiceException("Cannot get all GigE stats", e);
        }
    }

    @Override
    @WebMethod(operationName="getFcipStats")
    @WebResult(name="result", partName="result")
    public StatisticsDataDO[] getFcipStats(long switchDbId, int ifIndex, String interval) throws SanServiceException {
        try {
            ArrayList<StatisticsDataDO> statList = GigEStatHandler.getInstance().getFcipStats(switchDbId, ifIndex, interval);
            StatisticsDataDO[] retEP = new StatisticsDataDO[statList.size()];
            for (int i = 0; i < statList.size(); ++i) {
                retEP[i] = (StatisticsDataDO)statList.get(i);
            }
            return retEP;
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getFcipStats():", e);
            throw new SanServiceException("Cannot get all FCIP stats", e);
        }
    }

    @Override
    @WebMethod(operationName="getPortGroupPgMem")
    @WebResult(name="result", partName="result")
    public StatisticsDataDO[] getPortGroupPgMem(long switchId, long pgId, String interval) throws SanServiceException {
        try {
            List<StatisticsDataDO> statList = PortGroupStatHandler.getInstance().getPgMemForPortGroup(switchId, pgId, interval);
            StatisticsDataDO[] retEP = new StatisticsDataDO[statList.size()];
            for (int i = 0; i < statList.size(); ++i) {
                retEP[i] = statList.get(i);
            }
            return retEP;
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getFcipStats():", e);
            throw new SanServiceException("Cannot get all FCIP stats", e);
        }
    }

    @Override
    @WebMethod(operationName="getRealTimeStats")
    @WebResult(name="result", partName="result")
    public long[] getRealTimeStats(String rrdFile, int pmType) throws SanServiceException, SanNotFoundException {
        try {
            if (PmChart.getInstance().getRealTimeStats(rrdFile, pmType) == null) {
                throw new SanNotFoundException("No performance data for this interface");
            }
            return PmChart.getInstance().getRealTimeStats(rrdFile, pmType);
        }
        catch (SanNotFoundException se) {
            logger.warn((Object)"StatisticsWS caught exception in getRealTimeStats():", (Throwable)se);
            throw se;
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getRealTimeStats():", e);
            throw new SanServiceException("Cannot get all real time stat in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getCpuStatList")
    @WebResult(name="result", partName="result")
    public StatisticsDataDO[] getCpuStatList(DbFilterDO dbFilter, String interval, int startIdx, int recordSize) throws SanServiceException {
        try {
            ArrayList<StatisticsDataDO> statList = OidStatHandler.getInstance().getOidStatList(dbFilter, interval, startIdx, recordSize, OidStatHandler.TYPE_CPU);
            if (statList.size() < recordSize) {
                recordSize = statList.size();
            }
            StatisticsDataDO[] retEP = new StatisticsDataDO[statList.size()];
            for (int i = 0; i < statList.size(); ++i) {
                retEP[i] = statList.get(i);
            }
            return retEP;
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getOisStatList():", e);
            throw new SanServiceException("Cannot get Oid stat in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getCpuStatDataLength")
    @WebResult(name="result", partName="result")
    public int getCpuStatDataLength(DbFilterDO dbFilter, String interval) throws SanServiceException {
        try {
            return OidStatHandler.getInstance().getOidStatDataLength(dbFilter, interval, OidStatHandler.TYPE_CPU);
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getOidStatDataLength():", e);
            throw new SanServiceException("Cannot get all Oid stat length in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getMemoryStatList")
    @WebResult(name="result", partName="result")
    public StatisticsDataDO[] getMemoryStatList(DbFilterDO dbFilter, String interval, int startIdx, int recordSize) throws SanServiceException {
        try {
            ArrayList<StatisticsDataDO> statList = OidStatHandler.getInstance().getOidStatList(dbFilter, interval, startIdx, recordSize, OidStatHandler.TYPE_MEMORY);
            if (statList.size() < recordSize) {
                recordSize = statList.size();
            }
            StatisticsDataDO[] retEP = new StatisticsDataDO[statList.size()];
            for (int i = 0; i < statList.size(); ++i) {
                retEP[i] = statList.get(i);
            }
            return retEP;
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getOisStatList():", e);
            throw new SanServiceException("Cannot get Oid stat in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getMemoryStatDataLength")
    @WebResult(name="result", partName="result")
    public int getMemoryStatDataLength(DbFilterDO dbFilter, String interval) throws SanServiceException {
        try {
            return OidStatHandler.getInstance().getOidStatDataLength(dbFilter, interval, OidStatHandler.TYPE_MEMORY);
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getOidStatDataLength():", e);
            throw new SanServiceException("Cannot get all Oid stat length in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getOidStatList")
    @WebResult(name="result", partName="result")
    public StatisticsDataDO[] getOidStatList(DbFilterDO dbFilter, String interval, int startIdx, int recordSize) throws SanServiceException {
        try {
            ArrayList<StatisticsDataDO> statList = OidStatHandler.getInstance().getOidStatList(dbFilter, interval, startIdx, recordSize, OidStatHandler.TYPE_ALL);
            if (statList.size() < recordSize) {
                recordSize = statList.size();
            }
            StatisticsDataDO[] retEP = new StatisticsDataDO[statList.size()];
            for (int i = 0; i < statList.size(); ++i) {
                retEP[i] = statList.get(i);
            }
            return retEP;
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getOisStatList():", e);
            throw new SanServiceException("Cannot get Oid stat in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getOidOtherStatList")
    @WebResult(name="result", partName="result")
    public StatisticsDataDO[] getOidOtherStatList(DbFilterDO dbFilter, String interval, int startIdx, int recordSize) throws SanServiceException {
        try {
            ArrayList<StatisticsDataDO> statList = OidStatHandler.getInstance().getOidStatList(dbFilter, interval, startIdx, recordSize, OidStatHandler.TYPE_OTHER);
            if (statList.size() < recordSize) {
                recordSize = statList.size();
            }
            StatisticsDataDO[] retEP = new StatisticsDataDO[statList.size()];
            for (int i = 0; i < statList.size(); ++i) {
                retEP[i] = statList.get(i);
            }
            return retEP;
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getOisStatList():", e);
            throw new SanServiceException("Cannot get Oid stat in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getOidStatDataLength")
    @WebResult(name="result", partName="result")
    public int getOidStatDataLength(DbFilterDO dbFilter, String interval) throws SanServiceException {
        try {
            return OidStatHandler.getInstance().getOidStatDataLength(dbFilter, interval, OidStatHandler.TYPE_ALL);
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getOidStatDataLength():", e);
            throw new SanServiceException("Cannot get all Oid stat length in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getOidOtherStatDataLength")
    @WebResult(name="result", partName="result")
    public int getOidOtherStatDataLength(DbFilterDO dbFilter, String interval) throws SanServiceException {
        try {
            return OidStatHandler.getInstance().getOidStatDataLength(dbFilter, interval, OidStatHandler.TYPE_OTHER);
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getOidStatDataLength():", e);
            throw new SanServiceException("Cannot get all Oid stat length in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getFlowStatList")
    @WebResult(name="result", partName="result")
    public StatisticsDataDO[] getFlowStatList(DbFilterDO dbFilter, String interval, int startIdx, int recordSize) throws SanServiceException {
        try {
            ArrayList<StatisticsDataDO> statList = FlowStatHandler.getInstance().getFlowStatList(dbFilter, interval, startIdx, recordSize);
            if (statList.size() < recordSize) {
                recordSize = statList.size();
            }
            StatisticsDataDO[] retEP = new StatisticsDataDO[recordSize];
            for (int i = 0; i < statList.size(); ++i) {
                retEP[i] = statList.get(i);
            }
            return retEP;
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getFlowStatList():", e);
            throw new SanServiceException("Cannot get flow stat in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getFlowStatDataLength")
    @WebResult(name="result", partName="result")
    public int getFlowStatDataLength(DbFilterDO dbFilter, String interval) throws SanServiceException {
        try {
            return FlowStatHandler.getInstance().getFlowStatDataLength(dbFilter, interval);
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getFlowStatDataLength():", e);
            throw new SanServiceException("Cannot get all flow stat length in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getN3KBufferStatList")
    @WebResult(name="result", partName="result")
    public N3KBufferStatDataDO[] getN3KBufferStatList(DbFilterDO dbFilter, int startIdx, int recordSize) throws SanServiceException {
        try {
            ArrayList<N3KBufferStatDataDO> statList = N3KBufferStatHandler.getInstance().getN3KBufferStatList(dbFilter, startIdx, recordSize);
            if (statList.size() < recordSize) {
                recordSize = statList.size();
            }
            N3KBufferStatDataDO[] retEP = new N3KBufferStatDataDO[recordSize];
            for (int i = 0; i < statList.size(); ++i) {
                retEP[i] = statList.get(i);
            }
            return retEP;
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getN3KBufferStatList():", e);
            throw new SanServiceException("Cannot get flow stat in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getN3KBufferStatDataLength")
    @WebResult(name="result", partName="result")
    public int getN3KBufferStatDataLength(DbFilterDO dbFilter) throws SanServiceException {
        try {
            return N3KBufferStatHandler.getInstance().getN3KBufferStatDataLength(dbFilter);
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getN3KBufferStatDataLength():", e);
            throw new SanServiceException("Cannot get all N3K Buffer stat length.", e);
        }
    }

    @Override
    @WebMethod(operationName="getN3KBufferStatList")
    @WebResult(name="result", partName="result")
    public N3KBufferStatItemDataDO[] getN3KBufferStatItem(long switchId, long ifIndex) throws SanServiceException {
        try {
            ArrayList<N3KBufferStatItemDataDO> statList = N3KBufferStatHandler.getInstance().getN3KBufferStatItem(switchId, ifIndex);
            N3KBufferStatItemDataDO[] retEP = new N3KBufferStatItemDataDO[statList.size()];
            for (int i = 0; i < statList.size(); ++i) {
                retEP[i] = statList.get(i);
            }
            return retEP;
        }
        catch (Throwable e) {
            logger.warn((Object)"StatisticsWS caught exception in getN3KBufferStatList():", e);
            throw new SanServiceException("Cannot get flow stat in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getN3KBufferIfCount")
    @WebResult(name="result", partName="result")
    public N3KBufferIfCountData[] getN3KBufferIfCount(int lanId, long switchId, long ifIndex, long timestamp) throws SanServiceException, InvalidArgumentException {
        try {
            PMRif pmRif = ClusterProcessor.getInstance().getPMByPK(new LanPK(lanId));
            ArrayList<N3KBufferIfCountData> statList = pmRif.getN3KBufferIfCount(switchId, ifIndex, timestamp);
            N3KBufferIfCountData[] retEP = new N3KBufferIfCountData[statList.size()];
            for (int i = 0; i < statList.size(); ++i) {
                retEP[i] = statList.get(i);
            }
            return retEP;
        }
        catch (InvalidArgumentException e) {
            logger.error((Object)"SanWS caught exception in getN3KBufferIfCount():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.error((Object)"SanWS caught exception in getN3KBufferIfCount():", e);
            throw new SanServiceException("SanWS caught exception in getN3KBufferIfCount():" + e.getMessage());
        }
    }

    @Override
    public String printCpuStatTable(DbFilterDO dbFilter, String interval, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        return OidStatHandler.getInstance().printOidStatTable(dbFilter, interval, startIdx, recordSize, OidStatHandler.TYPE_CPU, columnHeader);
    }

    @Override
    public String exportCpuStatTable(DbFilterDO dbFilter, String interval, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        return OidStatHandler.getInstance().exportOidStatTable(dbFilter, interval, startIdx, recordSize, OidStatHandler.TYPE_CPU, columnHeader);
    }

    @Override
    public String printMemoryStatTable(DbFilterDO dbFilter, String interval, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        return OidStatHandler.getInstance().printOidStatTable(dbFilter, interval, startIdx, recordSize, OidStatHandler.TYPE_MEMORY, columnHeader);
    }

    @Override
    public String exportMemoryStatTable(DbFilterDO dbFilter, String interval, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        return OidStatHandler.getInstance().exportOidStatTable(dbFilter, interval, startIdx, recordSize, OidStatHandler.TYPE_MEMORY, columnHeader);
    }

    @Override
    public String printOidOtherStatTable(DbFilterDO dbFilter, String interval, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        return OidStatHandler.getInstance().printOidStatTable(dbFilter, interval, startIdx, recordSize, OidStatHandler.TYPE_OTHER, columnHeader);
    }

    @Override
    public String exportOidOtherStatTable(DbFilterDO dbFilter, String interval, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        return OidStatHandler.getInstance().exportOidStatTable(dbFilter, interval, startIdx, recordSize, OidStatHandler.TYPE_OTHER, columnHeader);
    }

    @Override
    public String printSwitchBandwidthStatTable(DbFilterDO dbFilter, String interval, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        return SwitchBandwidthHandler.getInstance().printSwitchBandwidthStatTable(dbFilter, interval, startIdx, recordSize, columnHeader);
    }

    @Override
    public String exportSwitchBandwidthStatTable(DbFilterDO dbFilter, String interval, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        return SwitchBandwidthHandler.getInstance().exportSwitchBandwidthStatTable(dbFilter, interval, startIdx, recordSize, columnHeader);
    }

    @Override
    public String printIslStatTable(DbFilterDO dbFilter, String interval, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        return IslStatHandler.getInstance().printIslStatTable(dbFilter, interval, startIdx, recordSize, columnHeader);
    }

    @Override
    public String exportIslStatTable(DbFilterDO dbFilter, String interval, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        return IslStatHandler.getInstance().exportIslStatTable(dbFilter, interval, startIdx, recordSize, columnHeader);
    }

    @Override
    public String printNpvLinkStatTable(DbFilterDO dbFilter, String interval, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        return NpvLinkStatHandler.getInstance().printNpvLinkStatTable(dbFilter, interval, startIdx, recordSize, columnHeader);
    }

    @Override
    public String exportNpvLinkStatTable(DbFilterDO dbFilter, String interval, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        return NpvLinkStatHandler.getInstance().exportNpvLinkStatTable(dbFilter, interval, startIdx, recordSize, columnHeader);
    }

    @Override
    public String printGigEStatTable(DbFilterDO dbFilter, String interval, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        return GigEStatHandler.getInstance().printGigEStatTable(dbFilter, interval, startIdx, recordSize, columnHeader);
    }

    @Override
    public String exportGigEStatTable(DbFilterDO dbFilter, String interval, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        return GigEStatHandler.getInstance().exportGigEStatTable(dbFilter, interval, startIdx, recordSize, columnHeader);
    }

    @Override
    public String printFlowStatTable(DbFilterDO dbFilter, String interval, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        return FlowStatHandler.getInstance().printFlowStatTable(dbFilter, interval, startIdx, recordSize, columnHeader);
    }

    @Override
    public String exportFlowStatTable(DbFilterDO dbFilter, String interval, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        return FlowStatHandler.getInstance().exportFlowStatTable(dbFilter, interval, startIdx, recordSize, columnHeader);
    }

    @Override
    public String printEndDeviceStatTable(DbFilterDO dbFilter, String type, String interval, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        return EndDeviceStatHandler.getInstance().printEndDeviceStatTable(dbFilter, type, interval, startIdx, recordSize, columnHeader);
    }

    @Override
    public String exportEndDeviceStatTable(DbFilterDO dbFilter, String type, String interval, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        return EndDeviceStatHandler.getInstance().exportEndDeviceStatTable(dbFilter, type, interval, startIdx, recordSize, columnHeader);
    }

    @Override
    public String printPortGroupStatTable(DbFilterDO dbFilter, String type, String interval, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        return PortGroupStatHandler.getInstance().printPortGroupStatTable(dbFilter, type, interval, startIdx, recordSize, columnHeader);
    }

    @Override
    public String exportPortGroupStatTable(DbFilterDO dbFilter, String type, String interval, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        return PortGroupStatHandler.getInstance().exportPortGroupStatTable(dbFilter, type, interval, startIdx, recordSize, columnHeader);
    }

    @Override
    public String printN3KBufferStatTable(DbFilterDO dbFilter, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        return N3KBufferStatHandler.getInstance().printN3KBufferStatTable(dbFilter, startIdx, recordSize, columnHeader);
    }

    @Override
    public String exportN3KBufferStatTable(DbFilterDO dbFilter, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        return N3KBufferStatHandler.getInstance().exportN3KBufferStatTable(dbFilter, startIdx, recordSize, columnHeader);
    }
}

