/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.san.wo;

import com.cisco.dcbu.jaxws.san.wo.HwInventoryComponentDO;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.sm.common.dto.HwInventoryType;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.type.PKIf;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="Card")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CardDO
extends HwInventoryComponentDO
implements Serializable {
    private int modelType;
    private int adminStatus;
    private int operStatus;
    private String resetReason;
    private long statusLastChangeTime;
    private int powerAdminStatus;
    private int powerOperStatus;
    private int powerCurrent;
    private DmmStateType dmmState;

    protected CardDO() {
    }

    public CardDO(PKIf swPK, int phyIndex, int[] vendorType, int slot, String name, String hwRev, String fwRev, String swRev, String serialNum, String model, String mfg, String assetId, int adminStatus, int operStatus, String statusDescr, String resetReason, long changeTime, int powerAdminStatus, int powerOperStatus, int current, int dmmState, long lastScanTime) {
        super(swPK, phyIndex, name, vendorType, HwInventoryType.MODULE.value(), slot, hwRev, fwRev, swRev, serialNum, mfg, model, assetId, statusDescr, "n/a", lastScanTime);
        if (this.vendorType != null && this.vendorType.length != 0) {
            this.modelType = FRUConstants.getModuleType(this.vendorType);
        }
        this.adminStatus = adminStatus;
        this.operStatus = operStatus;
        this.resetReason = resetReason;
        this.statusLastChangeTime = changeTime;
        this.powerAdminStatus = powerAdminStatus;
        this.powerOperStatus = powerOperStatus;
        this.powerCurrent = current;
        this.dmmState = DmmStateType.getType(dmmState);
        this.lastScanTime = lastScanTime;
    }

    public CardDO(Card card) {
        this((PKIf)card.getSwitchPK(), card.getPhysicalIndex(), card.getVendorType(), card.getSlotId(), card.getName(), card.getHardwareRevision(), card.getFirmwareRevision(), card.getSoftwareRevision(), card.getSerialNumber(), card.getModelName(), card.getManufacturer(), card.getAssetId(), card.getAdminStatus(), card.getOperStatus(), card.getStatusDescr(), card.getResetReason(), card.getStatusLastChangeTime(), card.getPowerAdminStatus(), card.getPowerOperStatus(), card.getPowerCurrent(), card.getDmmState(), card.getLastScanTime());
    }

    @Override
    public String toString() {
        return new StringBuffer("slot ").append(this.relativePosition).append(" ").append(this.getModelName()).append(" ").append(this.name).append(" ").append(this.softwareRevision).append(" ").append(this.operStatus == 2 ? "up" : "down").append(" status last change time: ").append(this.statusLastChangeTime).toString();
    }

    public boolean isDmmReady() {
        return this.dmmState == DmmStateType.Disabled;
    }

    public boolean isDmmReady4Set() {
        return this.dmmState == DmmStateType.Enabled;
    }

    public int getNumPorts() {
        return FRUConstants.getNumPorts(this.modelType);
    }

    public int getNumEthPorts() {
        return FRUConstants.getNumEthPorts(this.modelType);
    }

    public int getNumGigEPorts() {
        return FRUConstants.getNumEthPorts(this.modelType);
    }

    public boolean hasEthernetPorts() {
        return FRUConstants.hasEthernetPorts(this.modelType);
    }

    public boolean hasSup() {
        return FRUConstants.hasSup(this.modelType);
    }

    public boolean isSup2() {
        return FRUConstants.isSup2(this.modelType);
    }

    public boolean isMixedCard() {
        return FRUConstants.isMixedCard(this.modelType);
    }

    public int getIfType() {
        return FRUConstants.getIfType(this.modelType);
    }

    public int getIfType(int port) {
        return FRUConstants.getPortIfType(this.modelType, port);
    }

    public int getAdminStatus() {
        return this.adminStatus;
    }

    public void setAdminStatus(int adminStatus) {
        this.adminStatus = adminStatus;
    }

    public DmmStateType getDmmState() {
        return this.dmmState;
    }

    public void setDmmState(DmmStateType dmmState) {
        this.dmmState = dmmState;
    }

    public int getModelType() {
        return this.modelType;
    }

    public void setModelType(int modelType) {
        this.modelType = modelType;
    }

    public int getOperStatus() {
        return this.operStatus;
    }

    public void setOperStatus(int operStatus) {
        this.operStatus = operStatus;
    }

    public int getPowerAdminStatus() {
        return this.powerAdminStatus;
    }

    public void setPowerAdminStatus(int powerAdminStatus) {
        this.powerAdminStatus = powerAdminStatus;
    }

    public int getPowerCurrent() {
        return this.powerCurrent;
    }

    public void setPowerCurrent(int powerCurrent) {
        this.powerCurrent = powerCurrent;
    }

    public int getPowerOperStatus() {
        return this.powerOperStatus;
    }

    public void setPowerOperStatus(int powerOperStatus) {
        this.powerOperStatus = powerOperStatus;
    }

    public String getResetReason() {
        return this.resetReason;
    }

    public void setResetReason(String resetReason) {
        this.resetReason = resetReason;
    }

    public long getStatusLastChangeTime() {
        return this.statusLastChangeTime;
    }

    public void setStatusLastChangeTime(long statusLastChangeTime) {
        this.statusLastChangeTime = statusLastChangeTime;
    }

    public static enum DmmStateType {
        NotAvail(0),
        Enabled(1),
        Disabled(2);

        private int value;

        private DmmStateType(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static final DmmStateType getType(int value) {
            for (DmmStateType t : DmmStateType.values()) {
                if (t.value != value) continue;
                return t;
            }
            throw new IllegalArgumentException("Invalid type value:" + value);
        }

        public static final DmmStateType getType(String typeName) {
            for (DmmStateType t : DmmStateType.values()) {
                if (!t.name().equalsIgnoreCase(typeName)) continue;
                return t;
            }
            throw new IllegalArgumentException("Invalid type name:" + typeName);
        }
    }
}

