/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.san.wo;

import com.cisco.dcbu.sm.common.model.IndexerBase;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="IndexBase")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class IndexBaseDO
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int PERFORMANCE = 1;
    public static final int INVENTORY = 2;
    public static final int EVENT = 3;
    public static final int SWITCH = 1;
    public static final int END_DEVICE = 2;
    public static final int VSAN = 3;
    public static final int ISL = 4;
    public static final int ENCLOSURE = 5;
    public static final int VM = 6;
    public static final int MODULE = 7;
    public static final int ZONE = 8;
    public static final int IVR_ZONE = 9;
    public static final int LAN_SWITCH = 10;
    public static final int MODULE_SWITCH = 11;
    public static final int SMIS_STORAGE_SYSTEM = 12;
    public static final int SMIS_STORAGE_PORT = 13;
    public static final int SMIS_POOL = 14;
    public static final int SMIS_LUN = 15;
    public static final int SMIS_HOST_PORT = 16;
    public static final int SMIS_STORAGE_PROCESSOR = 17;
    public static final int PM_END_DEVICE = 1;
    public static final int PM_FLOW = 2;
    public static final int PM_ISL = 3;
    long id;
    long dstId;
    int category;
    int type;
    long identityId;
    int scopeType;
    String name = null;
    String strValue = null;
    String link = null;
    String typeString = "";
    String catString = "";
    String wwn = null;
    String alias = "";
    String ipaddr = "";
    String dscr = "";
    String mulPurpose = "";
    String errorCause = null;
    String serialNumber = "";
    String macAddr = "";

    public IndexBaseDO() {
    }

    public IndexBaseDO(IndexerBase base) {
        this.id = base.getId();
        this.dstId = base.getDstId();
        this.name = base.getName();
        this.category = base.getCategory();
        this.type = base.getType();
        this.link = base.getLink(this.category, this.type);
        this.catString = this.getCatString();
        this.identityId = base.getIdentityId();
        this.typeString = this.getTypeString();
        this.wwn = base.getWwn();
        this.alias = base.getAlias();
        this.ipaddr = base.getIpaddr();
        this.dscr = base.getDscrpt();
        this.mulPurpose = base.getMulPurpose();
        this.serialNumber = base.getSerialNumber();
        this.scopeType = base.getScopeType();
        this.macAddr = base.getMacAddr();
    }

    public IndexBaseDO(String errorCause) {
        this.errorCause = errorCause;
    }

    public String toString() {
        return "id: " + this.id + "\tname: " + this.name + "\tcategory: " + this.category + "\ttype:" + this.type + "\tlink: " + this.link;
    }

    public long getDstId() {
        return this.dstId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getId() {
        return this.id;
    }

    public int getCategory() {
        return this.category;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeString() {
        if (this.category == 2) {
            switch (this.type) {
                case 1: {
                    this.typeString = "Switch";
                    break;
                }
                case 2: {
                    this.typeString = "End Device";
                    break;
                }
                case 3: {
                    this.typeString = "Vsan";
                    break;
                }
                case 4: {
                    this.typeString = "ISL";
                    break;
                }
                case 8: {
                    this.typeString = "Zone";
                    break;
                }
                case 9: {
                    this.typeString = "IVR Zone";
                    break;
                }
                case 5: {
                    this.typeString = "Enclosure";
                    break;
                }
                case 6: {
                    this.typeString = "VM";
                    break;
                }
                case 10: {
                    this.typeString = "Switch";
                    break;
                }
                case 11: {
                    this.typeString = "Switch Module";
                    break;
                }
                case 12: {
                    this.typeString = "Storage System";
                    break;
                }
                case 13: {
                    this.typeString = "Storage Port";
                    break;
                }
                case 14: {
                    this.typeString = "Storage Pool";
                    break;
                }
                case 15: {
                    this.typeString = "Storage Lun";
                    break;
                }
                case 16: {
                    this.typeString = "Storage Host Port";
                    break;
                }
                case 17: {
                    this.typeString = "Storage Processor";
                }
            }
            return this.typeString + ":" + "Inventory";
        }
        if (this.category == 3) {
            return "Event";
        }
        switch (this.type) {
            case 1: {
                this.typeString = "End Device";
                break;
            }
            case 2: {
                this.typeString = "Flows";
                break;
            }
            case 3: {
                this.typeString = "ISL";
            }
        }
        return this.typeString + ":" + "Performance";
    }

    public void setTypeString(String typeString) {
        this.typeString = typeString;
    }

    public String getStrValue() {
        return this.strValue;
    }

    public String getLink() {
        return this.link == null ? "#" : this.link + ".do?dbId=" + this.id + "&dbDstId=" + this.dstId;
    }

    public String getCatString() {
        switch (this.category) {
            case 2: {
                this.catString = "Inventory";
                break;
            }
            case 1: {
                this.catString = "Performance";
                break;
            }
            case 3: {
                this.catString = "Event";
                break;
            }
            default: {
                this.catString = "";
            }
        }
        return this.catString;
    }

    public void setCatString(String catString) {
        this.catString = catString;
    }

    public String getWwn() {
        return this.wwn;
    }

    public void setWwn(String wwn) {
        this.wwn = wwn;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getIpaddr() {
        return this.ipaddr;
    }

    public void setIpaddr(String ipaddr) {
        this.ipaddr = ipaddr;
    }

    public String getDscr() {
        return this.dscr;
    }

    public void setDscr(String dscr) {
        this.dscr = dscr;
    }

    public long getIdentityId() {
        return this.identityId;
    }

    public void setIdentityId(int identityId) {
        this.identityId = identityId;
    }

    public String getMulPurpose() {
        return this.mulPurpose;
    }

    public void setMulPurpose(String mulPurpose) {
        this.mulPurpose = mulPurpose;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public int getScopeType() {
        return this.scopeType;
    }

    public void setScopeType(int scopeType) {
        this.scopeType = scopeType;
    }

    public String getMacAddr() {
        return this.macAddr;
    }

    public void setMacAddr(String macAddr) {
        this.macAddr = macAddr;
    }

    public String getErrorCause() {
        return this.errorCause;
    }

    public void setErrorCause(String errorCause) {
        this.errorCause = errorCause;
    }
}

