/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.san.wo;

import com.cisco.dcbu.sm.common.dto.LicenseInfoFlex;
import java.io.Serializable;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="LicenseInfoFlex")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class LicenseInfoFlexDO
implements Serializable {
    private boolean permanent = false;
    private String featureName;
    private String licenseFile;
    private int deviceCount = 0;
    private Date expDate = null;
    private String signature;
    private String licFileID;
    private String licLineID;
    private String pak;
    private String pid;
    private String pidDeviceStr;
    private int sanUsageCount = -1;
    private int lanUsageCount = -1;
    private int sanFreeCount = -1;
    private int lanFreeCount = -1;
    private String sanFreeDisplayStr;
    private String lanFreeDisplayStr;

    protected LicenseInfoFlexDO() {
    }

    public LicenseInfoFlexDO(String licenseFile, String featureName, String pid, String pidDeviceStr, boolean permanent, int deviceCount, Date expDate, String signature, String licFileID, String licLineID, String pak) {
        this.licenseFile = licenseFile;
        this.featureName = featureName;
        this.pid = pid;
        this.pidDeviceStr = pidDeviceStr;
        this.deviceCount = deviceCount;
        this.permanent = permanent;
        this.expDate = expDate;
        this.signature = signature;
        this.licFileID = licFileID;
        this.licLineID = licLineID;
        this.pak = pak;
        if (this.sanUsageCount != -1) {
            this.sanFreeCount = deviceCount - this.sanUsageCount;
        }
        if (this.lanUsageCount != -1) {
            this.lanFreeCount = deviceCount - this.lanUsageCount;
        }
    }

    public LicenseInfoFlexDO(LicenseInfoFlex infoFlex) {
        this(infoFlex.getLicenseFile(), infoFlex.getFeatureName(), infoFlex.getPid(), infoFlex.getPidDeviceStr(), infoFlex.isPermanent(), infoFlex.getDeviceCount(), infoFlex.getExpDate() == null ? null : infoFlex.getExpDate().getTime(), infoFlex.getSignature(), infoFlex.getLicFileID(), infoFlex.getLicLineID(), infoFlex.getPak());
    }

    public boolean isPermanent() {
        return this.permanent && this.deviceCount > 0;
    }

    public boolean isEval() {
        return !this.permanent && this.deviceCount > 0;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getLicFileID() {
        return this.licFileID;
    }

    public String getLicLineID() {
        return this.licLineID;
    }

    public String getPak() {
        return this.pak;
    }

    public int getDeviceCount() {
        return this.deviceCount;
    }

    public String getLicenseFile() {
        return this.licenseFile;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public Date getExpDate() {
        return this.expDate;
    }

    public String getPid() {
        return this.pid;
    }

    public String getPidDeviceStr() {
        return this.pidDeviceStr;
    }

    public int getSanUsageCount() {
        return this.sanUsageCount;
    }

    public int getLanUsageCount() {
        return this.lanUsageCount;
    }

    public String getSanFreeCount() {
        return this.sanFreeDisplayStr;
    }

    public String getLanFreeCount() {
        return this.lanFreeDisplayStr;
    }

    public void setSanUsageCount(int sanUsageCount) {
        this.sanUsageCount = sanUsageCount;
        if (sanUsageCount != -1) {
            this.sanFreeCount = this.deviceCount - sanUsageCount;
            this.sanFreeDisplayStr = this.sanFreeCount + " / " + this.deviceCount;
        } else {
            this.sanFreeCount = -1;
            this.sanFreeDisplayStr = "";
        }
    }

    public void setLanUsageCount(int lanUsageCount) {
        this.lanUsageCount = lanUsageCount;
        if (lanUsageCount != -1) {
            this.lanFreeCount = this.deviceCount - lanUsageCount;
            this.lanFreeDisplayStr = this.lanFreeCount + " / " + this.deviceCount;
        } else {
            this.lanFreeCount = -1;
            this.lanFreeDisplayStr = "";
        }
    }

    public String getLanFreeDisplayStr() {
        return this.sanFreeDisplayStr;
    }

    public String getSanFreeDisplayStr() {
        return this.lanFreeDisplayStr;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("Flexlm license: ");
        str.append("Filename - ").append(this.licenseFile);
        str.append(", featureName - ").append(this.featureName);
        str.append(", deviceCount - ").append(this.deviceCount);
        str.append(", sanUsageCount - ").append(this.sanUsageCount);
        str.append(", lanUsageCount - ").append(this.lanUsageCount);
        str.append(", expirationDate - ").append(this.expDate == null ? "none" : this.expDate);
        str.append(", signiture - ").append(this.signature);
        str.append(", fileID - ").append(this.licFileID);
        str.append(", lineID - ").append(this.licLineID);
        str.append(", pak - ").append(this.pak);
        return str.toString();
    }
}

