/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.san.wo;

import com.cisco.dcbu.jaxws.san.wo.SnmpV3AuthTypeDO;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SnmpCredential")
public class SnmpCredentialDO
implements Serializable {
    protected String username;
    protected String v2Community;
    protected boolean v3 = true;
    protected String v3Password;
    protected SnmpV3AuthTypeDO v3Protocol;

    protected SnmpCredentialDO() {
    }

    public SnmpCredentialDO(SnmpUserOpt userOpt) {
        this.username = userOpt.getUsername();
        this.v3Password = userOpt.getPassword();
        this.v2Community = userOpt.getCommunity();
        this.v3 = userOpt.isV3();
        if (userOpt.isV3()) {
            this.v3Protocol = SnmpV3AuthTypeDO.getType(userOpt.getSnmpV3Security());
        }
    }

    public SnmpCredentialDO(String username, String v2Community) {
        this.v3 = false;
        this.username = username;
        this.v2Community = v2Community;
    }

    public SnmpCredentialDO(String username, String password, int v3Protocol) {
        this.v3 = true;
        this.username = username;
        this.v3Password = password;
        this.v3Protocol = SnmpV3AuthTypeDO.getType(v3Protocol);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isV3() {
        return this.v3;
    }

    public void setV3(boolean v3) {
        this.v3 = v3;
    }

    public SnmpV3AuthTypeDO getV3Protocol() {
        return this.v3Protocol;
    }

    public void setV3Protocol(SnmpV3AuthTypeDO protocol) {
        this.v3Protocol = protocol;
    }

    public String getV2Community() {
        return this.v2Community;
    }

    public void setV2Community(String community) {
        this.v2Community = community;
    }

    public String getV3Password() {
        return this.v3Password;
    }

    public void setV3Password(String password) {
        this.v3Password = password;
    }

    public SnmpUserOpt toUserOpt() {
        int v3Value = -1;
        if (this.v3Protocol != null) {
            v3Value = this.v3Protocol.value();
        }
        SnmpUserOpt opt = new SnmpUserOpt(this.username, this.v3Password, this.v2Community, v3Value, this.v3);
        return opt;
    }
}

