/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.jnm;

import com.cisco.dcbu.lib.snmp.SnmpCounter64;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.ui.table.BorderCellRenderer;
import java.math.BigInteger;
import java.text.DecimalFormat;

public class DefaultSnmpNumberRenderer
extends BorderCellRenderer {
    public static final DecimalFormat NUM_FORMAT = new DecimalFormat("0.00");
    public static final DecimalFormat NUM_FORMAT_0_PREC = new DecimalFormat("0");

    public DefaultSnmpNumberRenderer() {
        this.setHorizontalAlignment(4);
    }

    public static String formatLong(long l) {
        return DefaultSnmpNumberRenderer.formatLong(l, NUM_FORMAT, false);
    }

    public static String formatLong(long l, boolean space) {
        return DefaultSnmpNumberRenderer.formatLong(l, NUM_FORMAT, space);
    }

    public static String formatLongNoPrec(long l) {
        return DefaultSnmpNumberRenderer.formatLong(l, NUM_FORMAT_0_PREC, false);
    }

    public static String formatLong(long l, DecimalFormat formatter) {
        return DefaultSnmpNumberRenderer.formatLong(l, formatter, false);
    }

    public static String formatLong(long l, DecimalFormat formatter, boolean space) {
        if (l > 0L && l < Long.MAX_VALUE) {
            double d = 0.0;
            String suffix = null;
            if (l >= 1000000000L) {
                d = (double)l / 1.0E9;
                suffix = "G";
            } else if (l >= 1000000L) {
                d = (double)l / 1000000.0;
                suffix = "M";
            } else if (l >= 1000L) {
                d = (double)l / 1000.0;
                suffix = "K";
            }
            if (suffix != null) {
                return formatter.format(d) + (space ? " " : "") + suffix;
            }
            return Long.toString(l);
        }
        byte[] bytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bytes[i] = (byte)(l >> (7 - i) * 8 & 0xFFL);
        }
        return DefaultSnmpNumberRenderer.formatBigInt(new BigInteger(1, bytes));
    }

    public static String formatBigInt(BigInteger l) {
        BigInteger[] dArray = new BigInteger[2];
        long index = 1L;
        String suffix = null;
        if (l.compareTo(BigInteger.valueOf(1000000000000000L)) >= 0) {
            dArray = l.divideAndRemainder(BigInteger.valueOf(1000000000000000L));
            index = 1000000000000000L;
            suffix = "P";
        } else if (l.compareTo(BigInteger.valueOf(1000000000000L)) >= 0) {
            dArray = l.divideAndRemainder(BigInteger.valueOf(1000000000000L));
            index = 1000000000000L;
            suffix = "T";
        } else if (l.compareTo(BigInteger.valueOf(1000000000L)) >= 0) {
            dArray = l.divideAndRemainder(BigInteger.valueOf(1000000000L));
            index = 1000000000L;
            suffix = "G";
        } else if (l.compareTo(BigInteger.valueOf(1000000L)) >= 0) {
            dArray = l.divideAndRemainder(BigInteger.valueOf(1000000L));
            index = 1000000L;
            suffix = "M";
        } else if (l.compareTo(BigInteger.valueOf(1000L)) >= 0) {
            dArray = l.divideAndRemainder(BigInteger.valueOf(1000L));
            index = 1000L;
            suffix = "K";
        }
        if (suffix != null) {
            double val = (double)dArray[0].longValue() + dArray[1].doubleValue() / (double)index;
            return NUM_FORMAT.format(val) + suffix;
        }
        return l.toString();
    }

    public static String formatFloat(double l) {
        double d = 0.0;
        String suffix = null;
        if (l >= 1.0E9) {
            d = l / 1.0E9;
            suffix = "G";
        } else if (l >= 1000000.0) {
            d = l / 1000000.0;
            suffix = "M";
        } else if (l >= 1000.0) {
            d = l / 1000.0;
            suffix = "K";
        }
        if (suffix != null) {
            return NUM_FORMAT.format(d) + suffix;
        }
        return Double.toString((double)((int)(l * 1000.0)) / 1000.0);
    }

    @Override
    protected void setValue(Object value) {
        if (value == null) {
            this.setText("");
        } else if (value instanceof SnmpUnsignedInt) {
            this.setText(DefaultSnmpNumberRenderer.formatLong(((SnmpUnsignedInt)value).getValue()));
        } else if (value instanceof SnmpInt) {
            this.setText(DefaultSnmpNumberRenderer.formatLong(((SnmpInt)value).getValue()));
        } else if (value instanceof SnmpCounter64) {
            this.setText(DefaultSnmpNumberRenderer.formatBigInt(((SnmpCounter64)value).getBigValue()));
        } else if (value instanceof Number) {
            this.setText(DefaultSnmpNumberRenderer.formatLong(((Number)value).longValue()));
        }
    }
}

