/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.jnm;

import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.snmp.SnmpString;

public final class SnmpWWN
extends SnmpString {
    public SnmpWWN(byte[] fcId) {
        super(fcId);
    }

    public SnmpWWN(String wwn) throws NumberFormatException {
        super(SnmpWWN.parse(wwn.trim(), true));
    }

    public SnmpWWN(String wwn, boolean isLengthOrZero) throws NumberFormatException {
        super(SnmpWWN.parse(wwn.trim(), isLengthOrZero));
    }

    @Override
    public String toString() {
        if (this._value == null) {
            this._value = SnmpWWN.toHexString(this._byteValue);
        }
        return this._value;
    }

    public static final String toString(int[] index, int offset, boolean lookup) {
        if (index != null && offset >= 0) {
            if (index.length - offset >= 8) {
                byte[] b = new byte[8];
                for (int i = 0; i < 8; ++i) {
                    b[i] = (byte)(index[offset + i] & 0xFF);
                }
                return lookup ? WwnDictionary.get(b) : SnmpWWN.toHexString(b);
            }
            return index.toString();
        }
        return null;
    }

    public static byte[] parse(String wwn, boolean isLengthOrZero) throws NumberFormatException {
        byte[] b = SnmpString.fromHexString(wwn, wwn.indexOf(58) != -1);
        if (isLengthOrZero && (b.length == 8 || b.length == 0)) {
            return b;
        }
        if (!isLengthOrZero && b.length == 8) {
            return b;
        }
        throw new NumberFormatException(isLengthOrZero ? "bad wwn: length 0 or 8" : "bad wwn: length 8");
    }
}

