/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.jnm;

import java.util.Arrays;
import java.util.Comparator;

public final class SwitchVersion
implements Comparable {
    String _version;
    int _major;
    int _feature;
    int _maint;
    int _interim = -1;
    char _rebuild = '\u0000';
    char _support = '\u0000';
    boolean _unknown = true;
    boolean _isPreRel = false;
    int _engVersionNum = -1;
    int _preRelVersionNum = Integer.MAX_VALUE;
    String _leadingChars;
    public static final String UNKNOWN = "unknown";

    public SwitchVersion(String version) {
        this(version, true);
    }

    public SwitchVersion(String version, boolean trimLeadingChars) {
        int i;
        int s;
        if (version == null) {
            return;
        }
        this._version = version.trim();
        this._version = this.trimEnd(this._version, trimLeadingChars);
        if (this._version.length() == 0) {
            return;
        }
        int m = this._version.indexOf(46);
        if (m == -1) {
            return;
        }
        this._major = Integer.parseInt(this._version.substring(0, m));
        int f = this._version.indexOf(40, m);
        if (f == -1) {
            return;
        }
        this._feature = Integer.parseInt(this._version.substring(m + 1, f));
        int cusion = 0;
        int value = this.getSpecialVerIdx(this._version);
        if (value != -1) {
            int endIdx = this._version.indexOf(41, value);
            if (endIdx == -1) {
                return;
            }
            String ehpVer = this._version.substring(value + 1, endIdx);
            cusion = ehpVer.length() + 1;
            if (this._isPreRel) {
                this._preRelVersionNum = Integer.parseInt(ehpVer);
            } else if (ehpVer.length() > 0) {
                this._engVersionNum = Integer.parseInt(ehpVer);
            }
        }
        if ((s = this._version.indexOf(45, f)) != -1 && s < this._version.length()) {
            this._support = this._version.charAt(s + 1);
            if (this._version.charAt(s + 2) != ')') {
                return;
            }
        } else {
            s = this._version.indexOf(41, f) - cusion;
            if (s == -1) {
                return;
            }
        }
        if (Character.isLetter(this._version.charAt(s - 1))) {
            this._rebuild = this._version.charAt(s - 1);
            --s;
        }
        if ((i = this._version.indexOf(46, f)) != -1) {
            try {
                this._interim = Integer.parseInt(this._version.substring(i + 1, s));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            s = i;
        }
        this._maint = Integer.parseInt(this._version.substring(f + 1, s));
        this._unknown = false;
    }

    private int getSpecialVerIdx(String version) {
        for (int i = 0; i < version.length(); ++i) {
            char ch = version.charAt(i);
            if (ch == 'P') {
                this._isPreRel = true;
            }
            if (!Character.isUpperCase(ch)) continue;
            return i;
        }
        return -1;
    }

    private String trimEnd(String version, boolean trimLeadingChars) {
        String _version = version;
        int rightBracket = _version.indexOf(41);
        _version = _version.substring(0, rightBracket + 1);
        if (!trimLeadingChars) {
            int secondLeftBracket = version.indexOf(40, rightBracket);
            String tempVersion = null;
            tempVersion = secondLeftBracket != -1 ? version.substring(0, secondLeftBracket) : version;
            this._leadingChars = tempVersion.substring(rightBracket + 1);
        }
        return _version;
    }

    public boolean isUnknown() {
        return this._unknown;
    }

    public int compareTo(Object o) {
        if (o instanceof SwitchVersion) {
            return this.compareTo((SwitchVersion)o);
        }
        throw new ClassCastException("Cannot compare to " + o);
    }

    public int compareTo(SwitchVersion v) {
        if (this.isUnknown() && v.isUnknown()) {
            return 0;
        }
        if (v.isUnknown()) {
            return 1;
        }
        if (this.isUnknown()) {
            return -1;
        }
        if (this.equals(v)) {
            return 0;
        }
        if (this._major > v._major) {
            return 1;
        }
        if (this._major < v._major) {
            return -1;
        }
        if (this._feature > v._feature) {
            return 1;
        }
        if (this._feature < v._feature) {
            return -1;
        }
        if (this._maint > v._maint) {
            return 1;
        }
        if (this._maint < v._maint) {
            return -1;
        }
        if (this._interim > v._interim) {
            return 1;
        }
        if (this._interim < v._interim) {
            return -1;
        }
        if (this._rebuild > v._rebuild) {
            return 1;
        }
        if (this._rebuild < v._rebuild) {
            return -1;
        }
        if (this._engVersionNum != -1 || v._engVersionNum != -1) {
            if (this._engVersionNum > v._engVersionNum) {
                return 1;
            }
            return -1;
        }
        if (this._preRelVersionNum != v._preRelVersionNum) {
            return this._preRelVersionNum > v._preRelVersionNum ? 1 : -1;
        }
        if (this._support < v._support) {
            return -1;
        }
        if (this._leadingChars != null && v._leadingChars != null) {
            return this._leadingChars.compareTo(v._leadingChars);
        }
        return 1;
    }

    public boolean lessThanEqual(SwitchVersion v) {
        return this.compareTo(v) <= 0;
    }

    public boolean lessThan(SwitchVersion v) {
        return this.compareTo(v) < 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SwitchVersion) {
            SwitchVersion v = (SwitchVersion)obj;
            return this._major == v._major && this._feature == v._feature && this._maint == v._maint && this._interim == v._interim && this._rebuild == v._rebuild && this._engVersionNum == v._engVersionNum && this._preRelVersionNum == v._preRelVersionNum && this._support == v._support && this._leadingChars == v._leadingChars;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.isUnknown()) {
            return UNKNOWN.hashCode();
        }
        return this._version.hashCode();
    }

    public String toString() {
        return this.isUnknown() ? UNKNOWN : this._version;
    }

    public String debugString() {
        return "_major = " + this._major + " _feature = " + this._feature + " _maint = " + this._maint + " _interim = " + this._interim + " _ rebuild = " + this._rebuild + " _engVersionNum = " + this._engVersionNum + " _preRelVersionNum = " + this._preRelVersionNum + " _support = " + this._support;
    }

    public static void main(String[] args) {
        new SwitchVersion("4.1(2a)").compareTo(new SwitchVersion("4.1(2.123)"));
        SwitchVersion[][] tests = new SwitchVersion[][]{{new SwitchVersion("4.1(2)"), new SwitchVersion("4.1(2a)"), new SwitchVersion("4.1(2.123)")}, {new SwitchVersion("4.1(2)"), new SwitchVersion("4.1(2-q)"), new SwitchVersion("4.1(2a-q)"), new SwitchVersion("4.1(2a-t)"), new SwitchVersion("4.1(2a)")}, {new SwitchVersion("4.1(2E1)"), new SwitchVersion("4.1(2H1)"), new SwitchVersion("4.1(2E10)"), new SwitchVersion("4.1(2H10)")}, {new SwitchVersion("4.1(0)"), new SwitchVersion("4.1(2a-q)"), new SwitchVersion("4.1(2P1)"), new SwitchVersion("4.1(2.123P1)"), new SwitchVersion("4.1(2aP1)"), new SwitchVersion("4.1(2.123aP1)"), new SwitchVersion("4.1(2E1)"), new SwitchVersion("4.1(2.123E1)"), new SwitchVersion("4.1(2aE1)"), new SwitchVersion("4.1(2.123aE1)"), new SwitchVersion("4.1(2)"), new SwitchVersion("4.1(2.123)"), new SwitchVersion("4.1(2a)"), new SwitchVersion("4.1(2.123a)")}, {new SwitchVersion("4.1(2E1)"), new SwitchVersion("4.1(2H1)"), new SwitchVersion("4.1(2P1)"), new SwitchVersion("4.1(2T1)"), new SwitchVersion("4.1(2Z1)"), new SwitchVersion("4.1(2A1)")}, {new SwitchVersion("6.1(2E)"), new SwitchVersion("6.2(1X)"), new SwitchVersion("6.1(2E2)"), new SwitchVersion("6.1(2E1)")}};
        for (int idx = 0; idx < tests.length; ++idx) {
            SwitchVersion[] vers = tests[idx];
            Arrays.sort(vers, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((SwitchVersion)o1).compareTo((SwitchVersion)o2);
                }
            });
            StringBuffer printStr = new StringBuffer(vers[0].toString());
            for (int i = 1; i < vers.length; ++i) {
                String comparisonOp = vers[i - 1].equals(vers[i]) ? " = " : " < ";
                printStr.append(comparisonOp).append(vers[i]);
            }
            System.out.println("Test Result " + (idx + 1) + "  ==> " + printStr);
        }
    }
}

